# Copyright (c) 01/10/97 by Sun Microsystems, Inc. All Rights Reserved
# Version 1.0.1 FCS built on 01/10/97


puts stdout "Begin loading ASN1 parser information"


# ------------------------------
# Module
# CMIP-1
# Encoding procedures
# ------------------------------


proc CMIP-1.AccessControl.encode value0 {
EXTERNAL.encode $value0
};

proc CMIP-1.ActionArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }]  [if {[tmns_keylget value0 actionInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } [CMIP-1.ActionInfo.encode $value1] } else { error "Can not find key actionInfo" }] 
};

proc CMIP-1.ActionError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 actionErrorInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [CMIP-1.ActionErrorInfo.encode $value1] } else { error "Can not find key actionErrorInfo" }] 
};

proc CMIP-1.ActionErrorInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorStatus value1]} {if {$value1 == "accessDenied"} {set value1 2}; if {$value1 == "noSuchAction"} {set value1 9}; if {$value1 == "noSuchArgument"} {set value1 14}; if {$value1 == "invalidArgumentValue"} {set value1 15}; ENUM.encode $value1} else { error "Can not find key errorStatus" }]  [if {[tmns_keylget value0 errorInfo value1]} {
proc intern0 value0 {
if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else {if {[tmns_keylget value0 actionArgument value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } [CMIP-1.NoSuchArgument.encode $value1] } else {if {[tmns_keylget value0 argumentValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [CMIP-1.InvalidArgumentValue.encode $value1] } else { error "Missing choice" }}}
};
intern0 $value1} else { error "Can not find key errorInfo" }] 
};

proc CMIP-1.ActionInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }]  [if {[tmns_keylget value0 actionInfoArg value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 actionType value1]} {set value1} else { error "Can not find key actionType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.ActionReply.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }]  [if {[tmns_keylget value0 actionReplyInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 actionType value1]} {set value1} else { error "Can not find key actionType" }] ] } else { error "Can not find key actionReplyInfo" }] 
};

proc CMIP-1.ActionResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 actionReply value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.ActionReply.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.ActionTypeId.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.Attribute.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 attributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key attributeValue" }] 
};

proc CMIP-1.AttributeError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorStatus value1]} {if {$value1 == "accessDenied"} {set value1 2}; if {$value1 == "noSuchAttribute"} {set value1 5}; if {$value1 == "invalidAttributeValue"} {set value1 6}; if {$value1 == "invalidOperation"} {set value1 24}; if {$value1 == "invalidOperator"} {set value1 25}; ENUM.encode $value1} else { error "Can not find key errorStatus" }]  [if {[tmns_keylget value0 modifyOperator value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.ModifyOperator.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 attributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.AttributeId.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.AttributeIdError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorStatus value1]} {if {$value1 == "accessDenied"} {set value1 2}; if {$value1 == "noSuchAttribute"} {set value1 5}; ENUM.encode $value1} else { error "Can not find key errorStatus" }]  [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }] 
};

proc CMIP-1.BaseManagedObjectId.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }] 
};

proc CMIP-1.CMISFilter.encode value0 {
if {[tmns_keylget value0 item value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [CMIP-1.FilterItem.encode $value1] } else {if {[tmns_keylget value0 and value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } [
proc intern1 value0 {
CMIP-1.CMISFilter.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern1 " [list $i] \]"
}
eval $toEval
] } else {if {[tmns_keylget value0 or value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } [
proc intern2 value0 {
CMIP-1.CMISFilter.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern2 " [list $i] \]"
}
eval $toEval
] } else {if {[tmns_keylget value0 not value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT false} } [CMIP-1.CMISFilter.encode $value1] } else { error "Missing choice" }}}}
};

proc CMIP-1.CMISSync.encode value0 {
if {$value0 == "bestEffort"} {set value0 0}; if {$value0 == "atomic"} {set value0 1}; ENUM.encode $value0
};

proc CMIP-1.ComplexityLimitation.encode value0 {
SET.encode [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 filter value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [CMIP-1.CMISFilter.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 sync value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [CMIP-1.CMISSync.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.CreateArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 --nofield1 value1]} {
proc intern3 value0 {
if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else {if {[tmns_keylget value0 superiorObjectInstance value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else { error "Missing choice" }}
};
intern3 $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 referenceObjectInstance value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [
proc intern4 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern4 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.CreateResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern5 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern5 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.DeleteArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }] 
};

proc CMIP-1.DeleteError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 deleteErrorInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [if {$value1 == "accessDenied"} {set value1 2}; ENUM.encode $value1] } else { error "Can not find key deleteErrorInfo" }] 
};

proc CMIP-1.DeleteResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventReply.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }]  [if {[tmns_keylget value0 eventReplyInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 eventType value1]} {set value1} else { error "Can not find key eventType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventReportArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key managedObjectInstance" }]  [if {[tmns_keylget value0 eventTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }]  [if {[tmns_keylget value0 eventInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 eventType value1]} {set value1} else { error "Can not find key eventType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventReportResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 eventReply value1]} {CMIP-1.EventReply.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.EventTypeId.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.FilterItem.encode value0 {
if {[tmns_keylget value0 equality value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 substrings value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern6 value0 {

proc intern7 value0 {
if {[tmns_keylget value0 initialString value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [
proc intern8 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 string value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key string" }] 
};
intern8 $value1] } else {if {[tmns_keylget value0 anyString value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern9 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 string value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key string" }] 
};
intern9 $value1] } else {if {[tmns_keylget value0 finalString value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [
proc intern10 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 string value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { error "Can not find key string" }] 
};
intern10 $value1] } else { error "Missing choice" }}}
};
intern7 $value0
};
set toEval SEQUENCE.encode;
foreach i $value1 {
  append toEval " \[" intern6 " [list $i] \]"
}
eval $toEval
] } else {if {[tmns_keylget value0 greaterOrEqual value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 lessOrEqual value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 present value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [CMIP-1.AttributeId.encode $value1] } else {if {[tmns_keylget value0 subsetOf value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 supersetOf value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else {if {[tmns_keylget value0 nonNullSetIntersection value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else { error "Missing choice" }}}}}}}}
};

proc CMIP-1.GetArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }]  [if {[tmns_keylget value0 attributeIdList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } [
proc intern11 value0 {
CMIP-1.AttributeId.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern11 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.GetInfoStatus.encode value0 {
if {[tmns_keylget value0 attributeIdError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.AttributeIdError.encode $value1] } else {if {[tmns_keylget value0 attribute value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.GetListError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 getInfoList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern12 value0 {
CMIP-1.GetInfoStatus.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern12 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key getInfoList" }] 
};

proc CMIP-1.GetResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern13 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern13 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.InvalidArgumentValue.encode value0 {
if {[tmns_keylget value0 actionValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.ActionInfo.encode $value1] } else {if {[tmns_keylget value0 eventValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern14 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }]  [if {[tmns_keylget value0 eventInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 eventType value1]} {set value1} else { error "Can not find key eventType" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern14 $value1] } else { error "Missing choice" }}
};

proc CMIP-1.LinkedReplyArgument.encode value0 {
if {[tmns_keylget value0 getResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.GetResult.encode $value1] } else {if {[tmns_keylget value0 getListError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [CMIP-1.GetListError.encode $value1] } else {if {[tmns_keylget value0 setResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.SetResult.encode $value1] } else {if {[tmns_keylget value0 setListError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [CMIP-1.SetListError.encode $value1] } else {if {[tmns_keylget value0 actionResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } [CMIP-1.ActionResult.encode $value1] } else {if {[tmns_keylget value0 processingFailure value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [CMIP-1.ProcessingFailure.encode $value1] } else {if {[tmns_keylget value0 deleteResult value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.DeleteResult.encode $value1] } else {if {[tmns_keylget value0 actionError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [CMIP-1.ActionError.encode $value1] } else {if {[tmns_keylget value0 deleteError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } [CMIP-1.DeleteError.encode $value1] } else { error "Missing choice" }}}}}}}}}
};

proc CMIP-1.ModifyOperator.encode value0 {
if {$value0 == "replace"} {set value0 0}; if {$value0 == "addValues"} {set value0 1}; if {$value0 == "removeValues"} {set value0 2}; if {$value0 == "setToDefault"} {set value0 3}; INTEGER.encode $value0
};

proc CMIP-1.NoSuchAction.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }] 
};

proc CMIP-1.NoSuchArgument.encode value0 {
if {[tmns_keylget value0 actionId value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [
proc intern15 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 actionType value1]} {CMIP-1.ActionTypeId.encode $value1} else { error "Can not find key actionType" }] 
};
intern15 $value1] } else {if {[tmns_keylget value0 eventId value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern16 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }] 
};
intern16 $value1] } else { error "Missing choice" }}
};

proc CMIP-1.NoSuchEventType.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 eventType value1]} {CMIP-1.EventTypeId.encode $value1} else { error "Can not find key eventType" }] 
};

proc CMIP-1.ObjectClass.encode value0 {
if {[tmns_keylget value0 globalForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 localForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.ObjectInstance.encode value0 {
if {[tmns_keylget value0 distinguishedName value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [InformationFramework.DistinguishedName.encode $value1] } else {if {[tmns_keylget value0 nonSpecificForm value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [OCTET.encode $value1] } else {if {[tmns_keylget value0 localDistinguishedName value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } [InformationFramework.RDNSequence.encode $value1] } else { error "Missing choice" }}}
};

proc CMIP-1.ProcessingFailure.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key managedObjectClass" }]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 specificErrorInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.SpecificErrorInfo.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.Scope.encode value0 {
if {[tmns_keylget value0 scope-int value1]} {if {$value1 == "baseObject"} {set value1 0}; if {$value1 == "firstLevelOnly"} {set value1 1}; if {$value1 == "wholeSubtree"} {set value1 2}; INTEGER.encode $value1} else {if {[tmns_keylget value0 individualLevels value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [INTEGER.encode $value1] } else {if {[tmns_keylget value0 baseToNthLevel value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [INTEGER.encode $value1] } else { error "Missing choice" }}}
};

proc CMIP-1.SetArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 baseManagedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { error "Can not find key baseManagedObjectClass" }]  [if {[tmns_keylget value0 baseManagedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key baseManagedObjectInstance" }]  [if {[tmns_keylget value0 accessControl value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [CMIP-1.AccessControl.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 synchronization value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [CMIP-1.CMISSync.encode $value1] } else { error "Can not find key synchronization" }]  [if {[tmns_keylget value0 scope value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [CMIP-1.Scope.encode $value1] } else { error "Can not find key scope" }]  [if {[tmns_keylget value0 filter value1]} {CMIP-1.CMISFilter.encode $value1} else { error "Can not find key filter" }]  [if {[tmns_keylget value0 modificationList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } [
proc intern17 value0 {

proc intern18 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 modifyOperator value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [CMIP-1.ModifyOperator.encode $value1] } else { error "Can not find key modifyOperator" }]  [if {[tmns_keylget value0 attributeId value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeId" }]  [if {[tmns_keylget value0 attributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeId value1]} {set value1} else { error "Can not find key attributeId" }] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern18 $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern17 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key modificationList" }] 
};

proc CMIP-1.SetInfoStatus.encode value0 {
if {[tmns_keylget value0 attributeError value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [CMIP-1.AttributeError.encode $value1] } else {if {[tmns_keylget value0 attribute value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [CMIP-1.Attribute.encode $value1] } else { error "Missing choice" }}
};

proc CMIP-1.SetListError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 setInfoList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern19 value0 {
CMIP-1.SetInfoStatus.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern19 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key setInfoList" }] 
};

proc CMIP-1.SetResult.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 managedObjectClass value1]} {CMIP-1.ObjectClass.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 managedObjectInstance value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 currentTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [
proc intern20 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern20 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.SpecificErrorInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 errorId value1]} {OID.encode $value1} else { error "Can not find key errorId" }]  [if {[tmns_keylget value0 errorInfo value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 errorId value1]} {set value1} else { error "Can not find key errorId" }] } else { error "Can not find key errorInfo" }] 
};

proc CMIP-1.MultipleReply.encode value0 {

proc intern21 value0 {
CMIP-1.LinkedReplyArgument.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern21 " [list $i] \]"
}
eval $toEval

};

proc CMIP-1.ServiceError.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 problem value1]} {INTEGER.encode $value1} else { error "Can not find key problem" }]  [if {[tmns_keylget value0 parameter value1]} {ANY.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CMIP-1.CancelGetArgument.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 getInvokeId value1]} {INTEGER.encode $value1} else { error "Can not find key getInvokeId" }] 
};

# ------------------------------
# Module
# CMIP-1
# Decoding procedures
# ------------------------------


proc CMIP-1.AccessControl.decode {value0 index optional explicit} {
EXTERNAL.decode $value0 $index $optional $explicit
};

proc CMIP-1.ActionArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; tmns_keylset result actionInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } false true; CMIP-1.ActionInfo.decode $value0 $index false false] ; ; return $result
};

proc CMIP-1.ActionError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result actionErrorInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.ActionErrorInfo.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.ActionErrorInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result errorStatus  [set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; if {$simple == "9"} {set simple noSuchAction}; if {$simple == "14"} {set simple noSuchArgument}; if {$simple == "15"} {set simple invalidArgumentValue}; set simple ] ; tmns_keylset result errorInfo  [
proc intern22.decode {value0 index optional explicit} {
set result {}; set tmp  [CMIP-1.ActionTypeId.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result actionType $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.NoSuchArgument.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result actionArgument $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.InvalidArgumentValue.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result argumentValue $tmp; set result } else { error "Missing choice" }}}; return $result
};
intern22.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.ActionInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; tmns_keylset result actionInfoArg  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result actionType value1]} {set value1} else { error "Can not find key actionType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.ActionReply.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; tmns_keylset result actionReplyInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result actionType value1]} {set value1} else { error "Can not find key actionType" }] ] ; ; return $result
};

proc CMIP-1.ActionResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result actionReply  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionReply.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.ActionTypeId.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.Attribute.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result attributeValue  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};

proc CMIP-1.AttributeError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result errorStatus  [set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; if {$simple == "5"} {set simple noSuchAttribute}; if {$simple == "6"} {set simple invalidAttributeValue}; if {$simple == "24"} {set simple invalidOperation}; if {$simple == "25"} {set simple invalidOperator}; set simple ] ; tmns_keylset result modifyOperator  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ModifyOperator.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result attributeValue  [ANY_DEF_BY.decode $value0 $index true true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};

proc CMIP-1.AttributeId.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.AttributeIdError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result errorStatus  [set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; if {$simple == "5"} {set simple noSuchAttribute}; set simple ] ; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.BaseManagedObjectId.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.CMISFilter.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.FilterItem.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result item $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern23.decode {value0 index optional explicit} {
CMIP-1.CMISFilter.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern23.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result and $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern24.decode {value0 index optional explicit} {
CMIP-1.CMISFilter.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern24.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result or $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.CMISFilter.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result not $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}
};

proc CMIP-1.CMISSync.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple bestEffort}; if {$simple == "1"} {set simple atomic}; set simple 
};

proc CMIP-1.ComplexityLimitation.decode {value0 index optional explicit} {
set result {}; if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result scope  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result filter  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.CMISFilter.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result sync  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.CMISSync.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.CreateArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result --nofield1  [
proc intern25.decode {value0 index optional explicit} {
set result {}; set tmp  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result managedObjectInstance $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result superiorObjectInstance $tmp; set result } else { error "Missing choice" }}; return $result
};
intern25.decode $value0 $index true true] ; tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result referenceObjectInstance  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern26.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern26.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.CreateResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern27.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern27.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.DeleteArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.DeleteError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result deleteErrorInfo  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; set simple  [ENUM.decode $value0 $index false true] ; if {$simple == "2"} {set simple accessDenied}; set simple ] ; ; return $result
};

proc CMIP-1.DeleteResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.EventReply.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; tmns_keylset result eventReplyInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result eventType value1]} {set value1} else { error "Can not find key eventType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.EventReportArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result eventTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; tmns_keylset result eventInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result eventType value1]} {set value1} else { error "Can not find key eventType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.EventReportResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result eventReply  [CMIP-1.EventReply.decode $value0 $index true true] ; ; return $result
};

proc CMIP-1.EventTypeId.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.FilterItem.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result equality $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern28.decode {value0 index optional explicit} {

proc intern29.decode {value0 index optional explicit} {
set result {}; set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern30.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result string  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern30.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result initialString $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern31.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result string  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern31.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result anyString $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern32.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result string  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern32.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result finalString $tmp; set result } else { error "Missing choice" }}}; return $result
};
intern29.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern28.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result substrings $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result greaterOrEqual $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result lessOrEqual $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AttributeId.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result present $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result subsetOf $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result supersetOf $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result nonNullSetIntersection $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}}}}}
};

proc CMIP-1.GetArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; tmns_keylset result attributeIdList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern33.decode {value0 index optional explicit} {
CMIP-1.AttributeId.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern33.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.GetInfoStatus.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.AttributeIdError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result attributeIdError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result attribute $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.GetListError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result getInfoList  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; 
proc intern34.decode {value0 index optional explicit} {
CMIP-1.GetInfoStatus.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern34.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc CMIP-1.GetResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern35.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern35.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.InvalidArgumentValue.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionInfo.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result actionValue $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern36.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; tmns_keylset result eventInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result eventType value1]} {set value1} else { error "Can not find key eventType" }] } else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern36.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result eventValue $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.LinkedReplyArgument.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.GetResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result getResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.GetListError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result getListError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.SetResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result setResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.SetListError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result setListError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result actionResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ProcessingFailure.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result processingFailure $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.DeleteResult.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result deleteResult $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.ActionError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result actionError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.DeleteError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result deleteError $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}}}}}}
};

proc CMIP-1.ModifyOperator.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple replace}; if {$simple == "1"} {set simple addValues}; if {$simple == "2"} {set simple removeValues}; if {$simple == "3"} {set simple setToDefault}; set simple 
};

proc CMIP-1.NoSuchAction.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.NoSuchArgument.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern37.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result actionType  [CMIP-1.ActionTypeId.decode $value0 $index false true] ; ; return $result
};
intern37.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result actionId $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern38.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; ; return $result
};
intern38.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result eventId $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.NoSuchEventType.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result eventType  [CMIP-1.EventTypeId.decode $value0 $index false true] ; ; return $result
};

proc CMIP-1.ObjectClass.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result globalForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result localForm $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.ObjectInstance.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {InformationFramework.DistinguishedName.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result distinguishedName $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {OCTET.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result nonSpecificForm $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } true true]  != "__tmns_opt"} {InformationFramework.RDNSequence.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result localDistinguishedName $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc CMIP-1.ProcessingFailure.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result specificErrorInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.SpecificErrorInfo.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.Scope.decode {value0 index optional explicit} {
set tmp  [set simple  [INTEGER.decode $value0 $index true true] ; if {$simple == "0"} {set simple baseObject}; if {$simple == "1"} {set simple firstLevelOnly}; if {$simple == "2"} {set simple wholeSubtree}; set simple ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result scope-int $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result individualLevels $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {INTEGER.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result baseToNthLevel $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc CMIP-1.SetArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result baseManagedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result baseManagedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result accessControl  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.AccessControl.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result synchronization  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; CMIP-1.CMISSync.decode $value0 $index false false] ; tmns_keylset result scope  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.Scope.decode $value0 $index false true] ; tmns_keylset result filter  [CMIP-1.CMISFilter.decode $value0 $index false true] ; tmns_keylset result modificationList  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } false true; 
proc intern39.decode {value0 index optional explicit} {

proc intern40.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result modifyOperator  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } false true; CMIP-1.ModifyOperator.decode $value0 $index false false] ; tmns_keylset result attributeId  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result attributeValue  [ANY_DEF_BY.decode $value0 $index true true [if {[tmns_keylget result attributeId value1]} {set value1} else { error "Can not find key attributeId" }] ] ; ; return $result
};
intern40.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern39.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc CMIP-1.SetInfoStatus.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.AttributeError.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result attributeError $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {CMIP-1.Attribute.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result attribute $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc CMIP-1.SetListError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result setInfoList  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } false true; 
proc intern41.decode {value0 index optional explicit} {
CMIP-1.SetInfoStatus.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern41.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc CMIP-1.SetResult.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result managedObjectClass  [CMIP-1.ObjectClass.decode $value0 $index true true] ; tmns_keylset result managedObjectInstance  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; tmns_keylset result currentTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern42.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern42.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CMIP-1.SpecificErrorInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result errorId  [OID.decode $value0 $index false true] ; tmns_keylset result errorInfo  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result errorId value1]} {set value1} else { error "Can not find key errorId" }] ] ; ; return $result
};

proc CMIP-1.MultipleReply.decode {value0 index optional explicit} {

proc intern43.decode {value0 index optional explicit} {
CMIP-1.LinkedReplyArgument.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern43.decode $value0 $index false true]; }
; set tmp 
};

proc CMIP-1.ServiceError.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result problem  [INTEGER.decode $value0 $index false true] ; tmns_keylset result parameter  [ANY.decode $value0 $index true true] ; ; return $result
};

proc CMIP-1.CancelGetArgument.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result getInvokeId  [INTEGER.decode $value0 $index false true] ; ; return $result
};

# ------------------------------
# Module
# InformationFramework
# Encoding procedures
# ------------------------------


proc InformationFramework.AttributeType.encode value0 {
OID.encode $value0
};

proc InformationFramework.AttributeValue.encode value0 {
ANY.encode $value0
};

proc InformationFramework.AttributeValueAssertion.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 namingAttributeId value1]} {OID.encode $value1} else { error "Can not find key namingAttributeId" }]  [if {[tmns_keylget value0 namingAttributeValue value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 namingAttributeId value1]} {set value1} else { error "Can not find key namingAttributeId" }] } else { error "Can not find key namingAttributeValue" }] 
};

proc InformationFramework.DistinguishedName.encode value0 {
InformationFramework.RDNSequence.encode $value0
};

proc InformationFramework.Name.encode value0 {
if {[tmns_keylget value0 rDNSequence value1]} {InformationFramework.RDNSequence.encode $value1} else { error "Missing choice" }
};

proc InformationFramework.RDNSequence.encode value0 {

proc intern44 value0 {
InformationFramework.RelativeDistinguishedName.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value0 {
  append toEval " \[" intern44 " [list $i] \]"
}
eval $toEval

};

proc InformationFramework.RelativeDistinguishedName.encode value0 {

proc intern45 value0 {
InformationFramework.AttributeValueAssertion.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern45 " [list $i] \]"
}
eval $toEval

};

# ------------------------------
# Module
# InformationFramework
# Decoding procedures
# ------------------------------


proc InformationFramework.AttributeType.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc InformationFramework.AttributeValue.decode {value0 index optional explicit} {
ANY.decode $value0 $index $optional $explicit
};

proc InformationFramework.AttributeValueAssertion.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result namingAttributeId  [OID.decode $value0 $index false true] ; tmns_keylset result namingAttributeValue  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result namingAttributeId value1]} {set value1} else { error "Can not find key namingAttributeId" }] ] ; ; return $result
};

proc InformationFramework.DistinguishedName.decode {value0 index optional explicit} {
InformationFramework.RDNSequence.decode $value0 $index $optional $explicit
};

proc InformationFramework.Name.decode {value0 index optional explicit} {
set tmp  [InformationFramework.RDNSequence.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result rDNSequence $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}
};

proc InformationFramework.RDNSequence.decode {value0 index optional explicit} {

proc intern46.decode {value0 index optional explicit} {
InformationFramework.RelativeDistinguishedName.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern46.decode $value0 $index false true]; }
; set tmp 
};

proc InformationFramework.RelativeDistinguishedName.decode {value0 index optional explicit} {

proc intern47.decode {value0 index optional explicit} {
InformationFramework.AttributeValueAssertion.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern47.decode $value0 $index false true]; }
; set tmp 
};

# ------------------------------
# Module
# ACSE-1
# Encoding procedures
# ------------------------------


proc ACSE-1.ACSE-apdu.encode value0 {
if {[tmns_keylget value0 aarq value1]} {ACSE-1.AARQ-apdu.encode $value1} else {if {[tmns_keylget value0 aare value1]} {ACSE-1.AARE-apdu.encode $value1} else {if {[tmns_keylget value0 rlrq value1]} {ACSE-1.RLRQ-apdu.encode $value1} else {if {[tmns_keylget value0 rlre value1]} {ACSE-1.RLRE-apdu.encode $value1} else {if {[tmns_keylget value0 abrt value1]} {ACSE-1.ABRT-apdu.encode $value1} else { error "Missing choice" }}}}}
};

proc ACSE-1.AARQ-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 0} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 protocol-version value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [BIT.encode $value1] } else { error "Can not find key protocol-version" }]  [if {[tmns_keylget value0 application-context-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [ACSE-1.Application-context-name.encode $value1] } else { error "Can not find key application-context-name" }]  [if {[tmns_keylget value0 called-AP-title value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ACSE-1.AP-title.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 called-AE-qualifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } [ACSE-1.AE-qualifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 called-AP-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ACSE-1.AP-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 called-AE-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [ACSE-1.AE-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AP-title value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [ACSE-1.AP-title.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AE-qualifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [ACSE-1.AE-qualifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AP-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } [ACSE-1.AP-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-AE-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT false} } [ACSE-1.AE-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 sender-acse-requirements value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } [ACSE-1.ACSE-requirements.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 mechanism-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT true} } [ACSE-1.Mechanism-name.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 calling-authentication-value value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT false} } [ACSE-1.Authentication-value.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 implementation-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } [ACSE-1.Implementation-data.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.AARE-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 1} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 protocol-version value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [BIT.encode $value1] } else { error "Can not find key protocol-version" }]  [if {[tmns_keylget value0 application-context-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [ACSE-1.Application-context-name.encode $value1] } else { error "Can not find key application-context-name" }]  [if {[tmns_keylget value0 result value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ACSE-1.Associate-result.encode $value1] } else { error "Can not find key result" }]  [if {[tmns_keylget value0 result-source-diagnostic value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } [ACSE-1.Associate-source-diagnostic.encode $value1] } else { error "Can not find key result-source-diagnostic" }]  [if {[tmns_keylget value0 responding-AP-title value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } [ACSE-1.AP-title.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-AE-qualifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } [ACSE-1.AE-qualifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-AP-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } [ACSE-1.AP-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-AE-invocation-identifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } [ACSE-1.AE-invocation-identifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responder-acse-requirements value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } [ACSE-1.ACSE-requirements.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 mechanism-name value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } [ACSE-1.Mechanism-name.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 responding-authentication-value value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT false} } [ACSE-1.Authentication-value.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 implementation-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } [ACSE-1.Implementation-data.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.RLRQ-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 2} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 reason value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [ACSE-1.Release-request-reason.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.RLRE-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 3} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 reason value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [ACSE-1.Release-response-reason.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.ABRT-apdu.encode value0 {
TAG.encode { {CLASS APPLICATION} {NUMBER 4} {IMPLICIT true} } [SEQUENCE.encode [if {[tmns_keylget value0 abort-source value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [ACSE-1.ABRT-source.encode $value1] } else { error "Can not find key abort-source" }]  [if {[tmns_keylget value0 abort-diagnostic value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [ACSE-1.ABRT-diagnostic.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 user-information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } [ACSE-1.Association-information.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] ] 
};

proc ACSE-1.ABRT-diagnostic.encode value0 {
if {$value0 == "no-reason-given"} {set value0 1}; if {$value0 == "protocol-error"} {set value0 2}; if {$value0 == "authentication-mechanism-name-not-recognized"} {set value0 3}; if {$value0 == "authentication-mechanism-name-required"} {set value0 4}; if {$value0 == "authentication-failure"} {set value0 5}; if {$value0 == "authentication-required"} {set value0 6}; ENUM.encode $value0
};

proc ACSE-1.ABRT-source.encode value0 {
if {$value0 == "acse-service-user"} {set value0 0}; if {$value0 == "acse-service-provider"} {set value0 1}; INTEGER.encode $value0
};

proc ACSE-1.ACSE-requirements.encode value0 {
BIT.encode $value0
};

proc ACSE-1.Application-context-name.encode value0 {
OID.encode $value0
};

proc ACSE-1.AP-title.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {ACSE-1.AP-title-form1.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {ACSE-1.AP-title-form2.encode $value1} else { error "Missing choice" }}
};

proc ACSE-1.AE-qualifier.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {ACSE-1.AE-qualifier-form1.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {ACSE-1.AE-qualifier-form2.encode $value1} else { error "Missing choice" }}
};

proc ACSE-1.AP-title-form1.encode value0 {
InformationFramework.Name.encode $value0
};

proc ACSE-1.AE-qualifier-form1.encode value0 {
InformationFramework.RelativeDistinguishedName.encode $value0
};

proc ACSE-1.AP-title-form2.encode value0 {
OID.encode $value0
};

proc ACSE-1.AE-qualifier-form2.encode value0 {
INTEGER.encode $value0
};

proc ACSE-1.AE-title.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {ACSE-1.AE-title-form1.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {ACSE-1.AE-title-form2.encode $value1} else { error "Missing choice" }}
};

proc ACSE-1.AE-title-form1.encode value0 {
InformationFramework.Name.encode $value0
};

proc ACSE-1.AE-title-form2.encode value0 {
OID.encode $value0
};

proc ACSE-1.AE-invocation-identifier.encode value0 {
INTEGER.encode $value0
};

proc ACSE-1.AP-invocation-identifier.encode value0 {
INTEGER.encode $value0
};

proc ACSE-1.Associate-result.encode value0 {
if {$value0 == "accepted"} {set value0 0}; if {$value0 == "rejected-permanent"} {set value0 1}; if {$value0 == "rejected-transient"} {set value0 2}; INTEGER.encode $value0
};

proc ACSE-1.Associate-source-diagnostic.encode value0 {
if {[tmns_keylget value0 acse-service-user value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [if {$value1 == "null"} {set value1 0}; if {$value1 == "no-reason-given"} {set value1 1}; if {$value1 == "application-context-name-not-supported"} {set value1 2}; if {$value1 == "calling-AP-title-not-recognized"} {set value1 3}; if {$value1 == "calling-AP-invocation-identifier-not-recognized"} {set value1 4}; if {$value1 == "calling-AE-qualifier-not-recognized"} {set value1 5}; if {$value1 == "calling-AE-invocation-identifier-not-recognized"} {set value1 6}; if {$value1 == "called-AP-title-not-recognized"} {set value1 7}; if {$value1 == "called-AP-invocation-identifier-not-recognized"} {set value1 8}; if {$value1 == "called-AE-qualifier-not-recognized"} {set value1 9}; if {$value1 == "called-AE-invocation-identifier-not-recognized"} {set value1 10}; if {$value1 == "authentication-mechanism-name-not-recognized"} {set value1 11}; if {$value1 == "authentication-mechanism-name-required"} {set value1 12}; if {$value1 == "authentication-failure"} {set value1 13}; if {$value1 == "authentication-required"} {set value1 14}; INTEGER.encode $value1] } else {if {[tmns_keylget value0 acse-service-provider value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [if {$value1 == "null"} {set value1 0}; if {$value1 == "no-reason-given"} {set value1 1}; if {$value1 == "no-common-acse-version"} {set value1 2}; INTEGER.encode $value1] } else { error "Missing choice" }}
};

proc ACSE-1.Association-information.encode value0 {

proc intern48 value0 {
EXTERNAL.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value0 {
  append toEval " \[" intern48 " [list $i] \]"
}
eval $toEval

};

proc ACSE-1.Authentication-value.encode value0 {
if {[tmns_keylget value0 charstring value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [GraphicString.encode $value1] } else {if {[tmns_keylget value0 bitstring value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [BIT.encode $value1] } else {if {[tmns_keylget value0 external value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [EXTERNAL.encode $value1] } else {if {[tmns_keylget value0 other value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [
proc intern49 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 other-mechanism-name value1]} {ACSE-1.Mechanism-name.encode $value1} else { error "Can not find key other-mechanism-name" }]  [if {[tmns_keylget value0 other-mechanism-value value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 other-mechanism-name value1]} {set value1} else { error "Can not find key other-mechanism-name" }] } else { error "Can not find key other-mechanism-value" }]  [if {[tmns_keylget value0 other value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [
proc intern50 value0 {
ANY.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value1 {
  append toEval " \[" intern50 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key other" }] 
};
intern49 $value1] } else { error "Missing choice" }}}}
};

proc ACSE-1.Implementation-data.encode value0 {
GraphicString.encode $value0
};

proc ACSE-1.Mechanism-name.encode value0 {
OID.encode $value0
};

proc ACSE-1.Release-request-reason.encode value0 {
if {$value0 == "normal"} {set value0 0}; if {$value0 == "urgent"} {set value0 1}; if {$value0 == "user-defined"} {set value0 30}; INTEGER.encode $value0
};

proc ACSE-1.Release-response-reason.encode value0 {
if {$value0 == "normal"} {set value0 0}; if {$value0 == "not-finished"} {set value0 1}; if {$value0 == "user-defined"} {set value0 30}; INTEGER.encode $value0
};

# ------------------------------
# Module
# ACSE-1
# Decoding procedures
# ------------------------------


proc ACSE-1.ACSE-apdu.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AARQ-apdu.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result aarq $tmp; set result } else {set tmp  [ACSE-1.AARE-apdu.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result aare $tmp; set result } else {set tmp  [ACSE-1.RLRQ-apdu.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result rlrq $tmp; set result } else {set tmp  [ACSE-1.RLRE-apdu.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result rlre $tmp; set result } else {set tmp  [ACSE-1.ABRT-apdu.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result abrt $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}}
};

proc ACSE-1.AARQ-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 0} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern51.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result protocol-version  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } false true; BIT.decode $value0 $index false false] ; tmns_keylset result application-context-name  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Application-context-name.decode $value0 $index false true] ; tmns_keylset result called-AP-title  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result called-AE-qualifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-qualifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result called-AP-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result called-AE-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result calling-AP-title  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result calling-AE-qualifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-qualifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result calling-AP-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result calling-AE-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result sender-acse-requirements  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.ACSE-requirements.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result mechanism-name  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Mechanism-name.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result calling-authentication-value  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.Authentication-value.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result implementation-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Implementation-data.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern51.decode $value0 $index false false
};

proc ACSE-1.AARE-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 1} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern52.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result protocol-version  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } false true; BIT.decode $value0 $index false false] ; tmns_keylset result application-context-name  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Application-context-name.decode $value0 $index false true] ; tmns_keylset result result  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Associate-result.decode $value0 $index false true] ; tmns_keylset result result-source-diagnostic  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ACSE-1.Associate-source-diagnostic.decode $value0 $index false true] ; tmns_keylset result responding-AP-title  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result responding-AE-qualifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-qualifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result responding-AP-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AP-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result responding-AE-invocation-identifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-invocation-identifier.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result responder-acse-requirements  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.ACSE-requirements.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result mechanism-name  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Mechanism-name.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result responding-authentication-value  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.Authentication-value.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result implementation-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 29} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Implementation-data.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern52.decode $value0 $index false false
};

proc ACSE-1.RLRQ-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 2} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern53.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result reason  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Release-request-reason.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern53.decode $value0 $index false false
};

proc ACSE-1.RLRE-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 3} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern54.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result reason  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Release-response-reason.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern54.decode $value0 $index false false
};

proc ACSE-1.ABRT-apdu.decode {value0 index optional explicit} {
if { [TAG.decode $value0 $index { {CLASS APPLICATION} {NUMBER 4} {IMPLICIT true} } $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; 
proc intern55.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result abort-source  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } false true; ACSE-1.ABRT-source.decode $value0 $index false false] ; tmns_keylset result abort-diagnostic  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.ABRT-diagnostic.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result user-information  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 30} {IMPLICIT true} } true true]  != "__tmns_opt"} {ACSE-1.Association-information.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};
intern55.decode $value0 $index false false
};

proc ACSE-1.ABRT-diagnostic.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "1"} {set simple no-reason-given}; if {$simple == "2"} {set simple protocol-error}; if {$simple == "3"} {set simple authentication-mechanism-name-not-recognized}; if {$simple == "4"} {set simple authentication-mechanism-name-required}; if {$simple == "5"} {set simple authentication-failure}; if {$simple == "6"} {set simple authentication-required}; set simple 
};

proc ACSE-1.ABRT-source.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple acse-service-user}; if {$simple == "1"} {set simple acse-service-provider}; set simple 
};

proc ACSE-1.ACSE-requirements.decode {value0 index optional explicit} {
BIT.decode $value0 $index $optional $explicit
};

proc ACSE-1.Application-context-name.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.AP-title.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AP-title-form1.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [ACSE-1.AP-title-form2.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.AE-qualifier.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AE-qualifier-form1.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [ACSE-1.AE-qualifier-form2.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.AP-title-form1.decode {value0 index optional explicit} {
InformationFramework.Name.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-qualifier-form1.decode {value0 index optional explicit} {
InformationFramework.RelativeDistinguishedName.decode $value0 $index $optional $explicit
};

proc ACSE-1.AP-title-form2.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-qualifier-form2.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-title.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AE-title-form1.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [ACSE-1.AE-title-form2.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.AE-title-form1.decode {value0 index optional explicit} {
InformationFramework.Name.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-title-form2.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.AE-invocation-identifier.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc ACSE-1.AP-invocation-identifier.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc ACSE-1.Associate-result.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple accepted}; if {$simple == "1"} {set simple rejected-permanent}; if {$simple == "2"} {set simple rejected-transient}; set simple 
};

proc ACSE-1.Associate-source-diagnostic.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple null}; if {$simple == "1"} {set simple no-reason-given}; if {$simple == "2"} {set simple application-context-name-not-supported}; if {$simple == "3"} {set simple calling-AP-title-not-recognized}; if {$simple == "4"} {set simple calling-AP-invocation-identifier-not-recognized}; if {$simple == "5"} {set simple calling-AE-qualifier-not-recognized}; if {$simple == "6"} {set simple calling-AE-invocation-identifier-not-recognized}; if {$simple == "7"} {set simple called-AP-title-not-recognized}; if {$simple == "8"} {set simple called-AP-invocation-identifier-not-recognized}; if {$simple == "9"} {set simple called-AE-qualifier-not-recognized}; if {$simple == "10"} {set simple called-AE-invocation-identifier-not-recognized}; if {$simple == "11"} {set simple authentication-mechanism-name-not-recognized}; if {$simple == "12"} {set simple authentication-mechanism-name-required}; if {$simple == "13"} {set simple authentication-failure}; if {$simple == "14"} {set simple authentication-required}; set simple } else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result acse-service-user $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple null}; if {$simple == "1"} {set simple no-reason-given}; if {$simple == "2"} {set simple no-common-acse-version}; set simple } else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result acse-service-provider $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc ACSE-1.Association-information.decode {value0 index optional explicit} {

proc intern56.decode {value0 index optional explicit} {
EXTERNAL.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern56.decode $value0 $index false true]; }
; set tmp 
};

proc ACSE-1.Authentication-value.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {GraphicString.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result charstring $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {BIT.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result bitstring $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {EXTERNAL.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result external $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern57.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result other-mechanism-name  [ACSE-1.Mechanism-name.decode $value0 $index false true] ; tmns_keylset result other-mechanism-value  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result other-mechanism-name value1]} {set value1} else { error "Can not find key other-mechanism-name" }] ] ; tmns_keylset result other  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } false true; 
proc intern58.decode {value0 index optional explicit} {
ANY.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern58.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};
intern57.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result other $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}}
};

proc ACSE-1.Implementation-data.decode {value0 index optional explicit} {
GraphicString.decode $value0 $index $optional $explicit
};

proc ACSE-1.Mechanism-name.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc ACSE-1.Release-request-reason.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple normal}; if {$simple == "1"} {set simple urgent}; if {$simple == "30"} {set simple user-defined}; set simple 
};

proc ACSE-1.Release-response-reason.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple normal}; if {$simple == "1"} {set simple not-finished}; if {$simple == "30"} {set simple user-defined}; set simple 
};

# ------------------------------
# Module
# CAT-ASN1Module
# Encoding procedures
# ------------------------------


proc CAT-ASN1Module.CatDummySyntax.encode value0 {
INTEGER.encode $value0
};

proc CAT-ASN1Module.CT-Moi.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 moc value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [CMIP-1.ObjectClass.encode $value1] } else { error "Can not find key moc" }]  [if {[tmns_keylget value0 instance value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else { error "Can not find key instance" }]  [if {[tmns_keylget value0 alias value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [GraphicString.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 nbdg value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } [OID.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 topMo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [BOOLEAN.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 initialMo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [BOOLEAN.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 referenceMo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [BOOLEAN.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 autoNamingMo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } [BOOLEAN.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 collapse value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } [BOOLEAN.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 initialValues value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } [
proc intern59 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern59 " [list $i] \]"
}
eval $toEval
] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 userData value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT true} } [OCTET.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 comments value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } [GraphicString.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc CAT-ASN1Module.CT-Mois.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 prefix value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 13} {IMPLICIT true} } [InformationFramework.DistinguishedName.encode $value1] } else { error "Can not find key prefix" }]  [if {[tmns_keylget value0 mois value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 14} {IMPLICIT true} } [
proc intern60 value0 {
CAT-ASN1Module.CT-Moi.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value1 {
  append toEval " \[" intern60 " [list $i] \]"
}
eval $toEval
] } else { error "Can not find key mois" }] 
};

proc CAT-ASN1Module.InvokeId.encode value0 {
INTEGER.encode $value0
};

proc CAT-ASN1Module.CatSizeType.encode value0 {
INTEGER.encode $value0
};

proc CAT-ASN1Module.NotDecoded.encode value0 {
ANY.encode $value0
};

proc CAT-ASN1Module.DummyAnyType.encode value0 {
OCTET.encode $value0
};

# ------------------------------
# Module
# CAT-ASN1Module
# Decoding procedures
# ------------------------------


proc CAT-ASN1Module.CatDummySyntax.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc CAT-ASN1Module.CT-Moi.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result moc  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.ObjectClass.decode $value0 $index false true] ; tmns_keylset result instance  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result alias  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {GraphicString.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result nbdg  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result topMo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {BOOLEAN.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result initialMo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {BOOLEAN.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result referenceMo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {BOOLEAN.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result autoNamingMo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } true true]  != "__tmns_opt"} {BOOLEAN.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result collapse  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } true true]  != "__tmns_opt"} {BOOLEAN.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result initialValues  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern61.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern61.decode $value0 $index false true]; }
; set tmp } else {set tmp "__tmns_opt"}; ] ; tmns_keylset result userData  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 11} {IMPLICIT true} } true true]  != "__tmns_opt"} {OCTET.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result comments  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 12} {IMPLICIT true} } true true]  != "__tmns_opt"} {GraphicString.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc CAT-ASN1Module.CT-Mois.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result prefix  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 13} {IMPLICIT true} } false true; InformationFramework.DistinguishedName.decode $value0 $index false false] ; tmns_keylset result mois  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 14} {IMPLICIT true} } false true; 
proc intern62.decode {value0 index optional explicit} {
CAT-ASN1Module.CT-Moi.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern62.decode $value0 $index false true]; }
; set tmp ] ; ; return $result
};

proc CAT-ASN1Module.InvokeId.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc CAT-ASN1Module.CatSizeType.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc CAT-ASN1Module.NotDecoded.decode {value0 index optional explicit} {
ANY.decode $value0 $index $optional $explicit
};

proc CAT-ASN1Module.DummyAnyType.decode {value0 index optional explicit} {
OCTET.decode $value0 $index $optional $explicit
};

# ------------------------------
# Module
# ManagedObjectClassesDefinitions
# Encoding procedures
# ------------------------------


# ------------------------------
# Module
# ManagedObjectClassesDefinitions
# Decoding procedures
# ------------------------------


# ------------------------------
# Module
# Attribute-ASN1Module
# Encoding procedures
# ------------------------------


proc Attribute-ASN1Module.ActiveDestination.encode value0 {
Attribute-ASN1Module.Destination.encode $value0
};

proc Attribute-ASN1Module.AdditionalText.encode value0 {
GraphicString.encode $value0
};

proc Attribute-ASN1Module.AdditionalInformation.encode value0 {

proc intern63 value0 {
Attribute-ASN1Module.ManagementExtension.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern63 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.Allomorphs.encode value0 {

proc intern64 value0 {
CMIP-1.ObjectClass.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern64 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AdministrativeState.encode value0 {
if {$value0 == "locked"} {set value0 0}; if {$value0 == "unlocked"} {set value0 1}; if {$value0 == "shuttingDown"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.AttributeIdentifierList.encode value0 {

proc intern65 value0 {
CMIP-1.AttributeId.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern65 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AttributeList.encode value0 {

proc intern66 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern66 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AttributeValueChangeDefinition.encode value0 {

proc intern67 value0 {

proc intern68 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 attributeID value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key attributeID" }]  [if {[tmns_keylget value0 oldAttributeValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeID value1]} {set value1} else { error "Can not find key attributeID" }] ] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 newAttributeValue value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 attributeID value1]} {set value1} else { error "Can not find key attributeID" }] ] } else { error "Can not find key newAttributeValue" }] 
};
intern68 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern67 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AlarmStatus.encode value0 {

proc intern69 value0 {
if {$value0 == "underRepair"} {set value0 0}; if {$value0 == "critical"} {set value0 1}; if {$value0 == "major"} {set value0 2}; if {$value0 == "minor"} {set value0 3}; if {$value0 == "alarmOutstanding"} {set value0 4}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern69 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.AvailabilityStatus.encode value0 {

proc intern70 value0 {
if {$value0 == "inTest"} {set value0 0}; if {$value0 == "failed"} {set value0 1}; if {$value0 == "powerOff"} {set value0 2}; if {$value0 == "offLine"} {set value0 3}; if {$value0 == "offDuty"} {set value0 4}; if {$value0 == "dependency"} {set value0 5}; if {$value0 == "degraded"} {set value0 6}; if {$value0 == "notInstalled"} {set value0 7}; if {$value0 == "logFull"} {set value0 8}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern70 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.BackedUpStatus.encode value0 {
BOOLEAN.encode $value0
};

proc Attribute-ASN1Module.BackUpDestinationList.encode value0 {

proc intern71 value0 {
ACSE-1.AE-title.encode $value0
};
set toEval SEQUENCE.encode;
foreach i $value0 {
  append toEval " \[" intern71 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.BackUpRelationshipObject.encode value0 {
if {[tmns_keylget value0 objectName value1]} {CMIP-1.ObjectInstance.encode $value1} else {if {[tmns_keylget value0 noObject value1]} {NULL.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.CapacityAlarmThreshold.encode value0 {

proc intern72 value0 {
INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern72 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.ConfirmedMode.encode value0 {
BOOLEAN.encode $value0
};

proc Attribute-ASN1Module.ControlStatus.encode value0 {

proc intern73 value0 {
if {$value0 == "subjectToTest"} {set value0 0}; if {$value0 == "partOfServicesLocked"} {set value0 1}; if {$value0 == "reservedForTest"} {set value0 2}; if {$value0 == "suspended"} {set value0 3}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern73 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.Count.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.CounterThreshold.encode value0 {

proc intern74 value0 {

proc intern75 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 comparisonLevel value1]} {INTEGER.encode $value1} else { error "Can not find key comparisonLevel" }]  [if {[tmns_keylget value0 offsetValue value1]} {INTEGER.encode $value1} else { error "Can not find key offsetValue" }]  [if {[tmns_keylget value0 notificationOnOff value1]} {BOOLEAN.encode $value1} else { error "Can not find key notificationOnOff" }] 
};
intern75 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern74 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.CorrelatedNotifications.encode value0 {

proc intern76 value0 {

proc intern77 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 correlatedNotifications value1]} {
proc intern78 value0 {
Attribute-ASN1Module.NotificationIdentifier.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern78 " [list $i] \]"
}
eval $toEval
} else { error "Can not find key correlatedNotifications" }]  [if {[tmns_keylget value0 sourceObjectInst value1]} {CMIP-1.ObjectInstance.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern77 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern76 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.CurrentLogSize.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.Destination.encode value0 {
if {[tmns_keylget value0 single value1]} {ACSE-1.AE-title.encode $value1} else {if {[tmns_keylget value0 multiple value1]} {
proc intern79 value0 {
ACSE-1.AE-title.encode $value0
};
set toEval SET.encode;
foreach i $value1 {
  append toEval " \[" intern79 " [list $i] \]"
}
eval $toEval
} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.DiscriminatorConstruct.encode value0 {
CMIP-1.CMISFilter.encode $value0
};

proc Attribute-ASN1Module.EventTime.encode value0 {
GeneralizedTime.encode $value0
};

proc Attribute-ASN1Module.GaugeThreshold.encode value0 {

proc intern80 value0 {

proc intern81 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 notifyLow value1]} {Attribute-ASN1Module.NotifyThreshold.encode $value1} else { error "Can not find key notifyLow" }]  [if {[tmns_keylget value0 notifyHigh value1]} {Attribute-ASN1Module.NotifyThreshold.encode $value1} else { error "Can not find key notifyHigh" }] 
};
intern81 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern80 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.GaugeThresholdValue.encode value0 {
Attribute-ASN1Module.ObservedValue.encode $value0
};

proc Attribute-ASN1Module.GroupObjects.encode value0 {

proc intern82 value0 {
CMIP-1.ObjectInstance.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern82 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.IntervalsOfDay.encode value0 {

proc intern83 value0 {

proc intern84 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 intervalStart value1]} {Attribute-ASN1Module.Time24.encode $value1} else { error "Can not find key intervalStart" }]  [if {[tmns_keylget value0 intervalEnd value1]} {Attribute-ASN1Module.Time24.encode $value1} else { error "Can not find key intervalEnd" }] 
};
intern84 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern83 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.LogAvailability.encode value0 {
Attribute-ASN1Module.AvailabilityStatus.encode $value0
};

proc Attribute-ASN1Module.LogFullAction.encode value0 {
if {$value0 == "wrap"} {set value0 0}; if {$value0 == "halt"} {set value0 1}; ENUM.encode $value0
};

proc Attribute-ASN1Module.LoggingTime.encode value0 {
GeneralizedTime.encode $value0
};

proc Attribute-ASN1Module.LogRecordId.encode value0 {
Attribute-ASN1Module.SimpleNameType.encode $value0
};

proc Attribute-ASN1Module.MaxLogSize.encode value0 {
if {$value0 == "unlimited"} {set value0 0}; INTEGER.encode $value0
};

proc Attribute-ASN1Module.ManagementExtension.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 identifier value1]} {OID.encode $value1} else { error "Can not find key identifier" }]  [if {[tmns_keylget value0 significance value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [BOOLEAN.encode $value1] } else { error "Can not find key significance" }]  [if {[tmns_keylget value0 information value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 identifier value1]} {set value1} else { error "Can not find key identifier" }] ] } else { error "Can not find key information" }] 
};

proc Attribute-ASN1Module.MonitoredAttributes.encode value0 {

proc intern85 value0 {
CMIP-1.Attribute.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern85 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.NameBinding.encode value0 {
OID.encode $value0
};

proc Attribute-ASN1Module.NotificationIdentifier.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.NotifyThreshold.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 threshold value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key threshold" }]  [if {[tmns_keylget value0 notifyOnOff value1]} {BOOLEAN.encode $value1} else { error "Can not find key notifyOnOff" }] 
};

proc Attribute-ASN1Module.NumberOfRecords.encode value0 {
INTEGER.encode $value0
};

proc Attribute-ASN1Module.ObservedValue.encode value0 {
if {[tmns_keylget value0 integer value1]} {INTEGER.encode $value1} else {if {[tmns_keylget value0 real value1]} {REAL.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.OperationalState.encode value0 {
if {$value0 == "disabled"} {set value0 0}; if {$value0 == "enabled"} {set value0 1}; ENUM.encode $value0
};

proc Attribute-ASN1Module.Packages.encode value0 {

proc intern86 value0 {
OID.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern86 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.PerceivedSeverity.encode value0 {
if {$value0 == "indeterminate"} {set value0 0}; if {$value0 == "critical"} {set value0 1}; if {$value0 == "major"} {set value0 2}; if {$value0 == "minor"} {set value0 3}; if {$value0 == "warning"} {set value0 4}; if {$value0 == "cleared"} {set value0 5}; ENUM.encode $value0
};

proc Attribute-ASN1Module.PrioritisedObject.encode value0 {

proc intern87 value0 {

proc intern88 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 object value1]} {CMIP-1.ObjectInstance.encode $value1} else { error "Can not find key object" }]  [if {[tmns_keylget value0 priority value1]} {if {$value1 == "lowest"} {set value1 0}; if {$value1 == "highest"} {set value1 127}; INTEGER.encode $value1} else { error "Can not find key priority" }] 
};
intern88 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern87 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.ProbableCause.encode value0 {
if {[tmns_keylget value0 globalValue value1]} {OID.encode $value1} else {if {[tmns_keylget value0 localValue value1]} {INTEGER.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.ProceduralStatus.encode value0 {

proc intern89 value0 {
if {$value0 == "initializationRequired"} {set value0 0}; if {$value0 == "notInitialized"} {set value0 1}; if {$value0 == "initializing"} {set value0 2}; if {$value0 == "reporting"} {set value0 3}; if {$value0 == "terminating"} {set value0 4}; INTEGER.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern89 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.ProposedRepairActions.encode value0 {

proc intern90 value0 {
Attribute-ASN1Module.SpecificIdentifier.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern90 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.SchedulingAvailability.encode value0 {
Attribute-ASN1Module.AvailabilityStatus.encode $value0
};

proc Attribute-ASN1Module.SecurityAlarmCause.encode value0 {
OID.encode $value0
};

proc Attribute-ASN1Module.SecurityAlarmSeverity.encode value0 {
Attribute-ASN1Module.PerceivedSeverity.encode $value0
};

proc Attribute-ASN1Module.SecurityAlarmDetector.encode value0 {
if {[tmns_keylget value0 mechanism value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } [OID.encode $value1] } else {if {[tmns_keylget value0 object value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else {if {[tmns_keylget value0 application value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [ACSE-1.AE-title.encode $value1] } else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.ServiceProvider.encode value0 {
Attribute-ASN1Module.ServiceUser.encode $value0
};

proc Attribute-ASN1Module.ServiceUser.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 identifier value1]} {OID.encode $value1} else { error "Can not find key identifier" }]  [if {[tmns_keylget value0 details value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 identifier value1]} {set value1} else { error "Can not find key identifier" }] } else { error "Can not find key details" }] 
};

proc Attribute-ASN1Module.SimpleNameType.encode value0 {
if {[tmns_keylget value0 number value1]} {INTEGER.encode $value1} else {if {[tmns_keylget value0 string value1]} {GraphicString.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.SpecificIdentifier.encode value0 {
if {[tmns_keylget value0 --nofield1 value1]} {OID.encode $value1} else {if {[tmns_keylget value0 --nofield2 value1]} {INTEGER.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.SourceIndicator.encode value0 {
if {$value0 == "resourceOperation"} {set value0 0}; if {$value0 == "managementOperation"} {set value0 1}; if {$value0 == "unknown"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.SpecificProblems.encode value0 {

proc intern91 value0 {
Attribute-ASN1Module.SpecificIdentifier.encode $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern91 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.StandbyStatus.encode value0 {
if {$value0 == "hotStandby"} {set value0 0}; if {$value0 == "coldStandby"} {set value0 1}; if {$value0 == "providingService"} {set value0 2}; INTEGER.encode $value0
};

proc Attribute-ASN1Module.StartTime.encode value0 {
GeneralizedTime.encode $value0
};

proc Attribute-ASN1Module.StopTime.encode value0 {
if {[tmns_keylget value0 specific value1]} {GeneralizedTime.encode $value1} else {if {[tmns_keylget value0 continual value1]} {NULL.encode $value1} else { error "Missing choice" }}
};

proc Attribute-ASN1Module.SupportedFeatures.encode value0 {

proc intern92 value0 {

proc intern93 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 featureIdentifier value1]} {OID.encode $value1} else { error "Can not find key featureIdentifier" }]  [if {[tmns_keylget value0 featureInfo value1]} {ANY_DEF_BY.encode $value1 [if {[tmns_keylget value0 featureIdentifier value1]} {set value1} else { error "Can not find key featureIdentifier" }] } else { error "Can not find key featureInfo" }] 
};
intern93 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern92 " [list $i] \]"
}
eval $toEval

};

proc Attribute-ASN1Module.SystemId.encode value0 {
if {[tmns_keylget value0 name value1]} {GraphicString.encode $value1} else {if {[tmns_keylget value0 number value1]} {INTEGER.encode $value1} else {if {[tmns_keylget value0 nothing value1]} {NULL.encode $value1} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SystemTitle.encode value0 {
if {[tmns_keylget value0 distinguishedName value1]} {InformationFramework.DistinguishedName.encode $value1} else {if {[tmns_keylget value0 oid value1]} {OID.encode $value1} else {if {[tmns_keylget value0 nothing value1]} {NULL.encode $value1} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.TideMarkInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 currentTideMark value1]} {Attribute-ASN1Module.TideMark.encode $value1} else { error "Can not find key currentTideMark" }]  [if {[tmns_keylget value0 previousTideMark value1]} {Attribute-ASN1Module.TideMark.encode $value1} else { error "Can not find key previousTideMark" }]  [if {[tmns_keylget value0 resetTime value1]} {GeneralizedTime.encode $value1} else { error "Can not find key resetTime" }] 
};

proc Attribute-ASN1Module.TideMark.encode value0 {
if {[tmns_keylget value0 maxTideMar value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } [Attribute-ASN1Module.ObservedValue.encode $value1] } else {if {[tmns_keylget value0 minTideMark value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [Attribute-ASN1Module.ObservedValue.encode $value1] } else { error "Missing choice" }}
};

proc Attribute-ASN1Module.Time24.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 hour value1]} {INTEGER.encode $value1} else { error "Can not find key hour" }]  [if {[tmns_keylget value0 minute value1]} {INTEGER.encode $value1} else { error "Can not find key minute" }] 
};

proc Attribute-ASN1Module.ThresholdInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 triggeredThreshold value1]} {CMIP-1.AttributeId.encode $value1} else { error "Can not find key triggeredThreshold" }]  [if {[tmns_keylget value0 observedValue value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key observedValue" }]  [if {[tmns_keylget value0 thresholdLevel value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } [Attribute-ASN1Module.ThresholdLevelInd.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 armTime value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [GeneralizedTime.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Attribute-ASN1Module.ThresholdLevelInd.encode value0 {
if {[tmns_keylget value0 up value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [
proc intern94 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 high value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key high" }]  [if {[tmns_keylget value0 low value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};
intern94 $value1] } else {if {[tmns_keylget value0 down value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [
proc intern95 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 high value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key high" }]  [if {[tmns_keylget value0 low value1]} {Attribute-ASN1Module.ObservedValue.encode $value1} else { error "Can not find key low" }] 
};
intern95 $value1] } else { error "Missing choice" }}
};

proc Attribute-ASN1Module.TrendIndication.encode value0 {
if {$value0 == "lessSevere"} {set value0 0}; if {$value0 == "noChange"} {set value0 1}; if {$value0 == "moreSevere"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.UnknownStatus.encode value0 {
BOOLEAN.encode $value0
};

proc Attribute-ASN1Module.UnscheduledLogAvailability.encode value0 {
Attribute-ASN1Module.AvailabilityStatus.encode $value0
};

proc Attribute-ASN1Module.UsageState.encode value0 {
if {$value0 == "idle"} {set value0 0}; if {$value0 == "active"} {set value0 1}; if {$value0 == "busy"} {set value0 2}; ENUM.encode $value0
};

proc Attribute-ASN1Module.WeekMask.encode value0 {

proc intern96 value0 {

proc intern97 value0 {
SEQUENCE.encode [if {[tmns_keylget value0 daysOfWeek value1]} {BIT.encode $value1} else { error "Can not find key daysOfWeek" }]  [if {[tmns_keylget value0 intervalsOfDay value1]} {Attribute-ASN1Module.IntervalsOfDay.encode $value1} else { error "Can not find key intervalsOfDay" }] 
};
intern97 $value0
};
set toEval SET.encode;
foreach i $value0 {
  append toEval " \[" intern96 " [list $i] \]"
}
eval $toEval

};

# ------------------------------
# Module
# Attribute-ASN1Module
# Decoding procedures
# ------------------------------


proc Attribute-ASN1Module.ActiveDestination.decode {value0 index optional explicit} {
Attribute-ASN1Module.Destination.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.AdditionalText.decode {value0 index optional explicit} {
GraphicString.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.AdditionalInformation.decode {value0 index optional explicit} {

proc intern98.decode {value0 index optional explicit} {
Attribute-ASN1Module.ManagementExtension.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern98.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.Allomorphs.decode {value0 index optional explicit} {

proc intern99.decode {value0 index optional explicit} {
CMIP-1.ObjectClass.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern99.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AdministrativeState.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple locked}; if {$simple == "1"} {set simple unlocked}; if {$simple == "2"} {set simple shuttingDown}; set simple 
};

proc Attribute-ASN1Module.AttributeIdentifierList.decode {value0 index optional explicit} {

proc intern100.decode {value0 index optional explicit} {
CMIP-1.AttributeId.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern100.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AttributeList.decode {value0 index optional explicit} {

proc intern101.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern101.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AttributeValueChangeDefinition.decode {value0 index optional explicit} {

proc intern102.decode {value0 index optional explicit} {

proc intern103.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result attributeID  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result oldAttributeValue  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeID value1]} {set value1} else { error "Can not find key attributeID" }] } else {set tmp "__tmns_opt"}; ] ; tmns_keylset result newAttributeValue  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result attributeID value1]} {set value1} else { error "Can not find key attributeID" }] ] ; ; return $result
};
intern103.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern102.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AlarmStatus.decode {value0 index optional explicit} {

proc intern104.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple underRepair}; if {$simple == "1"} {set simple critical}; if {$simple == "2"} {set simple major}; if {$simple == "3"} {set simple minor}; if {$simple == "4"} {set simple alarmOutstanding}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern104.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.AvailabilityStatus.decode {value0 index optional explicit} {

proc intern105.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple inTest}; if {$simple == "1"} {set simple failed}; if {$simple == "2"} {set simple powerOff}; if {$simple == "3"} {set simple offLine}; if {$simple == "4"} {set simple offDuty}; if {$simple == "5"} {set simple dependency}; if {$simple == "6"} {set simple degraded}; if {$simple == "7"} {set simple notInstalled}; if {$simple == "8"} {set simple logFull}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern105.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.BackedUpStatus.decode {value0 index optional explicit} {
BOOLEAN.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.BackUpDestinationList.decode {value0 index optional explicit} {

proc intern106.decode {value0 index optional explicit} {
ACSE-1.AE-title.decode $value0 $index false true
};
if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern106.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.BackUpRelationshipObject.decode {value0 index optional explicit} {
set tmp  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result objectName $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result noObject $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.CapacityAlarmThreshold.decode {value0 index optional explicit} {

proc intern107.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern107.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.ConfirmedMode.decode {value0 index optional explicit} {
BOOLEAN.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.ControlStatus.decode {value0 index optional explicit} {

proc intern108.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple subjectToTest}; if {$simple == "1"} {set simple partOfServicesLocked}; if {$simple == "2"} {set simple reservedForTest}; if {$simple == "3"} {set simple suspended}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern108.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.Count.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.CounterThreshold.decode {value0 index optional explicit} {

proc intern109.decode {value0 index optional explicit} {

proc intern110.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result comparisonLevel  [INTEGER.decode $value0 $index false true] ; tmns_keylset result offsetValue  [INTEGER.decode $value0 $index false true] ; tmns_keylset result notificationOnOff  [BOOLEAN.decode $value0 $index false true] ; ; return $result
};
intern110.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern109.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.CorrelatedNotifications.decode {value0 index optional explicit} {

proc intern111.decode {value0 index optional explicit} {

proc intern112.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result correlatedNotifications  [
proc intern113.decode {value0 index optional explicit} {
Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index false true
};
if { [SET.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern113.decode $value0 $index false true]; }
; set tmp ] ; tmns_keylset result sourceObjectInst  [CMIP-1.ObjectInstance.decode $value0 $index true true] ; ; return $result
};
intern112.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern111.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.CurrentLogSize.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.Destination.decode {value0 index optional explicit} {
set tmp  [ACSE-1.AE-title.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result single $tmp; set result } else {set tmp  [
proc intern114.decode {value0 index optional explicit} {
ACSE-1.AE-title.decode $value0 $index false true
};
if { [SET.decode $value0 $index true true]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern114.decode $value0 $index false true]; }
; set tmp ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result multiple $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.DiscriminatorConstruct.decode {value0 index optional explicit} {
CMIP-1.CMISFilter.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.EventTime.decode {value0 index optional explicit} {
GeneralizedTime.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.GaugeThreshold.decode {value0 index optional explicit} {

proc intern115.decode {value0 index optional explicit} {

proc intern116.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result notifyLow  [Attribute-ASN1Module.NotifyThreshold.decode $value0 $index false true] ; tmns_keylset result notifyHigh  [Attribute-ASN1Module.NotifyThreshold.decode $value0 $index false true] ; ; return $result
};
intern116.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern115.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.GaugeThresholdValue.decode {value0 index optional explicit} {
Attribute-ASN1Module.ObservedValue.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.GroupObjects.decode {value0 index optional explicit} {

proc intern117.decode {value0 index optional explicit} {
CMIP-1.ObjectInstance.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern117.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.IntervalsOfDay.decode {value0 index optional explicit} {

proc intern118.decode {value0 index optional explicit} {

proc intern119.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result intervalStart  [Attribute-ASN1Module.Time24.decode $value0 $index false true] ; tmns_keylset result intervalEnd  [Attribute-ASN1Module.Time24.decode $value0 $index false true] ; ; return $result
};
intern119.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern118.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.LogAvailability.decode {value0 index optional explicit} {
Attribute-ASN1Module.AvailabilityStatus.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.LogFullAction.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple wrap}; if {$simple == "1"} {set simple halt}; set simple 
};

proc Attribute-ASN1Module.LoggingTime.decode {value0 index optional explicit} {
GeneralizedTime.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.LogRecordId.decode {value0 index optional explicit} {
Attribute-ASN1Module.SimpleNameType.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.MaxLogSize.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple unlimited}; set simple 
};

proc Attribute-ASN1Module.ManagementExtension.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result identifier  [OID.decode $value0 $index false true] ; tmns_keylset result significance  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } false true; BOOLEAN.decode $value0 $index false false] ; tmns_keylset result information  [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } false true; LENGTH.decode $value0 $index; ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result identifier value1]} {set value1} else { error "Can not find key identifier" }] ] ; ; return $result
};

proc Attribute-ASN1Module.MonitoredAttributes.decode {value0 index optional explicit} {

proc intern120.decode {value0 index optional explicit} {
CMIP-1.Attribute.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern120.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.NameBinding.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.NotificationIdentifier.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.NotifyThreshold.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result threshold  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; tmns_keylset result notifyOnOff  [BOOLEAN.decode $value0 $index false true] ; ; return $result
};

proc Attribute-ASN1Module.NumberOfRecords.decode {value0 index optional explicit} {
INTEGER.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.ObservedValue.decode {value0 index optional explicit} {
set tmp  [INTEGER.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result integer $tmp; set result } else {set tmp  [REAL.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result real $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.OperationalState.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple disabled}; if {$simple == "1"} {set simple enabled}; set simple 
};

proc Attribute-ASN1Module.Packages.decode {value0 index optional explicit} {

proc intern121.decode {value0 index optional explicit} {
OID.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern121.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.PerceivedSeverity.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple indeterminate}; if {$simple == "1"} {set simple critical}; if {$simple == "2"} {set simple major}; if {$simple == "3"} {set simple minor}; if {$simple == "4"} {set simple warning}; if {$simple == "5"} {set simple cleared}; set simple 
};

proc Attribute-ASN1Module.PrioritisedObject.decode {value0 index optional explicit} {

proc intern122.decode {value0 index optional explicit} {

proc intern123.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result object  [CMIP-1.ObjectInstance.decode $value0 $index false true] ; tmns_keylset result priority  [set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple lowest}; if {$simple == "127"} {set simple highest}; set simple ] ; ; return $result
};
intern123.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern122.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.ProbableCause.decode {value0 index optional explicit} {
set tmp  [OID.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result globalValue $tmp; set result } else {set tmp  [INTEGER.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result localValue $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.ProceduralStatus.decode {value0 index optional explicit} {

proc intern124.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index false true] ; if {$simple == "0"} {set simple initializationRequired}; if {$simple == "1"} {set simple notInitialized}; if {$simple == "2"} {set simple initializing}; if {$simple == "3"} {set simple reporting}; if {$simple == "4"} {set simple terminating}; set simple 
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern124.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.ProposedRepairActions.decode {value0 index optional explicit} {

proc intern125.decode {value0 index optional explicit} {
Attribute-ASN1Module.SpecificIdentifier.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern125.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.SchedulingAvailability.decode {value0 index optional explicit} {
Attribute-ASN1Module.AvailabilityStatus.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.SecurityAlarmCause.decode {value0 index optional explicit} {
OID.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.SecurityAlarmSeverity.decode {value0 index optional explicit} {
Attribute-ASN1Module.PerceivedSeverity.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.SecurityAlarmDetector.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT true} } true true]  != "__tmns_opt"} {OID.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result mechanism $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result object $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; ACSE-1.AE-title.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result application $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc Attribute-ASN1Module.ServiceProvider.decode {value0 index optional explicit} {
Attribute-ASN1Module.ServiceUser.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.ServiceUser.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result identifier  [OID.decode $value0 $index false true] ; tmns_keylset result details  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result identifier value1]} {set value1} else { error "Can not find key identifier" }] ] ; ; return $result
};

proc Attribute-ASN1Module.SimpleNameType.decode {value0 index optional explicit} {
set tmp  [INTEGER.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result number $tmp; set result } else {set tmp  [GraphicString.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result string $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SpecificIdentifier.decode {value0 index optional explicit} {
set tmp  [OID.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield1 $tmp; set result } else {set tmp  [INTEGER.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result --nofield2 $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SourceIndicator.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple resourceOperation}; if {$simple == "1"} {set simple managementOperation}; if {$simple == "2"} {set simple unknown}; set simple 
};

proc Attribute-ASN1Module.SpecificProblems.decode {value0 index optional explicit} {

proc intern126.decode {value0 index optional explicit} {
Attribute-ASN1Module.SpecificIdentifier.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern126.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.StandbyStatus.decode {value0 index optional explicit} {
set simple  [INTEGER.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple hotStandby}; if {$simple == "1"} {set simple coldStandby}; if {$simple == "2"} {set simple providingService}; set simple 
};

proc Attribute-ASN1Module.StartTime.decode {value0 index optional explicit} {
GeneralizedTime.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.StopTime.decode {value0 index optional explicit} {
set tmp  [GeneralizedTime.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result specific $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result continual $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.SupportedFeatures.decode {value0 index optional explicit} {

proc intern127.decode {value0 index optional explicit} {

proc intern128.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result featureIdentifier  [OID.decode $value0 $index false true] ; tmns_keylset result featureInfo  [ANY_DEF_BY.decode $value0 $index false true [if {[tmns_keylget result featureIdentifier value1]} {set value1} else { error "Can not find key featureIdentifier" }] ] ; ; return $result
};
intern128.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern127.decode $value0 $index false true]; }
; set tmp 
};

proc Attribute-ASN1Module.SystemId.decode {value0 index optional explicit} {
set tmp  [GraphicString.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result name $tmp; set result } else {set tmp  [INTEGER.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result number $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result nothing $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc Attribute-ASN1Module.SystemTitle.decode {value0 index optional explicit} {
set tmp  [InformationFramework.DistinguishedName.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result distinguishedName $tmp; set result } else {set tmp  [OID.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result oid $tmp; set result } else {set tmp  [NULL.decode $value0 $index true true] ; if {$tmp != "__tmns_opt"} {tmns_keylset result nothing $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}}
};

proc Attribute-ASN1Module.TideMarkInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result currentTideMark  [Attribute-ASN1Module.TideMark.decode $value0 $index false true] ; tmns_keylset result previousTideMark  [Attribute-ASN1Module.TideMark.decode $value0 $index false true] ; tmns_keylset result resetTime  [GeneralizedTime.decode $value0 $index false true] ; ; return $result
};

proc Attribute-ASN1Module.TideMark.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 0} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; Attribute-ASN1Module.ObservedValue.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result maxTideMar $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; Attribute-ASN1Module.ObservedValue.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result minTideMark $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.Time24.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result hour  [INTEGER.decode $value0 $index false true] ; tmns_keylset result minute  [INTEGER.decode $value0 $index false true] ; ; return $result
};

proc Attribute-ASN1Module.ThresholdInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result triggeredThreshold  [CMIP-1.AttributeId.decode $value0 $index false true] ; tmns_keylset result observedValue  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; tmns_keylset result thresholdLevel  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; Attribute-ASN1Module.ThresholdLevelInd.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result armTime  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {GeneralizedTime.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Attribute-ASN1Module.ThresholdLevelInd.decode {value0 index optional explicit} {
set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern129.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result high  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; tmns_keylset result low  [Attribute-ASN1Module.ObservedValue.decode $value0 $index true true] ; ; return $result
};
intern129.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result up $tmp; set result } else {set tmp  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {
proc intern130.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false false]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result high  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; tmns_keylset result low  [Attribute-ASN1Module.ObservedValue.decode $value0 $index false true] ; ; return $result
};
intern130.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; if {$tmp != "__tmns_opt"} {tmns_keylset result down $tmp; set result } else {if {$optional == "true"} {return "__tmns_opt"} else { error "Missing choice" }}}
};

proc Attribute-ASN1Module.TrendIndication.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple lessSevere}; if {$simple == "1"} {set simple noChange}; if {$simple == "2"} {set simple moreSevere}; set simple 
};

proc Attribute-ASN1Module.UnknownStatus.decode {value0 index optional explicit} {
BOOLEAN.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.UnscheduledLogAvailability.decode {value0 index optional explicit} {
Attribute-ASN1Module.AvailabilityStatus.decode $value0 $index $optional $explicit
};

proc Attribute-ASN1Module.UsageState.decode {value0 index optional explicit} {
set simple  [ENUM.decode $value0 $index $optional $explicit] ; if {$simple == "0"} {set simple idle}; if {$simple == "1"} {set simple active}; if {$simple == "2"} {set simple busy}; set simple 
};

proc Attribute-ASN1Module.WeekMask.decode {value0 index optional explicit} {

proc intern131.decode {value0 index optional explicit} {

proc intern132.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index false true]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result daysOfWeek  [BIT.decode $value0 $index false true] ; tmns_keylset result intervalsOfDay  [Attribute-ASN1Module.IntervalsOfDay.decode $value0 $index false true] ; ; return $result
};
intern132.decode $value0 $index false true
};
if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {}; 
upvar #0 $index loop;
set total [expr $length + $loop];
while {$loop < $total} {
lappend tmp [intern131.decode $value0 $index false true]; }
; set tmp 
};

# ------------------------------
# Module
# Notification-ASN1Module
# Encoding procedures
# ------------------------------


proc Notification-ASN1Module.AlarmInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 probableCause value1]} {Attribute-ASN1Module.ProbableCause.encode $value1} else { error "Can not find key probableCause" }]  [if {[tmns_keylget value0 specificProblems value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.SpecificProblems.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 perceivedSeverity value1]} {Attribute-ASN1Module.PerceivedSeverity.encode $value1} else { error "Can not find key perceivedSeverity" }]  [if {[tmns_keylget value0 backedUpStatus value1]} {Attribute-ASN1Module.BackedUpStatus.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 backUpObject value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } [CMIP-1.ObjectInstance.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 trendIndication value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.TrendIndication.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 thresholdInfo value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } [Attribute-ASN1Module.ThresholdInfo.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 notificationIdentifier value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } [Attribute-ASN1Module.NotificationIdentifier.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 stateChangeDefinition value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } [Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 monitoredAttributes value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } [Attribute-ASN1Module.MonitoredAttributes.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 proposedRepairActions value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } [Attribute-ASN1Module.ProposedRepairActions.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.AttributeValueChangeInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeIdentifierList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.AttributeIdentifierList.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeValueChangeDefinition value1]} {Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1} else { error "Can not find key attributeValueChangeDefinition" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.ObjectInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeList value1]} {Attribute-ASN1Module.AttributeList.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.RelationshipChangeInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeIdentifierList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.AttributeIdentifierList.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 relationshipChangeDefinition value1]} {Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1} else { error "Can not find key relationshipChangeDefinition" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.StateChangeInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 sourceIndicator value1]} {Attribute-ASN1Module.SourceIndicator.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 attributeIdentifierList value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.AttributeIdentifierList.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 stateChangeDefinition value1]} {Attribute-ASN1Module.AttributeValueChangeDefinition.encode $value1} else { error "Can not find key stateChangeDefinition" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

proc Notification-ASN1Module.SecurityAlarmInfo.encode value0 {
SEQUENCE.encode [if {[tmns_keylget value0 securityAlarmCause value1]} {Attribute-ASN1Module.SecurityAlarmCause.encode $value1} else { error "Can not find key securityAlarmCause" }]  [if {[tmns_keylget value0 securityAlarmSeverity value1]} {Attribute-ASN1Module.SecurityAlarmSeverity.encode $value1} else { error "Can not find key securityAlarmSeverity" }]  [if {[tmns_keylget value0 securityAlarmDetector value1]} {Attribute-ASN1Module.SecurityAlarmDetector.encode $value1} else { error "Can not find key securityAlarmDetector" }]  [if {[tmns_keylget value0 serviceUser value1]} {Attribute-ASN1Module.ServiceUser.encode $value1} else { error "Can not find key serviceUser" }]  [if {[tmns_keylget value0 serviceProvider value1]} {Attribute-ASN1Module.ServiceProvider.encode $value1} else { error "Can not find key serviceProvider" }]  [if {[tmns_keylget value0 notificationIdentifier value1]} {Attribute-ASN1Module.NotificationIdentifier.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 correlatedNotifications value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } [Attribute-ASN1Module.CorrelatedNotifications.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalText value1]} {Attribute-ASN1Module.AdditionalText.encode $value1} else { set asn1_error {{LENGTH 0} {TAG 00}}}]  [if {[tmns_keylget value0 additionalInformation value1]} {TAG.encode { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } [Attribute-ASN1Module.AdditionalInformation.encode $value1] } else { set asn1_error {{LENGTH 0} {TAG 00}}}] 
};

# ------------------------------
# Module
# Notification-ASN1Module
# Decoding procedures
# ------------------------------


proc Notification-ASN1Module.AlarmInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result probableCause  [Attribute-ASN1Module.ProbableCause.decode $value0 $index false true] ; tmns_keylset result specificProblems  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.SpecificProblems.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result perceivedSeverity  [Attribute-ASN1Module.PerceivedSeverity.decode $value0 $index false true] ; tmns_keylset result backedUpStatus  [Attribute-ASN1Module.BackedUpStatus.decode $value0 $index true true] ; tmns_keylset result backUpObject  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT false} } true true]  != "__tmns_opt"} {LENGTH.decode $value0 $index; CMIP-1.ObjectInstance.decode $value0 $index false true} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result trendIndication  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.TrendIndication.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result thresholdInfo  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.ThresholdInfo.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result notificationIdentifier  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 5} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 6} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result stateChangeDefinition  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 7} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result monitoredAttributes  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.MonitoredAttributes.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result proposedRepairActions  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 9} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.ProposedRepairActions.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 10} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.AttributeValueChangeInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; tmns_keylset result attributeIdentifierList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeIdentifierList.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result attributeValueChangeDefinition  [Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false true] ; tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.ObjectInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; tmns_keylset result attributeList  [Attribute-ASN1Module.AttributeList.decode $value0 $index true true] ; tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.RelationshipChangeInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; tmns_keylset result attributeIdentifierList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeIdentifierList.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result relationshipChangeDefinition  [Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false true] ; tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.StateChangeInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result sourceIndicator  [Attribute-ASN1Module.SourceIndicator.decode $value0 $index true true] ; tmns_keylset result attributeIdentifierList  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AttributeIdentifierList.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result stateChangeDefinition  [Attribute-ASN1Module.AttributeValueChangeDefinition.decode $value0 $index false true] ; tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 3} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

proc Notification-ASN1Module.SecurityAlarmInfo.decode {value0 index optional explicit} {
set result {}; if { [SEQUENCE.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; LENGTH.decode $value0 $index; tmns_keylset result securityAlarmCause  [Attribute-ASN1Module.SecurityAlarmCause.decode $value0 $index false true] ; tmns_keylset result securityAlarmSeverity  [Attribute-ASN1Module.SecurityAlarmSeverity.decode $value0 $index false true] ; tmns_keylset result securityAlarmDetector  [Attribute-ASN1Module.SecurityAlarmDetector.decode $value0 $index false true] ; tmns_keylset result serviceUser  [Attribute-ASN1Module.ServiceUser.decode $value0 $index false true] ; tmns_keylset result serviceProvider  [Attribute-ASN1Module.ServiceProvider.decode $value0 $index false true] ; tmns_keylset result notificationIdentifier  [Attribute-ASN1Module.NotificationIdentifier.decode $value0 $index true true] ; tmns_keylset result correlatedNotifications  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.CorrelatedNotifications.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; tmns_keylset result additionalText  [Attribute-ASN1Module.AdditionalText.decode $value0 $index true true] ; tmns_keylset result additionalInformation  [if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {Attribute-ASN1Module.AdditionalInformation.decode $value0 $index false false} else {set tmp "__tmns_opt"}; ] ; ; return $result
};

# ------------------------------
# Module
# Parameter-ASN1Module
# Encoding procedures
# ------------------------------


proc Parameter-ASN1Module.MiscellaneousError.encode value0 {
NULL.encode $value0
};

# ------------------------------
# Module
# Parameter-ASN1Module
# Decoding procedures
# ------------------------------


proc Parameter-ASN1Module.MiscellaneousError.decode {value0 index optional explicit} {
NULL.decode $value0 $index $optional $explicit
};

puts stdout "End loading ASN1 parser information"

