
#pragma ident "@(#)tmns_type.tcl	1.3 96/07/04 Copyright SMI"

#*****************************************************************************#
#*          # Copyright 01/10/97 Sun Microsystems, Inc. All Rights Reserved        #
#*			All Rights Reserved				      #
#*****************************************************************************#

# The file contains TCL procedures allowing an application to use TMNscript
# representation for common types within user defined types.
# The file should be loaded after having loaded all encoding/decoding scripts.
#
# Example:
#   if you define an ASN.1 type as follows:
#        UserType ::= SEQUENCE {
#                       id              AttributeId,
#                       moc             ObjectClass
#               }
#       If you do not load this file into TMNscript interpreter, a value
#       of type UserType will be represented as follows:
#       set valueOfUserType {{id {{globalForm 1.2.3}}} {moc {localForm 10}}}
#
#       If you load the current file into TMNscript interpreter, a value
#       of type UserType will be represented much simpler as follows:
#       set valueOfUserType {{id 1.2.3} {moc  10}}
#
# The file contains TCL procedures overloading encoding/decoding ASN.1
# functions for some of the common CMIS and DMI types.
# For instance, in the example above, if you define UserType, you would need
# to import the AttributeId and the ObjectClass from the CMIP-1 module.
# The code generated by the ASN.1 compiler would call encoding/decoding
# functions for AttributeId and ObjectClass.
# By loading this current file, you would overload (or define) generated
# functions for encoding/decoding AttributeId and ObjectClass by special
# functions provided by TMNscript. The new functions would allow you to use
# the common type representation within the UserType type.
#
# TMNscript allows you to use a special representation for the following
# types (or user defined types including the following types):
#		CMIP-1.Attribute
#		CMIP-1.AttributeId
#		CMIP-1.ActionInfo
#		CMIP-1.ActionReply
#		CMIP-1.ActionTypeId
#		CMIP-1.CMISFilter
#		CMIP-1.EventReply
#		CMIP-1.EventTypeId
#		CMIP-1.ModifyOperator
#		CMIP-1.ObjectClass
#		CMIP-1.ObjectInstance
#		CMIP-1.Scope
#		CMIP-1.SpecificErrorInfo
#		Attribute-ASN1Module.SystemId
#		Attribute-ASN1Module.SimpleNameType
#		InformationFramework.AttributeValueAssertion
#		InformationFramework.RelativeDistinguishedName
#
# If you wish to use the representation for only a subset of common types,
# you only need to comment out (or remove) from this file the common types
# for which you want to use the normal TMNscript representation.
#
# Similarly, if you wish to use your own representation for some specific types,
# nothing prevents you from redefining the generated encoding/decoding procedures
# for any ASN.1 type
# For instance, you could redefine UserType.encode to allow the value
# presented in the example above to be represented as follows:
# set valueOfUserType { 1.2.3 10}
#

proc Attribute-ASN1Module.SystemId.encode value0 {
	SystemId.encode $value0
}
proc Attribute-ASN1Module.SystemId.decode { value0 index optional explicit } {
	SystemId.decode $value0 $index $optional $explicit 
}

proc Attribute-ASN1Module.SimpleNameType.encode value0 {
	SimpleNameType.encode $value0
}
proc Attribute-ASN1Module.SimpleNameType.decode { value0 index optional explicit } {
	SimpleNameType.decode $value0 $index $optional $explicit 
}

proc CMIP-1.AttributeId.encode value0 {
	AttributeId.encode $value0
}
proc CMIP-1.AttributeId.decode { value0 index optional explicit } {
	AttributeId.decode $value0 $index $optional $explicit 
}
proc CMIP-1.Attribute.encode value0 {
	if { [llength $value0] != 2 } {
	   error "Invalid format for Attribute"
	}
	SEQUENCE.encode [CMIP-1.AttributeId.encode [lindex $value0 0]] \
		[ANY_DEF_BY.encode [lindex $value0 1] [lindex $value0 0]]
}
proc CMIP-1.Attribute.decode { value0 index optional explicit } {
	if {[SEQUENCE.decode $value0 $index $optional $explicit]=="__tmns_opt"} {
		return "__tmns_opt"
	} 
	LENGTH.decode $value0 $index
	set result  [CMIP-1.AttributeId.decode $value0 $index false true]
	lappend result [ANY_DEF_BY.decode $value0 $index false true $result] 
	return $result
}


proc CMIP-1.ActionInfo.encode value0 {
	SEQUENCE.encode [CMIP-1.ActionTypeId.encode [lindex $value0 0]] \
	  [if { [llength $value0] == 2 } {\
             TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } \
               [ANY_DEF_BY.encode [lindex $value0 1] [lindex $value0 0]] } else {\
              set asn1_error {{LENGTH 0} {TAG 00}}}] 
}
proc CMIP-1.ActionInfo.decode { value0 index optional explicit } {
	if {[SEQUENCE.decode $value0 $index $optional $explicit]=="__tmns_opt"} {
		return "__tmns_opt"
	}
	LENGTH.decode $value0 $index; 
	set result [CMIP-1.ActionTypeId.decode $value0 $index false true]
	lappend result [if { [TAG.decode $value0 $index  \
		{ {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true]  != "__tmns_opt"} { \
		LENGTH.decode $value0 $index; \
		ANY_DEF_BY.decode $value0 $index false true $result}]
	return $result
}

proc CMIP-1.ActionReply.encode value0 {
	if { [llength $value0] != 2 } {
	   error "Invalid format for ActionReply"
	}
	SEQUENCE.encode [CMIP-1.ActionTypeId.encode [lindex $value0 0]] \
	  [TAG.encode { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } \
               [ANY_DEF_BY.encode [lindex $value0 1] [lindex $value0 0]]] 
}
proc CMIP-1.ActionReply.decode { value0 index optional explicit } {
	if {[SEQUENCE.decode $value0 $index $optional $explicit]=="__tmns_opt"} {
		return "__tmns_opt"
	}
	LENGTH.decode $value0 $index; 
	set result [CMIP-1.ActionTypeId.decode $value0 $index false true]
	lappend result [TAG.decode $value0 $index  { {CLASS CONTEXT} {NUMBER 4} {IMPLICIT false} } true true; \
		LENGTH.decode $value0 $index; \
		ANY_DEF_BY.decode $value0 $index false true $result]
	return $result
}

proc CMIP-1.ActionTypeId.encode value0 {
	ActionTypeId.encode $value0
}
proc CMIP-1.ActionTypeId.decode { value0 index optional explicit } {
	ActionTypeId.decode $value0 $index $optional $explicit 
}

proc CMIP-1.CMISFilter.encode value0 {
	CMISFilter.encode $value0
}
proc CMIP-1.CMISFilter.decode { value0 index optional explicit } {
	CMISFilter.decode $value0 $index $optional $explicit 
}

proc CMIP-1.EventReply.encode value0 {
	SEQUENCE.encode [CMIP-1.EventTypeId.encode [lindex $value0 0]] \
	  [if { [llength $value0] == 2 } {\
             TAG.encode { {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } \
               [ANY_DEF_BY.encode [lindex $value0 1] [lindex $value0 0]] } else {\
              set asn1_error {{LENGTH 0} {TAG 00}}}] 
}
proc CMIP-1.EventReply.decode { value0 index optional explicit } {
	if {[SEQUENCE.decode $value0 $index $optional $explicit]=="__tmns_opt"} {
		return "__tmns_opt"
	}
	LENGTH.decode $value0 $index; 
	set result [CMIP-1.EventTypeId.decode $value0 $index false true]
	lappend result [if { [TAG.decode $value0 $index  \
		{ {CLASS CONTEXT} {NUMBER 8} {IMPLICIT false} } true true]  != "__tmns_opt"} { \
		LENGTH.decode $value0 $index; \
		ANY_DEF_BY.decode $value0 $index false true $result}]
	return $result
}

proc CMIP-1.EventTypeId.encode value0 {
	EventTypeId.encode $value0
}
proc CMIP-1.EventTypeId.decode { value0 index optional explicit } {
	EventTypeId.decode $value0 $index $optional $explicit 
}

proc CMIP-1.ModifyOperator.encode value0 {
	switch $value0 {
		"replace" {set value0 0}
		"add" {set value0 1}
		"remove" {set value0 2}
		"default" {set value0 3}
	}
	INTEGER.encode $value0
}
proc CMIP-1.ModifyOperator.decode { value0 index optional explicit } {
	set result [INTEGER.decode $value0 $index $optional $explicit]
	switch $result {
		"0" {set result "replace"}
		"1" {set result "add"}
		"2" {set result "remove"}
		"3" {set result "default"}
	}
	return $result
}

proc CMIP-1.ObjectClass.encode value0 {
	ObjectClass.encode $value0
}
proc CMIP-1.ObjectClass.decode { value0 index optional explicit } {
	ObjectClass.decode $value0 $index $optional $explicit 
}

proc CMIP-1.ObjectInstance.encode value0 {
	ObjectInstance.encode $value0
}
proc CMIP-1.ObjectInstance.decode { value0 index optional explicit } {
	ObjectInstance.decode $value0 $index $optional $explicit 
}

proc CMIP-1.Scope.encode value0 {
	set elmt0 [lindex $value0 0]
	set elmt1 [lindex $value0 1]
	switch $elmt0 {
		"base" { return [ENUM.encode 0] }
		"first" { return [ENUM.encode 1]}
		"whole" { return [ENUM.encode 2] }

		"level" {
			return [ TAG.encode \
			 { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} }\
			 [INTEGER.encode $elmt1] ]
		}

		"base-to" {
			return [ TAG.encode \
			 { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} }\
			 [INTEGER.encode $elmt1] ]
		}

		default {
			error "Invalid Scope"
		}
	}
}
proc CMIP-1.Scope.decode { value0 index optional explicit } {
	set tmp [ENUM.decode $value0 $index true true];
	if {$tmp != "__tmns_opt"} {
		switch $tmp {
			0 { return "base"}
			1 { return "first"}
			2 { return "whole"}
		}
		return $tmp;
	}
        if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 1} {IMPLICIT true} } true true]  != "__tmns_opt"} {
		set result [INTEGER.decode $value0 $index false false]
		return [list level $result]
	}
        if { [TAG.decode $value0 $index { {CLASS CONTEXT} {NUMBER 2} {IMPLICIT true} } true true]  != "__tmns_opt"} {
		set result [INTEGER.decode $value0 $index false false]
		return [list base-to $result]
	}
	error "Missing choice for Scope"
}

proc CMIP-1.SpecificErrorInfo.encode value0 {
        if { [llength $value0] != 2 } {
           error "Invalid format for SpecificErrorInfo"
        }
        SEQUENCE.encode [OID.encode [lindex $value0 0]] \
                [ANY_DEF_BY.encode [lindex $value0 1] [lindex $value0 0]]
}
proc CMIP-1.SpecificErrorInfo.decode { value0 index optional explicit } {
        if {[SEQUENCE.decode $value0 $index $optional $explicit]=="__tmns_opt"} {
                return "__tmns_opt"
        }
        LENGTH.decode $value0 $index
        set result  [OID.decode $value0 $index false true]
        lappend result [ANY_DEF_BY.decode $value0 $index false true $result]
        return $result
}

proc InformationFramework.AttributeValueAssertion.encode value0 {
	if { [llength $value0] != 2 } {
	   error "Invalid format for AttributeValueAssertion"
	}
	
	SEQUENCE.encode [OID.encode [lindex $value0 0]] \
                [ANY_DEF_BY.encode [lindex $value0 1] [lindex $value0 0]]
}
proc InformationFramework.AttributeValueAssertion.decode { value0 index optional explicit } {
	if {[SEQUENCE.decode $value0 $index $optional $explicit]=="__tmns_opt"} {
                return "__tmns_opt"
        }
        LENGTH.decode $value0 $index
        set result  [OID.decode $value0 $index false true]
        lappend result [ANY_DEF_BY.decode $value0 $index false true $result]
        return $result
}

proc InformationFramework.RelativeDistinguishedName.encode value0 {
        SET.encode [InformationFramework.AttributeValueAssertion.encode $value0]
}
 
proc InformationFramework.RelativeDistinguishedName.decode { value0 index optional explicit } { 
	proc intern77.decode {value0 index optional explicit} { 
		InformationFramework.AttributeValueAssertion.decode $value0 $index false true 
	}; 
	if { [SET.decode $value0 $index $optional $explicit]  == "__tmns_opt"} {return "__tmns_opt"}; set length  [LENGTH.decode $value0 $index] ; set tmp {};  
	upvar #0 $index loop; 
	set total [expr $length + $loop]; 
	while {$loop < $total} { 
	set tmp [intern77.decode $value0 $index false true]; } 
	; set tmp
}
