#
# @(#)$Id: main.tcl,v 1.12 1996/09/12 02:13:05 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# Server wrapper script. Generated at build time.
#
set showfiles 0



#======================================================================
# Included file "init.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"init.tcl\""}
#
#
# Testing, testing...
#

# Could maybe be something else later: shell, install, config, text
if ![info exists SERV_INFO(run)] {
    set SERV_INFO(run)		http
}

set SERV_INFO(server_id)	TestServer/0.1
set SERV_INFO(address)		127.0.0.1

# Should be set at startup by binary
if ![string length [getrootdir]] {
    set SERV_INFO(root)		[pwd]    
} else {
    set SERV_INFO(root)		[getrootdir]
}

# Should be true
set SERV_INFO(localonly)	1

set SERV_INFO(magic)		[clock clicks]

# Should not be set (system selects one)
#set SERV_INFO(port)		4269

if [info exists env(BOKSADM_BROWSER)] {
    set SERV_INFO(client)	$env(BOKSADM_BROWSER)
} else {
    set SERV_INFO(client)	lynx
}

# Should be user configurable (that's "no tables", by the way) 
set SERV_INFO(notables)		[string match $SERV_INFO(client) *lynx]
if [info exists env(BOKSADM_NOTABLES)] {
    set SERV_INFO(notables)	[string length $env(BOKSADM_NOTABLES)]
}
if [info exists env(BOKSADM_FILE)] {
    set SERV_INFO(startfile)	$env(BOKSADM_FILE)
} else {
    set SERV_INFO(startfile)	/tmp/.[pid].html
}
if [string length $argv] {
    set SERV_INFO(start_page_template) [lindex $argv 0]
} else {
    set SERV_INFO(start_page_template) start
}

# Should not be true
set SERV_INFO(tracing)		0
set SERV_INFO(tracefile)	{}

# Add more here (E.g. HotJava)
set SERV_INFO(client_cache_dirs) {
    ~/.mosaic*
    ~/.netscape*
    ~/.MCOM*
}

# Should be 0
set debug_level 0

# Ultra-Special for testing!
#
if [info exists env(BOKSADM_TEST)] {
    if [string length $env(BOKSADM_TEST)] {
	array set SERV_INFO "
	client	{}
	localonly	 0
	startfile	$env(BOKSADM_TEST).html
	tracing		1
	tracefile	$env(BOKSADM_TEST).trace
	"
	set debug_level 9
    }
}

# Should include a single config file here somewhere

# And read user preferences, such as browser to use...



#======================================================================
# Included file "util.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"util.tcl\""}
#
# @(#)$Id: util.tcl,v 1.7 1996/09/14 21:25:27 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# Author: Mikko Tyljrvi
#
# Generic utility procedures
#

# Run-and-catch function. Evaluate all args, return code from
# catch is stored in ${?} (0 = ok), result in ${@}. returns ${?}
#
proc @ {args} {uplevel "set ? \[catch \{set @ \[$args\]\} @\]"}

# Read a file into an array. The file contents should look like
# a Tcl list of name value [ name value ] ...
#
# Lines starting in a "#" (in position 0) are removed.
# Catch this proc - it may fail on bad input
#
proc filearray {f arrayname {trim 0}} {
    upvar $arrayname a

    set data {}
    while {[gets $f line] > -1} {
	if {[string index $line 0] != "#"} {
	    if $trim {
		set line [string trim $line]
	    }
	    append data $line\n
	}
    }
    close $f
    array set a $data
}

# Read an entire file, given a file name. Optional argument can be
# used to get an error code on failure, otherwise a zero-length
# content is returned
#
proc read_file {filename {errmsgvar {}}} {
    @ open $filename
    if !${?} {
	set f ${@}
	@ read $f
	close $f
	if !${?} {
	    return ${@}
	}
    }
    if [string length $errmsgvar] {
	upvar $errmsgvar e
	set e ${@}
    }
    return {}
}

# Write an entire file. In the same spirit as read_file above.
# Return a boolean (0 for ok)
#
proc write_file {filename data {errmsgvar {}}} {
    @ open $filename w
    if !${?} {
	set f ${@}
	@ puts $f $data
	close $f
	return ${?}
    }
    if [string length $errmsgvar] {
	upvar $errmsgvar e
	set e ${@}
    }
    return 1
}

# trace function to replace missing parts of an array with its index
# within angle brackets. Used for messages.
#
proc _trace_undefined_array {n e o} {
        uplevel "if !\[info exists ${n}(${e})\] {set ${n}(${e}) {<${e}>}}"
}
proc trace_undefined_array {arrayname} {
    uplevel #0 "trace variable $arrayname r _trace_undefined_array"
}

# Substitute all occurences of @item@ with the corresponding values from
# the named array. Unknown @items@ are turned into empty strings.
# @@ is mapped to @.
#
# @items@ on the form @!cmd ...@ will evaluate the script in the global scope
# and insert the result. Errors are discarded.
#
proc descsubst {string descarrayvar} {
    upvar $descarrayvar d
    set data 1
    set result {}
    foreach s [split $string @] {
        if $data {
            append result $s
        } else { 
	    if [string match !* $s] {
		@ uplevel #0 [string range $s 1 end]
		if !${?} {
		    append result ${@}
		}
	    } elseif [info exists d($s)] {
		append result $d($s)
	    }
        }
        set data [expr 1 - $data]
    }
    return $result
}

# debug function: output string if debuglevel is >= level
#
if ![info exists debug_level] {
    set debug_level 0
}
if ![info exists debug_file] {
    set debug_file stderr
}
proc debug {level string} {
    global debug_level debug_file

    if {$level > $debug_level} return
    puts $debug_file $string
    flush $debug_file
}

# run a script in an unpolluted namespace
#
proc run {_code} {
    eval "unset _code; $_code"
}

# Set a variable, unless it is defined already
#
proc set_default {varname value} {
    upvar $varname x

    if ![info exists x] {
	set x $value
    }
}

# Read list of local users from password file
#
proc getpwusers_local {{file /etc/passwd}} {
    set list {}
    foreach line [split [read_file $file] \n] {
	set u [lindex [split $line :] 0]
	if {[string length $u] && ![string match -* $u]} {
	    lappend list $u
	}
    }
    return $list
}

# Read a hosts file and return a list of hosts from it
#
proc gethosts_local {{filename "/etc/hosts"}} {
    set list {}
    foreach line [split [read_file /etc/hosts] \n] {
	if ![string length $line] continue
	if [string match #* $line] continue
	foreach {addr host} $line break
	if {[string length $addr] && [string length $host]} {
	    lappend list $host
	}
    }
    return $list
}

proc find_executable {name} {
    global env

    foreach d [split $env(PATH) :] {
	set f $d/$name
	if [file excutable $f] {
	    return $f
	}
    }
    return {}
}


#======================================================================
# Included file "boks.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"boks.tcl\""}
#
# $Id: boks.tcl,v 1.19 1996/09/16 12:30:22 stejo Exp $
# Copyright  1996 Dynamic Software AB
#
# Some Low-level BoKS wrapper functions
#

# Map a route (given its modifier list) to a label.
# Unknown routes are ignored (return empty strings)
#
proc routelabel {modlist {timevar {}}} {
    global BOKSROUTES

    if [regexp {adm#=([^/,]*)/([^,]*)} $modlist m label time] {
	if [info exists BOKSROUTES($label)] {
	    if [string length $timevar] {
		upvar $timevar t
		set t $time
	    }
	    return $label
	}
    }
    return {}
}

# Read data from a table (symbolic name!) using a (possibly wildcard) key
# and zero or more VAL=value conditions, or FIELDS=fieldlist
#
# Returns a list of the results.
# 
proc boks_read_tab {tab key args} {
    global BOKSTAB
    eval @ callboks master read o TAB=$BOKSTAB($tab) KEY=$key $args
    if {!${?} && [info exists o(DATA)]} {
	return $o(DATA)
    }
    return {}
}

# Get a hex random number from BoKS
#
proc boks_get_random {{bits 32}} {
    @ callboks servc random o QUALITY=1 LENGTH=$bits
    if {${?} == 0 && [info exists o(RANDOM)]} {
	return $o(RANDOM)
    }
}


# Return a list of all users, or a limited selection of them
#
proc boks_listusers {{wildcard *}} {
    global BOKSTAB

    return [boks_read_tab USER $wildcard]
}

# Get user information. RTS for what args mean.
#
proc boks_userdata {user arrayname {info 0}} {
    upvar $arrayname a

    catch {
	set a(0) 0
	unset a(0)
    }
    @ callboks servc user-data a USER=$user DATA=$info
    foreach n [array names a] {
	if [string match \$* $n] { unset a($n) }
    }
}

# list access routes for a user or class
#
# "user" username   -> route modifiers days start end ...
# "class" classname -> route modifiers days start end ...
#
proc boks_getroutes {what name} {
    switch -exact $what {
	user    {set tab USERTIME}
	class   {set tab PROFILEROUTES}
	default {return {}}
    }
    return [boks_read_tab $tab $name "FIELDS=ROUTE MODLIST DAYS START END"]
}

# Set all route definitions for a user or class.
# Uses brute-force replacement of *all* routes ever added using this
# interface.
#
proc boks_setroutes {what name time start stop args} {
    global BOKSTAB BOKSTIMES BOKSROUTES

    switch -exact $what {
	user    {set tab $BOKSTAB(USERTIME)}
	class   {set tab $BOKSTAB(PROFILEROUTES)}
	default {return 0}
    }
    foreach {r modlist d s e} [boks_getroutes $what $name] {
	if ![string match *adm#=* $modlist] continue
	@ callboks master delete o TAB=$tab KEY=$name \
		FIELDS=MODLIST "&MODLIST=$modlist"
    }
    set starthour [expr $start / 3600]
    set stophour [expr $stop / 3600]
    foreach label $args {
	foreach {main mod} [split $label _] {}
	switch -exact $mod {
	    never {
		continue
	    }
	    logonly {
		set mod "logonly,"
	    }
	    default {
		set mod ""
	    }
	}
	foreach {days dummystart dummyend} $BOKSTIMES($time) {}
	foreach route $BOKSROUTES($label) {
	    @ callboks master write o TAB=$tab KEY=$name NEW=1 \
		    "NEWFIELDS=ROUTE MODLIST DAYS START END" \
		    +ROUTE=$route +DAYS=$days +START=$start +END=$stop \
		    +MODLIST=${mod}adm#=$label/${time}_${starthour}_${stophour}
	}
    }
}

# Get a list of label time label time ... for a user or class,
# optionally storing the time (should be the same for all routes)
# in one variable, and the number of unknown routes in another.
#
proc boks_getroutelabels {what name {timevar {}} {extravar {}}} {
    if [string length $timevar] {
	upvar $timevar t
    }
    if [string length $extravar] {
	upvar $extravar e
    }
    set e 0
    foreach {r modlist d s e} [boks_getroutes $what $name] {
	set m [routelabel $modlist t]
	if [string length $m] {
	    set a($m) $t
	} else {
	    incr e
	}
    }
    return [array names a]
}

# Initialise the pre-defined user classes, unless they already exist.
#
proc boks_initialise_predefined_user_classes {{level medium}} {
    global BOKS_PREDEFINED_USER_CLASSES BOKS_CONFIG_DEFAULTS

    foreach c [boks_read_tab PROFILE *] {
	set exists($c) 1
    }
    if ![info exists BOKS_CONFIG_DEFAULTS($level)] {
	set level medium
    }
    array set dflt $BOKS_CONFIG_DEFAULTS($level)

    foreach c $BOKS_PREDEFINED_USER_CLASSES(CLASSES) {
	if [info exists exists($c)] continue
	boks_user_class_create $c
	boks_set_predefined_class_routes \
		$c $dflt(su) $dflt(login) $dflt(rexec)
    }
}


# Configure a new set of default permissions for one of the
# predefined user classes
#
proc boks_set_predefined_class_routes {class su login rexec {anytime 1}} {
    global BOKS_PREDEFINED_USER_CLASSES


    # Filter routes
    #
    array set routes "su_$su 1 login_$login 1 rexec_$rexec 1"
    set plist $BOKS_PREDEFINED_USER_CLASSES($class)
    foreach {op r} $plist {
	switch -- $op {
	    + {
		set routes($r) 1
	    }
	    - {
		catch {unset routes($r)}
	    }
	    = {
		catch {unset routes}
		foreach r $plist {
		    set routes($r) 1
		}
		unset routes(=)
		break
	    }
	}
    }
    if !$anytime {
	# get routes for this class, to get the times
	set o(0) 0
	boks_helpfuncs_getrouteinfo class $class o
	unset o(0)
    }
    if { $anytime || ([info exists o(NOROUTES)] && $o(NOROUTES)) } {
	set list [list $class anytime 0 86400]
    } else {
	set list [list $class $o(days_val) $o(start_val) $o(stop_val)]
    }
    foreach su {logonly root user} {
	if [info exists routes(su_$su)] {
	    lappend list su_$su
	    break
	}
    }
    foreach login {logonly world trusted known local} {
	if [info exists routes(login_$login)] {
	    lappend list login_$login
	    break
	}
    }
    foreach rexec {logonly world trusted known} {
	if [info exists routes(rexec_$rexec)] {
	    lappend list rexec_$rexec
	    break
	}
    }
    @ eval boks_setroutes class $list
    return ${?}
}


# Return 1 if system password is defined, 0 if not
#
proc boks_syspsw_is_enabled {} {
    if [string length [boks_read_tab SYS 00 FIELDS=SYSPSW]] {
	return 1
    }
    return 0
}

# Set system password
#
proc boks_set_syspsw {password {disable 0}} {
    if $disable {
	set password {}
    }
    @ callboks master set-password o PSW=$password
    return 0
}

# Get password parameters, as a list. Optional user arg not supported yet.
# List is (more may be appended):
#  type/label minlen lifespan/days limit/days histlen minutes/min
#
proc boks_get_password_parameters {{user {}}} {
    global BOKSPSWFMT

    set fieldspec "FIELDS=PSWFORCE PSWMINLEN PSWVALIDTIME "
    append fieldspec "CHPSWTIME PSWHISTLEN CHPSWFREQ"
    foreach {type len life lim hist min} [boks_read_tab SYS 00 $fieldspec] {}
    set type $BOKSPSWFMT(label,$type)
    set life [expr $life / 86400]
    set lim  [expr $lim / 86400]
    set min  [expr $min / 60]
    return [list $type $len $life $lim $hist $min]
}

# Set password parameters, same format as for the "get" function above
# XXX: Some validation of values, perhaps?
#
proc boks_set_password_parameters {
    type minlen lifespan limit histlen minutes
} {
    global BOKSPSWFMT
    
    set fieldspec "NEWFIELDS=PSWFORCE PSWMINLEN PSWVALIDTIME "
    append fieldspec "CHPSWTIME PSWHISTLEN CHPSWFREQ"
    set type $BOKSPSWFMT(type,$type)
    set lifespan [expr $lifespan * 86400]
    set limit  [expr $limit * 86400]
    set minutes [expr $minutes * 60]
    @ callboks master write o TAB=0 00 KEY=00 $fieldspec \
	    +PSWFORCE=$type +PSWMINLEN=$minlen +PSWVALIDTIME=$lifespan \
	    +CHPSWTIME=$limit +PSWHISTLEN=$histlen +CHPSWFREQ=$minutes
    return ${?}
}

# List all banned passwords. If regexp is true, list regexp words as well.
#
proc boks_list_banned_passwords {{regexp 0}} {
    set list [boks_read_tab COPSPASS * FIELDS=PASSWORD]
    if !$regexp {
	set words {}
	foreach w $list {
	    if {[string index $w 0] == "/"} continue
	    lappend words $w
	}
	set list $words
    }
    return $list
}

# Add a banned password
#
proc boks_add_banned_password {word} {
    global BOKSTAB

    set key [string tolower [string index $word 0]]
    @ callboks master write o TAB=$BOKSTAB(COPSPASS) KEY=$key \
	    NEWFIELDS=PASSWORD +PASSWORD=$word NEW=1
    return ${?}
}

# Remove a banned password
#
proc boks_del_banned_password {word} {
    global BOKSTAB

    set key [string tolower [string index $word 0]]
    @ callboks master delete o TAB=$BOKSTAB(COPSPASS) KEY=$key \
	    FIELDS=PASSWORD &PASSWORD=$word
    return ${?}
}

# Fiddle with boks "environment" variables (the stuff in the ENV file)
#
proc boks_setboksenv {var value} {
    @ callboks clntd putboksenv o VAR=$var VALUE=$value
    return ${?}
}
proc boks_getboksenv {var} {
    @ callboks clntd getboksenv o VAR=$var
    if {${?} || ![info exists o(VALUE)]} {
	return {}
    }
    return $o(VALUE)
}

# Activate/Deactivate BoKS. First time, also remove the
# "PRECONFIG" flag from ENV.
#
proc boks_activate {on} {
    global boksenv

    if $on {
	if [info exists boksenv(PRECONFIG)] {
	    if [string length $boksenv(PRECONFIG)] {
		boks_setboksenv PRECONFIG {}
	    }
	}
	@ boks_exec sysreplace replace
    } else {
	@ boks_exec sysreplace restore
    }
    return $?
}

# Returns true or false if in pre-config
#
proc boks_preconfig {} {
    global boksenv

    arrayfile [boksdir etc]/ENV boksenv    
    if [info exists boksenv(PRECONFIG)] {
	if [string length $boksenv(PRECONFIG)] {
	    return 1
	}
    }
    return 0
}

proc boks_generate_startpage {} {
    global SERV_INFO

    @ generate_startpage
    set st ${?}
    @ boks_priv {
	exec chown [boks_logname] $SERV_INFO(startfile)
    }
    return $st
}

# list userwild -> user prog, user prog ...
proc boks_sux_list {{userwild *}} {
    set list {}
    set fields {USER ROUTE MODLIST}
    set data [boks_read_tab USERTIME $userwild "FIELDS=$fields"]
    foreach {user route mod} $data {
	if ![string match *adm#=sux* $mod] continue
	if [regexp {^SUEXEC:.*->[^%]*%(.*)$} $route m prog] {
	    lappend list $user $prog
	}
    }
    return $list
}

proc boks_sux_add {user prog} {
    global BOKSTAB BOKSTIMES

    foreach {days start stop} $BOKSTIMES(anytime) break
    set route "SUEXEC:*->root@[boks_master_name]%$prog"
    @ callboks master write o \
	    TAB=$BOKSTAB(USERTIME) KEY=$user NEW=1 \
	    "NEWFIELDS=ROUTE MODLIST DAYS START END" \
	    +ROUTE=$route +DAYS=$days +START=$start +END=$stop \
	    +MODLIST=adm#=sux
    return ${?}
}

proc boks_sux_del {user prog} {
    global BOKSTAB
    
    set route "SUEXEC:*->root@[boks_master_name]%$prog"
    @ callboks master delete o TAB=$BOKSTAB(USERTIME) \
	    KEY=$user FIELDS=ROUTE "&ROUTE=$route"
    return ${?}
}


#======================================================================
# Included file "bokstab.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"bokstab.tcl\""}
#
# $Id: bokstab.tcl,v 1.16.2.3 1996/09/27 20:55:41 russin Exp $
# Copyright  1996 Dynamic Software AB
#
# Various tables for BoKS data maping
#


# Need to know the BoKS name for this host, which should be
# the master.
#
if ![info exists boks_localhost] {
    @ callboks master master-name o
    if {${?} || ![info exists o(DATA)]} {
	set boks_localhost [exec uname -n]
    } else {
	set boks_localhost $o(DATA)
    }
}
proc boks_master_name {} {
    global boks_localhost

    return $boks_localhost
}

# Load boksenv, and store some locations in environment, for use by
# admin progs.
#
arrayfile [boksdir etc]/ENV boksenv
set env(BOKS_DIR) [boksdir]
set env(BA_LOGNAME) [boks_logname]
foreach d {etc data bin tmp var lib sbin} {
    set env(BOKS_$d) [boksdir $d]
}

# Get the version from the ENV file and change it in the server
#
if [info exists boksenv(VERSION)] {
    set SERV_INFO(server_id) "Solstice Security Manager / $boksenv(VERSION)"
}
regsub -all / [hex2b64 [boks_get_random 768]] _ SERV_INFO(magic)

# DB table numbers
array set BOKSTAB {
    SYS		     0
    USER	     1
    USERTIME	     2
    INVALIDCERT	     3
    ROUTESTAT	     4
    LOGIN	     5
    HOST	     6
    HOSTGROUP	     7
    CERT2USERMAP     8
    HOST2GROUPMAP    9
    NISMAP	    10
    OLDPSW	    11
    ROUTEPSW	    12
    ROLEGROUP	    13
    CA		    14
    ADDR	    15
    PROFILEROUTES   16
    PROFILE	    17
    UNIXGROUP	    18
    UNIXGROUPMEMBER 19
    LOGPARAMS	    20
    DBMAP	    21
    COPSSETUP	    22
    COPSREPORT	    23
    COPSSUID	    24
    COPSABLE	    25
    COPSPASS	    26
    PCUSER	    27
    PCGROUP	    28
    PCVIEW	    29
    PCRULE	    30
    PIN		    31
    PINHOST	    32
}

# misc flags, add on demand
# (Note that heaps of the USER, flags are obsolete)

array set BOKS_FLAGS {
    PARAMMASK,LOGINVALIDTIME    1
    PARAMMASK,PSWVALIDTIME      2
    PARAMMASK,CHPSWTIME         4
    PARAMMASK,PSWMINLEN         8
    PARAMMASK,PSWFORCE         16
    PARAMMASK,PSWHISTLEN       32
    PARAMMASK,CHPSWFREQ        64
    PARAMMASK,TIMEOUT         128
    PARAMMASK,TTIMEOUT        256
    PARAMMASK,TDAYS           512
    PARAMMASK,TSTART         1024
    PARAMMASK,TEND           2048
    PARAMMASK,RETRYMAX       4096
    PARAMMASK,CONCUR_LOGINS  8192
    PARAMMASK,SHELL         16384
    SYS,VERBOSE                 1
    SYS,PSWUPDATE               2
    USER,BOKSDEL                1
    USER,BLOCKED                2
    USER,NOLOGIN                4
    USER,NOSUTO                 8
    USER,NOSUFROM              16
    USER,NO_CPU                32
    USER,NO_TYPE               64
    USER,NO_UPDATE            128
    USER,NOTELNET             256
    USER,NORLOGIN             512
    USER,NOTTY_OK            1024
    USER,HARDSPIN            2048
    USER,TLOCK               4096
    USER,CHANGE_PSW          8192
}

array set BOKSPSWFMT {
    type,psw	16
    type,11     17
    type,22     18
    type,random	4
    type,model	8
    label,16	psw
    label,17	11
    label,18	22
    label,2	22
    label,1	11
    label,4	random
    label,8	model
}

array set BOKSHOSTTYPE {
    type,2	NONBOKSHOST
    type,5	UNIXBOKSHOST
    type,9	PCBOKSHOST
    label,NONBOKSHOST	2
    label,UNIXBOKSHOST	5
    label,PCBOKSHOST	9
}

set BOKS_CONFIG_PARAMS {
    rootlogin
    rootrexec
    login
    rexec
    su
    timeout
    bgmon
    messages
    retries
    pswmodel
    logs
    alarmlogs
}

set BOKS_CONFIG_DEFAULTS(low) {
    rootlogin	logonly
    rootrexec	logonly
    rootsu	logonly
    login	logonly
    rexec	logonly
    su		logonly
    timeout	root
    messages	verbose
    retries	low
    pswmodel	low
    logs	normal
    alarmlogs	console
    bgmon	low
}

set BOKS_CONFIG_DEFAULTS(medium) {
    rootlogin	trusted
    rootrexec	trusted
    rootsu	adm
    login	known
    rexec	known
    su		adm_users
    timeout	long
    messages	quiet
    retries	medium
    pswmodel	medium
    logs	normal
    alarmlogs	console
    bgmon	medium
}

set BOKS_CONFIG_DEFAULTS(high) {
    rootlogin	never
    rootrexec	never
    rootsu	listed
    login	trusted
    rexec	trusted
    su		adm_staff
    timeout	short
    messages	quiet
    retries	high
    pswmodel	high
    logs	full
    alarmlogs	console
    bgmon	high
}

set BOKS_CONFIG_DEFAULTS(default) $BOKS_CONFIG_DEFAULTS(medium)

# These are identical, apart from the extra office-hour bit. (bit 7)
#
array set BOKSTIMES {
    anytime	{127 0 86400}
    workhours	{159 0 86400}
}

array set BOKS_RETRIES {
    low		100
    medium	10
    high	3
}

array set BOKSROUTES  "
login_never	{}
login_local	{LOGIN:*->$boks_localhost XDM:$boks_localhost->$boks_localhost}
login_trusted	{RLOGIN,TELNET,XDM:TRUSTED->$boks_localhost}
login_known	{RLOGIN,TELNET,XDM:KNOWN/*->$boks_localhost}
login_world	{RLOGIN,TELNET,XDM:ANY/*->$boks_localhost}
login_logonly	{RLOGIN,TELNET,XDM:ANY/*->$boks_localhost}
su_never	{}
su_user		{SU:*->*}
su_root		{SU:*->#0 SU:*->*}
su_logonly	{SU:*->#0 SU:*->*}
rexec_never	{}
rexec_trusted	{REXEC,RSH,FTP,PCNFS:TRUSTED->$boks_localhost}
rexec_known	{REXEC,RSH,FTP,PCNFS:KNOWN/*->$boks_localhost}
rexec_world	{REXEC,RSH,FTP,PCNFS:ANY/*->$boks_localhost}
rexec_logonly	{REXEC,RSH,FTP,PCNFS:ANY/*->$boks_localhost}
"

foreach l {trusted known world logonly} {
    append BOKSROUTES(login_$l) " $BOKSROUTES(login_local)"
}

array set BOKS_TIMEOUT {
    type,short		10/0
    type,long		30/10
    type,root		0/10
    type,none		0/0
    label,10/0		short
    label,30/10		long
    label,0/10		root
    label,0/0		none
}

# Default classes that should not be removed. The values mean
# + always this
# - always this
# = always set to this entire list
#
array set BOKS_PREDEFINED_USER_CLASSES {
    CLASSES		{ADMIN STAFF USERS GUESTS NOACCESS}
    ADMIN		{+ su_root - su_user - su_never}
    STAFF		{+ su_user}
    USERS		{}
    GUESTS		{- su_root - su_user}
    NOACCESS		{=}
}


#======================================================================
# Included file "boksutils.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"boksutils.tcl\""}
# -*- tcl -*-
#
# $Id: boksutils.tcl,v 1.6 1996/09/12 02:13:00 mikko Exp $
# Copyright  1996 Dynamic Software AB
#
# BoKS-oriented utilities that do not actually use any of the
# extensions for BoKS
#

# Check that a username is legal, optionally prefixed with the
# local host. Returns a proper BoKS logname (host:user), or
# an empty string on error. 
#
proc boks_checklocalusername {user} {
    global boks_localhost

    set u $user
    if [regexp {^([^:]+):([^:]+)$} $user m h u] {
	if [string compare $h $boks_localhost] {
	    return {}
	}
    }
    if ![regexp {^[a-zA-Z0-9_-]+$} $u] {
	return {}
    }
    return $boks_localhost:$u
}

# get data for a user from boks and put in array supplied by user
# 
# Check that a hostname looks sane. Just looks for funny characters
# and rejects anything that looks like addresses
#
proc boks_check_hostname {host} {
    if ![regexp {^[-a-zA-Z0-9_.]+$} $host m] {
	return 0
    }
    if [regexp {^[0-9.]*$} $host m] {
	return 0
    }
    return 1
}

# Check that an IP-address looks like a sane host address
#
proc boks_check_ipaddr {addr} {
    return [gethostbyname -checkaddr $addr]
}

# Get hosts from DSN/wherever
#
proc boks_gethostbyname {host} {return [gethostbyname -nocomplain $host]}
proc boks_gethostbyaddr {addr} {return [gethostbyaddr -nocomplain $host]}

# Get user data from passwd/whatever
#
proc boks_getpwnam {name} {return [getpwnam -nocomplain -data $name]}

# Extract the user part of a host:user pair (if it is one)
#
proc username_only {name} {
    set l [split $name :]
    if {[llength $l] > 1} {
	return [lindex $l 1]
    } else {
	return $name
    }
}


#======================================================================
# Included file "bokslog.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"bokslog.tcl\""}
# -*- tcl -*-
#
# $Id: bokslog.tcl,v 1.3 1996/09/12 02:12:59 mikko Exp $
# Copyright  1996 Dynamic Software AB
#
# BoKS Logging interface
#


# boks_log [-type type] [-host host] [-tty tty] [-user user] [-prog prog] -label label string args ...
#
proc boks_log { args } {
    set adminprg SM_Admin

    set type S
    set tty ""
    set host ""
    set user [boks_logname]
    set prog $adminprg
    set label ""

    set next 0
    set flag 1
    set len [llength $args]
    set i 0
    while { $flag && $i < $len } {
	set arg [lindex $args $i]
	if $next {
	    set $name $arg
	    set next 0
	} else {
	    switch -glob -- $arg {
		-type { incr next; set name type }
		-tty { incr next; set name tty }
		-host { incr next; set name host }
		-user { incr next; set name user }
		-prog { incr next; set name prog }
		-label { incr next; set name label }
		-- { set flag 0 }
		-* { return 1 }
		* { set flag 0 }
	    }
	}
	if $flag {
	    incr i
        }
    }

    set arglist [lrange $args $i end]


    if { [llength $arglist] == 0 } {
	return 1
    }

    set log "\"[lindex $arglist 0]\""
    foreach arg [lrange $arglist 1 end] {
	set log "$log,\"$arg\""
    }

    @ callboks master log out TYPE=$type HOST=$host \
	TTY=$tty USER=$user PROG=$prog LABEL=$label LOG=$log
    return 0
}


#======================================================================
# Included file "backend.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"backend.tcl\""}
# -*- tcl -*-
###########################################################################
# $Id: backend.tcl,v 1.46.2.9 1996/11/13 14:53:14 cvsusr Exp $
#
# Copyright (c) 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# File:         functions.tcl
#
# Description:	Backend proc's to BoKS, Should all be simple
#
# Author:       Stefan Johansson, stejo
#
# Created:      19960712
#
# Modifications:
#
###########################################################################


# Proc's

# boks_filmon_userconfig
# handle the level indep. filmon config file ($BOKS_etc/files)
#  boks_filmon_userconfig -l         returns list of all files and dirs in file
#  boks_filmon_userconfig -a list    adds each path in list to file
#  boks_filmon_userconfig -d list    removes each path in list from file

proc boks_filmon_userconfig { switch args } {
    set file [boksdir etc]/files
    set do_listing 0
    set do_add 0
    set do_delete 0

    switch -glob -- $switch {
	-l { set do_listing 1 }
	-a { set do_add 1 }
	-d { set do_delete 1 }
	* { return {} }
    }
    set file_list {}
    @ boks_priv "open $file r"
    if {!${?}} {
	while {[gets ${@} line] != -1} {
	    lappend file_list $line
	}
	close ${@}
    }
    set lines {}
    foreach line $file_list {
	if ![string match #* $line] {
	    lappend lines $line
	}
    }

    if $do_listing {
	return [lsort $lines]
    }
    if ![llength $args] {
	return {}
    }
    set plist [lindex $args 0]
    set errlist {}
    if $do_add {
	foreach p $plist {
	    if ![string match /* $p] {
		lappend errlist $p
	    } elseif ![boks_priv "file exists $p"] {
		lappend errlist $p
	    } elseif {[lsearch -exact $file_list $p] == -1} {
		lappend file_list $p
	    }
	}
    } elseif $do_delete {
	foreach p $plist {
	    if ![string match /* $p] {
		continue
	    } else {
		set i [lsearch -exact $file_list $p]
		if {$i == -1} {
		    continue
		}
		set file_list [concat [lrange $file_list 0 [expr $i - 1]] \
			[lrange $file_list [expr $i + 1] end]]
	    }
	}
    }
    @ boks_priv "open $file w"
    if ${?} {
	return 0
    }
    set fp ${@}
    foreach l $file_list {
	puts $fp "$l"
    }
    close $fp
    return $errlist
}

# boks_uadm_get_group_list [-names]
#
# return a list of gids as numbers (or symbolic if -names given)
# from host identified by host or user.
# sorted.
#
proc boks_uadm_get_group_list { args } {
    set names 0

    set next 0
    set flag 1
    set len [llength $args]
    set i 0
    while { $flag && $i < $len } {
	set arg [lindex $args $i]
	if $next {
	    set $name $arg
	    set next 0
	} else {
	    switch -glob -- $arg {
		-names { set names 1 }
		-- { set flag 0 }
		-* { return 1 }
		* { set flag 0 }
	    }
	}
	if $flag {
	    incr i
        }
    }


    if { $i != [llength $args] } {
	return 1
    }

    if $names {
	set list [lsort [groups -names]]
    } else {
	set list [lsort [groups -gids]]
    }

    set ret {}
    foreach grp $list {
	if { [lsearch -exact $ret $grp] == -1 } {
	    lappend ret $grp
	}
    }
    return $ret
}

# boks_uadm_get_userclasses
#
# get a list of all userclasses defined (sorted)
#
proc boks_uadm_get_userclasses { } {
    set tmp [lsort [boks_read_tab PROFILE *]]
    set List ""
    foreach n $tmp {
	if [string length $n] {
	    lappend List $n
	}
    }
    return $List
}

#Proc to create user.
#All arguments to proc should be validated at an higher level.
#Figure out physical homedir. todo

#returns 1 if user does not exist, else 0
proc boks_user_exist {User} {
    @ callboks master read o TAB=1 KEYFIELD=LOGNAME
    if ${?} {
	return 0
    }
    if {[lsearch $o(DATA) $User] < 0} {
	return 0
    }
    return 1
}


#Proc to create user.
#All arguments to proc should be validated at an higher level.
#Figure out physical homedir. todo

#returns 1 if user does not exist, else 0
proc boks_user_exist {User} {
    @ callboks master read o TAB=1 KEYFIELD=LOGNAME
    if ${?} {
	return 0
    }
    if {[lsearch $o(DATA) $User] < 0} {
	return 0
    }
    return 1
}

proc boks_uadm_create_user {User Group Comment Uid HomeDir Shell {Class ""} {Psw ""}} {
    
    #Set program to use modbks/mkbks
    if [boks_user_exist $User] {
	set prog modbks
    } else {
	set prog mkbks
    }
    set argv $prog
    lappend argv -l$User
    if [string length $Class] {
	lappend argv -P$Class
    }
    lappend argv "-g$Group"
    if [string length $Comment] {
	lappend argv "-r$Comment"
    }
    lappend argv "-u$Uid"
    if [string length $HomeDir] {
	lappend argv "-h$HomeDir"
    }
    if [string length $Shell] {
	lappend argv "-s$Shell"
    }
    if [string length $Psw] {
	lappend argv "-p$Psw"
    }
    eval @ boks_exec $argv
    return ${?}
}

proc boks_uadm_mkhome {User Path Umask {StartProgram ""}} {
    set argv [list mkhome "-l$User"]
    if [string length $StartProgram] {
	lappend argv $StartProgram
    }
    if [string length $Path] {
	lappend argv "-P$Path"
    }
    if [string length $Umask] {
	lappend argv "-U$Umask"
    }
    eval @ boks_exec $argv
    return ${?}
}

#Set password to $Password for $User
#No validation what so ever is done here
#Make log entries as well, todo.
proc boks_uadm_set_password {User Password} {
    @ callboks master set-password o LOGNAME=$User PSW=$Password ENC=0
    if {${?} || [info exists o(ERROR)]} {
	return 1
    }
    return 0
}

#uadm_import_user, will import users into BoKS database.
#args: Host -> Host to read from, e.g. spirit
#      UserLocation, is Local || NIS || NIS_and_Local, else cons. as a file
#      UserType, System, Normal, All, Uid range givan as Uid_lower_upper,
#                unix group given as Group_group
#      HostCreate, Which host(group) tp create them at, e.g. spirit || ALL
#      UserClass, Which userclass to put users in
#      Start, End & Week should be entered in the old familiar format
#      Route routes that users should have.
proc boks_uadm_import_user {Host UserLocation UserType HostCreate \
	{UserClass {}} {Start {}} {End {}} \
        {Week {}} {Route {}} } {

    set argv [list mkcusers -f -h $Host -H $HostCreate]
    if [string length $UserClass] {
	lappend argv -c $UserClass
    }
    #Where are users located
    if {$UserLocation == "Local"} {
	lappend argv "-l"
    } elseif {$UserLocation == "NIS"} {
	lappend argv -r
    } elseif {$UserLocation != "NIS_and_Local"} {
	lappend argv -F $UserLocation
    }
    #Which users to import
    set FirstPart [lindex [split $UserType _] 0]
    if {$UserType == "System"} {
	set UserTypeUse "-RM-99"
    } elseif {$UserType == "Normal"} {
	set UserTypeUse "-R100-M"
    } elseif {$UserType == "All"} {
	set UserTypeUse "-RM-M"
    } elseif {$FirstPart == "Uid"} {
	set List [split $UserType _]
	set Lower [lindex $List 1]
	set Upper [lindex $List 2]
	set UserTypeUse "-R$Lower-$Upper"
    } elseif {$FirstPart == "Group"} {
	set UserTypeUse "-G[lindex [split $UserType _] 1]"
    }
    lappend argv $UserTypeUse
    set use_route 1
    foreach n [list $Start $End $Week $Route] {
	if ![string length $n] {
	    set use_route 0
	    break
	}
    }
    if $use_route {
	lappend argv -b $Start -e $End -w $Week -z $Route
    }
    eval @ boks_exec $argv
    return ${@}
}

proc boks_uadm_import_user_log {} {
    set file "[boksdir data]"
    read_file  "[lindex $file 0]/mkcuserslog"
}

proc getmsg {lab {prefix gen_}} {
    set r [MSG_GET ${prefix}$lab]
    if ![string length $r] {
	set r $lab
    }
    return $r
}

proc boks_helpfuncs_userstatus {user} {
    set f "%-50s %s"

    set no [getmsg no]
    set yes [getmsg yes]
    set never [getmsg never]
    set minutes [getmsg minutes]

    if [boks_uadm_get_admin_status $user] {
	set isadm $yes
    } else {
	set isadm $no
    }

    set list {}
    boks_uadm_get_user_data $user udata
    lappend list [format $f [getmsg username user_list_] $user]
    lappend list [format $f [getmsg is_admin user_list_] $isadm]
    lappend list [format $f [getmsg uid user_list_] $udata(UID)]
    lappend list [format $f [getmsg userclass user_list_] $udata(PROFILE)]
    set g [getgrgid -nocomplain $udata(GID)]
    if ![string length $g] {
	set g $udata(GID)
    }
    lappend list [format $f [getmsg gid user_list_] $g]
    lappend list [format $f [getmsg realname user_list_] $udata(REALNAME)]
    lappend list [format $f [getmsg homedir user_list_] $udata(HOMEDIR)]
    lappend list [format $f [getmsg shell user_list_] $udata(SHELL)]
    set v $never
    if { $udata(TIMEOUT) != -1 } {
	set v "[expr $udata(TIMEOUT) / 60] $minutes"
    }
    lappend list [format $f [getmsg timeout user_list_] $v]
    lappend list [format $f [getmsg pswlastchg user_list_] [clock format $udata(PSWLASTCHANGE) -format %x]]
    set v [expr $udata(PSWLASTCHANGE) + $udata(PSWVALIDTIME)]
    set now [clock seconds]
    if [expr $v < $now] {
	if [expr ($v + $udata(CHPSWTIME)) < $now] {
	    set v [getmsg expired user_list_]
	} else {
	    set v [getmsg mustchg user_list]
	}
    } else {
	set v [clock format $v -format %x]
    }
    lappend list [format $f [getmsg pswvalid user_list_] $v]
    set v [expr $udata(LOGINVALIDTIME) + $udata(USERLASTCHANGE)]
    if [expr $v < $now] {
	set v [getmsg expired user_list_]
    } else {
	set v [clock format $v -format %x]
    }
    lappend list [format $f [getmsg uservalid user_list_] $v]
    set v $never
    if $udata(LASTLOGIN) {
	set v [clock format $udata(LASTLOGIN) -format  "%x %X"]
    }
    lappend list [format $f [getmsg lastlogin user_list_] $v]
    set v $never
    if $udata(LASTLOGOUT) {
	set v [clock format $udata(LASTLOGOUT) -format  "%x %X"]
    }
    lappend list [format $f [getmsg lastlogout user_list_] $v]
    lappend list [format $f [getmsg failedlogins user_list_] $udata(RETRY)]
    set v $no
    if [llength [boks_helpfuncs_user_blocked udata 1]] {
	set v $yes
    }
    lappend list [format $f [getmsg locked user_list_] $v]
    if [string length $udata(PROFILE)] {
	boks_helpfuncs_getrouteinfo class $udata(PROFILE) outinfo
    } else {
	boks_helpfuncs_getrouteinfo user $user outinfo
    }
    set days [getmsg $outinfo(days_val)]
    set start [getmsg hour_[expr $outinfo(start_val) / 3600]]
    set stop [getmsg hour_[expr $outinfo(stop_val) / 3600]]
    set login [getmsg $outinfo(login_val)_acc]
    set su [getmsg $outinfo(su_val)_acc]
    set rexec [getmsg $outinfo(rexec_val)_acc]
    lappend list [format $f [getmsg login_time user_list_] "$days $start - $stop"]
    lappend list [format $f [getmsg login user_list_] $login]
    lappend list [format $f [getmsg su user_list_] $su]
    lappend list [format $f [getmsg rexec user_list_] $rexec]

    set msg [getmsg user_suexec_prg]
    foreach {u p} [boks_sux_list $user] {
	lappend list [format $f $msg $p]
	set msg {}
    }
    return $list
}

proc boks_helpfuncs_shortustatus {user {header 0}} {
    global BOKS_FLAGS
    set f "%-16.16s %6.6s  %-10.10s %-9.9s %-10.10s %6.6s %6.6s %s"
    set list {}
    if $header {
	lappend list [format $f [getmsg shortuser user_list_] \
		[getmsg shortuid user_list_] [getmsg shortgid user_list_] \
		[getmsg pswexp1 user_list_] [getmsg userexp1 user_list_] \
		[getmsg shortfail user_list_] [getmsg shorttimeout user_list_] \
		[getmsg shortcomment user_list_]]
	lappend list [format $f "" "" "" \
		[getmsg pswexp2 user_list_] [getmsg userexp2 user_list_] \
		"" "" ""]
	lappend list {}
	return $list
    }
    boks_uadm_get_user_data $user udata
    set uid $udata(UID)
    set gid [getgrgid -nocomplain $udata(GID)]
    if ![string length $gid] {
	set gid $udata(GID)
    }
    set pwexp ""
    if [expr $udata(FLAGS) & $BOKS_FLAGS(USER,CHANGE_PSW)] {
	set pwexp [getmsg mustchg user_list_]
    }
    set l [boks_helpfuncs_user_blocked udata 1]
    if { [lsearch -glob $l psw_*] != -1 } {
	set pwexp [getmsg blocked user_list_]
    }
    if ![string length $pwexp] {
	set v [expr $udata(PSWLASTCHANGE) + $udata(PSWVALIDTIME) + $udata(CHPSWTIME)]
	set pwexp [clock format $v -format %x]
    }
    set acexp [expr $udata(LOGINVALIDTIME) + $udata(USERLASTCHANGE)]
    if [expr $acexp < [clock seconds]] {
	set acexp [getmsg expired user_list_]
    } else {
	set acexp [clock format $acexp -format %x]
    }
    set fail $udata(RETRY)
    if [expr $fail > $udata(RETRYMAX)] {
	set fail [getmsg exceeded user_list_]
    }
    set tout $udata(TIMEOUT)
    if { $tout == -1 } {
	set tout [getmsg never]
    } else {
	set tout [expr $tout / 60]
    }
	
    set com $udata(REALNAME)
    return [format $f $user $uid $gid $pwexp $acexp $fail $tout $com]
}

proc boks_uadm_full_user_status {long {Users ""} } {

    if ![string length $Users] {
	set Users [boks_listusers]
    }

    set List ""
    if !$long {
	set List [boks_helpfuncs_shortustatus dummy 1]
    }
    foreach u $Users {
	if {"$u" != ""} {
	    if $long {
		set List "$List[boks_helpfuncs_userstatus $u]"
		set List  "$List {} "
	    } else {
		lappend List [boks_helpfuncs_shortustatus $u]
	    }
	}
    }
    return $List
}

#Change User Timeout Limit
#Mode is Logout
proc boks_uadm_timeout_change_user_limit {User {Limit 10} {Mode Logout}} {
    @ boks_exec modbks -e -l$User -D$Mode timeout=$Limit
    return ${?}
}

proc boks_uadm_timeout_time_dep {User Start Stop Week Limit} {
    @ boks_exec modbks -e -l$User tstart=$Start tend=$Stop \
	    tdays=$Week ttimeout=$Limit
    return ${?}
}

proc boks_uadm_timeout_mode {User Cpu Screen} {
    if {$Cpu == "yes"} {
	set CpuUse "-Acpu_timeout"
    } else {
	set CpuUse "-Dcpu_timeout"
    }
    if {$Screen == "yes"} {
	set ScreenUse "-Atty_output_timeout"
    } else {
	set ScreenUse "-Dtty_output_timeout"
    }
    @ boks_exec modbks -l$User $CpuUse $ScreenUse
    return ${?}
}

#Used to enable system defaults for a user 
#that has got another set of personal defaults.
#todo all of it.
proc boks_uadm_enable_defaults { User Parameter} {
    return "Uninplemented"
}

#Proc to set user last login date
proc boks_uadm_user_last_login_date { User Date} {
    @ boks_exec modbks -l$User loginvalidtime=$Date
    if { "${?}" != "0"} {
	return ${@}
    } else {
	return 0
    }
}
#Proc to set user last password life span
proc boks_uadm_user_last_login_date { User Days} {
    @ boks_exec modbks -l$User pswvalidtime=$Days
    if { "${?}" != "0"} {
	return ${@}
    } else {
	return 0
    }
}

#Proc to remove a BoKS user
#Support for post rmbks ?, todo.
proc boks_uadm_remove_user {User} {
    @ boks_exec rmbks $User
    if { "${?}" != "0"} {
	return ${@}
    } else {
	return 0
    }
}

# ------------------------------------------------------------
# Host administration
#
# Many of thses ops use extenral commands -- there was too much
# magic involved (dependencies between tables) to re-invent here,
# at least right now.
#

# Create/Modify a host
#
proc boks_hostadm_add_host {Host Ip {Trusted 0} {Type NONBOKSHOST}} {
    if [string length $Ip] {
	@ boks_exec hostadm -a -h$Host -i$Ip -t$Type
	if ${?} {
	    return 1
	}
    }
    if $Trusted {
	@ boks_exec hgrpadm -a -m $Host -g TRUSTED
    } else {
	boks_hostadm_rem_trusted $Host
    }
    return 0
}

# Remove a host
#
proc boks_hostadm_rem_host {Host {Ip {}}} {
    if [string length $Ip] {
	@ boks_exec hostadm -d -i$Ip
    } else {
	@ boks_exec hostadm -d -h$Host
    }
    return ${?}
}

#Remove a host from group trusted
#
proc boks_hostadm_rem_trusted {Host} {
    set TAB HOSTGROUP
    set fieldspec "FIELDS=GROUP MEMBER"
    set hlist [boks_read_tab $TAB TRUSTED $fieldspec]
    if [string compare [lsearch $hlist $Host] "-1"] {
       @ boks_exec hgrpadm -r -m $Host -g TRUSTED
    }

}

# Check if a host is trusted
#
proc boks_host_is_trusted {host} {
    set s [boks_read_tab HOSTGROUP $host KEYFIELD=MEMBER FIELDS=GROUP]
    if {[lsearch $s TRUSTED] > -1} {
	return 1
    }
    return 0
}

# List host names in database
#
proc boks_hostadm_list {{hostwild *}} {
    return [boks_read_tab HOST $hostwild]
}

# Get list of trusted hosts
#
proc boks_hostadm_list_trusted {} {
    return [boks_read_tab HOSTGROUP TRUSTED FIELDS=MEMBER]
}

# Get Host data into an array. Returns the list of names.
# Array contains: name,addrs -> address list
#		  name,type  -> type (see boks.tcl)
#
# ADD MORE RETURNED DATA AS NECESSARY!!!
#
proc boks_hostadm_list_byname {arrayvar {hostwild *}} {
    global BOKSHOSTTYPE
    upvar $arrayvar hosts
    
    catch {unset hosts}
    set fieldspec "FIELDS=NAME TYPE"
    set hlist [boks_read_tab HOST $hostwild $fieldspec]
    set addrs [boks_read_tab ADDR * "FIELDS=NAME ADDRESS"]
    set list {}
    foreach {n a} $addrs {
	lappend hosts($n,addrs) $a
    }
    foreach {n t} $hlist {
	lappend list $n
	set hosts($n,type) $BOKSHOSTTYPE(type,$t)
    }
    return $list
}
proc boks_hostadm_list_byaddr {arrayvar {addrwild *}} {
    global BOKSHOSTTYPE
    upvar $arrayvar hosts

    catch {unset hosts}
    set addrs [boks_read_tab ADDR $addrwild "FIELDS=NAME ADDRESS"]
    set list {}
    foreach {n a} $addrs {
	if ![info exists hosts($n,type)] {
	    set t [boks_read_tab HOST $n FIELDS=TYPE]
	    set hosts($n,type) $BOKSHOSTTYPE(type,$t)
	}
	lappend hosts($n,addrs) $a
	lappend list $n
    }
    return $list    
}

proc boks_hostadm_host_exist {Host} {
    set fieldspec "FIELDS=NAME"
    set hlist [boks_read_tab HOST $Host $fieldspec]
    return [llength $hlist]
}

#UserClasses
proc slask {} {
    boks_getroutelabels class DAEMON
}
proc boks_user_class_create {UserClass {DoComment ""} {Comment ""} } {
    if [string length $DoComment] {
	@ boks_exec classadm -a -u$UserClass -c $Comment
    } else {
	@ boks_exec classadm -a -u$UserClass
    }
    return ${?}
}
proc boks_user_class_comment {UserClass Comment} {
    set fieldspec "FIELDS=PROFILE INFO"
    set List [boks_read_tab PROFILE $UserClass $fieldspec]
    if [string compare [lindex $List 1] $Comment] {
	@ boks_exec classadm -a -u$UserClass -c$Comment
    }
}

proc boks_user_class_remove {UserClassList} {
    set ret 0
    foreach UserClass $UserClassList {
	@ boks_exec classadm -r -u$UserClass
	if { "${?}" != "0"} {
	    set ret ${?}
	}
    }
    return $ret
}

proc boks_user_class_list { {UserClass ""}} {
    if {"$UserClass" != ""} {
    @ boks_exec classadm -l -u$UserClass
    } else {
	@ boks_exec classadm -l
    }
    return ${@}
}

proc boks_user_class_list_full { {ClassList ""}} {
    set result {}
    if [string length $ClassList] {
	foreach Class $ClassList {
	    @ boks_exec classadm -lv -u $Class
	    append result ${@}
	}
    } else {
	@ boks_exec classadm -lv
	set result ${@}
    }
    return $result
}

proc boks_classlist {} {
    set fieldspec "FIELDS=PROFILE"
    set clist [boks_read_tab PROFILE "*" $fieldspec]
    return $clist
}

proc boks_checkclassname {Class} {
    set ExistingClasses [boks_classlist]
    if {[lsearch $ExistingClasses $Class] != -1} {
	return ""
    } else {
	return $Class
    }
}

proc boks_userclass_exists {Class} {
    return [expr [lsearch [boks_classlist] $Class] != -1]
}

proc boks_list_users_to_userclass {UserClass} {
    @ boks_read_tab USER $UserClass KEYFIELD=PROFILE "FIELDS=LOGNAME"
    return ${@}
}

proc boks_get_userclass_comment {Class} {
    set fieldspec "FIELDS=PROFILE INFO"
    set ulist [boks_read_tab PROFILE $Class $fieldspec]
    return [lindex $ulist 1]
}

# This one should NOT be needed.
# See boks_setroutes in boks.tcl
#   Goran
proc boks_set_route_to_class {UserClass Route Start End Week} {
    @ boks_exec routeadm -a -u$UserClass -z$Route -b$Start -e$End -w$Week
    if { "${?}" != "0"} {
	return ${@}
    } else {
	return 0
    }
}



#Logs
proc boks_query_logs {Lt Alarm User Host LogFile Terminal Search Start End} {
    set Args "-wnH"
    set LtUse ""
    if { [string compare $Lt "Session"] == 0} {
	set LtUse "-u"
    }
    if { [string compare $Lt "System"] == 0} {
	set LtUse "-s"
    }
    if [string length $LtUse] {
	lappend Args $LtUse
    } else {
	lappend Args "-s"
	lappend Args "-u"
    }
    if {"$Alarm" == "yes"} {
	lappend Args "-A"
    }
    if {"$Terminal" != "*"} {
	lappend Args "-t$Terminal"
    }
    if {"$User" != "*"} {
	lappend Args "-l$User"
    }
    if {"$Host" != "*"} {
	lappend Args "-h$Host"
    }
    if {"$Search" != "*"} {
	lappend Args "-T$Search"
    }
    if {"$Start" != "*"} {
	lappend Args "-b[boks_date2boksdate $Start]"
    }

    if {"$End" != "*"} {
	lappend Args "-e[boks_date2boksdate $End]"
    }
    set fieldspec "FIELDS=HOST LOGDIR"
    set ulist [boks_read_tab LOGPARAMS [exec uname -n] $fieldspec]
    set logdir [lindex $ulist 1]
    if ![string length $logdir] {
	set logdir [boksdir data]
    }
    set logbackupdir [boks_get_log_param BACKUPDIR LOGPARAMS]
    if ![string length $logbackupdir] {
        set logbackupdir [boksdir data]
    }

    if ![string compare $LogFile "LOG"] {
	lappend Args "-f$logdir/$LogFile"
    } else {
	lappend Args "-f$logbackupdir/$LogFile"
    }
    eval @ boks_exec bkslog $Args
    return ${@}
}

# Convert LANG date to boks date (YYMMDD. YY < 70 -> 21:st century)
#
proc boks_date2boksdate {date} {
    @ strptime $date %x
    if ${?} {
	return ""
    }
    return [clock format ${@} -format "%y%m%d"]
}


proc boks_log_param_global {
    MaxSize CritSize Lang CharSet AlarmLogCommand {PrgAfterBackup ""} } {
    set argv [list logadm -M$CritSize -T$MaxSize -L$Lang -C$AlarmLogCommand]
# -A$CharSet
    lappend argv "-p" "$PrgAfterBackup"
    eval @ boks_exec $argv
    return ${?}
    
}

proc boks_log_param_host {Host LogDir {LogDirBackup ""} } {
    set argv [list logadm -h$Host -d$LogDir]
    if [string length $LogDirBackup] {
	lappend argv "-b$LogDirBackup"
    }
    eval @ boks_exec $argv
    return ${?}
}

proc boks_log_param_host_get { Host } {
    @ boks_exec logadm -h $Host -Ddb
    return ${@}
}
proc boks_get_lognames { {Host ""} } {

    set logdir ""
    if [string length $Host] {
	set fieldspec "FIELDS=HOST LOGDIR"
	set ulist [boks_read_tab LOGPARAMS $Host $fieldspec]
	set logdir [lindex $ulist 1]
    }
    if ![string length $logdir] {
	set logdir [boksdir data]
    }
    set logbackupdir [boks_get_log_param BACKUPDIR LOGPARAMS]
    if ![string length $logbackupdir] {
	set logbackupdir  [boksdir data]
    }
    set List "$logdir/LOG"
    boks_priv {
	set pat "$logbackupdir/L\[0-9\]\[0-9\]\[0-9\]\[0-9\]\[0-9\]\[0-9\]?\[0-9\]\[0-9\]\[0-9\]\[0-9\]\[0-9\]\[0-9\]"
	foreach n [split [glob -nocomplain $pat] " "] {
	    lappend List $n
	}
    }
    foreach n $List {
	set tmp [split $n /]
	lappend result [lindex $tmp end]
    }
    return $result
}

proc boks_log_get_globpar {} {
    set List ""
    @ boks_exec logadm -DT
    lappend List ${@}
    @ boks_exec logadm -DC
    lappend List ${@}
    @ boks_exec logadm -Dp
    lappend List ${@}
    return $List
}
proc boks_get_log_param {Param {TAB SYS}} {
    set fieldspec "FIELDS=$Param"
    if ![string compare $TAB SYS] {
	set KEY 00
    } else {
	set KEY [exec uname -n]
    }
    set ulist [boks_read_tab $TAB $KEY $fieldspec]
    if ![string compare $Param LOGASCII] {
	set tmp /*
	set nls [boksdir lib]/nls/*
	foreach n "[glob $nls] 7BIT" {
	    set nn [split $n /]
	    set tmp [lindex $nn end]
	    if ![string compare [lsearch $ulist $tmp] "-1"] {
		lappend ulist $tmp
	    }
	}
    }
    return $ulist
}

proc boks_log_get_critsize {} {
    @ boks_exec logadm -DT
    return ${@}
}

#Backup
proc boks_backup {Device} {
    umask 077 {
	@ boks_exec boks_bru -p -l -d$Device
    }
    return ${?}
}
proc boks_restore {Device} {
    @ boks_exec boks_bru -u -d $Device
    return ${?}
}

proc boks_get_backup_dev_list {{op {}}} {
    global boksenv

    set dev /dev/rmt/0
    set name [boksdir etc]/bdevlist
    if [file exists $name] {
	set fd [open $name RDONLY]
	while {[gets $fd line] >= 0} {
            if {[lsearch $dev $line] == -1} {
                lappend dev $line
	    }
	}
	close $fd
    }
    # Check for saved DB too?
    if {[string compare $op restore] == 0 && [info exists boksenv(SAVEDB)]} {
	if [file exists $boksenv(SAVEDB)] {
	    set dev [lappend dev $boksenv(SAVEDB)]
	}
    }
    return [lappend dev File]
}

proc boks_log_start_new {} {
    @ boks_exec logadm -n -f
}


#Reports
proc boks_reports_logged_in_users { {Host *}} {
    set fieldspec "FIELDS=USER TTY TIME"
    set ulist2 ""
    set ulist [boks_read_tab LOGIN "*" $fieldspec]
    set n [llength $ulist]
    for {set i 0} { $i < $n} { incr i 3} {
	lappend ulist2 [lindex $ulist $i]
	lappend ulist2 [lindex $ulist [expr $i + 1]]
	lappend ulist2 [lindex $ulist [expr $i + 2]]
    }
    return $ulist2
}

#Background
proc boks_background_status {Host Type} {
    @ boks_exec cadm -h $Host -E $Type
    return ${@}
}
proc boks_background_set {host args} {
    eval boks_exec cadm -h $host $args
}
proc boks_xlock_set {Host args} {
    eval @ boks_exec xdladm -h $Host $args
    return ${?}
}
proc boks_get_xdefaults {Arg} {
    set boks_etc [boksdir etc]
    set file [lindex $boks_etc 0]/X11/Xdefaults
    set tmp [split [exec grep $Arg $file] :]
    set nn [llength $tmp]
    if {$nn > 0} {
	return [lindex $tmp [expr $nn -1]]
    } else {
	return ""
    }
}

proc boks_timeout_get_val {Val host} {
    @ boks_exec cadm -h $host -E $Val
    return ${@}
}

proc boks_bksd_off {Host} {
    @ boks_exec cadm -E BKSD=off -h $Host
}

proc boks_xlock_status {Host {Mod ""}} {
    if ![string compare $Mod XDL] {
	@ boks_exec cadm -h $Host -E XD
    } else {
	@ boks_exec xdladm -h $Host -s
    }
	return ${@}
}
proc boks_get_locked_displays {{Host ""}} {
    if [string length $Host] {
	@ boks_exec xdladm -h $Host -d
    } else {
	@ boks_exec xdladm -d
    }
    return ${@}
}
proc boks_unlock_reset_display {display {unlock unlock}} {
    if ![string compare $unlock reset] {
	@ boks_exec xdladm -r $display
    } else {
	@ boks_exec xdladm -u $display
    }
    return ${?}
}

#Misc
proc boks_run_boks_program { Prog argv} {
    eval @ boks_exec $Prog $argv
    return ${@}
}

proc boks_get_xlock_def {Host} {
    @ boks_exec xdladm -s -h $Host
    return ${@}
}

proc boks_set_xlock_parameters {Host Mod} {
    set text {Timeout Warntime BeepInterval FastBeep Volume Transparent Log Wait Retries}
    set Len [llength $text]
    set argv ""
    for {set i 0} {$i < $Len} {incr i} {
	if [string compare [lindex $Mod $i] "*"] {
	    lappend argv "[lindex $text $i]:[lindex $Mod $i]"
	}
    }
    if [llength argv] {
	eval @ boks_exec xdladm -h $Host -m $argv
    } else {
	return 0
    }
}


# boks_helpfunc_matchlist [-remove] match_string list
# help func
# return the elems in list that match match_string at beginning
# if -remove is set, remove the match_string from returned elems
#
# (eg boks_helpfunc_matchlist -remove su_ {su_never su_trusted login_world}
# should return {never trusted})
#
proc boks_helpfunc_matchlist { args } {
    set remove 0

    set next 0
    set flag 1
    set len [llength $args]
    set i 0
    while { $flag && $i < $len } {
	set arg [lindex $args $i]
	if $next {
	    set $name $arg
	    set next 0
	} else {
	    switch -glob -- $arg {
		-remove { set remove 1 }
		-- { set flag 0 }
		-* { return 1 }
		* { set flag 0 }
	    }
	}
	if $flag {
	    incr i
        }
    }


    set arglist [lrange $args $i end]

    if { [llength $arglist] != 2 } {
	return 1
    }
    foreach {match_string list} $arglist {}

    set ret {}
    set len [string length $match_string]
    foreach l $list {
	if [string match ${match_string}* $l] {
	    if $remove {
		lappend ret [string range $l $len end]
	    } else {
		lappend ret $l
	    }
	}
    }
    return $ret
}


# boks_uadm_set_user_data user field data ...
#
# Set fields in TAB_USER.
# If a field is one involving PARAMETERMASK, PARAMETERMASK
# will be set to reflect that the data is now in TAB_USER
#
proc boks_uadm_set_user_data { user args } {
    global BOKS_FLAGS BOKSTAB
    set mask_affected 0
    if [expr [llength $args] % 2] {
	return 1
    }
    set parammask [boks_read_tab USER $user FIELDS=PARAMETERMASK]
    if ![llength $parammask] {
	return 1
    }
    set fields {}
    set list {}
    foreach {field val} $args {
	if [info exists BOKS_FLAGS(PARAMMASK,$field)] {
	    set parammask [expr $parammask | $BOKS_FLAGS(PARAMMASK,$field)]
	    set mask_affected 1
	}
	lappend fields $field
	lappend list "+${field}=$val"
	boks_uadm_log_entry $user $field $val
    }
    if $mask_affected {
	lappend fields PARAMETERMASK
	lappend list +PARAMETERMASK=$parammask
    }
    lappend list TAB=$BOKSTAB(USER) NEWFIELDS=$fields KEY=$user
    eval @ callboks master write o $list
    return ${?}
}

#Wrapper to send log entries to BoKS
#field is field sent to boks_uadm_set_user_data
#val is new value
proc boks_uadm_log_entry {user field {val ""}} {
    switch -exact -- $field {
	GID {
	    boks_log -type S -label changed_gid \
		    "Changed group ID to %ld: %s" $val $user
	}
	UID {
	    boks_log -type S -label changed_uid \
		    "Changed user ID to %ld: %s" $val $user
	}
	REALNAME {
	    boks_log -type S -label changed_realname \
		    "Changed user comment: %s" $user
	}
	SHELL {
	    boks_log -type S -label changed_shell \
		    "Changed shell to %s: %s" $val $user
	}
	TLOCK {
	    boks_log -type S -label changed_to_tlock \
		    "Timeout changed to tlock for %s" $user
	}
	NO_TLOCK {
	    boks_log -type S -label changed_to_no_tlock \
		    "Timeout changed to no tlock for %s" $user
	}
	HOMEDIR {
	    boks_log -type S -label changed_homedir \
		    "Changed home directory to %s: %s" $val $user
	}
	PROFILE {
	    boks_log -type S -label changed_userclass \
		    "Changed User Class to %s: %s" $val $user
	}
	CHPSW {
	    boks_log -type S -label chpsw_own \
		    "Password changed for user %s" $user
	}
	CHPSWFORCE {
	    boks_log -type S -label chpsw_force \
		    "Forcing password change for user %s" $user
	}
	USERLASTCHANGE {
	    set a n
	}
	RETRY {
	    boks_log -type S -label new_login_tries \
		    "Authorized new login tries: %s" $user
	}
	TIMEOUT {
	    boks_log -type S -label changed_timeout \
		    "Changed timeout to %ld minutes: %s" [expr $val/60] $user
	}
	LOGINVALIDTIME {
	    set valid [expr $val + [boks_read_tab USER $user FIELDS=USERLASTCHANGE]]
	    boks_log -type S -label changed_validtime \
		    "Changed expire date to %s: %s" [clock format $valid -format %x]  $user
	}
	USER_ROUTE {
	    set tmp [split $val #]
	    set days [lindex $tmp 0]
	    set start [lindex $tmp 1]
	    set stop [lindex $tmp 2]
	    set login [lindex $tmp 3]
	    set su [lindex $tmp 4]
	    set rexec [lindex $tmp 5]
	    boks_helpfuncs_getrouteinfo user $user outinfo
	    set tmp [lindex $outinfo(login) [expr [lsearch $outinfo(login) $login] +1]]
	    set login2 [MSG_GET user_mod_$tmp]
	    set tmp [lindex $outinfo(su) [expr [lsearch $outinfo(su) $su] +1]]
	    set su2 [MSG_GET user_mod_$tmp]
	    set tmp [lindex $outinfo(rexec) [expr [lsearch $outinfo(rexec) $rexec] +1]]
	    set rexec2 [MSG_GET user_mod_$tmp]
	    set tmp [lindex $outinfo(days) [expr [lsearch $outinfo(days) $days] +1]]
	    set days2 [MSG_GET user_mod_$tmp]
	    set tmp [lindex $outinfo(start) [expr [lsearch $outinfo(start) $start] +1]]
	    set start2 [MSG_GET user_mod_$tmp]
	    set tmp [lindex $outinfo(stop) [expr [lsearch $outinfo(stop) $stop] +1]]
	    set stop2 [MSG_GET user_mod_$tmp]
	    boks_log -type S -label set_user_route \
		    "%s Access Route set to login=%s, su=%s, rexec=%s, days=%s, start=%s, stop=%s" \
		    $user $login2 $su2 $rexec2 $days2 $start2 $stop2
	}
	CLASS_ROUTE {
	    set tmp [split $val #]
	    set days [lindex $tmp 0]
	    set start [lindex $tmp 1]
	    set stop [lindex $tmp 2]
	    set login [lindex $tmp 3]
	    set su [lindex $tmp 4]
	    set rexec [lindex $tmp 5]
	    boks_helpfuncs_getrouteinfo class $user outinfo
	    set tmp [lindex $outinfo(login) [expr [lsearch $outinfo(login) $login] +1]]
	    set login2 [MSG_GET class_mod_$tmp]
	    set tmp [lindex $outinfo(su) [expr [lsearch $outinfo(su) $su] +1]]
	    set su2 [MSG_GET class_mod_$tmp]
	    set tmp [lindex $outinfo(rexec) [expr [lsearch $outinfo(rexec) $rexec] +1]]
	    set rexec2 [MSG_GET class_mod_$tmp]
	    set tmp [lindex $outinfo(days) [expr [lsearch $outinfo(days) $days] +1]]
	    set days2 [MSG_GET class_mod_$tmp]
	    set tmp [lindex $outinfo(start) [expr [lsearch $outinfo(start) $start] +1]]
	    set start2 [MSG_GET class_mod_$tmp]
	    set tmp [lindex $outinfo(stop) [expr [lsearch $outinfo(stop) $stop] +1]]
	    set stop2 [MSG_GET class_mod_$tmp]
	    boks_log -type S -label set_user_route \
		    "%s Access Route set to login=%s, su=%s, rexec=%s, days=%s, start=%s, stop=%s" \
		    $user $login2 $su2 $rexec2 $days2 $start2 $stop2
	}
	default {
	    boks_log -type S -label unknown "Unknown log entry field=%s" $user
	}
    }
}
proc boks_log_psw_params {type val} {
    switch -exact -- $type {
	TYPE {
	    boks_log -type S -label pswforce "Password format: %s" $val
	}
	MINLEN {
	    boks_log -type S -label pswminlen "Minimum password length: %d characters" $val
	}
	HISTLEN {
	    boks_log -type S -label pswhistlen "Length of password history: %d" $val
	}
	MINUTES {
	    boks_log -type S -label chpswfreq "Minimum time between password changes: %d minutes" $val
	}
	LIFESPAN {
	    boks_log -type S -label pswvalidtime "Term of validity for passwords: %ld days" $val
	}
	LIMIT {
	    boks_log -type S -label chpswtime "Time limit for expired password: %ld days" $val
	}
	ADD_BANNED {
	    boks_log -type S -label addbanpsw "Added %s to list of banned passwords" $val
	}
	DEL_BANNED {
	    boks_log -type S -label delbanpsw "Deleted %s from list of banned passwords" $val
	}
	default {
	    boks_log -type S -label unknown "Unknown psw log entry field=%s" $type
	}
    }
}

# interface routine to get a new uniq uid.
#
proc boks_uadm_newuid {} {
    @ callboks master newuid out
    return $out(DATA)
}

# Get frost shell from /etc/shells if it exists, 
# return /bin/sh otherwise
#
proc boks_uadm_get_default_shell {} {
    set line "/bin/sh"
    if { [catch {set fp [open /etc/shells r]}] == 0 } {
	gets $fp line
	close $fp
    }
    return $line
}

# boks_uadm_get_user_data [-level level] user outarr
#
# get all data for user currently in TAB_USER 
# and put in outarr. outarr is then indexed with field name
# from dbdef.boks. NOTE! Fields that are common to TAB_SYS and
# TAB_PROFILE will be taken from the one it is set in according
# to PARAMETERMASK (so you are not guaranteed to get data from TAB_USER
# only!).
# level is not currently used, but can be a number that gives
# more info for higher numbers (presumably from other user related tables)
# return 0 on success, 1 on user does not exist != 0 on other errors

proc boks_uadm_get_user_data { args } {
    global BOKSTAB BOKS_FLAGS
    set level 1

    set next 0
    set flag 1
    set len [llength $args]
    set i 0
    while { $flag && $i < $len } {
	set arg [lindex $args $i]
	if $next {
	    set $name $arg
	    set next 0
	} else {
	    switch -glob -- $arg {
		-level { incr next; set name level }
		-- { set flag 0 }
		-* { return 1 }
		* { set flag 0 }
	    }
	}
	if $flag {
	    incr i
        }
    }


    set arglist [lrange $args $i end]

    if { [llength $arglist] != 2 } {
	return 1
    }

    set user [lindex $arglist 0]
    set var [lindex $arglist 1]
    upvar $var outarr

    @ callboks master read out TAB=$BOKSTAB(USER) KEY=$user FIELDS=*
    if { ${?} != 0 || ![info exists out(DATA)] || [llength $out(DATA)] == 0 } {
	return 1
    }
    set uclass [lindex $out(DATA) [lsearch -exact $out(FIELDS) PROFILE]]

    # defaults from TAB_SYS
    set fields [boks_helpfunc_matchlist -remove PARAMMASK, [array names BOKS_FLAGS]]
    @ callboks master read tmp TAB=$BOKSTAB(SYS) KEY=00 FIELDS=$fields
    if { ${?} != 0 || ![info exists tmp(DATA)] || [llength $tmp(DATA)] == 0 } {
	return 1
    }
    foreach field $fields val $tmp(DATA) {
	set outarr($field) $val
    }

    # Some may be from TAB_PROFILE
    if [llength $uclass] {
	@ callboks master read tmp TAB=$BOKSTAB(PROFILE) KEY=$uclass \
		FIELDS=[concat $fields PARAMETERMASK]
	if { ${?} != 0 || ![info exists tmp(DATA)] || [llength $tmp(DATA)] == 0 } {
	    return 1
	}
	set parammask [lindex $tmp(DATA) end]
	foreach field $fields val $tmp(DATA) {
	    if {[info exists BOKS_FLAGS(PARAMMASK,$field)] && \
		    [expr $parammask & $BOKS_FLAGS(PARAMMASK,$field)]} {
		set outarr($field) $val
	    }
	}
    }

    set parammask [lindex $out(DATA) [lsearch -exact $out(FIELDS) PARAMETERMASK]]
    foreach field $out(FIELDS) val $out(DATA) {
	if [info exists BOKS_FLAGS(PARAMMASK,$field)] {
	    if [expr $parammask & $BOKS_FLAGS(PARAMMASK,$field)] {
		set outarr($field) $val
	    }
	} else {
	    set outarr($field) $val
	}
    }
    return 0
}

# return a list with elem first, then list with any elem removed
#
proc boks_helpfuncs_lprepend_uniq {elem list} {
    set ret $elem
    foreach l $list {
	if [string compare $elem $l] {
	    lappend ret $l
	}
    }
    return $ret
}

# used in function below
set bhf_time_list  {
	3600   hour_1
	7200   hour_2
	10800  hour_3
	14400  hour_4
	18000  hour_5
	21600  hour_6
	25200  hour_7
	28800  hour_8
	32400  hour_9
	36000  hour_10
	39600  hour_11
	43200  hour_12
	46800  hour_13
	50400  hour_14
	54000  hour_15
	57600  hour_16
	61200  hour_17
	64800  hour_18
	68400  hour_19
	72000  hour_20
	75600  hour_21
	79200  hour_22
	82800  hour_23
}

# these could be found from [array names BOKSROUTES]
# but the ordering varies in that case...
#
set bhf_login_list {
    never
    local
    trusted
    known
    world
    logonly
}

set bhf_su_list {
    never
    user
    root
    logonly
}

set bhf_rexec_list {
    never
    trusted
    known
    world
    logonly
}

# boks_helpfunc_getrouteinfo what name outarr
#
# Help function to get info needed to set up access info
# in gui
# what i user class or default
# name is username classname or dummy
# outarr is output and contains the following
# outarr(start)   list of time info accepted by GUI
# outarr(start_val) current value
# outarr(stop)    list of time info accepted by GUI
# outarr(sto_val) current value
# outarr(days)    list of days login is possible (GUI)
# outarr(days_val) current value
# outarr(login)   login access routes for GUI
# outarr(login_val) current value
# outarr(su)      su access routes for GUI
# outarr(su_val) current value
# outarr(rexec)   rexec (network NI) access routes for GUI
# outarr(rexec_val) current value
#
# outarr(NOROUTES) is 1 if no previosly defined sunboks routes were found
#    0 if they existed.
#
# return 0 on ok, 1 on error
#
proc boks_helpfuncs_getrouteinfo {what name outarr} {
    global bhf_time_list bhf_login_list bhf_su_list bhf_rexec_list
    upvar $outarr ret

    set list(login) $bhf_login_list
    set list(su)    $bhf_su_list
    set list(rexec) $bhf_rexec_list

    if ![string compare $what default] {
	set ret(days)  {workhours days_workdays anytime days_anyday}
	set ret(days_val) workhours
	set ret(start) [concat 0 hour_0 $bhf_time_list]
	set ret(start_val) 0
	set ret(stop)  [concat $bhf_time_list 86400 hour_24]
	set ret(stop_val) 86400
	foreach n {login su rexec} {
	    set ret($n) {}
	    set ret(${n}_val) ${n}_never
	    foreach l $list($n) {
		lappend ret($n) ${n}_$l
		lappend ret($n) ${n}_${l}_acc
	    }
	}
    } else {
	set labs [boks_getroutelabels $what $name t]
	set d workhours
	set s 0
	set e 24
	set ret(NOROUTES) 0
	if [info exists t] {
	    foreach {d s e} [split $t _] {}
	    set ret(NOROUTES) 1
	}
	set ret(start) [concat 0 hour_0 $bhf_time_list]
	set ret(start_val) [expr $s * 3600]
	set ret(stop) [concat $bhf_time_list 86400 hour_24]
	set ret(stop_val) [expr $e * 3600]
	set ret(days) {workhours days_workdays anytime days_anyday}
	if {[string compare $d workhours] == 0} {
	    set ret(days_val) workhours
	} else {
	    set ret(days_val) anytime
	}
	foreach n {login su rexec} {
	    set ret($n) {}
	    set ret(${n}_val) ${n}_never
	    foreach l $list($n) {
		lappend ret($n) ${n}_$l
		lappend ret($n) ${n}_${l}_acc
	    }
	}
	foreach l $labs {
	    foreach {name sec} [split $l _] {}
	    set ret(${name}_val) $l
	}
    }
    return 0
}

# boks_uadm_change_user_psw [-force] user psw
#
# change a users password
# Force psw change next time if -force is used
#
proc boks_uadm_change_user_psw { args } {
    set force 0

    set next 0
    set flag 1
    set len [llength $args]
    set i 0
    while { $flag && $i < $len } {
	set arg [lindex $args $i]
	if $next {
	    set $name $arg
	    set next 0
	} else {
	    switch -glob -- $arg {
		-force { set force 1 }
		-- { set flag 0 }
		-* { return 1 }
		* { set flag 0 }
	    }
	}
	if $flag {
	    incr i
        }
    }


    set arglist [lrange $args $i end]

    if { [llength $arglist] != 2 } {
	return 1
    }
    foreach {user psw} $arglist {}

    @ callboks master set-password o LOGNAME=$user PSW=$psw TIME=[clock seconds]
    if $force {
	boks_helpfuncs_set_user_flags $user CHANGE_PSW 1
	boks_uadm_log_entry $user CHPSWFORCE
    } else {
	boks_uadm_log_entry $user 
    }
    boks_addusermap $user
    return 0
}

# boks_helpfuncs_set_user_flags user flag val ...
#
# set or clear FLAG depending on val
#
proc boks_helpfuncs_set_user_flags { user args } {
    global BOKSTAB BOKS_FLAGS

    foreach {flag val} $args {
	if [info exists BOKS_FLAGS(USER,$flag)] {
	    if $val {
		@ callboks master field-arit 0 TAB=$BOKSTAB(USER) KEY=$user FIELD=FLAGS \
			OPVAL=|$BOKS_FLAGS(USER,$flag)
	    } else {
		@ callboks master field-arit 0 TAB=$BOKSTAB(USER) KEY=$user FIELD=FLAGS \
			OPVAL=&[expr (~$BOKS_FLAGS(USER,$flag))&65535]
	    }
	}
    }
    return ${?}
}

# boks_helpfuncs_set_user_parammask user flag val ...
#
# set or clear PARAMETERMASK depending on val
#
proc boks_helpfuncs_set_user_parammask { user args } {
    global BOKSTAB BOKS_FLAGS

    foreach {flag val} $args {
	if [info exists BOKS_FLAGS(PARAMMASK,$flag)] {
	    if $val {
		@ callboks master field-arit 0 TAB=$BOKSTAB(USER) KEY=$user FIELD=PARAMETERMASK \
			OPVAL=|$BOKS_FLAGS(PARAMMASK,$flag)
	    } else {
		@ callboks master field-arit 0 TAB=$BOKSTAB(USER) KEY=$user FIELD=PARAMETERMASK \
			OPVAL=&[expr (~$BOKS_FLAGS(PARAMMASK,$flag))&65535]
	    }
	}
    }
    return ${?}
}    

proc boks_helpfuncs_user_flag_isset {user param} {
    global BOKS_FLAGS

    if ![info exists BOKS_FLAGS(USER,$param)] {
	return 0
    }
    set parammask [boks_read_tab USER $user FIELDS=FLAGS]
    if ![string length parammask] {
	return 0
    }
    if ![regexp -- {^(-[0-9]+|[0-9]+)$} $parammask] {
	return 0
    }
    if [expr $parammask & $BOKS_FLAGS(USER,$param)] {
	return 1
    }
    return 0
}

proc boks_helpfuncs_user_param_isset {user param} {
    global BOKS_FLAGS

    if ![info exists BOKS_FLAGS(PARAMMASK,$param)] {
	return 0
    }
    set parammask [boks_read_tab USER $user FIELDS=PARAMETERMASK]
    if ![string length parammask] {
	return 0
    }
    if ![regexp -- {^(-[0-9]+|[0-9]+)$} $parammask] {
	return 0
    }
    if [expr $parammask & $BOKS_FLAGS(PARAMMASK,$param)] {
	return 1
    }
    return 0
}

# check if uid exists
#
# return 1 if exists
#        0 if not (and on errors unfortunately)
#
proc boks_helpfuncs_uid_exists { uid } {
    global BOKSTAB

    @ callboks master read out TAB=$BOKSTAB(USER) FIELDS=UID
    if { [info exists out(DATA)] && [lsearch -exact $out(DATA) $uid] != -1 } {
	return 1
    }
    return 0
}

# boks_helpfuncs_user_blocked udata
#
# Check if a user represented by udata (from s_uadm_get_user_data
# to save calls to master) is blocked
#
# return a list of single words identifying the reason
# empty if not blocked.
# Tries to emulate code in lsbks (but actually not quite, it assume udata is
# updated with value from TAB_PROFILE or TAB_SYS if needed)
#
proc boks_helpfuncs_user_blocked { data {ret_early 0}} {
    global BOKS_FLAGS

    upvar $data udata

    set ret {}
    set now [clock seconds]
    set l [string length $udata(PSW)]
    if { $l > 0 && $l < 13 } {
	lappend ret psw_invalid
	if $ret_early { return $ret }
    }
    if { $l == 0 } {
	lappend ret psw_empty
	if $ret_early { return $ret }
    }
    if { [expr ($udata(PSWLASTCHANGE) + $udata(PSWVALIDTIME) \
	    + $udata(CHPSWTIME)) < $now] } {
	lappend ret psw_old
	if $ret_early { return $ret }
    }
    if { $udata(RETRY) > $udata(RETRYMAX) } {
	lappend ret login_fail
	if $ret_early { return $ret }
    }
    if { [expr ($udata(USERLASTCHANGE) + $udata(LOGINVALIDTIME)) < $now] } {
	lappend ret user_exp
	if $ret_early { return $ret }
    }
    if [expr $udata(FLAGS) & $BOKS_FLAGS(USER,BLOCKED)] {
	lappend ret blocked
    }
    return $ret
}

#Delete all users in $users, check against list of users
#that are not allowed to be removed. currently only 'root'
# Also delete users homedir if delete_home is set
proc boks_helpfuncs_del_users {users {delete_home 0}} {
    set List ""
    foreach user $users {
	set tmp [lindex [split $user :] 1]
	if [string compare $tmp root] {
	    lappend List $user
	}
    }
    if [string length $List] {
	if $delete_home {
	    foreach u $List {
		boks_helpfuncs_rm_userhome $u
	    }
	}
	foreach u $List {
	    set arg ""
	    set hu [split $u :]
	    lappend arg -h [lindex $hu 0] -n [lindex $hu 1]
	    if $delete_home {
		lappend arg -d
	    }
	    boks_run_extra_script USERDEL $arg
	}
	eval @ boks_exec rmbks $List
    }
    return $List
}

proc boks_home2realhome { home } {
    if ![string match /* $home] {
	@ callboks master master-name o
	set host $o(DATA)
	set hpref [boks_read_tab HOST $host FIELDS=HOMEPREFIX]
	set fhost [boks_read_tab HOST $host FIELDS=FILEHOST]
	if [string compare $fhost $host] {
	    return ""
	}
	set fhdir [boks_read_tab HOST $host FIELDS=FILEHOSTDIR]
	if [string length $fhdir] {
	   set home [file join $fhdir $home]
	} elseif [string length $hpref] {
	    set home [file join $hpref $home]
	}
    }
    return $home
}

# do rm -rf on users home dir after verifying that user is
# not root and homedir is not /, is absolute, and is a directory
#
proc boks_helpfuncs_rm_userhome user {
    if [string match *:root $user] {
	return 0
    }
    set home [boks_home2realhome [boks_read_tab USER $user FIELDS=HOMEDIR]]

    if ![string length $home] {
	return 0
    }
    if [string match $home /] {
	return 0
    }
    if ![string match /* $home] {
	return 0
    }
    if ![file isdirectory $home] {
	return 0
    }
    set cmd [list @ exec /bin/rm -rf $home]
    boks_priv $cmd
    return 1
}
    
# Get a list of users not already existing in the BoKS DB.
# src can be "local" or "nis" to restrict the list to
# local users or nis users -- anything else will give the
# union of both (i.e. whatever getpwent() returns).
#
proc boks_users_not_imported { src {file ""} } {
    set ret {}
    set list {}
    set all {}
    
    set host [boks_master_name]
    if ![string length $file] {
	if [string compare $src local] {
	    foreach l [boks_priv getpwlist] {
		lappend all [lindex [split $l :] 0]
	    }
	}
	switch -- $src {
	    nis {
		set local [getpwusers_local]
		foreach u $all {
		    if {[lsearch -exact $local $u] <0} {
			lappend list $u
		    }
		}
	    }
	    local {
		set list [getpwusers_local]
	    }
	    default {
		set list $all
	    }
	}
    } else {
	foreach l [split [boks_priv "read_file $file"] \n] {
	    lappend list [lindex [split $l :] 0]
	}
    }
    foreach u $list {
	if ![string length $u] {
	    continue
	}
	if ![boks_user_exist ${host}:$u] {
	    lappend ret $u
	}
    }
    set real_ret {}
    foreach user $ret {
      if {[lsearch $real_ret $user] < 0} {
              lappend real_ret $user
        }
    }
    return [lsort $real_ret]
}

proc boks_import_users_pwd {users class crvar exvar novar uidvar failvar {uid_override 0}} {
    global BOKSTAB
    upvar $crvar create_list
    upvar $exvar exist_list
    upvar $novar noexist_list
    upvar $uidvar uid_exist
    upvar $failvar fail_list

    set create_list {}
    set exist_list {}
    set noexist_list {}
    set uid_exist {}
    set fail_list {}

    set host [boks_master_name]
    set hpref [boks_read_tab HOST $host FIELDS=HOMEPREFIX]
    set use_hpref 0
    set hpreflen [string length $hpref/]
    if {[string length $hpref] && [string match /* $hpref]} {
	set use_hpref 1
    }
    foreach u $users {
	@ boks_priv {getpwnam -data $u}
	if ${?} {
	    continue
	}
	foreach pf ${@} n {name pwd uid gid gecos dir shell} {
	    set pwd($u,$n) $pf
	}
    }
    foreach u $users {
	if ![string length $u] {
	    continue
	}
	set uide  [boks_helpfuncs_uid_exists $pwd($u,uid)]
	if $uide {
	    lappend uid_exist $u
	}	    
	set user ${host}:$u
	if [boks_user_exist $user] {
	    lappend exist_list $user
	} elseif ![info exists pwd(${u},name)] {
		lappend noexist_list $u
	} elseif {!$uid_override && $uide} {
	    contine
	} else {
	    set hdir $pwd(${u},dir)
	    if [string match $hpref/* $hdir] {
		set hdir [string range $hdir $hpreflen end]
	    }
	    if [boks_uadm_create_user $user $pwd(${u},gid) $pwd(${u},gecos) \
		    $pwd(${u},uid) $hdir $pwd(${u},shell) $class $pwd(${u},pwd)] {
		lappend fail_list $user
	    } else {
		lappend create_list "$user $pwd(${u},uid) $pwd(${u},gid) $pwd(${u},dir) $pwd(${u},shell) $class"
	    }
	}
    }
    return 0
}

proc boks_import_users_file {file users class crvar exvar novar uidvar failvar {uid_override 0}} {
    upvar $crvar create_list
    upvar $exvar exist_list
    upvar $novar noexist_list
    upvar $uidvar uid_exist
    upvar $failvar fail_list

    set create_list {}
    set exist_list {}
    set noexist_list {}
    set uid_exist {}
    set fail_list {}

    set host [boks_master_name]
    foreach p [split [boks_priv "read_file $file"] \n] {
	set l [split $p :]
	if {[llength $l] != 7} {
	    continue
	}
	set u [lindex $l 0]
	foreach p $pw n {name pwd uid gid gecos dir shell} {
	    set pwd(${u},$n) $p
	}
    }

    foreach u $users {
	if ![string length $u] {
	    continue
	}
	set user ${host}:$u
	if [boks_user_exist $user] {
	    lappend exist_list $user
	} elseif ![info exists pwd(${u},name)] {
		lappend noexist_list $u
	} elseif { !$uid_override && [boks_helpfuncs_uid_exists $pwd(${u},uid)] } {
	    lappend uid_exist $u
	} else {
	    if [boks_uadm_create_user $user $pwd(${u},gid) $pwd(${u},uid) \
		    $pwd(${u},dir) $pwd(${u},shell) $class] {
		lappend fail_list $user
	    } else {
		lappend create_list "$user $pwd(${u},gid) $pwd(${u},uid) $pwd(${u},dir) $pwd(${u},shell) $class"
	    }
	}
    }
    return 0
}

proc boks_addusermap user {
    @ callboks master update-passwd o LOGNAME=$user
}

proc boks_uadm_get_admin_status {username} {
    set user [username_only $username]
    
    boks_priv {
	set data [read_file [boksdir etc]/admins]
    }
    set list [split $data \n]
    if {[lsearch $list $user] > -1} {
	return 1
    }
    return 0
}

proc boks_uadm_set_admin_status {username is_admin} {
    set user [username_only $username]

    boks_priv {
	set data [read_file [boksdir etc]/admins]
    }
    set list [split $data \n]
    set idx [lsearch -exact $list $user]
    if $is_admin {
	if {$idx > -1} {
	    return
	}
	set list [lappend list $user]
    } else {
	if {$idx < 0} {
	    return
	}
	set list [lreplace $list $idx $idx]
    }
    set data {}
    foreach u $list {
	if [string length $u] {
	    append data "$u\n"
	}
    }
    boks_priv {
	write_file [boksdir etc]/admins $data
    }
}

proc boks_uadm_get_default_homeprefix {{host {}}} {
    if ![string length $host] {
	set host [boks_master_name]
    }
    return [boks_read_tab HOST $host FIELDS=HOMEPREFIX]
}

proc boks_admin_users {{list {}}} {
    set admins {}
    boks_priv {
	foreach u [split [read_file [boksdir etc]/admins] \n] {
	    if [string length $u] {
		lappend admins $u
	    }
	}
    }
    if ![string length $list] {
	set list [boks_listusers]
    }
    set result {}
    foreach u $list {	
	if {[lsearch $admins [username_only $u]] > -1} {
	    lappend result $u
	}
    }
    return $result
}


proc boks_run_extra_script { symb_name arglist {stdin_arg ""} } {
    global env
    set scriptname "";
    if [boks_priv {file exists $env(BOKS_etc)/ssm_hook_config}] {
	set l [string length $symb_name]
	boks_priv {set fp [open $env(BOKS_etc)/ssm_hook_config r]}
	while {[gets $fp line] != -1} {
	    if {[string compare "$symb_name=" [string range $line 0 $l]] == 0} {
		incr l
		set scriptname [string trim [string range $line $l end]]
		break
	    }
	}
	close $fp
	if {[string length $scriptname] && [string match /* $scriptname] && \
		[boks_priv {file executable $scriptname}] && \
		[boks_priv {file isfile $scriptname}]} {
	    boks_priv {file stat $scriptname s}
	    if {$s(uid) == 0 && [expr $s(mode) & 022] == 0} {
		boks_priv {eval exec $scriptname $arglist <<\$stdin_arg}
	    }
	}
    }
}

proc boks_sanity_check {what val} {
    if ![string compare $what USERNAME] {
	#  use boks_checklocalusername
	if {![string length $val] || ![string length [boks_checklocalusername $val]]} {
	    return 0
	}
    } elseif ![string compare $what UID] {
	# numeric, not empty
	if ![regexp {^-?[0-9]+$} $val] {
	    return 0
	}
    } elseif ![string compare $what ISPROG] {
	# must be executable file, absolute path
	if {![string match /* $val] || ![boks_priv {file executable $val}]} {
	    return 0
	}
    } elseif ![string compare $what ISDIR] {
	# must be directory, absolute path
	if {![string match /* $val] || ![boks_priv {file isdir $val}]} {
	    return 0
	}
    } elseif ![string compare $what ALARM] {
	# empty string or start with | or >
	if {[string length $val] && ![regexp {^[|>]} $val]} {
	    return 0
	}
    } elseif ![string compare $what HOSTNAME] {
	# use existing boks_check_hostname
	if ![boks_check_hostname $val] {
	    return 0
	}
    } elseif ![string compare $what DATE] {
	# check using strptime + not empty
	if ![string length $val] {
	    return 0
	}
	@ strptime $val %x
	if ${?} {
	    return 0
	}
    } elseif ![string compare $what GROUP] {
	# not empty, letters numbers _ and - only
	if {![string length $val] || ![regexp {^[-a-zA-Z0-9_]*$} $val]} {
	    return 0
	}
    } elseif ![string compare $what CARDINAL] {
	# positive non-zero number
	if ![regexp {^[1-9][0-9]*$} $val] {
	    return 0
	}
    } elseif ![string compare $what USERCLASS] {
	# no space, not empty, letters, numbers, _ and - only
	if {![string length $val] || ![regexp {^[-a-zA-Z0-9_]*$} $val]} {
	    return 0
	}
    } elseif ![string compare $what NO_COLON] {
	if [regexp {:} $val] {
	    return 0
	}
    } elseif ![string compare $what NO_SPACE] {
	if [regexp { } $val] {
	    return 0
	}
    } elseif ![string compare $what NO_SPACE_COLON] {
	if [regexp {[ :]} $val] {
	    return 0
	}
    } elseif ![string compare $what SHELL] {
	# no :, executable if given and start with /
	if {[string length $val] && ([regexp {:} $val] || ![string match /* $val] || \
		![file executable $val] || ![file isfile $val])} {
	    return 0
	}
    } elseif ![string compare $what HOMEDIR] {
	# if non empty, no :, start with / (probably does not exists yet)
	if {[string length $val] && ([regexp {:} $val] || ![string match /* $val])} {
	    return 0
	}
    }
    return 1
}


# helpfunction used in forms/user/mod.form to create a user.
#
# Note. last part of code is basically same as boks_uadm_moduser below.
# Maybe they can be put in one function...
#
proc boks_uadm_adduser {user psw uid group realname homedir shell \
		expires create_homedir class days start stop login su \
		rexec action_timeout timeout is_admin block_user} {

    set hp [boks_uadm_get_default_homeprefix]
    if {[string length $hp] && [string match $hp/* $homedir]} {
	set hdir [string range $homedir [string length $hp/] end]
	while [string match /* $hdir] {
	    set hdir [string range $hdir 1 end]
	}
    } else {
	set hdir $homedir
    }
    set rhdir [boks_home2realhome $hdir]
    set is_in_userclass [expr [string compare $class "-"] != 0]
    if $is_in_userclass {
	if [boks_uadm_create_user $user $group $realname $uid $hdir $shell $class] {
	    return 0
	}
    } else {
	if [boks_uadm_create_user $user $group $realname $uid $hdir $shell] {
	    return 0
	}
	boks_setroutes user $user $days $start $stop $login $su $rexec
	set tmp "$days#$start#$stop#$login#$su#$rexec"
	boks_uadm_log_entry $user USER_ROUTE $tmp
    }
    if $create_homedir {
	@ callboks master master-name o
	set me $o(DATA)
	set fhost [boks_read_tab HOST $me FIELDS=FILEHOST]
	if {![string length $fhost] || ![string compare $me $fhost] ||\
	    ![string compare $hdir $homedir]} {
	    @ boks_exec mkhome -l $user
	}
    }
    if $block_user {
	boks_helpfuncs_set_user_flags $user BLOCKED 1
	}
    if [string compare $action_timeout lock] {
	boks_helpfuncs_set_user_flags $user TLOCK 0
	boks_uadm_log_entry $user NO_TLOCK
    } else {
	boks_helpfuncs_set_user_flags $user TLOCK 1
	boks_uadm_log_entry $user TLOCK
    }
    boks_uadm_get_user_data $user udata

    if ![info exists udata(UID)] {
	return 0
    }
    # set timeout and expire here, but only if != what exists
    if [boks_helpfuncs_user_param_isset $user TIMEOUT] {
	if { $udata(TIMEOUT) == -1 } {
	    set tmout -1
	} elseif { $udata(TIMEOUT) <= 600 } {
	    set tmout 10
	} elseif { $udata(TIMEOUT) <= 1800 } {
	    set tmout 30
	} else {
	    set tmout 60
	}
    } else {
	set tmout def
    }
    if [string compare $timeout $tmout] {
	if ![string compare $timeout def] {
	    boks_helpfuncs_set_user_parammask $user TIMEOUT 0
	} else {
	    set t [expr $timeout * 60]
	    if { $timeout == -1 } {
		set t -1
	    }
	    boks_uadm_set_user_data $user TIMEOUT $t
	}
    }


    # Check if expire date has changed. Only bother if more than 24 h away from
    # old val (implicit rounding happens due to reformatting with %x)
    set etime [expr $udata(USERLASTCHANGE) + $udata(LOGINVALIDTIME)]
    set netime [strptime $expires %x]
    set diff [expr $netime - $etime]
    if {$diff > 86400 || $diff < -86400} {
	set ltime [expr $netime - $udata(USERLASTCHANGE)]
        if {$ltime >= 0} {
	    boks_uadm_set_user_data $user LOGINVALIDTIME $ltime
	}
    }

    if [string length $psw] {
	boks_uadm_change_user_psw -force $user $psw
    } else {
	boks_addusermap $user
    }
    boks_uadm_set_admin_status $user $is_admin


    foreach {h u} [split $user ':'] {}
    set arglist ""
    lappend arglist "-h" "$h" "-n" "$u" "-r" "$realname" "-u" "$uid" \
	    "-g" "$group" "-d" "$homedir" "-D" "$rhdir"
    if $is_admin {
	lappend arglist "-a"
    }
    if $create_homedir {
	lappend arglist "-c"
    }
    if [string length $psw] {
	lappend arglist -p
    }

    if [string length $psw] {
	boks_run_extra_script USERADD $arglist $psw
    } else {
	boks_run_extra_script USERADD $arglist
    }
    return 1
}

# Help function called from forms/user/mod.form for modify user operation
# after all validity checks are done.
#
# Note last part of code is basically same as in boks_uadm_adduser
#
proc boks_uadm_moduser {udata_var user psw uid group realname homedir shell \
		expires create_homedir class days start stop login su \
		rexec action_timeout timeout is_admin block_user unblock_user} {

    upvar $udata_var udata
    set accessroute_mod none
    set addmap 0

    set hp [boks_uadm_get_default_homeprefix]
    if {[string length $hp] && [string match $hp/* $homedir]} {
	set hdir [string range $homedir [string length $hp/] end]
	while [string match /* $hdir] {
	    set hdir [string range $hdir 1 end]
	}
    } else {
	set hdir $homedir
    }
    set rhdir [boks_home2realhome $hdir]
    set is_in_userclass [expr [string compare $class "-"] != 0]
    if $unblock_user {
	set user_blocked_reason [boks_helpfuncs_user_blocked udata]
	if { [lsearch -exact $user_blocked_reason blocked] != -1 } {
	    boks_helpfuncs_set_user_flags $user BLOCKED 0
	}
	if { [lsearch -exact $user_blocked_reason login_fail] != -1 } {
	    boks_uadm_set_user_data $user RETRY 0
	}
	# psw stuff is taken care of below since admin has set psw
	set addmap 1
    }
    if $block_user {
	# if he sets both unblock and block, so be it.
	boks_helpfuncs_set_user_flags $user BLOCKED 1
	set addmap 1
    }
	
    # uid, group, shell, userclass, access routes including time
    set change_list {}
    if { $uid != $udata(UID) } {
	lappend change_list UID $uid
	set addmap 1
    }
    if [string compare $realname $udata(REALNAME)] {
	lappend change_list REALNAME $realname
	set addmap 1
    }	    
    if [string compare $shell $udata(SHELL)] {
	lappend change_list SHELL $shell
	set addmap 1
    }	    
    set gid [getgrnam -nocomplain $group]
    if ![string length $gid] {
	# maybe it is a number
	if [regexp {^[0-9]*$} $group] {
	    set gid $group
	} else {
	    set gid ""
	}
    }
    if { [string length $gid] && $gid != $udata(GID) } {
	lappend change_list GID $gid
	set addmap 1
    }

    set inuclass [expr [string length $udata(PROFILE)] != 0]
    if $inuclass {
	boks_helpfuncs_getrouteinfo class $udata(PROFILE) outinfo
    } else {
	boks_helpfuncs_getrouteinfo user $user outinfo
    }
    set old_days     $outinfo(days_val)
    set old_start    $outinfo(start_val)
    set old_stop     $outinfo(stop_val)
    set old_login    $outinfo(login_val)
    set old_su       $outinfo(su_val)
    set old_rexec    $outinfo(rexec_val)

    if { $is_in_userclass != $inuclass } {
	if $is_in_userclass {
	    # add to userclass
	    lappend change_list PROFILE $class
	    # remember to remove any personal admin acc routes
	    set accessroute_mod remove
	} else {
	    # remove
	    lappend change_list PROFILE {}
	    # remember to add personal admin acc routes
	    set accessroute_mod add
	}
    } elseif { $is_in_userclass && [string compare $class $udata(PROFILE)] } {
	# changed userclass
	lappend change_list PROFILE $class
    } elseif !$is_in_userclass {
	# Check if routes have changed
	if { $login != $old_login || $su != $old_su || $rexec != $old_rexec \
		|| $days != $old_days || $start != $old_start || $stop != $old_stop } {
	    set accessroute_mod change
	}
    }

    set uhdir $udata(HOMEDIR)
    if {[string length $hp] && [string match $hp/* $uhdir]} {
	set uhdir [string range $uhdir [string length $hp/] end]
	while [string match /* $uhdir] {
	    set uhdir [string range $uhdir 1 end]
	}
    }
    if [string compare $hdir $uhdir] {
	lappend change_list HOMEDIR $hdir
	set addmap 1
    }
    eval boks_uadm_set_user_data $user $change_list
    if [string compare $accessroute_mod none] {
	if ![string compare $accessroute_mod add] {
	    boks_setroutes user $user $days $start $stop $login $su $rexec
	    set tmp "$days#$start#$stop#$login#$su#$rexec"
	    boks_uadm_log_entry $user USER_ROUTE $tmp
	} elseif ![string compare $accessroute_mod remove] {
	    boks_setroutes user $user $days $start $stop login_never su_never rexec_never
	    set tmp "$days#$start#$stop#login_never#su_never#rexec_never"
	    boks_uadm_log_entry $user USER_ROUTE $tmp
	} elseif ![string compare $accessroute_mod change] {
	    boks_setroutes user $user $days $start $stop $login $su $rexec
	    set tmp "$days#$start#$stop#$login#$su#$rexec"
	    boks_uadm_log_entry $user USER_ROUTE $tmp
	}
    }
    if $create_homedir {
	@ callboks master master-name o
	set me $o(DATA)
	set fhost [boks_read_tab HOST $me FIELDS=FILEHOST]
	if {![string length $fhost] || ![string compare $me $fhost] ||\
	    ![string compare $hdir $homedir]} {
	    @ boks_exec mkhome -l $user
	}
    }
    # tlock?
    set tlock [boks_helpfuncs_user_flag_isset $user TLOCK]
    if { $tlock && [string compare $action_timeout logout] == 0 } {
	boks_helpfuncs_set_user_flags $user TLOCK 0
	boks_uadm_log_entry $user NO_TLOCK
    } elseif { !$tlock && [string compare $action_timeout logout] != 0 } {
	boks_helpfuncs_set_user_flags $user TLOCK 1
	boks_uadm_log_entry $user TLOCK
    }
	
    # set timeout and expire here, but only if != what exists
    if [boks_helpfuncs_user_param_isset $user TIMEOUT] {
	if { $udata(TIMEOUT) == -1 } {
	    set tmout -1
	} elseif { $udata(TIMEOUT) <= 600 } {
	    set tmout 10
	} elseif { $udata(TIMEOUT) <= 1800 } {
	    set tmout 30
	} else {
	    set tmout 60
	}
    } else {
	set tmout def
    }
    if [string compare $timeout $tmout] {
	if ![string compare $timeout def] {
	    boks_helpfuncs_set_user_parammask $user TIMEOUT 0
	} else {
	    set t [expr $timeout * 60]
	    if { $timeout == -1 } {
		set t -1
	    }
	    boks_uadm_set_user_data $user TIMEOUT $t
	}
    }

    # Check if expire date has changed. Only bother if more than 24 h avay from
    # old val (implicit rounding happens due to reformatting with %x)
    set etime [expr $udata(USERLASTCHANGE) + $udata(LOGINVALIDTIME)]
    set netime [strptime $expires %x]
    set diff [expr $netime - $etime]
    if {$diff > 86400 || $diff < -86400} {
	set ltime [expr $netime - $udata(USERLASTCHANGE)]
        if {$ltime >= 0} {
	    boks_uadm_set_user_data $user LOGINVALIDTIME $ltime
	    set addmap 1
	}
    }

    if [string length $psw] {
	boks_uadm_change_user_psw -force $user $psw
	set addmap 0
    }

    if $addmap {
	boks_addusermap $user
    }

    boks_uadm_set_admin_status $user $is_admin

    foreach {h u} [split $user ':'] {}
    set arglist ""
    lappend arglist "-h" "$h" "-n" "$u" "-r" "$realname" \
	    "-u" "$uid" "-g" "$group" "-d" "$homedir" "-D" "$rhdir"
    if $is_admin {
	lappend arglist "-a"
    }
    if $create_homedir {
	lappend arglist "-c"
    }
    if [string length $psw] {
	lappend arglist -p
    }


    if [string length $psw] {
	boks_run_extra_script USERMOD $arglist $psw
    } else {
	boks_run_extra_script USERMOD $arglist
    }
    return 1
}

# Wrap 'lh' to list all hosts there is
#
proc boks_list_hosts {{flags -a}} {
    set args -l
    if {[string match $flags -a] == 0} {
	lappend args -h
    }
    eval @ boks_exec lh $args
    if ${?} {
	return {}
    }
    return [lsort -ascii ${@}]
}

# List hosts from "source" that do not already exist in the
# BoKS DB. Source can be "local," "svc" or "all" (anything else is
# intepreted as "all". "svc" is short for whatever naming service
# is used (dns/nis), "local" is /etc/hosts.
#
proc boks_hosts_not_imported {source} {
    set hosts {}
    switch -exact $source {
	svc {
	    set local [gethosts_local]
	    set all [boks_list_hosts]
	    foreach h $all {
		if {[lsearch $local $h] < 0} {
		    lappend hosts $h
		}
	    }
	}
	local {
	    set local [lsort -ascii [gethosts_local]]
	    set bokshosts [boks_read_tab HOST *]
	    foreach h $local {
		if {[lsearch $bokshosts $h] < 0} {
		    lappend hosts $h
		}
	    }
	}
	default {
	    set hosts [boks_list_hosts]
	}
    }
    return $hosts
}

# Read the "not-licensed" info file, and put the contents in
# a supplied variable. Returns length of contents.
# This is just a warning message, the actual check is done inside BoKS.
#
proc boks_not_licensed {varname} {
    upvar $varname str

    set str [read_file [boksdir var]/.licinfo]
    return [string length $str]
}


#======================================================================
# Included file "configure.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"configure.tcl\""}
###########################################################################
#
# $Id: configure.tcl,v 1.23.2.1 1996/10/05 16:57:28 cvsusr Exp $
#
# Copyright (c) 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# File:         configure.tcl
#
# Description:	boks_config_* routines to set up security levels.
#		(names are after list on p 7. SunBoKS spec)
#
# Author:       Gran Hammarbck (+ Mikko)
#
# Created:      19960627
#
###########################################################################

#
# All functions return 0 on OK, other val on error (normally just 1)
# Most functions read values from an array variable, which is
# may be initialised from a file.
# 
# Note that many of the "get" functions just make qualified guesses,
# as parameters may consist of "packages" of parameters taht may have been
# changed individually since last configured.
#

# Initial configuration, if needed -- called at the end of this file!
#
proc boks_config_init_maybe {} {
    @ boks_config_get_overallconfig a
    if {${?} || [info exists a(unconfigured)]} {
	catch {unset a}
	boks_config_get_overallconfig a low
	boks_config_save_overallconfig a
	boks_config_execute_overallconfig a
    }
}

# Check if there is a saved file
#
proc boks_config_saved_file_exists {{type saved}} {
    global boksenv

    return [file readable $boksenv(BOKS_etc)/conf.$type]
}

# Return the parameter names used for overall configuration
#
proc boks_config_get_param_names {} {
    global BOKS_CONFIG_PARAMS

    return $BOKS_CONFIG_PARAMS
}


# Get a bunch of overall options, either one of the predefined
# "high," "medium," "low" or the saved file, if there is one,
# and store in the supplied array
#
proc boks_config_get_overallconfig {arrayvar {type saved}} {
    upvar $arrayvar a
    global boksenv BOKS_CONFIG_DEFAULTS

    catch {unset a}
    array set a $BOKS_CONFIG_DEFAULTS(default)
    if {[lsearch {low medium high default} $type] > -1} {
	array set a $BOKS_CONFIG_DEFAULTS($type)
	return 0
    }
    set file $boksenv(BOKS_etc)/conf.$type
    boks_priv {
	if ![file readable $file] {
	    return 1
	}
	@ arrayfile $file a
    }
    return ${?}
}

# Save an overall config file
#
proc boks_config_save_overallconfig {arrayvar {type saved}} {
    upvar $arrayvar a
    global boksenv

    if {[lsearch {low medium high default} $type] > -1} {
	return 1
    }
    if {[string length $type] > 16 || [string match {*/*} $type]} {
	return 1
    }
    set s {}
    foreach n [array names a] {
	append s "$n=$a($n)\n"
    }
    set file $boksenv(BOKS_etc)/conf.$type
    boks_priv {
	@ open $file w 0644
	if ${?} {
	    return 1
	}
	puts ${@} $s
	close ${@}
    }
    return 0
}

# Execute a configuration array
#
proc boks_config_execute_overallconfig {arrayvar} {
    upvar $arrayvar a
    global BOKS_CONFIG_PARAMS

    foreach param $BOKS_CONFIG_PARAMS {
	if ![string length [info proc boks_config_$param]] {
	    puts "missing proc for $param, dimwit!"
	    continue
	}
	debug 1 "param = $param"
	if [boks_config_$param a] {
	    debug 1 "              -> $param failed"
	}
    }
    boks_config_executeroutes
    return 0
}

proc boks_config_executeroutes { {anytime 1} } {
    global BOKS_saverouteconfig BOKS_PREDEFINED_USER_CLASSES
    set host [boks_master_name]

    # root
    if !$anytime {
	boks_helpfuncs_getrouteinfo user ${host}:root o
    }
    if { $anytime || ([info exists o(NOROUTES)] && $o(NOROUTES)) } {
	boks_setroutes user ${host}:root anytime 0 86400 \
	    login_$BOKS_saverouteconfig(rootlogin) \
	    rexec_$BOKS_saverouteconfig(rootrexec) \
	    su_root
    } else {
	boks_setroutes user ${host}:root $o(days_val) $o(start_val) $o(stop_val) \
	    login_$BOKS_saverouteconfig(rootlogin) \
	    rexec_$BOKS_saverouteconfig(rootrexec) \
	    su_root
    }

    # classes
    foreach c $BOKS_PREDEFINED_USER_CLASSES(CLASSES) {
	set su "never"
	# adm_staff is handled by default rules in
	# boks_set_predefined_class_routes
	switch -exact $BOKS_saverouteconfig(su) {
	    logonly     { set su logonly }
	    users_users { set su root }
	    adm_users   { set su user}
	    adm_staff   { }
	}
	if ![boks_userclass_exists $c] {
	    boks_user_class_create $c
	}
	boks_set_predefined_class_routes $c \
		$su \
		$BOKS_saverouteconfig(login) \
		$BOKS_saverouteconfig(rexec)
    }
}
    
# If installed, try to modify a configuration array to reflect what is
# installed.
#
proc boks_config_get_loaded_configuration {arrayvar} {
    upvar $arrayvar a
    global BOKS_CONFIG_PARAMS

    foreach param $BOKS_CONFIG_PARAMS {
	if [info exists a($param)] {
	    set b $a($param)
	} else {
	    set b "(Not Defined!)"
	}
	set s [boks_config_get_$param a]
	debug 3 "$param: $b -> $s"
	set a($param) $s
    }
}

# Set alarm log destination: normal, console, mailto (root)
#
proc boks_config_alarmlogs {arrayvar} {
    upvar $arrayvar a
    global BOKSTAB
    
    if ![info exists a(alarmlogs)] {
	return 1
    }
    set arg $a(alarmlogs)
    switch $arg {
	console {
	    set logdest ">/dev/console"
	}
	mailto {
	    set logdest "|/bin/mailx -s BoKS/AlarmLog root"
	}
	default {
	    set logdest ">/dev/null"
	}
    }
    @ callboks master write o TAB=$BOKSTAB(SYS) KEY=00 \
	    NEWFIELDS=LOGCMD +LOGCMD=$logdest
    if ${?} {
	return 1
    }
    boks_log -type S -label logcmd "Log redirection command: %s" "$logdest"
    return 0
}

# Get ditto
proc boks_config_get_alarmlogs {arrayvar} {
    upvar $arrayvar a

    set default console
    if [info exists a(alarmlogs)] {
	set default $a(alarmlogs)
    }
    set logdest [boks_read_tab SYS 00 FIELDS=LOGCMD]
    switch -regexp -- $logdest {
	{^[ \t]*\|[ \t]*/bins/mailx.*root[ \t]*$} {
	    set default mailto
	}
	{^[ \t]*>[ \t]*/dev/null[ \t]*$} {
	    set default normal
	}
    }
    return $default
}

# Get log configuration
#
proc boks_config_logs {arrayvar} {
    upvar $arrayvar a

    if ![info exists a(logs)] {
	return 1
    }
    switch $a(logs) {
	full {
	    set values {on on on on}
	}
	default {
	    set values {off off on on}
	}
    }
    set varlist {RSHD_CMD_LOG REXEC_CMD_LOG RSHD_LOGGING REXECD_LOGGING}
    foreach n $varlist v $values {
	boks_setboksenv $n $v
    }
    return 0
}

# Get log configuration
proc boks_config_get_logs {arrayvar} {
    upvar $arrayvar a

    set default normal
    if [info exists a(logs)] {
	set default $a(logs)
    }
    set s [boks_getboksenv RSHD_LOGGING]
    if [string compare $s "on"] {
	return normal
    }
    return $default
}

# Set password parameters
#
proc boks_config_pswmodel {arrayvar} {
    upvar $arrayvar a
    global BOKSPSWFMT

    if ![info exists a(pswmodel)] {return 1}
    set arg $a(pswmodel)

    # infinite time (days) (approx 11 years, can't use more, overflow in ssm)
    set infinite_days 4000

    if [info exists BOKSPSWFMT(type,$arg)] {
	set type $arg
    } else {
	switch $arg {
	    medium {
		set type 11
	    }
	    high {
		set type 22
	    }
	    default {
		set type psw
	    }
	}
    }
    switch $arg {
	random {
	    set values {6 365 31 1 5}
	}
	model {
	    set values {6 365 31 1 5}
	}
	high {
	    set values {8 90 31 20 120}
	}
	medium {
	    set values {7 365 60 10 60}
	}
	low {
	    set values {6 365 60 10 60}
	}
	default {
	    set values "1 $infinite_days $infinite_days 3 1"
	}
    }
    foreach {minlen lifespan limit histlen min} $values {}
    if [boks_set_password_parameters \
	    $type $minlen $lifespan $limit $histlen $min] {
	return 1
    }
    boks_log -type S -label sa_config \
	    "configuration parameter %s set to %s" \
	    password_parameters $arg
    return 0
}

# Try to figure out current password parameters
#
proc boks_config_get_pswmodel {arrayvar} {
    upvar $arrayvar a
    
    set default psw
    if [info exists a(pswmodel)] {
	set default $a(pswmodel)
    }
    foreach {type len life lim hist min} [boks_get_password_parameters] {}
    if {[lsearch {random model} $type] > -1} {
	return $type
    }
    switch $type {
	11 {
	    return medium
	}
	22 {
	    return high
	}
	default {
	    if {$life <= 365} {
		return low
	    }
	}
    }
    return $default
}

# Set number of failed logins allowed
#
proc boks_config_retries {arrayvar} {
    upvar $arrayvar a
    global BOKSTAB

    if ![info exists a(retries)] {
	return 1
    }
    set arg $a(retries)
    if { [string compare $arg "high"] == 0 } {
	set retrymax 3
    } elseif {[string compare $arg "medium"] == 0} {
	set retrymax 10
    } elseif {[string compare $arg "low"] == 0} {
	set retrymax 100
    } else {
	return 1
    }
    @ callboks master write o TAB=$BOKSTAB(SYS) KEY=00 \
	    "NEWFIELDS=RETRYMAX" +RETRYMAX=$retrymax
    if ${?} {
	return 1
    }
    boks_log -type S -label sa_config \
	    "configuration parameter %s set to %s" \
	    failed_logins_allowed $arg
    return 0
}

# Get ditto
#
proc boks_config_get_retries {arrayvar} {
    upvar $arrayvar a
    
    set default low
    if [info exists a(retries)] {
	set default $a(retries)
    }
    set r [boks_read_tab SYS 00 FIELDS=RETRYMAX]
    if [string length $r] {
	if {$r <= 3} {
	    return high
	}
	if {$r <= 10} {
	    return medium
	}
	return low
    }
    return $default
}

# Set level of messages (verbose or quiet)
#
proc boks_config_messages {arrayvar} {
    upvar $arrayvar a
    global BOKS_FLAGS BOKSTAB

    set val $BOKS_FLAGS(SYS,VERBOSE)
    if ![info exists a(messages)] {
	return 1
    }
    set arg $a(messages)
    if ![string length [boks_read_tab SYS 00 FIELDS=FLAGS]] {
	return 1
    }
    if {[string compare $arg "verbose"] == 0} {
	set op |
    } elseif {[string compare $arg "quiet"] == 0} {
	set op &
	set val [expr 0xffff & ~$val]
    } else {
	return 1
    }
    @ callboks master field-arit o TAB=$BOKSTAB(SYS) KEY=00 \
	    FIELD=FLAGS OP=$op OPVAL=$op$val
    if ${?} {
	return 1
    }
    boks_log -type S -label sa_config \
	    "configuration parameter %s set to %s" messages $arg
    return 0
}

# Get message level
#
proc boks_config_get_messages {arrayvar} {
    upvar $arrayvar a
    global BOKS_FLAGS

    set default quiet
    if [info exists a(messages)] {
	set default $a(messages)
    }
    set flags [boks_read_tab SYS 00 FIELDS=FLAGS]
    if ![string length $flags] {
	return $default
    }
    if {$flags & $BOKS_FLAGS(SYS,VERBOSE)} {
	set default verbose
    } else {
	set default quiet
    }
    return $default
}

# Set system monitoring level. Ths includes both the running of
# systsem security check ("COPS") and file monitoring.
#
proc boks_config_bgmon {arrayvar} {
    upvar $arrayvar a

    if ![info exists a(bgmon)] {
	return 1
    }
    set arg $a(bgmon)
    switch $arg {
	high {
	    set filmonlevel high
	    set crontime "0 0 * * 0,4"
	}
	medium {
	    set filmonlevel medium
	    set crontime "0 0 * * 0"
	}
	low {
	    set filmonlevel low
	    set crontime "0 0 1 * *"
	    set arg low
	}
	none {
	    set filmonlevel {}
	    set crontime {}
	    set arg none
	}
    }
    @ callboks clntd read o FILE=crontab
    set line {}
    foreach line [split $o(DATA) \n] {
	if [string match {*boks_icheck*} $line] {
	    @ callboks clntd delline o FILE=crontab LINE=$line
	}
    }
    if [string length $crontime] {
	@ callboks clntd addline o FILE=crontab \
		"LINE=$crontime [boksdir lib]/boks_icheck"
	if ${?} {
	    return 1
	}
    }
    # "filmon" must look for this ENV var to find filelist
    boks_setboksenv FILMONLEVEL $filmonlevel
    if [string length $filmonlevel] {
	boks_setboksenv FILMON on
    } else {
	boks_setboksenv FILMON off
    }
    boks_log -type S -label sa_config \
	    "configuration parameter %s set to %s" background_monitoring $arg
    return 0
}

# Get current background monitoring level
proc boks_config_get_bgmon {arrayvar} {
    upvar $arrayvar a

    set default low
    if [info exists a(bgmon)] {
	set default $a(bgmon)
    }
    switch [boks_getboksenv FILMONLEVEL] {
	medium {
	    set default medium
	}
	high {
	    set default high
	}
    }
    return $default
}

# Set timeout to one of the supported configurations
#
proc boks_config_timeout {arrayvar} {
    upvar $arrayvar a
    global BOKS_TIMEOUT BOKSTAB

    if ![info exists a(timeout)] {return 1}
    set type $a(timeout)
    if ![info exists BOKS_TIMEOUT(type,$type)] {return 1}
    scan $BOKS_TIMEOUT(type,$type) "%d/%d" sys root
    set sys [expr $sys * 60]
    set root [expr $root * 60]
    @ callboks master write o TAB=$BOKSTAB(SYS) KEY=00 \
	    NEWFIELDS=TIMEOUT +TIMEOUT=$sys
    boks_uadm_set_user_data [boks_master_name]:root TIMEOUT $root
    if {$type == "none"} {
	set val off
    } else {
	set val on
    }
    boks_setboksenv BKSD_TIMEOUT $val
    return 0
}

# Get ditto, from array variable or system
#
proc boks_config_get_timeout {arrayvar} {
    global BOKS_TIMEOUT
    upvar $arrayvar a

    set default none
    if [info exists a(timeout)] {
	if [info exists BOKS_TIMEOUT(type,$a(timeout))] {
	    set default $a(timeout)
	}
    }
    set sys [boks_read_tab SYS 00 FIELDS=TIMEOUT]
    set root [boks_read_tab USER [boks_master_name]:root FIELDS=TIMEOUT]
    set sys [expr $sys / 60]
    set root [expr $root / 60]
    if [info exists BOKS_TIMEOUT(label,$sys/$root)] {
	set default $BOKS_TIMEOUT(label,$sys/$root)
    }
    return $default
}

# take things like login_normal, rexec_trusted, and return
# normal and trusted.
#
proc boks_get_sec_level m_l {
    return [lindex [split $m_l _] 1]
}

proc boks_config_rootlogin {arrayvar} {
    upvar $arrayvar a
    global BOKS_saverouteconfig

    set type rootlogin
    if [info exists a($type)] {
	set BOKS_saverouteconfig($type) $a($type)
    } else {
	set BOKS_saverouteconfig($type) $a($type)
    }
    return 0
}

proc boks_config_get_rootlogin {arrayvar} {
    @ callboks master master-name o
    set host $o(DATA)
    boks_helpfuncs_getrouteinfo user ${host}:root out
    return [boks_get_sec_level $out(login_val)]
}

proc boks_config_rootrexec {arrayvar} {
    upvar $arrayvar a
    global BOKS_saverouteconfig

    set type rootrexec
    if [info exists a($type)] {
	set BOKS_saverouteconfig($type) $a($type)
    } else {
	set BOKS_saverouteconfig($type) $a($type)
    }
    return 0
}

proc boks_config_get_rootrexec {arrayvar} {
    @ callboks master master-name o
    set host $o(DATA)
    boks_helpfuncs_getrouteinfo user ${host}:root out
    return [boks_get_sec_level $out(rexec_val)]
}


# XXX: trouble -- these will have to be merged into one (or store values
# for later execution.  All route-setting functions set ALL routes
# at once.
#
# 
# Note : the new values from the config form (as far as i can see -- if
# "individual" means what I think it means), can be fed directly
# to boks_set_predefined_class_routes!!! -- no special cases, no nothing!
#
#
proc boks_config_login {arrayvar} {
    upvar $arrayvar a
    global BOKS_saverouteconfig

    set type login
    if [info exists a($type)] {
	set BOKS_saverouteconfig($type) $a($type)
    } else {
	set BOKS_saverouteconfig($type) $a($type)
    }
    return 0
}
proc boks_config_rexec {arrayvar} {
    upvar $arrayvar a
    global BOKS_saverouteconfig

    set type rexec
    if [info exists a($type)] {
	set BOKS_saverouteconfig($type) $a($type)
    } else {
	set BOKS_saverouteconfig($type) $a($type)
    }
    return 0
}
proc boks_config_su {arrayvar} {
    upvar $arrayvar a
    global BOKS_saverouteconfig

    set type su
    if [info exists a($type)] {
	set BOKS_saverouteconfig($type) $a($type)
    } else {
	set BOKS_saverouteconfig($type) $a($type)
    }
    return 0
}

# These don't even try to make a guess -- there is just too many
# parameters to tweak hidden behind each value. You just get your
# default previous back.
#
proc boks_config_get_login {arrayvar} {
    upvar $arrayvar a

    if [info exists a(login)] {
	return $a(login)
    }
}
proc boks_config_get_rexec {arrayvar} {
    upvar $arrayvar a

    if [info exists a(rexec)] {
	return $a(rexec)
    }

}
proc boks_config_get_su {arrayvar} {
    upvar $arrayvar a

    if [info exists a(su)] {
	return $a(su)
    }
}

# Make sure initial configuration has been done
#
boks_config_init_maybe


#======================================================================
# Included file "icheck.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"icheck.tcl\""}
#
# $Id: icheck.tcl,v 1.10.2.2 1996/09/29 12:09:39 cvsusr Exp $
# Copyright  1996 Dynamic Software AB
#
# Support routines used by BoKS Integrity Check Administration.
# (Many of these belong in another file - move them later)

# TRUE if there exists a lock for `pathname'
# (should preferably check for aliveness too, but since this is
#  a task for clntd on the client I leave it for now)

proc boks_lock_test {pathname} {
    set short [file tail $pathname]
    if [file exists [boksdir var]/LCK/$short] {
	debug 1 "Lockfile [boksdir var]/LCK/$short exists"
	return 1
    }
    return 0
}

# Return specified BoKS Integrity Check directory name.
#
proc boks_icheck_dir {name} {
    switch -- $name {
	data {
	    return [boksdir var]/bic
	}
	bin {
	    return [boksdir lib]
	}
    }
    return [boksdir $name]/bic
}

# Map name,<id> -> <cron-spec>
#     cron,<cron-spec> -> <id>

array set ICHECK_SCHEDS {
    name,monthly	{1 * *}
    name,weekly		{* * 0}
    name,biweekly	{* * 0,4}
    {cron,1 * *}	monthly
    {cron,* * 0}	weekly
    {cron,* * 0,4}	biweekly
}

array set ICHECK_DEFAULTS {
    cronminute	0
}

#
# Configure BoKS Integrity checks. Modifies crontab (or whatever)
# Return 0 if all OK.
#
# boks_icheck_set_schedule how_often ?hour? ?spec? 
#
proc boks_icheck_set_schedule {how_often {hour 0} {spec {}}} {
    global ICHECK_SCHEDS
    global ICHECK_DEFAULTS

    set minute $ICHECK_DEFAULTS(cronminute)
    set crontime {}
    switch $how_often {
	off {
	    set crontime {}
	}
	custom {
	    if {[llength $spec] > 4} {
		set crontime "$spec"
	    } else {
		set crontime "$minute $hour $spec"
	    }
	}
	default {
	    if [info exists ICHECK_SCHEDS(name,$how_often)] {
		set crontime "$minute $hour $ICHECK_SCHEDS(name,$how_often)"
	    } else {
		debug 1 "boks_icheck_set_schedule: unkown arg: $how_often"
		return 1
	    }
	}
    }	

    debug 1 "minute: $minute\nhour: $hour\ncrontime: $crontime"
    @ callboks clntd read o FILE=crontab
    set line {}
    foreach line [split $o(DATA) \n] {
	if [string match {*boks_icheck*} $line] {
	    @ callboks clntd delline o FILE=crontab LINE=$line
	}
    }
    if [string length $crontime] {
	@ callboks clntd addline o FILE=crontab \
		"LINE=$crontime [boks_icheck_dir bin]/boks_icheck"
	if ${?} {
	    return 1
	}
    }
    return 0
}

#
# Get scheduled time for Integrity checks
# reads from crontab (or whatever)
# Returns a 2-3 el. list: 
#   {<type> <hour> ?<cronspec>?}
#
proc boks_icheck_get_schedule {} {

    global ICHECK_SCHEDS

    @ callboks clntd read o FILE=crontab
#puts [array names o]
    set cronline {}
    foreach line [split $o(DATA) \n] {
	if [string match {*boks_icheck*} $line] {
	    set cronline [string trim $line]
	    break
	}
    }
    if {[string length $cronline] == 0} {
	return {off 0}
    } else {
	# Heuristic time..

	foreach {min hour day month dow cmd} [split $cronline] { }
	set idx "$day $month $dow"
	if [info exists ICHECK_SCHEDS(cron,$idx)] {
	    debug 1 "found: cron,$idx in table"
	    return [list $ICHECK_SCHEDS(cron,$idx) $hour]
	}
	return [list custom $hour [list $min $hour $day $month $dow] ] 
    }
}

# Return a list of all known checks (from $BIC_etc/checks.conf)
#
proc boks_icheck_get_checknames {} {
    set checks {}
    boks_priv {@ open [boks_icheck_dir etc]/checks.conf r}
    if !${?} {
	set f ${@}
	while {[gets $f line] >= 0} {
	    if {[regexp {^([^ #	]+)} $line word]} {
		lappend checks $word
	    }
	}
	close $f
    }
    return $checks
}

# Return state of checks in list (1 on, 0 off or does not exist)
#
proc boks_icheck_getstate {list} {
    boks_priv {@ open [boks_icheck_dir etc]/checks.conf r}
    if !${?} {
	set f ${@}
	while {[gets $f line] >= 0} {
	    if {[regexp {^([^ #	]+)[ 	]+([^ 	]+)} $line word test state]} {
		set mode($test) $state
	    }
	}
	close $f
    }
    set l {}
    foreach t $list {
	if {[info exists mode($t)] && [regexp {^[Oo][Nn]$} $mode($t)]} {
	    lappend l 1
	} else {
	    lappend l 0
	}
    }
    return $l
}



# Set state of tests, try to keep comments in file (and commands).
#
proc boks_icheck_setstate {tests states} {
    boks_priv {@ open [boks_icheck_dir etc]/checks.conf r}
    if ${?} {
	return
    }
    set f ${@}
    boks_priv {@ open [boks_icheck_dir etc]/checks.conf.new w}
    if ${?} {
	close $f
	return
    }
    set out ${@}
    while {[gets $f line] >= 0} {
	if [regexp {^([^# 	]+)[ 	]+([^ 	]+)(.*)} $line w test state cmd] {
	    set notfound 1
	    foreach t $tests s $states {
		if ![string compare $t $test] {
		    if $s {
			set is on
		    } else {
			set is off
		    }
		    puts $out "[format {%-15s %-10s %s} $test $is $cmd]"
		    set notfound 0
		}
	    }
	    if $notfound {
		puts $out $line
	    }
	} else {
	    puts $out $line
	}
    }
    close $f
    close $out
    boks_priv "@ exec /bin/chmod 644 [boks_icheck_dir etc]/checks.conf.new"
    boks_priv "@ exec /bin/chgrp sys [boks_icheck_dir etc]/checks.conf.new"
    boks_priv "@ exec /bin/mv -f [boks_icheck_dir etc]/checks.conf.new [boks_icheck_dir etc]/checks.conf"
}


# Start integrity check "manually" by calling clntd
#
proc boks_icheck_start_right_now {} {
    #    @ return [boks_exec [boks_icheck_dir bin]/boks_icheck]
    @ callboks clntd startprog o "PROG=boks_icheck.nowait"
    if [info exists o(ERROR)] {
	debug 1 "(1)ERROR=$o(ERROR)"
    }
    debug 1 "?=${?}"
    if {${?} != 0} {
	return 0
    }
    if [info exists o(ERROR)] {
	debug 1 "(2)ERROR=$o(ERROR)"
	return [expr $o(ERROR) != 0]
    }
    return 0
}

# -----------------------------
# Reports & exclusion stuff below. Needs commenting, rewriting and debugging

proc boks_icheck_db_path {{name {}}} {
#    global boks_localhost
    return "[boks_icheck_dir data]/$name"
}

# Split a report line into its components (as a list)
#
proc boks_icheck_split_report_record {line} {
    regsub -all {([\{\}\]\[])} $line {\\\1} line
    set s {}
    foreach x $line { lappend s $x }
    return $s
}

# Join a "splitted" report record into a string 
#
proc boks_icheck_join_report_record {record} {
    set res {}
    foreach part $record {
	if [regexp {[ 	\\"]} $part] {
	    regsub -all {(["\\])} $part {\\\1} part
	    append res {"} $part {" }
	} else {
	    append res $part { }
	}
    }
    return [string trimright $res]
}

proc boks_icheck_load_report {name var} {
    upvar $var v
	
    set v {}
    boks_priv {@ open $name r}
    if !${?} {
	set f ${@}
	while {[gets $f line] >= 0} {
	    if ![regexp {^[# 	]$} $line] {
		lappend v [boks_icheck_split_report_record $line]
	    }
	}
	close $f
	return 0
    }
    return 1
}

proc boks_icheck_get_excluded {var} {
    upvar $var v

    set v {}
    set exclude_db [boks_icheck_db_path "exclude.dat"]
    return [boks_icheck_load_report $exclude_db v]
}
	
# Format a message from supplied report record.
proc boks_icheck_get_message_text {record} {
     set fmt [lindex $record 6]
     set args [lrange $record 7 end]
     return [eval format {$fmt} $args]
#    set cmd [list format $fmt]
#    foreach arg [lrange $record 7 end] {
#	lappend cmd $arg
#    }
#    return [eval $cmd]
}

#
# Compare two report records. Returns 0 if equal
#
proc boks_icheck_compare_records {record1 record2} {
    foreach {el1 el2} [list $record1 $record2] {
	set cmp [string compare $el1 $el2]
	if $cmp {
	    return $cmp
	}
    }
    return 0
}

#
# Remove 'line_to_rm' from the report file 'report'
#
proc boks_icheck_remove_report_record {report line_to_rm} {
    set v {}
    boks_priv {@ open $report r}
    if !${?} {
	set f ${@}
	while {[gets $f line] >= 0} {
	    if ![regexp {^[# 	]$} $line] {
		set this_line [boks_icheck_split_report_record $line]
		if [boks_icheck_compare_records $this_line $line_to_rm] {
		    lappend v $line
		}
	    } else {
		lappend v $line
	    }
	}
	close $f
	# Rewrite the file sans the possibly removed line
	boks_priv {@ open $report w}
	if !${?} {
	    set f ${@}
	    foreach l $v {
		puts $f $l
	    }
	    close $f
	    return 0
	}
	return 1
    }
}

#
# Append the report record 'rec' to the report file 'report'
#
proc boks_icheck_add_report_record {report rec} {
    boks_priv {@ open $report "a+"}
    if !${?} {
	set f ${@}
	puts $f [boks_icheck_join_report_record $rec]
	close $f
	return 0
    }
    return 1
}


#
# Remove a single record from the "exclusion DB"
#
proc boks_icheck_remove_excluded {line_to_rm} {
    set exclude_db [boks_icheck_db_path "exclude.dat"]

    debug 1 $line_to_rm
    return [boks_icheck_remove_report_record $exclude_db $line_to_rm]
}

#
# Append a single record from the "exclusion DB"
#
proc boks_icheck_add_excluded {rec} {
    set exclude_db [boks_icheck_db_path "exclude.dat"]

    return [boks_icheck_add_report_record $exclude_db $rec]
}




#======================================================================
# Included file "form.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"form.tcl\""}
#
# @(#)$Id: form.tcl,v 1.12 1996/09/15 18:15:32 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# Form procedures.  Generate html, among other things.
# They use tables, but the result does not look too bad
# on a non-table capable browser. (It looks rather awful
# on any browser...)
#
# All results end up in a number of symbols (all message labels are
# avilable as symbols too).  Output is produced by expanding symbols
# in a template file. Template files are located in "etc/<language>" or
# "etc".
#
# Output from procs that do not take any names (e.g. form and menu
# items), are stored in the symbol BODY
#
# Default templates are "menu.tmpl", "form.tmpl" and "run.tmpl"
# Change by using the TEMPLATE proc.
#
# IMPORTANT: When inserting text output into forms (best avoided), try
#	make the output appear before the related input fields, to
#	make it easy to implement a dumb-terminal scrolling text-interface.
#
#
# NAME name		Required. Form elements will have message labels
#			composed of <name>_<form-element-name>, and will
#			have @PUBLIC@/help/<lang>/<name>.html as default
#			helpfile
#
# TEMPLATE file		Select a different template file
#			from the etc/lang or etc directory.
# 
# HELPFILE file		Select a different helpfile (under the
#			@PUBLIC@/help/<lang> directory)
#
# INIT { code }		Optional
#
# FORM { code } ?altpath?
#			Forms only. Alternative path for action is
#			best avioded.
#
# RUN  { code }		Submitted forms / Command files
#			Note: One may break out of a RUN body using
#			"return".
#
# MENU { code }		(No FORM, No RUN) Menu only
#
#
# NAME, INIT, { FORM/MENU }, RUN must be in that order!
#
#
# ITEM "PUBLIC"/"PRIVATE"/"LANG" label ref ?disabled?
#					Reference relative to server public
#					or private root.
#					"LANG"  is relative to public/<lang>
#
# REISSUE_FORM	?init?			RUN only. Re-issue above FORM.
#					If init is true, run the INIT part
#					as well
#
# NEW_FORM form ?args? ?save?		RUN only. Issue another form.
#					Args to form are optional, as
#					are list of SET/SAVEd values
#					to pass along as saved (hidden) fields.
#
# NOOUTPUT				RUN only. Produce no output.
#
# GETARGS a b c ...			Get arguments to command, if any.
#					Assign to named variables.
#
# SET name value			Set a value in INIT, for use in FORM
#					or RUN (will become default values)
#
# GET default-value name name ...	Get named values from posted form, or
#					as set with SET. Missing values are
#					initialised to default-value
#
# SAVE name value			FORM only. As SET, but also saves
#					values in a returned form, for
#					reading when it is submitted (as hidden
#					fields)
#
# TEXT label ?arrayvar? ?flags?		Output the text given by label.
#					Occurences of @names@ in text will  be
#					filled in from the supplied array
#					Flags: "c" compact. "h" - subheading.
#
# CHECKBOX name				FORM only. Output a checkbox.
#
# RADIO name {value label ...} ?val?	FORM:  a group of radiobuttons,
#					with values and labels... With
#					val != 0, show values directly.
#
# MENUBUTTON name {value label ...} ?values_only?
#					FORM: as radio, but menubutton 
#
# PICKBOX MULTI/SINGLE name {value label ...} ?values_only? ?size? ?raw?
#					FORM: pickbox, single/multiple picks,
#
# LINE name ?max?			FORM: Input a line of text, optional
#					max-length. With a negative length,
#					the field becomes read-only.
#
# BUTTONS button button ...		FORM: Set the list of buttons to
#					supply the form with. Default is
#					"reset" and "submit"
#
# OUT_DATA name data			Associate @name@ in template with
#					data.
# OUT_LABEL name label ?arrayvar?	Ditto with a message label, and fill
#					data from the array, as done in TEXT
#
# OUT_TABLE START name L R R L ...	Begin a table (end up in @name@)
# OUT_TABLE DATA iten item item...	Data for one row 
# OUT_TABLE END				End table
#
# CONFIRM variable label data		See proc description
#
# ERROR ?text_label? ?title_label? ?array_var?
#					Utility: Send error page, with optional
#					title label, text label and data to
#					insert.
#
# DONE ?text_label? ?title_label? ?array_var?
#					Ditto for "operation complete" pages.
#

# Required name of form/command file
proc NAME {name} {
    global FORM_INFO MSG SERV_INFO

    set FORM_INFO(name) $name
    set FORM_INFO(type) {}
    MSG_INFO HELP  $SERV_INFO(base)/public/$SERV_INFO(lang)/help/${name}.html
    MSG_INFO TITLE $MSG($FORM_INFO(name)_TITLE)
}

# Optional start of form
proc INIT {body} {
    global FORM_INFO MSG

    if $FORM_INFO(post) return
    set FORM_INFO(init_body) $body
    @ run $body
    if ${?} {
	debug 3 "INIT failed"
	MSG_INFO INFO "INIT failed: ${@}"
	ERRORPAGE 500 {}
    }
}

# Form body
proc FORM {body {altpath {}}} {
    global FORM_INFO MSG_INFO MSG SERV_INFO MSG FORM_VALUES REF

    if $FORM_INFO(stop) return
    if $FORM_INFO(post) {
	set FORM_INFO(form_body) $body
	return
    }
    set FORM_INFO(type) form
    if [string length $altpath] {
	set p $SERV_INFO(base)/$SERV_INFO(magic)/$altpath
    } else {
	set p $SERV_INFO(uri)
    }
    OUT "<form method=\"post\" action=\"[html -- $p]\">"
    foreach n $FORM_INFO(auto_save) {
	set v [html -- $FORM_VALUES($n)]
	set n [html -- $n]
	OUT "<input type=hidden name=\"$n\" value=\"$v\">"
    }
    OUT "<table>"
    @ run $body
    if ${?} {
	debug 3 "FORM failed"
	MSG_INFO INFO "FORM failed: ${@}"
	ERRORPAGE 500 internal
    } else {
	OUT "</table>"
	OUT "<hr>"
	foreach b $FORM_INFO(buttons) {
	    if [string compare $b reset] {
		set type submit
	    } else {
		set type reset
	    }
	    set v [html -- $MSG($FORM_INFO(name)_$b)]
	    set b [html -- $b]
	    OUT "<input type=$type name=\"$b\" value=\"$v\">"
	}
	if {[info exists REF($REF(last)->$SERV_INFO(path))] \
		|| ![info exists REF($FORM_INFO(name)<-)]} {
	    set REF($FORM_INFO(name)<-) $REF(last)
	    set REF($FORM_INFO(name)<-uri) $REF(uri)
	}
	SAVE _last_menu_name $REF($FORM_INFO(name)<-)
	SAVE _last_menu $REF($FORM_INFO(name)<-uri)
	OUT "</form>"
	debug 3 "FORM ok"
    }
    set FORM_INFO(stop) 1
}

# Set the list of buttons to use. Default is "submit" and "reset"
#
proc BUTTONS {args} {
    global FORM_INFO

    set FORM_INFO(buttons) $args
}

# Menu instead of form
proc MENU {body} {
    global FORM_INFO MSG SERV_INFO REF MSG_INFO

    if $FORM_INFO(stop) return
    set FORM_INFO(type) menu
    set REF(last) $FORM_INFO(name)
    set REF(uri) $SERV_INFO(uri)
    MSG_INFO FIGURE \
	    $SERV_INFO(base)/public/$SERV_INFO(lang)/figs/$FORM_INFO(name).gif
    OUT "<menu>"
    @ run $body
    if ${?} {
	MSG_INFO INFO "MENU failed: ${@}"
	ERRORPAGE 500 {}
    } else {
	OUT "</menu>"
    }
}

# Menu item for menus, or links inside forms
proc ITEM {public label ref {disabled 0}} {
    global FORM_INFO SERV_INFO MSG REF

    set public [string toupper $public]
    if {[string compare $public "PUBLIC"] == 0} {
	set ref [html -- $SERV_INFO(base)/public/$ref]
    } elseif {[string compare $public "LANG"] == 0} {
	set ref [html -- $SERV_INFO(base)/public/$SERV_INFO(lang)/$ref]
    } else {
	if {$FORM_INFO(type) != "form"} {
	    foreach x [split $ref ?] {
		set REF($FORM_INFO(name)->$x) 1; break
	    }
	}
	set ref [html -- $SERV_INFO(base)/$SERV_INFO(magic)/$ref]
    }
    if {$FORM_INFO(type) == "form"} {
	set pre "<tr><td><td><br>\n"
    } else {
	set pre "<li>"
    }
    set label $MSG($FORM_INFO(name)_$label)
    if $disabled {
	OUT "$pre[html -- { } $label]"
    } else {
	OUT "$pre<a href=\"[html -- $ref]\"> <b>[html -- $label]</b></a>"
    }
}

# Executed when form is submitted
proc RUN {body} {
    global FORM_INFO MSG REF SERV_INFO

    if $FORM_INFO(stop) return
    set FORM_INFO(type) run
    @ run $body
    if {[info exists REF($REF(last)->$SERV_INFO(path))] \
	    || ![info exists REF($FORM_INFO(name)<-)]} {
	set REF($FORM_INFO(name)<-) $REF(last)
	set REF($FORM_INFO(name)<-uri) $REF(uri)
	SAVE _last_menu_name $REF($FORM_INFO(name)<-)
	SAVE _last_menu $REF($FORM_INFO(name)<-uri)
    }
    if ${?} {
	MSG_INFO INFO "RUN failed: ${@}"
	ERRORPAGE 500 {}
    }
}

# Re-issue form (to be called from RUN)
proc REISSUE_FORM {{init 0}} {
    global FORM_INFO

    if ![info exists FORM_INFO(form_body)] {
	return
    }
    set FORM_INFO(output) {}
    set FORM_INFO(post) 0
    if {$init && [info exists FORM_INFO(init_body)]} {
	INIT $FORM_INFO(init_body)
    }
    FORM $FORM_INFO(form_body)
}

# Run some other form, menu or command file.
# File name is relative to the private root
# Arguments are optional.
# A list of SET/SAVEd values to keep can be supplied, these will be
# available in the new form.
#
proc NEW_FORM {file {arguments {}} {save {}}} {
    global SERV_INFO FORM_INFO FORM_VALUES

    set x(0) 0; unset x(0)
    set dosave 0
    if [string length $save] {
	foreach n $save {
	    if [info exists FORM_VALUES($n)] {
		set x($n) $FORM_VALUES($n)
	    }
	}
	set dosave 1
    }
    init_request GET /$SERV_INFO(magic)/$file $arguments
    if $dosave {
	foreach n [array names x] {
	    set FORM_VALUES($n) $x($n)
	}
	set FORM_INFO(auto_save) $save
    }
    run_request
    set FORM_INFO(abort) 1
}

# Select help file, other than the default
proc HELPFILE {file} {
    global MSG_INFO

    MSG_INFO HELP  $SERV_INFO(base)/public/$SERV_INFO(lang)/help/$file
}

# Set template file to use for output
proc TEMPLATE {file} {
    global FORM_INFO

    set FORM_INFO(template) $file
}

# Skip output
proc NOOUTPUT {} {
    global FORM_INFO

    set FORM_INFO(nooutput) 1
}

# Get arguments to form or command, if any
proc GETARGS {args} {
    global FORM_VALUES MSG FORM_INFO

    foreach name $args arg $FORM_INFO(args) {
	if ![string length $name] break
	set value {}
	if [string length $arg] {
	    set value $arg
	}
	uplevel [list set $name $value]
	set FORM_VALUES($name) $value
    }
}

# Set a value for use in the form
proc SET {name value} {
    global FORM_VALUES MSG

    uplevel [list set $name $value]
    set FORM_VALUES($name) $value
}

# Save a value from FORM to RUN (i.e. hidden field)
proc SAVE {name value} {
    global FORM_VALUES

    uplevel [list set $name $value]
    set FORM_VALUES($name) $value
    set name [html -- $name]
    set value [html -- $value]
    OUT "<input type=hidden name=\"$name\" value=\"$value\">"
}

# Get some values from the form, or force them into existence with
# a default value
#
proc GET {default args} {
    global FORM_VALUES MSG

    foreach name $args {
	set value $default
	if [info exists FORM_VALUES($name)] {
	    set value $FORM_VALUES($name)
	}
	uplevel [list set $name $value]
    }
}

# Just some plain text, with the possibility to use @labels@ from
# a supplied array. Added to the form body.
#
proc TEXT {label {arrayvar {}} {flags {}}} {
    global FORM_INFO MSG
    
    set x1 {}
    set x2 {}
    if ![string match *c* $flags] {
	set x1 {<p>}
	set x2 {<p>}
    }
    if [string match *h* $flags] {
	set x1 {<h2>}
	set x2 {</h2>}
    }
    set form 0
    set s $MSG($FORM_INFO(name)_$label)
    if [string length $arrayvar] {
	upvar $arrayvar a

	set s [descsubst $s a]
    }
    if {$FORM_INFO(type) == "form"} {
	OUT "<tr><td><td><br>"
    }
    OUT "$x1[html -- $s]$x2"
}

# Checkboxes.
#
proc CHECKBOX {name} {
    global FORM_INFO FORM_VALUES MSG

    set c {}
    if [info exists FORM_VALUES($name)] {
	if [string compare $FORM_VALUES($name) 1] {
	    set FORM_VALUES($name) 0
	}
	if $FORM_VALUES($name) {
	    set c checked
	}
    }
    set form $FORM_INFO(name)
    set label [html -- $MSG(${form}_$name)]
    OUT "<tr>"
    OUT "<td>$label"
    OUT "<td><input type=checkbox $c name=\"[html -- $name]\" value=1><br>"
}

# Radiobuttons. Values are alternating values and labels.
# Labels for items are first looked for as <form-name>_<label>, then
# as <label>
#
proc RADIO {name values_and_labels {values_only 0}} {
    global FORM_INFO FORM_VALUES MSG

    set checked {}
    if [info exists FORM_VALUES($name)] {
	set checked $FORM_VALUES($name)
    }
    set form $FORM_INFO(name)
    set label "[html -- $MSG(${form}_$name)]<br>"
    set name [html -- $name]
    set c {}
    if $values_only {
	set vars v
    } else {
	set vars {v l}
    }
    set vars 
    foreach $vars $values_and_labels {
	if {[string compare $checked $v] == 0} {
	    set c "checked"
	}
	if $values_only {
	    set l $v
	} else {
	    if [info exists MSG(${form}_$l)] {
		set l $MSG(${form}_$l)
	    } else {
		set l $MSG($l)
	    }
	}
	OUT "<tr>"
	OUT "<td>$label"
	OUT "<td><input type=radio name=\"$name\" $c value=\"[html -- $v]\">"
	OUT "[html -- $l]<br>"
	set label {}
	set c {}
    }
}

# Input line. Optional max length (otherwise use som earbitrary default
# presentation length, and unlimited input length.
#
# A negative length turns the field into "read-only" mode, i.e. just
# presenting a known fact.
#
proc LINE {name {max 0}} {
    global FORM_INFO FORM_VALUES MSG

    set default {}
    if [info exists FORM_VALUES($name)] {
	set v [html -- $FORM_VALUES($name)]
    } else {
	set v {}
    }
    set default "value=\"$v\""
    set maxlength {}
    set size "size=32"
    if {$max > 0} {
	set maxlength $max
	if {$max < 32} {
	    set size "size=\"$max\""
	}
	set maxlength "maxlength=\"$max\""
    }
    set form $FORM_INFO(name)
    set label [html -- $MSG(${form}_$name)]
    set name [html -- $name]
    OUT "<tr>\n<td>$label"
    OUT "<td>"
    if {$max < 0} {
	OUT "<b>$v</b>"
    } else {
	OUT "<input name=\"$name\" $size $maxlength $default>"
    }
    OUT "<br>"
}

# Menubutton. Values are alternating values and labels
# Labels for items are first looked for as <form-name>_<label>, then
# as <label>
#
proc MENUBUTTON {name values_and_labels {values_only 0}} {
    global FORM_INFO FORM_VALUES MSG

    set selected {}
    if [info exists FORM_VALUES($name)] {
	set selected $FORM_VALUES($name)
    }
    set form $FORM_INFO(name)
    set label "[html -- $MSG(${form}_$name)]<br>"
    set name [html -- $name]
    set c {}
    OUT "<tr><td>$label"
    OUT "<td>"
    OUT "<select size=1 name=\"$name\">"
    if $values_only {
	set vars v
    } else {
	set vars {v l}
    }
    foreach $vars $values_and_labels {
	if {[string compare $selected $v] == 0} {
	    set c "selected"
	}
	if $values_only {
	    set l $v
	} else {
	    if [info exists MSG(${form}_$l)] {
		set l $MSG(${form}_$l)
	    } else {
		set l $MSG($l)
	    }
	}
	OUT " <option $c value=\"[html -- $v]\"> [html -- $l]"
	set c {}
    }
    OUT "</select><br>"
}

# Pickbox. Values are alternating values and labels.
# The multi argument can be "MULTI" and "SINGLE".
#
# Labels for items are first looked for as <form-name>_<label>, then
# as <label>
#
proc PICKBOX {multi name values_and_labels {values_only 0} {size 0} {raw 0}} {
    global FORM_INFO FORM_VALUES MSG

    if {$size <= 0} {
	set size 6
    }
    if [info exists FORM_VALUES($name)] {
	set list $FORM_VALUES($name)
    } else {
	set list {}
    }
    if {[string compare $multi MULTI] == 0} {
	set multi "multiple"
    } else {
	set multi {}
    }
    set form $FORM_INFO(name)
    set label "[html -- $MSG(${form}_$name)]<br>"
    set name [html -- $name]
    set c {}
    OUT "<tr valign=top><td>$label"
    OUT "<td>"
    OUT "<select size=$size name=\"$name\" $multi>"
    if $values_only {
	set vars v
    } else {
	set vars {v l}
    }
    foreach $vars $values_and_labels {
	if {[lsearch $list $v] > -1} {
	    set c "selected"
	}
	if $values_only {
	    set l $v
	} else {
	    if !$raw {
		if [info exists MSG(${form}_$l)] {
		    set l $MSG(${form}_$l)
		} else {
		    set l $MSG($l)
		}
	    }
	}
	OUT " <option $c value=\"[html -- $v]\"> [html -- $l]"
	set c {}
    }
    OUT "</select><br>"
}

# Issue a confirm form and come back, with variable set to 1.
# Output label as formatted text, allowing insertion of any
# other labels, including anything defined with OUT_LABEL or
# or OUT_DATA.
# 
# data, if zero-length, will become pre-formatted data.
#
# If there is a <form_name>_CONFIRM_TITLE label, it will be
# used as title, otherwise the old <formname>_TITLE is used.
#
# Confusing? Try it.
#
proc CONFIRM {variable label data} {
    global FORM_INFO FORM_VALUES MSG_INFO MSG

    set FORM_INFO(output) {}
    set FORM_INFO(post) 0
    set form "global MSG_INFO\nTEMPLATE confirm.tmpl\n"
    catch {unset MSG_INFO(TEXT)}
    catch {unset MSG_INFO(DATA)}
    if [string length $label] {
	append form "OUT_LABEL TEXT $label MSG_INFO\n"
    }
    if [string length $data] {
	append form "OUT_DATA DATA [list $data]\n"
    }
    foreach n [array names FORM_VALUES] {
	if ![string match _last_menu* $n] {
	    append form "SAVE $n [list $FORM_VALUES($n)]\n"
	}
    }
    append form "BUTTONS CONFIRM\n"
    append form "SAVE $variable 1\n"

    if [info exists MSG($FORM_INFO(name)_CONFIRM_TITLE)] {
	MSG_INFO TITLE $MSG($FORM_INFO(name)_CONFIRM_TITLE)
    }
    FORM $form
}

# Simple error-page dispatcher. Call it and return.
#
proc ERROR {{body {}} {title {}} {arrayvar {}}} {
    global SERV_INFO

    TEMPLATE error.tmpl

    if [string length $title] {
	OUT_LABEL TITLE $title
    } else {
	OUT_LABEL TITLE error_default_title
    }
    if [string length $body] {
	if [string length $arrayvar] {
	    upvar $arrayvar a
	}
	OUT_LABEL TEXT $body a
    } else {
	OUT_LABEL TEXT done_default_text
    }
}
# Cal it and return.
#
proc DONE {{body {}} {title {}} {arrayvar {}}} {
    global SERV_INFO

    TEMPLATE ok.tmpl

    if [string length $title] {
	OUT_LABEL TITLE $title
    } else {
	OUT_LABEL TITLE done_default_title
    }
    if [string length $body] {
	if [string length $arrayvar] {
	    upvar $arrayvar a
	}
	OUT_LABEL TEXT $body a
    } else {
	OUT_LABEL TEXT done_default_text
    }
}


#======================================================================
# Included file "output.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"output.tcl\""}
#
# @(#)$Id: output.tcl,v 1.4 1996/09/12 02:13:07 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# Output-generating procedures. All strings used for output
# should be stored in the OUT array (by label)
#

# Append a line to output
proc OUT {s} {
    global FORM_INFO

    append FORM_INFO(output) $s
    append FORM_INFO(output) "\n"
}

# Send collected output to client. If FORM_INFO(type) is non-empty,
# use it as a template, otherwise send as-is.
#
proc OUT_FLUSH {} {
    global SERV_INFO FORM_INFO MSG MSG_INFO FORM_VALUES

    if $FORM_INFO(nooutput) {
	http reply 204
	http close
	return
    }
    set s $FORM_INFO(output)
    set FORM_INFO(output) {}
    set template $FORM_INFO(template)
    if ![string length $template] {
	set template $FORM_INFO(type).tmpl
    }
    if [info exists FORM_VALUES(_last_menu)] {
	set MSG_INFO(LAST_MENU) [html -- $FORM_VALUES(_last_menu)]
	set MSG_INFO(LAST_MENU_NAME) \
		[html -- $MSG($FORM_VALUES(_last_menu_name)_TITLE)]
    } else {
	set MSG_INFO(LAST_MENU) [html -- $SERV_INFO(startpage)]
	set MSG_INFO(LAST_MENU_NAME) [html -- $MSG(STARTPAGE_TITLE)]
    }
    if [string length $template] {
	set MSG_INFO(BODY) $s
	OUT_PAGE $template
    } else {
	http reply 200
	http write $s
	http close
    }
}

# Send a page to the client.
# The page is subject to @-substitution.
#
proc OUT_PAGE {filename} {
    global SERV_INFO FORM_INFO MSG_INFO

    set f [etc_filename $filename]
    @ open $f "r"
    if ${?} {
	MSG_INFO FILE $f
	ERRORPAGE 500 missing
	return
    }
    set f ${@}
    set s [read $f]
    close $f
    set s [descsubst $s MSG_INFO]
    http reply 200
#    http field Pragma no-cache
    http write $s
    http close
}

# Look for a file in the etc/language or etc directory under the server
# root.
#
proc etc_filename {name} {
    global SERV_INFO

    foreach f [list etc/$SERV_INFO(lang)/$name etc/$name] {
	if [file exists $SERV_INFO(root)/$f] break
    }
    return $SERV_INFO(root)/$f
}

# For use in forms etc
proc OUT_DATA {name data} {
    global MSG_INFO

    set MSG_INFO($name) [html -- $data]
}

proc OUT_LABEL {name label {arrayvar a}} {
    global MSG_INFO MSG

    set s $MSG($label)
    if [string length $arrayvar] {
	upvar $arrayvar a
	
	set s [descsubst $s a]
    }
    set MSG_INFO($name) [html -- $s]
}

# Produce table output. Op should be one of "start" "end" and "data"
# START name -> additional args are L or R for left/right-justified data.
# END        -> no additional args
# DATA       -> items for one row.
#
proc OUT_TABLE {op args} {
    global SERV_INFO OUTTAB MSG_INFO

    set tables [expr !$SERV_INFO(notables)]
    switch $op {
	START {
	    set OUTTAB(name) [lindex $args 0]
	    set OUTTAB(out) {}
	    set OUTTAB(list) {}
	    set OUTTAB(max) {}
	    set OUTTAB(fmt) [join [lrange $args 1 end]]
	    if $tables {
		append OUTTAB(out) "<table>\n"
	    }
	}
	DATA {
	    if $tables {
		append OUTTAB(out) "<tr>\n"
	    } else {
		lappend OUTTAB(list) $args
	    }
	    set oldmax $OUTTAB(max)
	    set OUTTAB(max) {}
	    foreach fmt $OUTTAB(fmt) item $args max $oldmax {
		if {[string length $fmt] == 0} break
		if $tables {
		    if {"$fmt" == "R"} {
			set a right
		    } else {
			set a left
		    }
		    append OUTTAB(out) "  <td align=$a>[html -- $item]\n"
		} else {
		    set len [string length $item]
		    if {"$max" == ""} {
			set max 0
		    }
		    lappend OUTTAB(max) [expr $max > $len ? $max : $len]
		}
	    }
	}
	END {
	    if $tables {
		append OUTTAB(out) "</table>\n"
	    } else {
		set pad {}
		set fmt {}
		foreach f $OUTTAB(fmt) max $OUTTAB(max) {
		    set sign "-"
		    if {"$f" == "R"} {
			set sign {}
		    }
		    append fmt " %${sign}${max}s"
		    lappend pad {}
		}
		set fmt [string range $fmt 1 end]
		append OUTTAB(out) "<pre>"
		foreach line $OUTTAB(list) {
		    append OUTTAB(out) \
			    [html -- [eval format {$fmt} $line $pad]]
		}
		append OUTTAB(out) "</pre>\n"
		set OUTTAB(list) {}
	    }
	    set MSG_INFO($OUTTAB(name)) $OUTTAB(out)
	    set OUTTAB(out) {}
	}
    }
}
    


#======================================================================
# Included file "request.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"request.tcl\""}
#
# @(#)$Id: request.tcl,v 1.5 1996/09/12 02:13:08 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#

proc init_request {method path arguments} {
    global SERV_INFO FORM_INFO MSG_INFO FORM_VALUES

    debug 3 "init_request $method $path $arguments"
    if [string match /public/* $path] {
	set SERV_INFO(public) 1
	set SERV_INFO(path) [string range $path 1 end]
    } else {
	set SERV_INFO(public) 0
	set SERV_INFO(path) [string range $path $SERV_INFO(magic_skip) end]
    }
    set SERV_INFO(method) $method
    set SERV_INFO(uri) $SERV_INFO(base)/$path
    if [string length $arguments] {
	append SERV_INFO(uri) ?[join $arguments +]
    }

    set FORM_INFO(public) $SERV_INFO(public)
    set FORM_INFO(path)	  $SERV_INFO(path)
    set FORM_INFO(template) {}
    set FORM_INFO(post) [expr ![string compare $method POST]]
    set FORM_INFO(type) {}
    set FORM_INFO(args) $arguments
    set FORM_INFO(abort) 0
    set FORM_INFO(stop)  0
    set FORM_INFO(nooutput) 0
    set FORM_INFO(output) {}
    set FORM_INFO(buttons) {submit reset}
    set FORM_INFO(auto_save) {}
    catch {unset FORM_INFO(form_body)}
    catch {unset FORM_INFO(init_body)}

    foreach n $SERV_INFO(auto_clear) {
	catch {unset MSG_INFO($n)}
    }
    set MSG_INFO(PATH)	[html -- $path]

    catch {unset FORM_VALUES}
}

# Receive a request for a file to run.
#
proc run_request {{do_debug 0}} {
    global SERV_INFO FORM_INFO FORM_VALUES
    
    debug 3 "run_request"
    @ open $SERV_INFO(root)/$SERV_INFO(path) "r"
    if ${?} {
	ERRORPAGE 404 notfound
	return
    }
    if $FORM_INFO(post) {
	http form FORM_VALUES
	if $do_debug {
	    foreach n [array names FORM_VALUES] {
		debug 1 "> $n = <$FORM_VALUES($n)>"
	    }
	}
    }
    set f ${@}
    set s [read $f]
    close $f
    @ run $s
    if $FORM_INFO(abort) return
    if ${?} {
	debug 2 "request failed: ${@}"
	if $FORM_INFO(abort) return
	MSG_INFO INFO "File \"$SERV_INFO(path)\" failed: ${@}"
	ERRORPAGE 500 internal
    } else {
	OUT_FLUSH
    }
}


#======================================================================
# Included file "messages.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"messages.tcl\""}
#
# @(#)$Id: messages.tcl,v 1.5 1996/09/12 02:13:06 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# Message file handling. Loads all *.msg files from the etc/<language>
# directory.
#
# Message files should look like TCL lists with alternating labels and
# strings: most conveniently written as:
#
# label_1	{string}
# label_2	{another string}
#
# Strings may contain newlines. Escape any occurences of {} with \.
# (Though any TCL-string will do).
#
# Labels may refer to other labels, by writing their strings as
# $$labelname
#
# Lines starting with a "#" are treated as comments, and are removed.
# Whitespace is trimmed from the start and end of lines.
#
# NOTE: There are procs that allow storing all sorts of temporary data
# as message labels.  To save the namespace from total chaos, try to
# stick to these conventions:
#
# Anything with underscores:		*_*	  permanent
# All uppercase				BODY,TEXT special, used in templates
# All lower case, no underscores	foo, x	  temporaries
#
# Forms and menus automatically use labels with underscores.
#


# Make sure references to undefined message labels show up
# as <label> instead of causing errors. But first make sure it
# is an array!
#
set MSG(x) {}; unset MSG(x)
trace_undefined_array MSG

# Load messages from all etc/<language>/*.msg files (sorted alphabetically),
# and export them all to the MSG_INFO array (in html-ified format)
#
proc load_messages {} {
    global SERV_INFO MSG MSG_INFO

    debug 1 "loading messages"
    set d $SERV_INFO(root)/etc/$SERV_INFO(lang)
    foreach file [lsort -ascii [glob -nocomplain $d/*.msg]] {
	@ open $file
	if ${?} {
	    debug 1 "could not open $file"
	} else {
	    set f ${@}
	    @ filearray $f MSG 1
	    if ${?} {
		debug 1 "trouble loading $file"
	    } else {
		debug 2 "message file: $file"
	    }
	}
    }
    message_array_xref MSG
    foreach n [array names MSG] {
	set MSG_INFO($n) [html -- $MSG($n)]
    }
}

# Sort out any refernces of labels
#
proc message_array_xref {arrayname} {
    upvar $arrayname a

    foreach n [array names a] {
	if {[string compare [string range $a($n) 0 1] {$$}] == 0} {
	    set s [string range $a($n) 2 end]
	    if [info exists a($s)] {
		set s $a($s)
	    } else {
		set s {}
	    }
	    set a($n) $s
	}
    }
}

# Set a value in the MSG_INFO array.
# All values are stored in html format.
#
proc MSG_INFO {name string} {
    global MSG_INFO

    set MSG_INFO($name) [html -- $string]
}

# Get a message, by label
#
proc MSG_GET {label} {
    global MSG

    return $MSG($label)
}


#======================================================================
# Included file "error.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"error.tcl\""}
#
# @(#)$Id: error.tcl,v 1.3 1996/09/12 02:13:02 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#

proc ERRORPAGE {code page} {
    global SERV_INFO MSG_INFO FORM_INFO errorInfo errorMessage

    set p {}
    if !$code {
	set code [http info code]
	switch $code {
	    500 {
		set p internal
	    }
	    400 {
		set p badreq
	    }
	    408 {
		set p timeout
	    }
	}
	@ http reply $code
    }
    if ![string length $page] {
	set page $p
	if ![string length $p] {
	    set page internal
	}
    }
    if ![info exists errorInfo] {
	set errorInfo {}
    }
    if ![info exists errorMessage] {
	set errorMessage {}
    }
    MSG_INFO errorInfo $errorInfo
    MSG_INFO errorMessage $errorMessage
    MSG_INFO httpErrorCode $code
    MSG_INFO httpErrorReason [http info reason]
    set filename [etc_filename err-$page.html]
    @ open $filename r
    if ${?} {
	set s "<h1>Error $code [html -- [http info reason]]</h1><hr>"
	append s "<p>No information available"
	debug 1 "errorpage \"$page\" not found"
    } else {
	set f ${@}
	set s [read $f]
	close $f
	set s [descsubst $s MSG_INFO]
    }
    http write $s
    http close
    set FORM_INFO(stop) 1
    set FORM_INFO(abort) 1
}


#======================================================================
# Included file "handlers.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"handlers.tcl\""}
#
# @(#)$Id: handlers.tcl,v 1.4 1996/09/12 02:13:04 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#

# Filters

if {$debug_level > 1} {
    http handler -filter * {
	set s {}
	if {[http info major] > 0} {
	    set s " HTTP/[http info major].[http info minor]"
	}
	debug 1 "[http info method] [http info path]$s"
	foreach f [http info fields] {
	    debug 1 "$f: [http info $f]"
	}
	debug 1 ""
    }
}

if $SERV_INFO(localonly) {
    http handler -filter * {
	if {[string compare [http info peer] local] != 0} {
	    ERRORPAGE 403 remote
	}
    }
}

http handler -filter * {
    set path [http info path]

    init_request [http info method] [http info path] [http args]
    set forms [string match /$SERV_INFO(magic)/forms/* $path]
    if {!$SERV_INFO(public) && !$forms} {
	ERRORPAGE 403 forbidden
    }
}

# Handlers

if {$debug_level > 1} {
    set verbose 1
} else {
    set verbose 0
}

foreach ext {form run} {
    http handler -path /$SERV_INFO(magic)/forms/*.$ext POST \
	    "run_request $verbose"
}
foreach ext {form run menu} {
    http handler -path /$SERV_INFO(magic)/forms/*.$ext GET \
	    "run_request $verbose"
}

http handler GET {
    set type "application/octet-stream"
    foreach {wild t} $SERV_INFO(filetypes) {
	if [string match $wild $SERV_INFO(path)] {
	    set type $t
	    break
	}
    }
    http reply 200
    if [catch {http file $type $SERV_INFO(root)/$SERV_INFO(path)}] {
	ERRORPAGE 404 notfound
    }
}

# Create default handler for anything else we won't handle.
#
http handler * {
    http reply 405
    http field Allow "GET POST"
    ERRORPAGE 0 denied
}

# Add error handler for errors detected by the server.
http error {
    set errorInfo [http info errorInfo]
    set errorMessage [http info errorMessage]
    ERRORPAGE 0 {}
}

# Default reply header fields
#
set_default SERV_INFO(server_id) "HttpSrv/1.0"
http field -default Server $SERV_INFO(server_id)


#======================================================================
# Included file "client.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"client.tcl\""}
#
# @(#)$Id: client.tcl,v 1.9 1996/09/12 22:24:00 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# Functions to set up a start page and start a browser.
#

proc default_startpage {{force 0}} {
    global SERV_INFO REF

    if ![string match /* $SERV_INFO(startfile)] {
	set SERV_INFO(startfile) [pwd]/$SERV_INFO(startfile)
    }
    if {$force || ![info exists SERV_INFO(startpage)]} {
	set SERV_INFO(startpage) file:$SERV_INFO(startfile)
    }
    if {$force || ![info exists SERV_INFO(start_page_template)]} {
	set SERV_INFO(start_page_template) start
    }
    set REF(last) STARTPAGE
    set REF(uri) $SERV_INFO(startpage)
    return $SERV_INFO(startpage)
}

proc generate_startpage {} {
    global SERV_INFO

    set f $SERV_INFO(root)/etc/$SERV_INFO(lang)/
    append f $SERV_INFO(start_page_template)-page.tmpl
    @ do_generate_startpage $f $SERV_INFO(startfile)
    if ${?} {
	return 1
    }
    return ${@}
}

# Use src as template and store in dest. Return 0 if ok, !0 if not.
#
proc do_generate_startpage {src dest} {
    global MSG_INFO

    @ open $src
    if ${?} {
	puts stderr "cannot open $src for reading: ${@}"
	return 1
    }
    set f ${@}
    set s [read $f]
    @ close $f
    @ exec rm -f $dest
    @ open $dest {WRONLY EXCL CREAT} 0600
    if ${?} {
	puts stderr "cannot create $dest: ${@}"
	return 1
    }
    set f ${@}
    set s [descsubst $s MSG_INFO]
    puts $f $s
    close $f
    debug 1 "created startpage $dest"
    return 0
}

# Start client program with a starturi, and arrange for server to
# exit when client does, as well as removing the file.
#
# There is no 100% sure way of making the cache directories
# unreadable for group & others, but at least make a try.
#
proc start_client {client file {uri {}}} {
    global SERV_INFO

    if ![string length $uri] {
	set uri file:$file
    }
    foreach wild $SERV_INFO(client_cache_dirs) {
	foreach dir [glob -nocomplain $wild] {
	    if [file isdirectory $dir] {
		@ exec chmod 0700 $dir > /dev/null 2> /dev/null
	    }
	}
    }
    umask 077 {@ exec $client $uri &}
    if ${?} {
	puts stderr "cannot start client $client: ${@}"
	exit 1
    }
    http watchpid ${@} "@ exec rm -f $file; debug 1 {client done}; exit"
    set SERV_INFO(client_pid) ${@}
    debug 1 "started $client $uri"
}

# Sighup client...
#
proc stop_client {} {
    global SERV_INFO

    if [info exists SERV_INFO(client_pid)] {
	@ exec kill -1 $SERV_INFO(client_pid)
    }
}





#======================================================================
# Included file "run.tcl"
#======================================================================
if $showfiles {puts stderr "file: \"run.tcl\""}
#
# @(#)$Id: run.tcl,v 1.9 1996/09/12 02:13:08 mikko Exp $
# -*- tcl -*-
#
# Copyright 1996 Dynamic Software AB
# This is unpublished proprietary source code.
#
# Final initialisation and server startup
#

if {$SERV_INFO(run) == "http"} {
    if ![info exists SERV_INFO(port)] {
	set SERV_INFO(port) [http port]
    } else {
	http port $SERV_INFO(port)
    }
} else {
    set SERV_INFO(port) {}
}
set_default SERV_INFO(address) 127.0.0.1
if ![info exists SERV_INFO(magic)] {
    # Need to generate a *real* magic cookie here!
    set SERV_INFO(magic) [clock clicks]
}
set SERV_INFO(base) "http://$SERV_INFO(address):$SERV_INFO(port)"
set SERV_INFO(magic_skip) [string length "/$SERV_INFO(magic)/"]
set_default SERV_INFO(filetypes) {
    *.html      text/html
    *.txt       text/plain
    *.tcl	text/plain
    *.gif       image/gif
    *.jpg       image/jpeg
    *           application/octet-stream
}
set_default SERV_INFO(lang) eng

set_default SERV_INFO(auto_clear) {
    INTRO TEXT BODY DATA TITLE HELP COMMENT
}

load_messages

set_default SERV_INFO(startfile) /tmp/.[pid].html
default_startpage

MSG_INFO BASEURI $SERV_INFO(base)
MSG_INFO SERVER_ID $SERV_INFO(server_id)
MSG_INFO PUBLIC	 $SERV_INFO(base)/public
MSG_INFO PRIVATE $SERV_INFO(base)/$SERV_INFO(magic)
MSG_INFO LANGURI $SERV_INFO(base)/public/$SERV_INFO(lang)
MSG_INFO LANG    $SERV_INFO(lang)
MSG_INFO STARTPAGE $SERV_INFO(startpage)

if $SERV_INFO(tracing) {
    set s {}
    if [string length $SERV_INFO(tracefile)] {
	set s "-file [list $SERV_INFO(tracefile)]"
    }
    eval proctrace -all -args $s
}

if {$SERV_INFO(run) == "http"} {
    @ generate_startpage
    if ${@} {
	exit 1
    }
    debug 1 "start page is $SERV_INFO(startpage)"
    debug 1 "listening to port $SERV_INFO(port)"
    if [string length $SERV_INFO(client)] {
	start_client $SERV_INFO(client) $SERV_INFO(startfile)
    } else {
	debug 1 "not starting a client"
    }

    # Start server main loop
    #
    http run
    # Nothing below this line will get executed
}



