/*
 * Copyright (c) 1993-1996 CheckPoint Software Technologies Ltd.
 * All Rights Reserved
 *
 * THIS IS AN UNPUBLISHED PROPRIETARY SOURCE CODE OF CHECKPOINT SOFTWARE
 * TECHNOLOGIES LTD. The copyright notice above does not evidence any actual
 * or intended publication of such source code.
 *
 * $Header: /fw/cvs/fw-1/fwlib/traps.h,v 1.23.2.4 1996/05/30 10:47:46 yoav Exp $
 */

#ifndef __traps_h__
#define __traps_h__

/*
 * Daemon traps
 */
#define	AUTH_INVOKE		0x101
#define AUTH_INTRCPT	0x102
#define	AUTH_MATCH		0x103

#define	PMAP_FETCH		0x110

#define ENCRYPT_INVOKE	0x120
#define ENCRYPT_INTRCPT	0x121

/*
 * User Encryption (GW side):
 *
 * At this stage we need only check that the destination is in the
 * encryption domain of the gateway, and if it is, add this connection
 * to the connections table (with its key). The daemon is also responsible
 * for sending the log. After completing the check, the packet, which
 * caused the invoke, will be released (regardless of the result of the
 * check). 
 */

#define USERC_SERVER_INVOKE 0x122

/*
 * User Encryption (PC side):
 *
 *    The daemon running on the PC is requested to establish a session with a
 * GW. The session key will be added to the session table. The packet which
 * caused the invoke will be relased.
 */
#define USERC_ENCRYPT_INVOKE 0x123

#define	DEBUG_TUNNEL	0x166

#define HOST_REPORT		0x170

#define TRAP_EXECUTE    0x190

#define ACCT_REPORT     0x200

#define ADD_CONN        0x210
#define DEL_CONN        0x211
#define GET_CONNS       0x212
#define CONN_UPDATE     0x213

/*
 * Kernel traps
 */
#define KFUNC_FTPPORT			0
#define KFUNC_GETNET			1
#define KFUNC_ENCRYPT			2
#define KFUNC_DECRYPT			3
#define KFUNC_CONN_EXPIRE		4
#define KFUNC_TCP_ESTABLISHED	5
#define	KFUNC_XLATE_FORW		6
#define	KFUNC_XLATE_BACKW		7
#define KFUNC_KBUF_DUP			8
#define	KFUNC_XLATE_FOLD		9
#define KFUNC_MASK_GET          10
#define KFUNC_END_ACCT_CONN     11
#define KFUNC_USERC_EXPIRE      12

#endif /* __traps_h__ */
