#ident "@(#)xomi.h	1.5 12 Feb 1996 SMI"
/*
 *
 * Copyright 12 Feb 1996 Sun Microsystems, Inc. All Rights Reserved
 * (c) Copyright 1993 Marben Produit  All rights reserved
 *
 */

#ifndef _XOMI_H
#define _XOMI_H

#include <stddef.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*-----------------------------------------------------------------**
**          Object Standard Internal Representation                **
**-----------------------------------------------------------------*/
typedef OM_descriptor OMP_object_header[2];
typedef OMP_object_header *OMP_object;


/*-----------------------------------------------------------------**
**          Workspace Standard Internal Representation             **
**-----------------------------------------------------------------*/
#if defined(__STDC__)

typedef OM_return_code (*OMP_copy)(
				   OM_private_object	/* original */,
				   OM_workspace		/* workspace */,
				   OM_private_object	* /* copy */
				   );
typedef OM_return_code (*OMP_copy_value)(
					 OM_private_object	/* source */,
					 OM_type		/* source_type */,
					 OM_value_position	/* source_value_position */,
					 OM_private_object	/* destination */,
					 OM_type		/* destination_type */,
					 OM_value_position	/* destination_value_position */
					 );
typedef OM_return_code (*OMP_create)(
				     OM_object_identifier	/* class */,
				     OM_boolean			/* initialise */,
				     OM_workspace		/* workspace */,
				     OM_private_object		* /* object */
				     );
typedef OM_return_code (*OMP_decode)(
				     OM_private_object		/* encoding */,
				     OM_private_object		* /* original */
				     );
typedef OM_return_code (*OMP_delete)(
				     OM_object	/* subject */
				     );
typedef OM_return_code (*OMP_encode)(
				     OM_private_object		/* original */,
				     OM_object_identifier	/* rules */,
				     OM_private_object		* /* encoding */
				     );
typedef OM_return_code (*OMP_get)(
				  OM_private_object	/* original */,
				  OM_exclusions		/* exclusions */,
				  OM_type_list		/* included_types */,
				  OM_boolean		/* local_strings */,
				  OM_value_position	/* initial_value */,
				  OM_value_position	/* limiting_value */,
				  OM_public_object	* /* copy */,
				  OM_value_position	* /* total_number */
				  );
typedef OM_return_code (*OMP_instance)(
				       OM_object		/* subject */,
				       OM_object_identifier	/* class */,
				       OM_boolean		* /* instance */
				       );
typedef OM_return_code (*OMP_put)(
				  OM_private_object	/* destination */,
				  OM_modification	/* modification */,
				  OM_object		/* source */,
				  OM_type_list		/* included_types */,
				  OM_value_position	/* initial_value */,
				  OM_value_position	/* limiting_value */
				  );
typedef OM_return_code (*OMP_read)(
				   OM_private_object	/* subject */,
				   OM_type		/* type */,
				   OM_value_position	/* value_position */,
				   OM_boolean		/* local_string */,
				   OM_string_length	* /* string_offset */,
				   OM_string		* /* elements */
				   );
typedef OM_return_code (*OMP_remove)(
				     OM_private_object	/* subject */,
				     OM_type		/* type */,
				     OM_value_position	/* initial_value */,
				     OM_value_position	/* limiting_value */
				     );
typedef OM_return_code (*OMP_write)(
				    OM_private_object	/* subject */,
				    OM_type		/* type */,
				    OM_value_position	/* value_position */,
				    OM_syntax		/* syntax */,
				    OM_string_length	* /* string_offset */,
				    OM_string		/* elements */
				    );

extern void	OMPexamin(OM_object, unsigned int, unsigned int);
extern void	(*OMPCustomizeOMPexamin(void (*) (char *)))(char *);
extern int	OMPipcgetfd(void);
extern OM_sint	OMPcompare(OM_object, OM_object);
extern int	OMPencodeOID(char *, unsigned int, char *);
extern int	OMPdecodeOID(char *, unsigned int, char *, unsigned int);
extern char	*OMPgetlasterror(void);

#else

typedef OM_return_code (*OMP_copy)( /*
				   OM_private_object	original,
				   OM_workspace		workspace,
				   OM_private_object	*copy
				    */ );
typedef OM_return_code (*OMP_copy_value)( /*
					 OM_private_object	source,
					 OM_type		source_type,
					 OM_value_position	source_value_position,
					 OM_private_object	destination,
					 OM_type		destination_type,
					 OM_value_position	destination_value_position
					  */ );
typedef OM_return_code (*OMP_create)( /*
				     OM_object_identifier	class,
				     OM_boolean			initialise,
				     OM_workspace		workspace,
				     OM_private_object		*object
				      */ );
typedef OM_return_code (*OMP_decode)( /*
				     OM_private_object		encoding,
				     OM_private_object		*original
				      */ );
typedef OM_return_code (*OMP_delete)( /*
				     OM_object	subject
				      */ );
typedef OM_return_code (*OMP_encode)( /*
				     OM_private_object		original,
				     OM_object_identifier	rules,
				     OM_private_object		*encoding
				      */ );
typedef OM_return_code (*OMP_get)( /*
				  OM_private_object	original,
				  OM_exclusions		exclusions,
				  OM_type_list		included_types,
				  OM_boolean		local_strings,
				  OM_value_position	initial_value,
				  OM_value_position	limiting_value,
				  OM_public_object	*copy,
				  OM_value_position	*total_number
				   */ );
typedef OM_return_code (*OMP_instance)( /*
				       OM_object		subject,
				       OM_object_identifier	class,
				       OM_boolean		*instance
				        */ );
typedef OM_return_code (*OMP_put)( /*
				  OM_private_object	destination,
				  OM_modification	modification,
				  OM_object		source,
				  OM_type_list		included_types,
				  OM_value_position	initial_value,
				  OM_value_position	limiting_value
				   */ );
typedef OM_return_code (*OMP_read)( /*
				   OM_private_object	subject,
				   OM_type		type,
				   OM_value_position	value_position,
				   OM_boolean		local_string,
				   OM_string_length	*string_offset,
				   OM_string		*elements
				    */ );
typedef OM_return_code (*OMP_remove)( /*
				     OM_private_object	subject,
				     OM_type		type,
				     OM_value_position	initial_value,
				     OM_value_position	limiting_value
				      */ );
typedef OM_return_code (*OMP_write)( /*
				    OM_private_object	subject,
				    OM_type		type,
				    OM_value_position	value_position,
				    OM_syntax		syntax,
				    OM_string_length	*string_offset,
				    OM_string		elements
				     */ );

extern void	OMPexamin(/* OM_object, unsigned int, unsigned int */);
extern void	(*OMPCustomizeOMPexamin(/* void (*) (char *) */))(/* char * */);
extern int	OMPipcgetfd(/* void */);
extern OM_sint	OMPcompare(/* OM_object, OM_object */);
extern int	OMPencodeOID(/* char *, unsigned int, char * */);
extern int	OMPdecodeOID(/* char *, unsigned int, char *, unsigned int */);
extern char	*OMPgetlasterror(/* void */);

#endif /* __STDC__ */

typedef struct OMP_functions_body {
    OM_uint32          function_number;
    OMP_copy           omp_copy;
    OMP_copy_value     omp_copy_value;
    OMP_create         omp_create;
    OMP_decode         omp_decode;
    OMP_delete         omp_delete;
    OMP_encode         omp_encode;
    OMP_get            omp_get;
    OMP_instance       omp_instance;
    OMP_put            omp_put;
    OMP_read           omp_read;
    OMP_remove         omp_remove;
    OMP_write          omp_write;
} OMP_functions;

/*
** typedef struct OMP_workspace_body {
**     struct OMP_functions_body *functions;
** } *OMP_workspace;
**/
typedef struct {
 OMP_functions *functions;
} OMP_workspace_body;

typedef OMP_workspace_body *OMP_workspace;


/*-----------------------------------------------------------------**
**               Workspace Interface Useful Macros                 **
**-----------------------------------------------------------------*/

/*
** convert an internal object pointer to external one
**/
#define OMP_EXTERNAL(internal) \
        ((OM_object)((OM_descriptor *)(internal)+1))

/*
** convert an external object pointer to internal one
**/
#define OMP_INTERNAL(external) \
        ((OM_object)((OM_descriptor *)(external)-1))

/*
** extract the type from an object's external pointer
**/
#define OMP_TYPE(external) \
        (((OM_descriptor *)(external))->type)

/*
** extract the workspace from an object's external pointer
**/
#define OMP_WORKSPACE(external) \
        ((OMP_workspace)(OMP_INTERNAL(external)->value.string.elements))

/*
** extract function jump-table from an object's external pointer
**/
#define OMP_FUNCTIONS(external) \
        (OMP_WORKSPACE(external)->functions)


/*-----------------------------------------------------------------**
**               Workspace Interface Dispatcher                    **
**-----------------------------------------------------------------*/

#define om_copy(original,workspace,destination) \
	( (workspace) == NULL ?\
	  OM_NO_SUCH_WORKSPACE :\
	  ((*(((OMP_workspace)(workspace))->functions->omp_copy))(\
		(original),(workspace),(destination))))

#define om_copy_value(source,source_type,source_pos,dest,dest_type,dest_pos) \
	( (dest) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)dest)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(dest)->omp_copy_value))(\
			(source),(source_type),(source_pos),\
			(dest),(dest_type),(dest_pos))):\
		OM_NOT_PRIVATE))

#define om_create(class,initialise,workspace,object) \
	( (workspace) == NULL ?\
	  OM_NO_SUCH_WORKSPACE :\
	  ((*(((OMP_workspace)(workspace))->functions->omp_create))(\
		(class),(initialise),(workspace),(object))))

#define om_decode(encoding,original) \
	( (encoding) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)encoding)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(encoding)->omp_decode))((encoding),(original))):\
		OM_NOT_PRIVATE))

#define om_delete(subject) \
	( (subject) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)subject)->syntax&OM_S_SERVICE_GENERATED)?\
		((*(OMP_FUNCTIONS(subject)->omp_delete))((subject))):\
		OM_NOT_THE_SERVICES))

#define om_encode(original,rules,encoding) \
	( (original) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)original)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(original)->omp_encode))((original),(rules),(encoding))):\
		OM_NOT_PRIVATE))

#define om_get(original,exclusions,types,local_strings,initial,limit,copy,total_number) \
	( (original) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)original)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(original)->omp_get))(\
			(original),(exclusions),(types),(local_strings),\
			(initial),(limit),(copy),(total_number))):\
		OM_NOT_PRIVATE))

#define om_instance(subject,class,instans) \
	( (subject) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)subject)->syntax&OM_S_SERVICE_GENERATED)?\
		((*(OMP_FUNCTIONS(subject)->omp_instance))((subject),(class),(instans))):\
		OM_NOT_THE_SERVICES))

#define om_put(dest,modification,source,incltypes,initial,limit) \
	( (dest) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)dest)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(dest)->omp_put))(\
			(dest),(modification),(source),(incltypes),(initial),(limit))):\
		OM_NOT_PRIVATE))

#define om_read(subject,type,value_pos,local_string,element_pos,elements) \
	( (subject) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)subject)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(subject)->omp_read))(\
			(subject),(type),(value_pos),(local_string),\
			(element_pos),(elements))):\
		OM_NOT_PRIVATE))

#define om_remove(subject,type,initial,limit) \
	( (subject) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)subject)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(subject)->omp_remove))(\
			(subject),(type),(initial),(limit))):\
		OM_NOT_PRIVATE))

#define om_write(subject,type,value_pos,syntx,element_pos,elements) \
	( (subject) == NULL ?\
	  OM_NO_SUCH_OBJECT :\
	  ((((OM_object)subject)->syntax&OM_S_PRIVATE)?\
		((*(OMP_FUNCTIONS(subject)->omp_write))(\
			(subject),(type),(value_pos),(syntx),\
			(element_pos),(elements))):\
		OM_NOT_PRIVATE))

#ifdef  __cplusplus
}
#endif

#endif	/* _XOMI_H */
