#ident "@(#)ex_MAdmain.c	1.10 05/07/98 SMI"
/*
 *
 * Copyright 05/07/98 Sun Microsystems, Inc. All Rights Reserved
 *
 */
/*
 * File:                ex_MAdmain.c
 *
 * contains:            main() for MA deliver example
 *
 * This example illustrates the use of the OM and MA interface functions
 * to deliver a message. A message object is obtained from the delivery
 * queue and selected information of the message is read.
 *
 * This example uses the following MA interface functions:
 *        ma_open()
 *        ma_start_delivery()
 *        ma_finish_delivery()
 *        ma_close()
 *  
 *  This example requires these files: 
 *      ex_MAdmain.c, ex_MAgetmsg.c
 *  as well as:
 *      ex_MAopen.c,  ex_read.c,
 *      ex_export.c,  ex_utils.c 
 *      example.h, ex_im_export.h, ex_import.h, ex_im_import.h,
 *  and all the header files as defined in the API specification.
 *
 *  In order to use this program, the user might need to configure
 *  certain variables (e.g., client name, recipient names), 
 *  or to modify the program appropriately.
 *  
 *  NOTE:     While this example has been compiled successfully,
 *            it has not be verified with an MA interface
 *            implementation and is not guaranteed to work.
 *            The following example is not complete.
 */
#include <stdio.h>
#include <xom.h>
#include <xmh.h>
#include <xmhp.h>
#include <ximp.h>
#include "example.h"

OM_private_object                 p1_object;  /* the message object */
extern OM_private_object          session;
extern OM_workspace               x4_workspace;
main(ac,av)    /* main routine for MA Deliver Example */
int ac;
char *av[];
{
  int                rc = 0;
  int                i = 0;
  char               client[64];
                     /* Message Attributes */
  int                priority; 
  char               msgid[254];
  char               originator[254];
  char               *recipients[11];  /* maximum 10 recipients
                                        * for this example */
  char               subject[254];
  bodypart           body[2];
 
 /* 
  * Open session
  */
	if (ac<2) {
		printf("usage, ex_MAd <clientname>\n");
		exit(1);
	}
  strcpy(client, av[1]);
  printf("Opening session, client is \"%s\"\n", client);
  rc = x4_MAopen(client);
  printf("x4_MAopen() returned -> %d\n",rc);
	if ( rc ) {
		exit(1);
	} /* end if */

 /*
  * Obtain the first message in the input queue
  */
  printf("getting a message\n");
  rc = ma_start_delivery(session, &p1_object);
  printf("ma_start_delivery() returned -> %d\n", rc);

  if ( rc != OM_SUCCESS ) cleanexit();

 /*
  * Get message identifier, originator, priority, recipients, 
  * subject and bodyparts
  */
  printf("Getting information from the message.\n");
  rc = MAgetmsg(&priority, msgid, originator, recipients, 
                        subject, body);
  printf("MAgetmsg() returned -> %d\n", rc);

  if ( rc != OM_SUCCESS ) cleanexit();
 

 /*
  * Print selected information read from the message.
  */
  printf("Priority: %d\n", priority);
  printf("Message Identifier: %s\n", msgid);
  printf("Originator: %s\n", originator);
  printf("Subject: %s\n", subject);
if(body[0].bodypart_file)
  {
        printf("BodyPart filename: %s\n", body[0].bodypart_file);
  } else {
        printf("BodyPart filename: no file\n");
  }
  printf("First Recipient Name: %s\n", recipients[0]);
  printf("First Recipient Name: %s\n", recipients[0]);

 /*
  * Complete processing and delete the current message from queue.
  */
  printf("\nFinishing with the message\n");
  rc = ma_finish_delivery(session, (OM_object) 0, (OM_object) 0);
  printf("ma_finish_delivery() returned -> %d\n",rc);
 /*
  * Close session
  */
  rc = ma_close(session);
  printf("ma_close() returned -> %d\n", rc);
}
