#!/bin/sh
#
#ident	"@(#)obp_helper.sh	1.5	95/03/24 CRS"
#
# Copyright (c) 1993 Cray Research Superservers, Inc.
#
# Startup script for obp_helper.
# An entry should be added to /etc/inittab to invoke this script ONCE only.
# The proper entry in /etc/inittab should look something like:
# 
# obp:234:once:su ssp -c /etc/opt/CYRSssp/obp_helper.sh

sspetc=/etc/opt/CYRSssp
cray_ssp_env=${sspetc}/cray_ssp_env.sh
hosts=${sspetc}/hosts

#
# make sure cray_ssp_env.sh exist
# cray_ssp_env.sh sets up environment variable for obp_helper
#
while [ ! -r ${cray_ssp_env} ]
do
	echo "obp_helper.sh: ${cray_ssp_env} does not exist.  Retry in 5 minutes." > /dev/console
	sleep 300
done
#
# source SSP package environment variables
#
. ${cray_ssp_env}

#
# make sure the hosts exist
# hosts identifies the CS6400 host name
#
while [ ! -r ${hosts} ]
do
	echo "obp_helper.sh: ${hosts} does not exist.  Retry in 5 minutes." > /dev/console
	sleep 300
done
#
# set up CRAY_HOSTNAME, search path, and library path
#
PATH=${CRAY_SSPROOT}/bin:/usr/sbin:/usr/bin
LD_LIBRARY_PATH=${CRAY_SSPROOT}/lib:/usr/openwin/lib:usr/lib:
export PATH LD_LIBRARY_PATH

#
# initiate obp_helper for each machine within the physical host.
#
for host in `awk '{print $1}' ${hosts}`
do
	CRAY_HOSTNAME=$host
	export CRAY_HOSTNAME
	obp_helper -r &
	sleep 10
done

