/* Copyright 1994 Sun Microsystems, Inc. All Rights Reserved. */
/* Copyright 1993 Sun Microsystems, Inc. All Rights Reserved. */

/**************************************************************************
 *  File:	include/netmgt_extern.h
 *
 *  Author:	Lynn Monsanto, Sun Microsystems Inc.
 *
 *  Copyright (c) 1989 Sun Microsystems, Inc.  All Rights Reserved.
 *  Sun considers its source code as an unpublished, proprietary trade 
 *  secret, and it is available only under strict license provisions.  
 *  This copyright notice is placed here only to protect Sun in the event
 *  the source is deemed a published work.  Dissassembly, decompilation, 
 *  or other means of reducing the object code to human readable form is 
 *  prohibited by the license agreement under which this code is provided
 *  to the user or company in possession of this copy.
 * 
 *  RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the 
 *  Government is subject to restrictions as set forth in subparagraph 
 *  (c)(1)(ii) of the Rights in Technical Data and Computer Software 
 *  clause at DFARS 52.227-7013 and in similar clauses in the FAR and 
 *  NASA FAR Supplement.
 *
 *  SCCSID:     @(#)netmgt_extern.h  2.13  93/06/16
 *
 *  Comments:	SunNet Manager external definitions
 *
 **************************************************************************
 */

#ifndef	_netmgt_extern_h
#define _netmgt_extern_h

/* Package public global data */
extern u_int netmgt_debug ;		/* debugging level */
extern Netmgt_error netmgt_error ;	/* error buffer */
extern Netmgt_agent_ID netmgt_agent_ID ; /* agent identification buffer */

/* package public functions with C linkage */
#if defined (__cplusplus)
extern "C" {

#ifdef SOL24HIGHER
struct  rusage {
        timestruc_t ru_utime;           /* user time used */
        timestruc_t ru_stime;           /* system time used */
        long    ru_maxrss;
#define ru_first        ru_ixrss
        long    ru_ixrss;               /* XXX: 0 */
        long    ru_idrss;               /* XXX: sum of rm_asrss */
        long    ru_isrss;               /* XXX: 0 */
        long    ru_minflt;              /* any page faults not requiring I/O */
        long    ru_majflt;              /* any page faults requiring I/O */
        long    ru_nswap;               /* swaps */
        long    ru_inblock;             /* block input operations */
        long    ru_oublock;             /* block output operations */
        long    ru_msgsnd;              /* messages sent */
        long    ru_msgrcv;              /* messages received */
        long    ru_nsignals;            /* signals received */
        long    ru_nvcsw;               /* voluntary context switches */
        long    ru_nivcsw;              /* involuntary " */
#define ru_last         ru_nivcsw
};
#endif

/* Package public manager and agent services */
bool_t netmgt_fetch_msginfo (Netmgt_msginfo *msginfo) ;

char *netmgt_getConfig(char *name);

char *netmgt_oid2string (u_int length, caddr_t value) ;

char *netmgt_oid2decodedstring (u_int length, caddr_t value, caddr_t oid_map) ;

caddr_t netmgt_get_oid_map (void) ;

struct timeval *netmgt_get_request_time (void) ;

void netmgt_set_debug (u_int level) ;

char *netmgt_sperror (void) ;

u_long *netmgt_string2oid (char *string) ;

/* Package public manager services */
struct timeval *netmgt_request_events (char *agent_host, 
				       u_long agent_prog, 
				       u_long agent_vers, 
				       char *rendez_host, 
				       u_long rendez_prog, 
				       u_long rendez_vers, 
				       u_int count, 
				       struct timeval interval, 
				       struct timeval timeout, 
				       u_int flags) ;

Netmgt_agent_ID *netmgt_request_agent_ID (char *agent_host, 
					  u_long agent_prog, 
					  u_long agent_vers, 
					  struct timeval timeout) ;

bool_t netmgt_fetch_data (Netmgt_data *data) ;

bool_t netmgt_fetch_error (Netmgt_error *error) ;

bool_t netmgt_fetch_event (Netmgt_event *event) ;

u_int netmgt_get_priority (void) ;

bool_t netmgt_kill_request (char *agent_name, 
			    u_long agent_prog, 
			    u_long agent_vers, 
			    char *manager_name, 
			    struct timeval request_time, 
			    struct timeval timeout) ;

bool_t netmgt_register_rendez (char *dispatch_host, 
			       char *rendez_host, 
			       u_long rendez_prog, 
			       u_long rendez_vers, 
			       u_long agent_prog, 
			       u_int event_priority, 
			       struct timeval timeout) ;

u_long netmgt_register_callback (void (*) (u_int type, char *system, 
					   char *group, char *key, 
					   u_int count, 
					   struct timeval interval, 
					   u_int flags), 
				 int *udpSockp, 
				 int *tcpSockp, 
				 u_long vers, 
				 u_long proto) ;

struct timeval *netmgt_request_data (char *agent_host, 
				     u_long agent_prog, 
				     u_long agent_vers, 
				     char *rendez_host, 
				     u_long rendez_prog, 
				     u_long rendez_vers, 
				     u_int count, 
				     struct timeval interval, 
				     struct timeval timeout, 
				     u_int flags) ;

bool_t netmgt_request_deferred (char *agent_name, 
				u_long agent_prog, 
				u_long agent_vers, 
				char *manager_name, 
				struct timeval request_time, 
				struct timeval timeout) ;

bool_t netmgt_request_set (char *agent_host, 
			   u_long agent_prog, 
			   u_long agent_vers, 
			   char *rendez_host,
			   u_long rendez_prog,
			   u_long rendez_vers,
			   struct timeval timeout, 
			   u_int flags) ;


struct timeval *netmgt_request_set2 (char *agent_host, 
				     u_long agent_prog, 
				     u_long agent_vers, 
				     char *rendez_host,
				     u_long rendez_prog,
				     u_long rendez_vers,
				     struct timeval timeout, 
				     u_int flags) ;


bool_t netmgt_set_argument (Netmgt_arg *arg) ;

bool_t netmgt_set_instance (char *system, char *group, char *key) ;

bool_t netmgt_set_threshold (Netmgt_thresh *thresh) ;

bool_t netmgt_set_value (Netmgt_setval *setval) ;

bool_t netmgt_unregister_callback (u_long prog, u_long vers) ;

bool_t netmgt_unregister_rendez (char *dispatch_host, 
				 char *rendez_host, 
				 u_long rendez_prog, 
				 u_long rendez_vers, 
				 u_long agent_prog, 
				 u_int event_priority, 
				 struct timeval timeout) ;

u_int netmgt_alloc_manager_id (void) ;

bool_t netmgt_set_manager_id (u_int manager_id) ;

u_int netmgt_get_manager_id (void) ;

bool_t netmgt_free_manager_id (u_int manager_id) ;

/* Package public agent services */
bool_t netmgt_build_report (Netmgt_data *data, bool_t *event) ;

bool_t netmgt_fetch_argument (char *name, Netmgt_arg *arg) ;

bool_t netmgt_fetch_setval (Netmgt_setval *setval) ;

bool_t netmgt_init_rpc_agent (char *name, 
			      u_int serial, 
			      u_long program, 
			      u_long version, 
			      u_long proto, 
			      struct timeval timeout, 
			      u_int reserved, 
			      u_int flags, 
			      bool_t (*verify) (u_int type, char *system, 
						char *group, char *key, 
						u_int count, 
						struct timeval interval, 
						u_int flags), 
			      void (*dispatch) (u_int type, char *system, 
						char *group, char *key, 
						u_int count, 
						struct timeval interval, 
						u_int flags), 
#ifdef SVR4
						void (*reap_child) (int sig, pid_t child_pid,
										int *stat_loc, struct rusage *usagep),
#else
			      void (*reap_child) (int sig, int code, 
						  struct sigcontext *scp, 
						  char *addr, int child_pid, 
						  union wait *waitp, 
						  struct rusage *usagep), 
#endif 

#ifdef SVR4
						void (*shutdown) (int sig)) ;
#else
			      void (*shutdown) (int sig, int code, 
						struct sigcontext *scp, 
						char *addr)) ;
#endif

bool_t netmgt_mark_end_of_row (void) ;

bool_t netmgt_receive_request (struct svc_req *rqst, register SVCXPRT *xprt) ;

bool_t netmgt_send_error (Netmgt_error *error) ;

bool_t netmgt_send_report (struct timeval delta_time, 
			   Netmgt_stat status, 
			   u_int flags) ;

#ifdef SVR4
void netmgt_shutdown_agent (int sig) ;
#else
void netmgt_shutdown_agent (int sig, 
			    int code, 
			    struct sigcontext *scp,
			    char *addr) ;
#endif 

void netmgt_start_agent (void) ;

void netmgt_start_rendez (void) ;

bool_t netmgt_start_trap (char *system, 
			  u_int agent_prog,
			  u_int agent_vers,
			  char *group,
			  char *host, 
			  u_int prog, 
			  u_int vers, 
			  u_int priority, 
			  struct timeval timeout) ; 
#ifdef BOGEY
typedef void (*SIG_PFV) (...);

bool_t netmgt_set_signal_handler (int sig, SIG_PFV handler) ;

bool_t netmgt_set_child_signal_handler (int sig, SIG_PFV handler) ;

void netmgt_wait (int secs) ;
#endif
}

#else  /* Sun C */

/* Package public manager and agent services */
extern bool_t netmgt_fetch_msginfo () ;
extern char *netmgt_getConfig();

extern char *netmgt_oid2string () ;
extern char *netmgt_oid2decodedstring () ;
extern caddr_t netmgt_get_oid_map() ;

extern void netmgt_set_debug () ;
extern char *netmgt_sperror () ;
extern u_long *netmgt_string2oid () ;

extern u_int netmgt_alloc_manager_id () ;
extern bool_t netmgt_set_manager_id () ;
extern u_int netmgt_get_manager_id () ;
extern bool_t netmgt_free_manager_id () ;

/* Package public manager services */
extern struct timeval *netmgt_request_events () ;
extern Netmgt_agent_ID *netmgt_request_agent_ID () ;
extern bool_t netmgt_fetch_data () ;
extern bool_t netmgt_fetch_error () ;
extern bool_t netmgt_fetch_event () ;
extern u_int netmgt_get_priority () ;
extern bool_t netmgt_kill_request () ;
extern bool_t netmgt_register_rendez () ;
extern u_long netmgt_register_callback () ;
extern struct timeval *netmgt_request_data () ;
extern bool_t netmgt_request_deferred () ;
bool_t netmgt_request_set () ;
extern bool_t netmgt_set_instance () ;
extern bool_t netmgt_set_threshold () ;
bool_t netmgt_set_value () ;
extern bool_t netmgt_unregister_callback () ;
extern bool_t netmgt_unregister_rendez () ;

/* Package public agent services */
extern bool_t netmgt_build_report () ;
extern bool_t netmgt_fetch_argument () ;
extern bool_t netmgt_fetch_setval () ;
extern bool_t netmgt_init_rpc_agent () ;
extern bool_t netmgt_mark_end_of_row () ;
extern bool_t netmgt_receive_request () ;
extern bool_t netmgt_send_error () ;
extern bool_t netmgt_send_report () ;
extern void netmgt_shutdown_agent () ;
extern void netmgt_start_agent () ;
extern void netmgt_start_rendez () ;
extern bool_t netmgt_start_trap () ;

#ifdef BOGEY
extern bool_t netmgt_set_signal_handler () ;
extern bool_t netmgt_set_child_signal_handler () ;
extern void netmgt_wait () ;
#endif

#endif /* defined (__cplusplus) */

#endif /* !_netmgt_extern_h */
