/*
 *	Copyright (C) 1989-1997 Softway Pty Ltd, Sydney Australia.
 *	All Rights Reserved.
 */

/*
 *	Copyright (C) 1997 Sun Microsystems, Inc.
 */


/*
 *	This is unpublished proprietary source code of Softway Pty Ltd.
 *	The contents of this file are protected by copyright laws and
 *	international copyright treaties, as well as other intellectual
 *	property laws and treaties.  These contents may not be extracted,
 *	copied,	modified or redistributed either as a whole or part thereof
 *	in any form, and may not be used directly in, or to assist with,
 *	the creation of derivative works of any nature without prior
 *	written permission from Softway Pty Ltd.  The above copyright notice
 *	does not evidence any actual or intended publication of this file.
 */
/*
 *	shareIIstubs.h
 *
 *	Share System Kernel Hooks header.
 */

#ifndef	_SYS_SHAREIISTUBS_H
#define	_SYS_SHAREIISTUBS_H

#pragma ident	"@(#)shareIIstubs.h	1.5	97/06/20 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#if _SHAREII

#include	<sys/types.h>
#include	<sys/systm.h>
#include	<sys/cred.h>
#include	<sys/vfs.h>




#define	SHR_IF_MAJOR	1
#define	SHR_IF_MINOR	33
#define	SHR_STRINGIT(s)	#s
#define	SHR_MK_VERSION(m, n)	(SHR_STRINGIT(m) "." SHR_STRINGIT(n))

extern const char	_shareii_interface_version[];
#define	_SHAREII_INTERFACE_VERSION	\
		SHR_MK_VERSION(SHR_IF_MAJOR, SHR_IF_MINOR)


/*
 *	This pointer is NULL while the ShareII module is not loaded
 *	or has not initialised yet. During initialisation it is set
 *	to point at a structure populated with addresses of the hooks.
 */
extern volatile struct _shareii_interface	*shareii_hook;


/*
 *	Prototypes for all the Share hooks called from the mainline
 *	kernel code.
 */

#ifndef	ShrProc_t
#include	<sys/proc.h>
#define	ShrProc_t		proc_t		/* machdep.h */
#define	ShrThread_t		kthread_t	/* machdep.h */
#define	ShrThreadId_t		kthread_id_t	/* machdep.h */
#endif	/* ShrProc_t */



typedef struct _shareii_interface {
	int	(*start)(id_t, int);
	int	(*setattr)(long, mode_t *);
	int	(*limitdisk)(struct vfs *, uid_t, u_long, int, int,
					u_long *, cred_t *);
	int	(*limitmemory)(size_t, int);
	int	(*chownfile)(struct vfs *, uid_t, uid_t, u_long, int,
					long, cred_t *);
	void	(*exit)(ShrProc_t *);
	void	(*flush)(u_long);
	int	(*umask)(void);
	int	(*proccreate)(ShrProc_t *, int);
	void	(*procdestroy)(ShrProc_t *);
	void	(*pcntup)(kthread_id_t);
	void	(*pcntdn)(kthread_id_t);
	void	(*rdwr)(struct vnode *, int, int);
	void	(*bio)(int);
	void	(*seteuid)(uid_t);
	void	(*setruid)(uid_t);
	void	(*swtch)(kthread_id_t);
	void	(*lwpfail)(ShrProc_t *, kthread_id_t);
	void	(*lwpexit)(void);
	int	(*lwpnew)(ShrProc_t *);
	int	(*iaccess)(struct vnode *, uid_t, uid_t, mode_t, mode_t,
					cred_t *);
	int	(*request)(void *);
} _shareii_interface;


#define	SHR_START(c, p)	(shareii_hook ? shareii_hook->start((c), (p)) : 0)
#define	SHR_SETATTR(w, m) \
			(shareii_hook ? shareii_hook->setattr((w), (m)) : 0)
#define	SHR_LIMITDISK(v, u, n, b, l, s, c) \
	(shareii_hook ? \
	shareii_hook->limitdisk((v), (u), (n), (b), (l), (s), (c)) : 0)
#define	SHR_LIMITMEMORY(n, l) \
	(shareii_hook ? shareii_hook->limitmemory((n), (l)) : 0)
#define	SHR_CHOWNFILE(v, w, u, n, b, m, c) \
	(shareii_hook ? \
	shareii_hook->chownfile((v), (w), (u), (n), (b), (m), (c)) : 0)
#define	SHR_EXIT(p)	(shareii_hook ? shareii_hook->exit((p)) : (void)0)
#define	SHR_FLUSH(a)	(shareii_hook ? shareii_hook->flush((a)) : (void)0)
#define	SHR_UMASK()	(shareii_hook ? shareii_hook->umask() : 0)
#define	SHR_PROCCREATE(p, f) \
		(shareii_hook ? shareii_hook->proccreate((p), (f)) : 0)
#define	SHR_PROCDESTROY(p) \
		(shareii_hook ? shareii_hook->procdestroy((p)) : (void)0)
#define	SHR_PCNTUP(t)	(shareii_hook ? shareii_hook->pcntup((t)) : (void)0)
#define	SHR_PCNTDN(t)	(shareii_hook ? shareii_hook->pcntdn((t)) : (void)0)
#define	SHR_RDWR(v, m, n) \
		(shareii_hook ? shareii_hook->rdwr((v), (m), (n)) : (void)0)
#define	SHR_BIO(f)	(shareii_hook ? shareii_hook->bio((f)) : (void)0)
#define	SHR_SETEUID(u)	(shareii_hook ? shareii_hook->seteuid((u)) : (void)0)
#define	SHR_SETRUID(u)	(shareii_hook ? shareii_hook->setruid((u)) : (void)0)
#define	SHR_SWTCH(t)	(shareii_hook ? shareii_hook->swtch((t)) : (void)0)
#define	SHR_LWPFAIL(p, t) \
		(shareii_hook ? shareii_hook->lwpfail((p), (t)) : (void)0)
#define	SHR_LWPEXIT()	(shareii_hook ? shareii_hook->lwpexit() : (void)0)
#define	SHR_LWPNEW(p)	(shareii_hook ? shareii_hook->lwpnew((p)) : 0)
#define	SHR_IACCESS(v, u, g, m, n, c) \
	(shareii_hook ? shareii_hook->iaccess((v), (u), (g), (m), (n), (c)) : 0)
#define	SHR_REQUEST(a)	(shareii_hook ? shareii_hook->request((a)) : -1)

#define	SHR_ACTIVE	(shareii_hook != NULL)

/*
 * These control the behaviour of limit enforce/update functions:
 *	SHlimitDisk()
 *	SHlimitMemory()
 */
#define	LI_ENFORCE	(1<<0)
#define	LI_UPDATE	(1<<1)
#define	LI_ALLOC	(1<<2)
#define	LI_FREE		(1<<3)

/*
 * These are return values used by SHaccess():
 */
#define	SH_ACCESS_NORMAL 0 /* none of the following access overrides */
#define	SH_ACCESS_ROOT	1 /* allow access as if user is root */
#define	SH_ACCESS_GROUP	2 /* allow access as if user is member of group */
#define	SH_ACCESS_OWNER	3 /* allow access as if user is owner */

/*
 * These are for the argument to SHbio():
 */
#define	SH_BIO_ASYNC	(1<<7)	/* not waiting for the i/o to complete */
#define	SH_BIO_HOLD	(1<<6)	/* not releasing the buffer after write */
#define	SH_BIO_BREAD	(1<<0)	/* a read */
#define	SH_BIO_BWRITE	(1<<1)	/* a write */

/*
 * These are for the flag argument to
 *	SHfork() and SHprocalloc():
 */
#define	SH_FORK_ALL	(1<<0)	/* A fork() which duplicates all threads */
#define	SH_FORK_POSIX	(1<<1)	/* A fork1() */

/*
 * This is for the flag argument to SHfork():
 * Used in combination with SH_FORK_ALL or SH_FORK_POSIX.
 */
#define	SH_FORK_V	(1<<7)	/* A vfork() */

#endif	/* _SHAREII */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SHAREIISTUBS_H */
