/*
 * Copyright 1995 Sun Microsystems, Inc. All Rights Reserved.
 */

#ifndef IPXSPX
#define IPXSPX

#pragma ident   "%Z%%M% %I% %E% SMI"

#ifdef __cplusplus
extern "C" {
#endif

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <tiuser.h>
#include <ctype.h>

#ifdef SOL
#include <sys/types.h>
#include <limits.h>
#include <time.h>
#include <memory.h>

#ifdef UNIXWARE
#define IPXDEVICE "/dev/ipx"
#define SPXDEVICE "/dev/nspx"
#else
#define IPXDEVICE "/dev/mipx"
#define SPXDEVICE "/dev/mspx"
#endif

#endif

#ifdef NWDOS
#include <mem.h>
#include <tispxipx.h>
#include <sys\types.h>
#include <time.h>
#include <process.h>

#define IPXDEVICE "/dev/nipx"
#define SPXDEVICE "/dev/nspx"
#endif

#ifdef NWNLM
#include <time.h>
#include <process.h>

#define IPXDEVICE "/dev/nipx"
#define SPXDEVICE "/dev/nspx"
#endif

#define FALSE           0
#define TRUE            1
#define FAILED          -1      /* return code for failed operations */
#define SUCCESS         0       /* return code for successful operations */
#define BCAST           1       /* flag to indicate bcast in get_send_params */
#define NOT_BCAST       0       /* flag to indicate not bcast */
#define ITERATION       1000    /* number of iterations */
#define IPXTEST_SOCKET  0x31    /* socket number for ipxtest */
#define MAX_CONN        10      /* queue length for outstanding requests */
#define MAX_BUF_SIZE    2048    /* message buffer size */
#define CLIENT          "Client"
#define SERVER          "Server"

#ifdef UNIXWARE
extern int t_errno;
#endif

struct ipx_addr {               /* ipx packet address structure */
	unsigned char network[4];
	unsigned char node[6];
	unsigned char socket[2];
};

struct prog_params {            /* program parameters structure */
	struct ipx_addr client; /* ipx addr for client side only */
	struct ipx_addr server; /* ipx addr for server side only */

	unsigned long   iteration;      /* number of iteration (server) */
	short iter_assigned;            /* who assigned iteration */

	int     packet_size;            /* packet size (client) */
	short packet_assigned;          /* who assigned packet size */

	unsigned short  inputsource;    /* source for input params */
	char input_filename[128];       /* input file name */

	unsigned short  outputdest;     /* stats output (server) */
	char output_filename[128];      /* output file name (server) */
	short output_assigned;          /* who assigned outputdest */

	char header_info[128];          /* header info (server) */
	short header_assigned;          /* who assigned header_info */

	int num_client;                 /* num of concurrent client */
	short num_client_assigned;      /* for nserv only */
};

/* defines for prog_params.inputsource */
#define INTERACTIVE     0
#define COMMANDLINE     1
#define CONFIGFILE      2

/* defines for prog_params.outputdest */
#define SCREEN  0
#define LOGFILE 1

/* defines for the *_assigned fields in struct prog_params */
#define INITIAL         0
#define COMMANDLINE     1

/* defines for some default values for struct prog_params */
#define DEFAULT_ITERATION       5000
#define DEFAULT_PACKET_SIZE     512
#define DEFAULT_NUM_CLIENT      1

#ifdef __cplusplus
}
#endif

#endif /* IPXSPX */
