#pragma ident  "@(#)qccdefs.h 1.2     95/11/10 SMI"

/*
 * Copyright (c) 1994 by Sun Microsystems, Inc.
 * Sun Proprietary / Confidential
 */

#define	EXT						0x80

#define	IE_INSTRUCTION_FIELD	0x80
#define	CODING_STANDARD1		0x20
#define	CODING_STANDARD2		0x40
#define	CODING_STANDARD3		0x60

/* AAL Type */
#define	AAL_TYPE_5					5
#define	FORWARD_SDU_SIZE_ID			0x8c
#define	BACKWARD_SDU_SIZE_ID		0x81
#define	MODE_ID						0x83	/* 3.0 only */
#define	MESSAGE_MODE				0x01	/* 3.0 only */
#define	STREAMING_MODE				0x02	/* 3.0 only */
#define	SSCS_TYPE_ID				0x84
#define	SSCS_TYPE_NULL				0x00
#define	SSCS_TYPE_SSCOP_ASSURED		0x01
#define	SSCS_TYPE_SSCOP_NON_ASSURED	0x02
#define	SSCS_TYPE_FRAME_RELAY		0x04

/* User Cell Rate */
#define	FORWARD_PEAK_CELL_RATE_CLP0_ID		0x82	/* CLP=0 */
#define	BACKWARD_PEAK_CELL_RATE_CLP0_ID		0x83	/* CLP=0 */
#define	FORWARD_PEAK_CELL_RATE_CLP1_ID		0x84	/* CLP=0+1 */
#define	BACKWARD_PEAK_CELL_RATE_CLP1_ID		0x85	/* CLP=0+1 */
#define	FORWARD_SUSTAINED_RATE_CLP0_ID		0x88	/* CLP=0 */
#define	BACKWARD_SUSTAINED_RATE_CLP0_ID		0x89	/* CLP=0 */
#define	FORWARD_SUSTAINED_RATE_CLP1_ID		0x90	/* CLP=0+1 */
#define	BACKWARD_SUSTAINED_RATE_CLP1_ID		0x91	/* CLP=0+1 */
#define	FORWARD_MAX_BURST_SIZE_CLP0_ID		0xa0	/* CLP=0 */
#define	BACKWARD_MAX_BURST_SIZE_CLP0_ID		0xa1	/* CLP=0 */
#define	FORWARD_MAX_BURST_SIZE_CLP1_ID		0xb0	/* CLP=0+1 */
#define	BACKWARD_MAX_BURST_SIZE_CLP1_ID		0xb1	/* CLP=0+1 */
#define	BEST_EFFORT_INDICATOR_ID			0xbe
#define	TRAFFIC_MANAGEMENT_OPTIONS_ID		0xbf
#define	PEAK_CELL_RATE						0x02439c
#define	MAX_BURST_SIZE						0x02439c
#define	RATE_MASK							0xffffff
#define	TAGGING_FORWARD_REQUESTED			0x01
#define	TAGGING_BACKWARD_REQUESTED			0x02

/* Flags to identify which rates to use */
#define	FORWARD_PEAK_CLP0			0x001
#define	BACKWARD_PEAK_CLP0			0x002
#define	FORWARD_PEAK_CLP1			0x004
#define	BACKWARD_PEAK_CLP1			0x008
#define	FORWARD_SUSTAINED_CLP0		0x010
#define	BACKWARD_SUSTAINED_CLP0		0x020
#define	FORWARD_SUSTAINED_CLP1		0x040
#define	BACKWARD_SUSTAINED_CLP1		0x080
#define	FORWARD_BURST_CLP0			0x100
#define	BACKWARD_BURST_CLP0			0x200
#define	FORWARD_BURST_CLP1			0x400
#define	BACKWARD_BURST_CLP1			0x800

/* Broadband Bearer Class */
#define	BCOB_A						0x01
#define	BCOB_C						0x03
#define	BCOB_X						0x10
#define	CONSTANT_BIT_RATE			(0x01 << 2)
#define	VARIABLE_BIT_RATE			(0x02 << 2)
#define	E2E_TIMING_REQUIRED			0x01
#define	E2E_TIMING_NOT_REQUIRED		0x02
#define	CLIPPING_NOT_SUSCEPTIBLE	(0x00 << 5)
#define	CLIPPING_SUSCEPTIBLE		(0x01 << 5)
#define	POINT_TO_POINT				0x00
#define	POINT_TO_MULTIPOINT			0x01
#define	NO_INDICATION				0x00	/* for both type and timing */

/* Broadband Higher Layer Profile */
#define	ISO						0x00
#define	USER_SPECIFIC			0x01
#define	HIGHER_LAYER_PROFILE	0x02	/* 3.0 only */
#define	VENDOR_SPECIFIC_APP_ID	0x03
#define	MAX_USER_INFO_LEN		8

/* Broadband Lower Layer Profile */
#define	LAYER1_ID						(0x01 << 5)
#define	LAYER2_ID						(0x02 << 5)
#define	LAYER3_ID						(0x03 << 5)

/* Layer 2 Protocol */
#define	BASIC_MODE				0x01
#define	CCITT_Q921				0x02
#define	CCITT_X25_LINK_LAYER	0x06
#define	CCITT_X25_MULTI_LINK	0x07
#define	EXTENDED_LAPB			0x08
#define	HDLC_ARM_1				0x09
#define	HDLC_ARM_2				0x0a
#define	HDLC_ARM_3				0x0b
#define	LAN_LLC					0x0c
#define	CCITT_X75				0x0d
#define	CCITT_Q922				0x0e
#define	USER_SPECIFIED			0x10
#define	ISO_7776				0x11

/* Layer 2 CCITT Protocol Modes */
#define	CCITT_NORMAL_MODE		(0x01 << 5)
#define	CCITT_EXTENDED_MODE		(0x02 << 5)

/* Layer 3 Protocol */
#define	CCITT_X25_PACKET_LAYER	0x06
#define	ISO_IEC_8208			0x07
#define	ISO_8878				0x08
#define	ISO_IEC_8473			0x09
#define	CCITT_TR_9577			0x0a
#define	ISO_IEC_9577			0x0b	/* Lan Emulation */
#define	USER_SPECIFIED			0x10

/* Multicast Send VCC Types for LANE */
#define	BEST_EFFORT				0x00
#define	VARIABLE				0x01
#define	CONSTANT				0x02

/* Layer 3 CCITT Protocol Modes */
#define	CCITT_NORMAL_SEQ		(0x01 << 5)
#define	CCITT_EXTENDED_SEQ		(0x02 << 5)

/* Layer 3 CCITT Default Packet Sizes */
#define	CCITT_PACKET_SIZE_16	0x04
#define	CCITT_PACKET_SIZE_32	0x05
#define	CCITT_PACKET_SIZE_64	0x06
#define	CCITT_PACKET_SIZE_128	0x07
#define	CCITT_PACKET_SIZE_256	0x08
#define	CCITT_PACKET_SIZE_512	0x09
#define	CCITT_PACKET_SIZE_1024	0x0a
#define	CCITT_PACKET_SIZE_2048	0x0b
#define	CCITT_PACKET_SIZE_4096	0x0c

/* Layer 3 SNAP */
#define	SNAP_IPI				0x80
#define	LAYER_3_SNAP_ID			(0x00 << 5)

/* Address */
#define	TYPE_UNKNOWN					(0x00 << 4)
#define	TYPE_INTERNATIONAL_NUMBER		(0x01 << 4)
#define	ISDN							0x01
#define	NSAP							0x02	/* UNI 3.0 */
#define	ATM_ENDSYSTEM					0x02	/* UNI 3.1 */
#define	NSAP_SUBADDRESS					0x00
#define	ATM_ENDSYSTEM_SUBADDRESS		0x01	/* UNI 3.1 */
#define	PRESENTATION_ALLOWED			(0x00 << 5)
#define	PRESENTATION_RESTRICTED			(0x01 << 5)
#define	PRESENTATION_NOT_AVAIL			(0x02 << 5)
#define	USER_PROVIDED_NOT_SCREENED		0x00
#define	USER_PROVIDED_VERIFIED_PASSED	0x01
#define	USER_PROVIDED_VERIFIED_FAILED	0x02
#define	NETWORK_PROVIDED				0x03

/* Cause */
#define	LOCATION_USER							0x00
#define	LOCATION_PRIVATE_NETWORK_LOCAL_USER		0x01
#define	LOCATION_PUBLIC_NETWORK_LOCAL_USER		0x02
#define	LOCATION_TRANSIT_NETWORK				0x03
#define	LOCATION_PRIVATE_NETWORK_REMOTE_USER	0x04
#define	LOCATION_PUBLIC_NETWORK_REMOTE_USER		0x05
#define	LOCATION_INTERNATIONAL_NETWORK			0x07
#define	LOCATION_NETWORK_BEYOND_INTERNETWORK	0x0a

/* Connection Identifier */
#define	EXCLUSIVE_VPCI_EXCLUSIVE_VCI	(0x00 << 3)
#define	EXPLICIT_INDICATION_VPCI		(0x01 << 3)

/* QOS */
#define	QOS_CLASS0		0x0
#define	QOS_CLASS1		0x1
#define	QOS_CLASS2		0x2
#define	QOS_CLASS3		0x3
#define	QOS_CLASS4		0x4

/* Restart Indicator */
#define RESTART_INDICATED_VC        0x0
#define RESTART_ALL_VCS             0x2
#define RESTART_CLASS_MASK          0x0007

/* Transit Network Selection */
#define	NATIONAL_NETWORK_ID		(0x02 << 4)
#define	CARRIER_ID_CODE			0x01

/* Endpoint Reference */
#define	LOCALLY_DEFINED_INT		0x00
#define	ROOT_INITIATED			0x00
#define	FROM_ORIGINATOR			0x00
#define	TO_ORIGINATOR			0x80
