#pragma ident  "@(#)qcctypes.h 1.2      95/10/17 SMI"

/*
 * Copyright (c) 1994 by Sun Microsystems, Inc.
 * Sun Proprietary / Confidential
 */

#ifndef	_ATM_QCCTYPES_H
#define	_ATM_QCCTYPES_H

#include <atm/qccdefs.h>
#include <atm/types.h>

/* This header file contains all the structures required for the    */
/* structural api to Q.2931 signalling.  There are two major types  */
/* of structures defined: structures that represent the individual  */
/* information elements, and structures that represent each message */
/* type.  The message structures are made up of pointers to infor-  */
/* mation element structures.                                       */


/* Information Element Structures */

typedef struct aal5 {
	u_short		forward_max;
	u_short		backward_max;
	u_char		mode;
	u_char		sscs_type;
	u_char		pad[2];
} aal5_t;

typedef union qcc_aal {
	aal5_t		aal5;
} qcc_aal_t;

typedef struct qcc_aal_params_ie {
	int			valid;
	int			type;
	qcc_aal_t	info;
} qcc_aal_params_t;

typedef struct qcc_traffic_desc_ie {
	int			valid;
	u_char		best_effort;
	u_char		tagging;
	u_short		params;
	int			forward_peak0;
	int			backward_peak0;
	int			forward_sustain0;
	int			backward_sustain0;
	int			forward_burst0;
	int			backward_burst0;
	int			forward_peak1;
	int			backward_peak1;
	int			forward_sustain1;
	int			backward_sustain1;
	int			forward_burst1;
	int			backward_burst1;
} qcc_traffic_desc_t;

typedef struct qcc_bbc_ie {
	int			valid;
	u_char		class;
	u_char		type;
	u_char		timing;
	u_char		clipping;
	u_char		userplane;
	u_char		pad[3];
} qcc_bbc_t;

typedef struct qcc_bhli_ie {
	int			valid;
	int			type;
	int			infolen;		/* number of octets of user information */
	u_char		info[MAX_USER_INFO_LEN];
} qcc_bhli_t;

typedef struct qcc_layer2 {
	u_char		protocol;
	u_char		mode;
	u_char		windowsize;
	u_char		userspec;
} qcc_layer2_t;

typedef struct qcc_layer3 {
	u_char		protocol;
	u_char		mode;
	u_char		pktsize;
	u_char		windowsize;
	u_char		userspec;
	u_char		ipi;
	u_char		pad[2];
	int			oui;
	int			pid;
} qcc_layer3_t;

typedef union qcc_lli {
	qcc_layer2_t	layer2;
	qcc_layer3_t	layer3;
} qcc_lli_t;

typedef struct qcc_blli_ie {
	int			valid;
	int			layer;
	qcc_lli_t	info;
} qcc_blli_t;

typedef struct qcc_call_state_ie {
	int			valid;
	u_char		state;
	u_char		pad[3];
} qcc_call_state_t;

typedef struct qcc_called_num_ie {
	int				valid;
	u_char			planid;
	u_char			pad[3];
	atm_address_t	address;
} qcc_called_num_t;

typedef struct qcc_called_subaddr_ie {
	int				valid;
	u_char			type;
	u_char			pad[3];
	atm_address_t	address;
} qcc_called_subaddr_t;

typedef struct qcc_calling_num_ie {
	int				valid;
	u_char			planid;
	u_char			presentation;
	u_char			screening;
	u_char			pad;
	atm_address_t	address;
} qcc_calling_num_t;

typedef struct qcc_calling_subaddr_ie {
	int				valid;
	u_char			type;
	u_char			pad[3];
	atm_address_t	address;
} qcc_calling_subaddr_t;

typedef struct qcc_cause_ie {
	int			valid;
	u_char		location;
	u_char		cause;
	u_char		pad[2];
	int			diaglen;		/* length of diagnostic, in octets */
	u_char		diag[28];
} qcc_cause_t;

typedef struct qcc_conn_id_ie {
	int			valid;
	u_short		vpci;
	u_short		vci;
} qcc_conn_id_t;

typedef struct qcc_qos_ie {
	int			valid;
	u_char		codingstd;
	u_char		forward_class;
	u_char		backward_class;
	u_char		pad;
} qcc_qos_t;

typedef struct qcc_restart_ind_ie {
	int			valid;
	u_char		class;
	u_char		pad[3];
} qcc_restart_ind_t;

typedef struct qcc_transit_ie {
	int			valid;
	u_char		cic[4];
} qcc_transit_t;

typedef struct qcc_endpt_ref_ie {
	int			valid;
	u_short		endptref;
	u_char		pad[2];
} qcc_endpt_ref_t;

typedef struct qcc_endpt_state_ie {
	int			valid;
	int			state;
} qcc_endpt_state_t;

typedef union qcc_ie_types {
	qcc_aal_params_t		*aal_params;
	qcc_traffic_desc_t		*traffic_desc;
	qcc_bbc_t				*bbc;
	qcc_bhli_t				*bhli;
	qcc_blli_t				*blli;
	qcc_call_state_t		*call_state;
	qcc_called_num_t		*called_num;
	qcc_called_subaddr_t	*called_subaddr;
	qcc_calling_num_t		*calling_num;
	qcc_calling_subaddr_t	*calling_subaddr;
	qcc_cause_t				*cause;
	qcc_conn_id_t			*conn_id;
	qcc_qos_t				*qos;
	qcc_restart_ind_t		*restart_ind;
	qcc_transit_t			*transit;
	qcc_endpt_ref_t			*endpt_ref;
	qcc_endpt_state_t		*endpt_state;
} qcc_ie_types_t;

typedef struct qcc_ie {
	int				type;
	qcc_ie_types_t	ie;
} qcc_ie_t;



/* Message structures */

typedef struct qcc_call_proc_msg {
	qcc_hdr_t				hdr;
	qcc_conn_id_t			conn_id;
	qcc_endpt_ref_t			endpt_ref;
} qcc_call_proc_t;

typedef struct qcc_connect_msg {
	qcc_hdr_t				hdr;
	qcc_aal_params_t		aal_params;
	qcc_blli_t				blli;
	qcc_conn_id_t			conn_id;
	qcc_endpt_ref_t			endpt_ref;
} qcc_connect_t;

typedef struct qcc_connect_ack_msg {
	qcc_hdr_t               hdr; 
} qcc_connect_ack_t;

typedef struct qcc_release_msg {
	qcc_hdr_t               hdr; 
	qcc_cause_t				cause;
} qcc_release_t;

typedef struct qcc_release_complete_msg {
	qcc_hdr_t               hdr;
	qcc_cause_t				cause;
} qcc_release_complete_t;

typedef struct qcc_setup_msg {
	qcc_hdr_t               hdr;
	qcc_aal_params_t		aal_params;
	qcc_traffic_desc_t		traffic_desc;
	qcc_bbc_t				bbc;
	qcc_bhli_t				bhli;
	int						repeat;
	qcc_blli_t				blli;
	qcc_called_num_t		called_num;
	qcc_called_subaddr_t	called_subaddr;
	qcc_calling_num_t		calling_num;
	qcc_calling_subaddr_t	calling_subaddr;
	qcc_conn_id_t			conn_id;
	qcc_qos_t				qos;
	int						send_comp;
	qcc_transit_t			transit;
	qcc_endpt_ref_t			endpt_ref;
} qcc_setup_t;

typedef struct qcc_status_msg {
	qcc_hdr_t               hdr;
	qcc_call_state_t		call_state;
	qcc_cause_t				cause;
	qcc_endpt_ref_t			endpt_ref;
	qcc_endpt_state_t		endpt_state;
} qcc_status_t;

typedef struct qcc_status_enq_msg {
	qcc_hdr_t               hdr;
	qcc_endpt_ref_t			endpt_ref;
} qcc_status_enq_t;

typedef struct qcc_restart_msg {
	qcc_hdr_t               hdr;
	qcc_conn_id_t			conn_id;
	qcc_restart_ind_t		restart_ind;
} qcc_restart_t;

typedef qcc_restart_t		qcc_restart_ack_t;

typedef struct qcc_add_party_msg {
	qcc_hdr_t               hdr;
	qcc_aal_params_t		aal_params;
	qcc_bhli_t				bhli;
	qcc_blli_t				blli;
	qcc_called_num_t		called_num;
	qcc_called_subaddr_t	called_subaddr;
	qcc_calling_num_t		calling_num;
	qcc_calling_subaddr_t	calling_subaddr;
	int						send_comp;
	qcc_transit_t			transit;
	qcc_endpt_ref_t			endpt_ref;
} qcc_add_party_t;

typedef struct qcc_add_party_ack_msg {
	qcc_hdr_t				hdr;
	qcc_endpt_ref_t			endpt_ref;
} qcc_add_party_ack_t;

typedef struct qcc_add_party_reject_msg {
	qcc_hdr_t               hdr;
	qcc_cause_t				cause;
	qcc_endpt_ref_t			endpt_ref;
} qcc_add_party_reject_t;

typedef qcc_add_party_reject_t	qcc_drop_party_t;

typedef qcc_add_party_reject_t	qcc_drop_party_ack_t;

typedef union qcc_msg_types {
	qcc_call_proc_t			*call_proc;
	qcc_connect_t			*connect;
	qcc_connect_ack_t		*connect_ack;
	qcc_release_t			*release;
	qcc_release_complete_t	*release_complete;
	qcc_setup_t				*setup;
	qcc_status_t			*status;
	qcc_status_enq_t		*status_enq;
	qcc_restart_t			*restart;
	qcc_restart_ack_t		*restart_ack;
	qcc_add_party_t			*add_party;
	qcc_add_party_ack_t		*add_party_ack; 
	qcc_add_party_reject_t	*add_party_reject;
	qcc_drop_party_t		*drop_party;
	qcc_drop_party_ack_t	*drop_party_ack;
} qcc_msg_types_t;

typedef struct qcc_msg {
	int				type;
	qcc_msg_types_t	msg;
} qcc_msg_t;

#endif   /* _ATM_QCCTYPES_H */
