/*
 *         Copyright (c) 1992 MARBEN Produit.
 *                  All Rights Reserved
 *
 *         Copyright (c)  Hewlett-Packard Company 1989,1990,1991
 *
 */

#ifdef  __cplusplus
extern "C" {
#endif
#define SUCCESS	0
#define FAIL	(-1)
#define TRUE	1
#define FALSE	0


/*
 * These ID numbers for each protocol are used to distinguish
 * #defines of various kinds for each layer, such as primitive
 * names, environment attribute names, error codes, etc.
 *
 * ID NUMBERS MAY NOT EXCEED 127 (could be sign extension problems
 * otherwise).
 */

#define ASN1_ID	(11)
#define FL_ID	(10)
#define CL_ID	(9)
#define	AP_ID	(8)
#define ACSE_ID	(7)
#define PRES_ID	(6)
#define SESS_ID	(5)
#define UNIX_ID (0)

/*
 * This macro takes the above id numbers and an error index
 * and combines them into an error code.
 */

#define ERRNO_SHIFT	((sizeof(long) - 1) * 8)
#define ERRNO(ID, NUM)	((unsigned long)((ID << ERRNO_SHIFT) | (NUM)))

/*
 * This macro takes an errno as made by the above macro and extracts
 * the layer id.
 */

#define ERRNO_ID(E)	((E) >> ERRNO_SHIFT)

/*
 * This macro takes an errno as made by the above macro and extracts
 * the error index. 
 */

#define ERRNO_INDEX(E)	((ERRNO_ID(E) << ERRNO_SHIFT) ^ (E))

/*
 * This macro takes the attribute name and returns the attribute id
 */

#define ATTR_SHIFT	16
#define ATTR_ID(A)	((A) >> ATTR_SHIFT)
#define ATTR_INDEX(A)	((~(0xff << ATTR_SHIFT)) & (A))

/*
 * This macro returns a bit mask with the specified bit set
 */

#define BITL(X) ((unsigned) 1 << ((sizeof(long)*8) - (X) - 1))

/*
 * osi_buf data structure for 'ubuf' parameter of ap_snd() & ap_rcv()
 */

struct osi_buf {
	unsigned int maxlen;
	unsigned int len;
	char *buf;
};

typedef struct {
	int  size;
	char *udata;
} any_t;

/*
 * TLI optmgt definition
 */

#define	USE_CLASS_0			(0x80)
#define	USE_CLASS_4_3_2			(0x20)
#define	NO_FLOW_CONTROL_CLASS_2		(0x10)
#define	USE_EXPEDITED_CLASS_2		(0x01)

/* 
 * TLI Optmgt Structures 
 */

struct T_opt_details {
  unsigned short T_opt_idus;	/* IDU size when sending */
  unsigned short T_opt_idur;	/* IDU size when receiving */
  unsigned char T_opt_clo;		/* Class/Options */
  unsigned char T_opt_qos;		/* Quality of Service Parameters (should be 0) */
};

#ifdef  __cplusplus
}
#endif
