/*
 *         Copyright (c) 1992 MARBEN Produit.
 *                  All Rights Reserved
 *
 *         Copyright (c)  Hewlett-Packard Company 1989,1990,1991
 *
 *
 *  PRODUCT  :  APLI
 *
 *  AUTHORS  :  OSIAM-STREAMS GROUP
 *
 *  COMPONENT:  Application Library
 *
 *  ABSTRACT :  Contains poll constant definitions and structures.
 *
 *  FILENAME :  apli/incl/ap_poll.h
 *
 *  COMMENTS :  --------------------
 *
 * =========================================================================== *
 * HISTORY TRACE                                  Starting file ref: 18-Aug-92 *
 *                                                                             *
 *  Notice : all modifications must be traced hereafter. The modified source   *
 *  lines must be referenced by bug number (BUG #001).                         *
 *                                                                             *
 * --------------------------------------------------------------------------- *
 * Prod. | Bug   | Modif.  | by     | summary                                  *
 * Vers. | Number| Date    |        |                                          *
 * ------+-------+---------+--------+----------------------------------------- *
 * 01.10 | ----  |18-Aug-92| gc     |-Created in MARBEN PRODUIT format.        *
 * ------+-------+---------+--------+----------------------------------------- *
 *       |       |         |        |                                          *
 * ------+-------+---------+--------+----------------------------------------- *
 */

#ifndef _AP_POLL
#define _AP_POLL

#ifdef  __cplusplus
extern "C" {
#endif/*
 * Structure of file descriptor/event pairs supplied in
 * the poll arrays.
 */
struct ap_pollfd {
	int fd;				/* file desc to poll */
	short events;			/* events of interest on fd */
	short revents;			/* events that occurred on fd */
};


/*
 * Testable select events 
 *     Include AP_POLLPRI for normal data read before APLI Spec defines it.
 *     Expedited event is not supported at this point.
 *     Do not include AP_POLLPRI in AP_POLLRDBAND to avoid mistaking
 *     AP_POLLPRI/AP_POLLIN/AP_POLLRDNORM as AP_POLLRDBAND event.
 */
#define AP_POLLIN	(0x0001|AP_POLLPRI)	/* fd is readable */
#define AP_POLLPRI	0x0002			/* hi priority data readable */
#define	AP_POLLOUT	0x0004			/* fd writeable (won't block) */
#define AP_POLLRDNORM	(0x4000|AP_POLLPRI)	/* normal data is readable */
#define AP_POLLWRNORM	AP_POLLOUT
#define AP_POLLRDBAND	0x0080			/* out-of-band data readable */
#define AP_POLLWRBAND	0x100			/* out-of-band data writeable */

/*
 * Timeout constant
 */
#define AP_INFTIM	-1		/* infinite timeout */
#ifdef  __cplusplus
}
#endif
#endif /* _AP_POLL */
