/*
 *         Copyright (c) 1992 MARBEN Produit.
 *                  All Rights Reserved
 *
 *         Copyright (c)  Hewlett-Packard Company 1989,1990,1991
 *
 *
 *  PRODUCT  :  APLI
 *
 *  AUTHORS  :  OSIAM-STREAMS GROUP
 *
 *  COMPONENT:  Application Library
 *
 *  ABSTRACT :  Constant definitions and data structures for A/P Library,
 * 		environment attributes and cdata parameters.
 *
 *  FILENAME :  apli/incl/ap_lib.h
 *
 *  COMMENTS :  --------------------
 *
 * =========================================================================== *
 * HISTORY TRACE                                  Starting file ref: 18-Aug-92 *
 *                                                                             *
 *  Notice : all modifications must be traced hereafter. The modified source   *
 *  lines must be referenced by bug number (BUG #001).                         *
 *                                                                             *
 * --------------------------------------------------------------------------- *
 * Prod. | Bug   | Modif.  | by     | summary                                  *
 * Vers. | Number| Date    |        |                                          *
 * ------+-------+---------+--------+----------------------------------------- *
 * 01.10 | ----  |18-Aug-92| gc     |-Created in MARBEN PRODUIT format.        *
 * ------+-------+---------+--------+----------------------------------------- *
 *       |       |         |        |                                          *
 * 01.20 | ----  |22-Dec-92| psh    |-Support of the basic concatenation       *
 *       |       |         |        | concerning tokens concatened to the      *
 *       |       |         |        | P_DATA_REQ primitive. This evolution     *
 *       |       |         |        | follows the XAP normalization but keeps  *
 *       |       |         |        | compatible with the APLI one.            *
 * ------+-------+---------+--------+----------------------------------------- *
 */


/*
 *	ap_lib.h -
 */

#ifdef  __cplusplus
extern "C" {
#endif/*
 *	Constant definitions and data structures for ACSE/Presentation
 *      Library environment attributes and cdata parameters.
 */

/*
 *	APLI Constants
 */

/*
 *	Primitives
 */


/* 
 *	Define all the PRES primitives 
 */

#define PRES_WRITESIDE		(1 << 8)
#define PRES_READSIDE		(3 << 8)
#define PRES_MASK		(PRES_ID << 16)
#define P_RESYNC_REQ		(PRES_MASK | PRES_WRITESIDE | 0x5)
#define P_RESYNC_RSP		(PRES_MASK | PRES_WRITESIDE | 0x6)
#define P_RELEASE_REQ		(PRES_MASK | PRES_WRITESIDE | 0x7)
#define P_RELEASE_RSP		(PRES_MASK | PRES_WRITESIDE | 0x8)
#define P_DATA_REQ		(PRES_MASK | PRES_WRITESIDE | 0x9)
#define P_TDATA_REQ		(PRES_MASK | PRES_WRITESIDE | 0xa)
#define P_XDATA_REQ		(PRES_MASK | PRES_WRITESIDE | 0xb)
#define P_TOKENGIVE_REQ		(PRES_MASK | PRES_WRITESIDE | 0xf)
#define P_TOKENPLEASE_REQ	(PRES_MASK | PRES_WRITESIDE | 0x10)
#define P_CTRLGIVE_REQ		(PRES_MASK | PRES_WRITESIDE | 0x11)
#define P_SYNCMINOR_REQ		(PRES_MASK | PRES_WRITESIDE | 0x13)
#define P_SYNCMAJOR_REQ		(PRES_MASK | PRES_WRITESIDE | 0x14)
#define P_SYNCMINOR_RSP		(PRES_MASK | PRES_WRITESIDE | 0x15)
#define P_SYNCMAJOR_RSP		(PRES_MASK | PRES_WRITESIDE | 0x16)
#define P_ACTSTART_REQ		(PRES_MASK | PRES_WRITESIDE | 0x17)
#define P_ACTRESUME_REQ		(PRES_MASK | PRES_WRITESIDE | 0x18)
#define P_ACTINTR_REQ		(PRES_MASK | PRES_WRITESIDE | 0x19)
#define P_ACTINTR_RSP		(PRES_MASK | PRES_WRITESIDE | 0x1a)
#define P_ACTDISCARD_REQ	(PRES_MASK | PRES_WRITESIDE | 0x1b)
#define P_ACTDISCARD_RSP	(PRES_MASK | PRES_WRITESIDE | 0x1c)
#define P_ACTEND_REQ		(PRES_MASK | PRES_WRITESIDE | 0x1d)
#define P_ACTEND_RSP		(PRES_MASK | PRES_WRITESIDE | 0x1e)
#define P_UXREPORT_REQ		(PRES_MASK | PRES_WRITESIDE | 0x1f)
#define P_RESYNC_IND		(PRES_MASK | PRES_READSIDE | 0x5)
#define P_RESYNC_CNF		(PRES_MASK | PRES_READSIDE | 0x6)
#define P_RELEASE_IND		(PRES_MASK | PRES_READSIDE | 0x7)
#define P_RELEASE_CNF		(PRES_MASK | PRES_READSIDE | 0x8)
#define P_DATA_IND		(PRES_MASK | PRES_READSIDE | 0x9)
#define P_TDATA_IND		(PRES_MASK | PRES_READSIDE | 0xa)
#define P_XDATA_IND		(PRES_MASK | PRES_READSIDE | 0xb)
#define P_TOKENGIVE_IND		(PRES_MASK | PRES_READSIDE | 0x12)
#define P_TOKENPLEASE_IND	(PRES_MASK | PRES_READSIDE | 0x13)
#define P_CTRLGIVE_IND		(PRES_MASK | PRES_READSIDE | 0x14)
#define P_SYNCMINOR_IND		(PRES_MASK | PRES_READSIDE | 0x17)
#define P_SYNCMAJOR_IND		(PRES_MASK | PRES_READSIDE | 0x18)
#define P_SYNCMINOR_CNF		(PRES_MASK | PRES_READSIDE | 0x1a)
#define P_SYNCMAJOR_CNF		(PRES_MASK | PRES_READSIDE | 0x1b)
#define P_ACTSTART_IND		(PRES_MASK | PRES_READSIDE | 0x1c)
#define P_ACTRESUME_IND		(PRES_MASK | PRES_READSIDE | 0x1d)
#define P_ACTINTR_IND		(PRES_MASK | PRES_READSIDE | 0x1e)
#define P_ACTINTR_CNF		(PRES_MASK | PRES_READSIDE | 0x1f)
#define P_ACTDISCARD_IND	(PRES_MASK | PRES_READSIDE | 0x20)
#define P_ACTDISCARD_CNF	(PRES_MASK | PRES_READSIDE | 0x21)
#define P_ACTEND_IND		(PRES_MASK | PRES_READSIDE | 0x22)
#define P_ACTEND_CNF		(PRES_MASK | PRES_READSIDE | 0x23)
#define P_UXREPORT_IND		(PRES_MASK | PRES_READSIDE | 0x24)
#define P_PXREPORT_IND		(PRES_MASK | PRES_READSIDE | 0x25)


/* 
 *	Define all the ACSE primitives 
 */

#define ACSE_WRITESIDE		(1 << 8)
#define ACSE_READSIDE		(3 << 8)
#define ACSE_MASK		(ACSE_ID << 16)
#define A_ASSOC_REQ		(ACSE_MASK | ACSE_WRITESIDE | 0x0)
#define A_ASSOC_RSP		(ACSE_MASK | ACSE_WRITESIDE | 0x1)
#define A_RELEASE_REQ		(ACSE_MASK | ACSE_WRITESIDE | 0x2)
#define A_RELEASE_RSP		(ACSE_MASK | ACSE_WRITESIDE | 0x3)
#define A_ABORT_REQ		(ACSE_MASK | ACSE_WRITESIDE | 0x4)
#define A_PABORT_REQ		(ACSE_MASK | ACSE_WRITESIDE | 0x7)
#define A_ASSOC_IND		(ACSE_MASK | ACSE_READSIDE | 0x0)
#define A_ASSOC_CNF		(ACSE_MASK | ACSE_READSIDE | 0x1)
#define A_RELEASE_IND		(ACSE_MASK | ACSE_READSIDE | 0x2)
#define A_RELEASE_CNF		(ACSE_MASK | ACSE_READSIDE | 0x3)
#define A_ABORT_IND		(ACSE_MASK | ACSE_READSIDE | 0x4)
#define A_REBIND_IND		(ACSE_MASK | ACSE_READSIDE | 0x6)
#define A_PABORT_IND		(ACSE_MASK | ACSE_READSIDE | 0x8)

/* ===================================================================== */

/* 
 *	Definitions of environment attribute #defines 
 */

#define AP_LIB_AVAIL			((AP_ID << 16) | 0x1)
#define AP_LIB_SEL			((AP_ID << 16) | 0x2)
#define AP_ACSE_AVAIL			((AP_ID << 16) | 0x3)
#define AP_ACSE_SEL			((AP_ID << 16) | 0x4)
#define AP_ROLE_ALLOWED			((AP_ID << 16) | 0x5)
#define AP_CNTX_NAME			((AP_ID << 16) | 0x6)
#define AP_BIND_PADDR			((AP_ID << 16) | 0x7)
#define AP_CLD_AEID			((AP_ID << 16) | 0x8)
#define AP_CLD_AEQ			((AP_ID << 16) | 0x9)
#define AP_CLD_APID			((AP_ID << 16) | 0xa)
#define AP_CLD_APT			((AP_ID << 16) | 0xb)
#define AP_CLG_AEID			((AP_ID << 16) | 0xc)
#define AP_CLG_AEQ			((AP_ID << 16) | 0xd)
#define AP_CLG_APID			((AP_ID << 16) | 0xe)
#define AP_CLG_APT			((AP_ID << 16) | 0xf)
#define AP_DPCN				((AP_ID << 16) | 0x10)
#define AP_DPCR				((AP_ID << 16) | 0x11)
#define AP_DCS				((AP_ID << 16) | 0x12)
#define AP_LCL_PADDR			((AP_ID << 16) | 0x13)
#define AP_MODE_AVAIL			((AP_ID << 16) | 0x14)
#define AP_MODE_SEL			((AP_ID << 16) | 0x15)
#define AP_PCDL				((AP_ID << 16) | 0x16)
#define AP_PCDRL			((AP_ID << 16) | 0x17)
#define AP_PFU_AVAIL			((AP_ID << 16) | 0x18)
#define AP_PFU_SEL			((AP_ID << 16) | 0x19)
#define AP_PRES_AVAIL			((AP_ID << 16) | 0x1a)
#define AP_PRES_SEL			((AP_ID << 16) | 0x1b)
#define AP_REM_PADDR			((AP_ID << 16) | 0x1c)
#define AP_RSP_AEID			((AP_ID << 16) | 0x1d)
#define AP_RSP_AEQ			((AP_ID << 16) | 0x1e)
#define AP_RSP_APID			((AP_ID << 16) | 0x1f)
#define AP_RSP_APT			((AP_ID << 16) | 0x20)
#define AP_ROLE_CURRENT			((AP_ID << 16) | 0x21)
#define AP_SESS_AVAIL			((AP_ID << 16) | 0x22)
#define AP_SESS_SEL			((AP_ID << 16) | 0x23)
#define AP_INIT_SYNC_PT			((AP_ID << 16) | 0x25)
#define AP_SFU_AVAIL			((AP_ID << 16) | 0x2a)
#define AP_SFU_SEL			((AP_ID << 16) | 0x2b)
#define AP_STATE			((AP_ID << 16) | 0x2c)
#define AP_STREAM_FLAGS			((AP_ID << 16) | 0x2d)
#define AP_TOKENS_AVAIL			((AP_ID << 16) | 0x2e)
#define AP_TOKENS_OWNED			((AP_ID << 16) | 0x2f)
#define AP_MSTATE			((AP_ID << 16) | 0x30)
#define AP_CLG_CONN_ID			((AP_ID << 16) | 0x31)
#define AP_CLD_CONN_ID			((AP_ID << 16) | 0x32)
#define AP_SESS_OPT_AVAIL		((AP_ID << 16) | 0x4b)
#define AP_QOS				((AP_ID << 16) | 0x4c)

/* env attrs not supported */
#define AP_QLEN				((AP_ID << 16) | 0x4d)


/*
 *	Distinguished values for environment attributes
 */

/* AP_LIB_AVAIL AP_LIB_SEL */
#define AP_LIBVER1		(1)

/* AP_ACSE_AVAIL AP_ACSE_SEL */
#define AP_ACSEVER1		(BITL(0))

/* AP_ROLE_ALLOWED AP_ROLE_CURRENT */
#define AP_INITIATOR		(1)
#define AP_RESPONDER		(2)

/* AP_CLD_AEID */
#define AP_CLD_AEID_NOVAL	(-2147483647)

/* AP_CLD_APID */
#define AP_CLD_APID_NOVAL	(-2147483647)

/* AP_CLG_AEID */
#define AP_CLG_AEID_NOVAL	(-2147483647)

/* AP_CLG_APID */
#define AP_CLG_APID_NOVAL	(-2147483647)

/* AP_DPCR */
#define AP_DPCR_NOVAL		(-2147483647)
#define AP_USER_REJ		(1)
#define AP_PROV_REJ		(2)

/* AP_MODE_AVAIL AP_MODE_SEL */
#define AP_NORMAL_MODE		(1)
#define AP_X410_MODE		(0)

/* AP_PRES_AVAIL AP_PRES_SEL */
#define AP_PRESVER1		(BITL(0))

/*AP_RSP_AEID */
#define AP_RSP_AEID_NOVAL	(-2147483647)

/*AP_RSP_APID */
#define AP_RSP_APID_NOVAL	((-2147483647))

/* AP_SESS_AVAIL AP_SESS_SEL */
#define AP_SESSVER1		(BITL(0))
#define AP_SESSVER2		(BITL(1))

/* AP_SFU_AVAIL/SEL */
#define AP_SESS_HALFDUPLEX	(BITL(0))
#define AP_SESS_DUPLEX		(BITL(1))
#define AP_SESS_XDATA		(BITL(2))
#define AP_SESS_MINORSYNC	(BITL(3))
#define AP_SESS_MAJORSYNC	(BITL(4))
#define AP_SESS_RESYNC		(BITL(5))
#define AP_SESS_ACTMGMT		(BITL(6))
#define AP_SESS_NEGREL 		(BITL(7))
#define AP_SESS_CDATA		(BITL(8))
#define AP_SESS_EXCEPT		(BITL(9))
#define AP_SESS_TDATA		(BITL(10))

/* AP_STATE */
#define AP_UNBOUND		(0x00)
#define AP_IDLE			(0x03)
#define AP_WASSOCcnf_ASSOCreq	(0x04)
#define AP_WASSOCrsp_ASSOCind	(0x05)
#define AP_DATAXFER		(0x07)
#define AP_WRELcnf_RELreq	(0x09)
#define AP_WRELrsp_RELind	(0x0a)
#define AP_WRELrsp_RELind_init	(0x0b)
#define AP_WRELcnf_RELreq_rsp	(0x0b)
#define AP_WRSYNcnf_RSYNreq	(0x0f)
#define AP_WRSYNrsp_RSYNind	(0x10)
#define AP_WSYNCMArsp_SYNCMAind	(0x15)
#define AP_WSYNCMAcnf_SYNCMAreq	(0x16)
#define AP_WACTErsp_ACTEind	(0x17)
#define AP_WACTEcnf_ACTEreq	(0x18)
#define AP_WACTIrsp_ACTIind	(0x19)
#define AP_WACTIcnf_ACTIreq	(0x1A)
#define AP_WACTDrsp_ACTDind	(0x1B)
#define AP_WACTDcnf_ACTDreq	(0x1C)
#define AP_WRECOVERYind		(0x1F)
#define AP_WRECOVERYreq		(0x1E)
#define AP_WCDATArsp_CDATAind	(0x1F)
#define AP_WCDATAcnf_CDATAreq	(0x20)

/* AP_MSTATE */
#define AP_SNDMORE		(0x1)
#define AP_RCVMORE		(0x2)

/* AP_STREAM_FLAGS */
#define AP_HUP_ONABORT		(0x1)
#define AP_NDELAY		(0x2)
#define AP_PEEK			(0x4)

/* AP_TOKENS_AVAIL/OWNED */
#define AP_DATA_TOK		(0x01)
#define AP_SYNCMINOR_TOK	(0x04)
#define AP_MAJACT_TOK		(0x10)  /* 7/30/91: orig 0x08, std 0x10 */
#define AP_RELEASE_TOK		(0x40)  /* 7/30/91: added */

/* AP_SESS_OPT_AVAIL */
#define AP_UCBC			(1)
#define AP_UCEC			(2)

/* AP_INIT_SYNC_PT */
#define AP_MIN_SYNCP		(0)
#define AP_MAX_SYNCP		(999999)

/* AP_QOS - priority */
#define AP_PRILOW		(3)
#define AP_PRIMID		(2)
#define AP_PRIHIGH		(1)
#define AP_PRITOP		(0)
#define AP_PRIDFLT		AP_PRILOW


/*
 * 	Define constants used in cdata 
 */


/*
 *	Distinguished values for 'tokens' field 
 *	(a_assoc_???_cd_t, p_resync_???_cd_t)
 */

#define AP_DATA_TOK_REQ		(0x0000)
#define AP_DATA_TOK_ACPT	(0x0001)
#define AP_DATA_TOK_CHOICE	(0x0002)

#define AP_SYNCMINOR_TOK_REQ	(0x0000)
#define AP_SYNCMINOR_TOK_ACPT	(0x0004)
#define AP_SYNCMINOR_TOK_CHOICE	(0x0008)

#define AP_MAJACT_TOK_REQ	(0x0000)
#define AP_MAJACT_TOK_ACPT	(0x0010)
#define AP_MAJACT_TOK_CHOICE	(0x0020)

#define AP_RELEASE_TOK_REQ	(0x0000)
#define AP_RELEASE_TOK_ACPT	(0x0040)
#define AP_RELEASE_TOK_CHOICE	(0x0080)


/*
 *	Distinguished values for 'res' field 
 *	(a_assoc_[rsp|cnf]_cd_t)
 */

#define AP_ACCEPT		(0)
#define AP_REJ_PERM		(1)
#define AP_REJ_TRAN		(2)

/*
 *	Distinguished values for 'res_src' field 
 *	(a_assoc_cnf_cd_t)
 */

#define AP_ACSE_SERV_USER	(0)
#define AP_ACSE_SERV_PROV	(1)
#define AP_PRES_SERV_PROV	(2)
#define AP_SESS_SERV_PROV	(3)
#define AP_TRAN_SERV_PROV	(4)

/*
 *	Distinguished values for 'diag' field 
 *	(a_assoc_[rsp|cnf]_cd_t)
 */

	/* AP_ACSE_SERV_USER */

#define AP_DIAG_NOVAL		(-2147483647)
#define AP_NULL			(0)
#define AP_NRSN			(1)
#define AP_CNTX_NAME_NSUP	(2)
#define AP_CLG_APT_NREC		(3)
#define AP_CLG_APID_NREC	(4)
#define AP_CLG_AEQ_NREC		(5)
#define AP_CLG_AEID_NREC	(6)
#define AP_CLD_APT_NREC		(7)
#define AP_CLD_APID_NREC	(8)
#define AP_CLD_AEQ_NREC		(9)
#define AP_CLD_AEID_NREC	(10)

	/* AP_ACSE_SERV_PROV */

#define AP_NCMN_ACSE_VER	(2)

	/* AP_PRES_SERV_PROV */

#define AP_PROV_NRSN		((0)+100)
#define AP_TEMP_CONGESTION	((1)+100)
#define AP_LCL_LIM_EXCEEDED	((2)+100)
#define AP_CLD_PADDR_UNK	((3)+100)
#define AP_PRES_VER_NSUP	((4)+100)
#define AP_DFCN_NSUP		((5)+100)
#define AP_UDATA_NREAD		((6)+100)
#define AP_NO_PSAP_AVAIL	((7)+100)
#define AP_SESS_PROV		((1000)+100)

	/* AP_SESS_SERV_PROV */

#define AP_CLD_SADDR_UNK	((128)+1)
#define AP_SSUSER_NATT		((128)+2)
#define AP_SPM_CONGESTION	((128)+3)
#define AP_SESS_VER_NSUP	((128)+4)
#define AP_SESS_PICS_ERROR	((128)+6)
#define AP_TRAN_PROV		((256)+1)

	/* AP_TRAN_SERV_PROV */

#define AP_TRAN_NRSN		(0)
#define AP_TSAP_CONGESTION	(1)
#define AP_TSUSER_NATT		(2)
#define AP_CLD_TADDR_UNK	(3)
#define AP_NORMDISCON		(128)
#define AP_TE_CONGESTION	((128)+1)
#define AP_TRAN_NEGFAIL		((128)+2)
#define AP_DUPSRCREF		((128)+3)
#define AP_MISMATCHREF		((128)+4)
#define AP_TRAN_PERROR		((128)+5)
#define AP_REFOVERFLOW		((128)+7)
#define AP_REFONNETCON		((128)+8)
#define AP_HPLENINV		((128)+10)


/*
 *	Distinguished values for 'rsn' field 
 *	(a_pabort_[req|ind]_cd_t)
 */

	/* AP_PRES_SERV_PROV */

#define AP_RSN_NOVAL		(-2147483647)
#define AP_NSPEC		(0)
#define AP_UNREC_PPDU		(1)
#define AP_UNEXPT_PPDU		(2)
#define AP_UNEXPT_SSPRIM	(3)
#define AP_UNREC_PPDU_PARM	(4)
#define AP_UNEXPT_PPDU_PARM	(5)
#define AP_INVAL_PPDU_PARM	(6)

	/* AP_SESS_SERV_PROV */

#define AP_SESS_TDISCON		(1)
#define AP_SESS_PERROR		(5)
#define AP_SESS_UNDEFINED	(9)
#define AP_SESS_PICS_ABORT 	(17)

/*
 *	Distinguished values for 'evt' field 
 *	(a_pabort_[req|ind]_cd_t)
 */

#define AP_EVT_NOVAL		(-2147483647)
#define AP_PEI_CP		(0)
#define AP_PEI_CPA		(1)
#define AP_PEI_CPR		(2)
#define AP_PEI_ARU		(3)
#define AP_PEI_ARP		(4)
#define AP_PEI_TD		(7)
#define AP_PEI_TTD		(8)
#define AP_PEI_TE		(9)
#define AP_PEI_TC		(10)
#define AP_PEI_TCC		(11)
#define AP_PEI_RS		(12)
#define AP_PEI_RSA		(13)
#define AP_PEI_S_RELEASE_IND	(14)
#define AP_PEI_S_RELEASE_CNF	(15)
#define AP_PEI_S_TOKENGIVE_IND	(16)
#define AP_PEI_S_TOKENPLEASE_IND	(17)
#define AP_PEI_S_CTRLGIVE_IND	(18)
#define AP_PEI_S_SYNCMINOR_IND	(19)
#define AP_PEI_S_SYNCMINOR_CNF	(20)
#define AP_PEI_S_SYNCMAJOR_IND	(21)
#define AP_PEI_S_SYNCMAJOR_CNF	(22)
#define AP_PEI_S_P_EXCEPT_REP_IND	(23)
#define AP_PEI_S_U_EXCEPT_REP_IND	(24)
#define AP_PEI_S_ACT_START_IND	(25)
#define AP_PEI_S_ACT_RESUME_IND	(26)
#define AP_PEI_S_ACT_INT_IND	(27)
#define AP_PEI_S_ACT_INT_CNF	(28)
#define AP_PEI_S_ACT_DISC_IND	(29)
#define AP_PEI_S_ACT_DISC_CNF	(30)
#define AP_PEI_S_ACT_END_IND	(31)
#define AP_PEI_S_ACT_END_CNF	(32)


/*
 *	Distinguished values for 'rsn' field 
 *	(a_release_[req|ind]_cd_t)
 */

#define AP_REL_NORMAL		(0)
#define AP_REL_URGENT		(1)
#define AP_REL_USER_DEF		(30)


/*
 *	Distinguished values for 'res' field 
 *	(a_release_[rsp|cnf]_cd_t)
 */

#define AP_REL_NEGATIVE		(0)	
#define AP_REL_AFFIRM		(1)


/*
 *	Distinguished values for 'rsn' field 
 *	(a_release_[rsp|cnf]_cd_t)
 */

#define AP_REL_NOTFINISHED	(1)


/*
 *	Distinguished values for 'resync_type' field 
 *	(p_resync_[req|ind]_cd_t)
 */

#define AP_RESTART		(0)
#define AP_ABANDON		(1)
#define AP_SET			(2)


/*
 *	Distinguished values for 'sync_type' field 
 *	(p_syncminor_[req|ind]_cd_t)
 */

#define AP_EXPLICIT		(0)
#define AP_OPTIONAL		(1)


/*
 *	Distinguished values for 'rsn' field 
 *	(p_actdiscard_[req|ind]_cd_t, p_actintr_[req|ind]_cd_t)
 */

#define AP_NSPEC_ERR		(0)
#define AP_RCV_ABILITY_JEOP	(1)
#define AP_SEQ_ERR		(3)
#define AP_LCL_USER_ERR		(5)
#define AP_UNRCVR_PROC_ERR	(6)
#define AP_DEMAND_DT_TOK	(128)


/*
 *	Distinguished values for 'src' field 
 *	(a_abort_ind_cd_t)
 */

#define AP_ACSE_USER		(0)
#define AP_ACSE_PROV		(1)
#define AP_SRC_NOVAL		(-2147483647)


/* 
 * 	Define constants for 'flags' argument to ap_snd() & ap_rcv()
 */

#define AP_MORE		(0x1)
#define AP_DELAY	(0x2)
#define AP_CLEAR	(0x4)


/*
 *	APLI Data Structures
 */

/* 
 *	Environment data structures 
 */

/*
 * 	Object Identifier structure
 */

#define	MAXOBJBUF		12
#define	CK_OBJ_NULL(O)		((O)->length ? 0 : 1)
#define	SET_OBJ_NULL(O)		((O)->length = 0)

typedef struct {
        long length;
        union {
                char *long_buf;
                char short_buf[MAXOBJBUF];
        } b;
} objid_t;

/* AP_PCDL */
typedef struct  {
	int	size_ap_cdl;
	struct seqof_ap_cdl {
		long	pci;
		objid_t	*a_sytx;
		int	size_t_sytx;
		objid_t	**m_t_sytx;
	} *m_ap_cdl;
} ap_cdl_t;


/* AP_DCN */
typedef struct seq_ap_dcn {
	objid_t	*a_sytx;
	objid_t	*t_sytx;
} ap_dcn_t;


/* AP_PCDRL */
/* AP_PCDRL.res */
#define ACCPT			(0)
#define USER_REJ		(1)
#define PROV_REJ		(2)

/* AP_PCDRL.prov_rsn */
#define RSN_NSPEC		(0)
#define A_SYTX_NSUP		(1)
#define PROP_T_SYTX_NSUP	(2)
#define LCL_LMT_DCS_EXCEEDED	(3)

typedef struct  {
	int	size_ap_cdrl;
	struct seqof_ap_cdrl {
		long	res;
		objid_t	*t_sytx;
		long	prov_rsn;
	} *m_ap_cdrl;
} ap_cdrl_t;


typedef struct  {
	long	length;
	unsigned char	* data;
} ap_octet_string_t;


/* AP_BIND_PADDR, AP_LCL_PADDR, AP_REM_PADDR */
typedef struct  {
	ap_octet_string_t	*p_selector;
	ap_octet_string_t	*s_selector;
	ap_octet_string_t	*t_selector;
	int	n_nsaps;
	ap_octet_string_t	*nsaps;
} ap_paddr_t;


/* AP_DCS */
typedef struct  {
	int	size;
	struct dcs_elt {
		int	pci;
		objid_t	*a_sytx;
		objid_t	*t_sytx;
	} *dcs;
} ap_dcs_t;


typedef struct  {
	/* ap_octet_string_t	*clg_ref; */
	ap_octet_string_t	*user_ref;
	ap_octet_string_t	*comm_ref;
	ap_octet_string_t	*addtl_ref;
	/* ap_octet_string_t	*cld_ref; */
} ap_conn_id_t;


/* AP_CLG_CONN_ID */
typedef struct  {
	ap_octet_string_t	*clg_ref;
	ap_octet_string_t	*comm_ref;
	ap_octet_string_t	*addtl_ref;
} ap_clg_conn_id_t;


/* AP_CLD_CONN_ID */
typedef struct  {
	ap_octet_string_t	*comm_ref;
	ap_octet_string_t	*addtl_ref;
	ap_octet_string_t	*cld_ref;
} ap_cld_conn_id_t;


/* AP_QOS */
typedef struct  {
	int	priority;
} ap_qos_t;


/*
 * Cdata type definitions
 */

typedef struct  {
	unsigned long	 tokens;
	long	udata_length;
} a_assoc_req_cd_t;

typedef a_assoc_req_cd_t	a_assoc_ind_cd_t;

typedef struct  {
	long	res;
	long	diag;
	unsigned long	 tokens;
	long	udata_length;
} a_assoc_rsp_cd_t;

typedef struct  {
	long	res;
	long	res_src;
	long	diag;
	unsigned long	 tokens;
	long	udata_length;
} a_assoc_cnf_cd_t;

typedef struct  {
	long	rsn;
	long	udata_length;
} a_release_req_cd_t;

typedef a_release_req_cd_t	a_release_ind_cd_t;

typedef struct  {
	long	res;
	long	rsn;
	long	udata_length;
} a_release_rsp_cd_t;

typedef a_release_rsp_cd_t	a_release_cnf_cd_t;

typedef struct  {
	long	udata_length;
} a_abort_req_cd_t;

typedef struct  {
	long	src;
	long	udata_length;
} a_abort_ind_cd_t;

typedef struct  {
	long	rsn;
	long	evt;
} a_pabort_req_cd_t;

typedef struct  {
	long	rsn;
	long	evt;
	long	src;
} a_pabort_ind_cd_t;

typedef struct  {
	long	sync_type;
	long	udata_length;
} p_syncminor_req_cd_t;

typedef struct  {
	long	sync_type;
	long	sync_p_sn;
	long	udata_length;
} p_syncminor_ind_cd_t;

typedef struct  {
	long	sync_p_sn;
	long	udata_length;
} p_syncminor_rsp_cd_t;

typedef p_syncminor_rsp_cd_t	p_syncminor_cnf_cd_t;

typedef struct  {
	long	resync_type;
	long	sync_p_sn;
	unsigned long	 tokens;
	long	udata_length;
} p_resync_req_cd_t;

typedef p_resync_req_cd_t	p_resync_ind_cd_t;

typedef struct  {
	long	sync_p_sn;
	unsigned long	 tokens;
	long	udata_length;
} p_resync_rsp_cd_t;

typedef p_resync_rsp_cd_t	p_resync_cnf_cd_t;

typedef struct  {
	unsigned long	 tokens;
	long	udata_length;
} p_tokengive_req_cd_t;

typedef p_tokengive_req_cd_t	p_tokengive_ind_cd_t;

typedef struct  {
	unsigned long	 tokens;
	long	udata_length;
} p_tokenplease_req_cd_t;

typedef p_tokenplease_req_cd_t	p_tokenplease_ind_cd_t;

typedef struct  {
	long	udata_length;
} p_syncmajor_req_cd_t;

typedef struct  {
	long	sync_p_sn;
	long	udata_length;
} p_syncmajor_ind_cd_t;

typedef p_syncmajor_req_cd_t	p_syncmajor_rsp_cd_t;

typedef p_syncmajor_req_cd_t	p_syncmajor_cnf_cd_t;

typedef p_syncmajor_ind_cd_t	p_actend_ind_cd_t;

typedef struct  {
	ap_octet_string_t	act_id;
	long	udata_length;
} p_actstart_req_cd_t;

typedef p_actstart_req_cd_t	p_actstart_ind_cd_t;

typedef struct  {
	ap_octet_string_t	act_id;
	ap_octet_string_t	old_act_id;
	long	sync_p_sn;
	ap_conn_id_t	*old_conn_id;
	long	udata_length;
} p_actresume_req_cd_t;

typedef p_actresume_req_cd_t	p_actresume_ind_cd_t;

typedef struct  {
	long	rsn;
	long	udata_length;
} p_actintr_req_cd_t;

typedef p_actintr_req_cd_t	p_actintr_ind_cd_t;

typedef p_actintr_req_cd_t	p_actdiscard_req_cd_t;

typedef p_actintr_req_cd_t	p_actdiscard_ind_cd_t;

typedef p_actintr_req_cd_t	p_uxreport_req_cd_t;

typedef p_actintr_req_cd_t	p_uxreport_ind_cd_t;

typedef struct  {
	long	udata_length;
} p_actintr_rsp_cd_t;

typedef p_actintr_rsp_cd_t	p_actintr_cnf_cd_t;

typedef p_actintr_rsp_cd_t	p_actdiscard_rsp_cd_t;

typedef p_actintr_rsp_cd_t	p_actdiscard_cnf_cd_t;

typedef p_actintr_rsp_cd_t	p_actend_req_cd_t;

typedef p_actintr_rsp_cd_t	p_actend_rsp_cd_t;

typedef p_actintr_rsp_cd_t	p_actend_cnf_cd_t;

typedef p_actintr_rsp_cd_t	p_ctrlgive_req_cd_t;

typedef p_actintr_rsp_cd_t	p_ctrlgive_ind_cd_t;

typedef struct  {
	long	rsn;
} p_pxreport_ind_cd_t;

/* 22-Dec-92: add p_data_req_cd_t type */
typedef struct  {
	unsigned long	 tokens;
} p_data_req_cd_t;
/* End 22-Dec-92 */


/* Union of all the CDATA's */

typedef union {
	a_assoc_req_cd_t	assoc_req;
	a_assoc_ind_cd_t	assoc_ind;
	a_assoc_rsp_cd_t	assoc_rsp;
	a_assoc_cnf_cd_t	assoc_cnf;
	a_abort_req_cd_t	abort_req;
	a_abort_ind_cd_t	abort_ind;
	a_pabort_req_cd_t	pabort_req;
	a_pabort_ind_cd_t	pabort_ind;
	a_release_req_cd_t	release_req;
	a_release_ind_cd_t	release_ind;
	a_release_rsp_cd_t	release_rsp;
	a_release_cnf_cd_t	release_cnf;
/* 22-Dec-92: add data_req part to cdata union */
	p_data_req_cd_t		data_req;
/* End 22-Dec-92 */
	p_tokengive_req_cd_t	tokengive_req;
	p_tokengive_ind_cd_t	tokengive_ind;
	p_tokenplease_req_cd_t	tokenplease_req;
	p_tokenplease_ind_cd_t	tokenplease_ind;
	p_resync_req_cd_t	resync_req;
	p_resync_ind_cd_t	resync_ind;
	p_resync_rsp_cd_t	resync_rsp;
	p_resync_cnf_cd_t	resync_cnf;
	p_syncminor_req_cd_t	syncminor_req;
	p_syncminor_ind_cd_t	syncminor_ind;
	p_syncminor_rsp_cd_t	syncminor_rsp;
	p_syncminor_cnf_cd_t	syncminor_cnf;
	p_syncmajor_req_cd_t	syncmajor_req;
	p_syncmajor_ind_cd_t	syncmajor_ind;
	p_syncmajor_rsp_cd_t	syncmajor_rsp;
	p_syncmajor_cnf_cd_t	syncmajor_cnf;
	p_actstart_req_cd_t	actstart_req;
	p_actstart_ind_cd_t	actstart_ind;
	p_actresume_req_cd_t	actresume_req;
	p_actresume_ind_cd_t	actresume_ind;
	p_actintr_req_cd_t	actintr_req;
	p_actintr_ind_cd_t	actintr_ind;
	p_actintr_rsp_cd_t	actintr_rsp;
	p_actintr_cnf_cd_t	actintr_cnf;
	p_actdiscard_req_cd_t	actdiscard_req;
	p_actdiscard_ind_cd_t	actdiscard_ind;
	p_actdiscard_rsp_cd_t	actdiscard_rsp;
	p_actdiscard_cnf_cd_t	actdiscard_cnf;
	p_actend_req_cd_t	actend_req;
	p_actend_ind_cd_t	actend_ind;
	p_actend_rsp_cd_t	actend_rsp;
	p_actend_cnf_cd_t	actend_cnf;
	p_ctrlgive_req_cd_t	ctrlgive_req;
	p_ctrlgive_ind_cd_t	ctrlgive_ind;
	p_uxreport_req_cd_t	uxreport_req;
	p_uxreport_ind_cd_t	uxreport_ind;
	p_pxreport_ind_cd_t	pxreport_ind;
} ap_cdata_t;


/* 
 * 	ap_val_t union for 'val' argument to ap_set_env() 
 */

typedef union {
	long l;
	void *v;
} ap_val_t;


/*###########################################################################*/
/*
 *	ap_err.h -
 * 	Error codes for the ACSE/Presentation Library Interface
 */
#ifndef _AP_ERR
#define _AP_ERR

#define AP_NOERROR		ERRNO(AP_ID, (0))
#define AP_BADLSTATE		ERRNO(AP_ID, (1))
#define AP_BADUBUF		ERRNO(AP_ID, (2))
#define AP_BADPRIM		ERRNO(AP_ID, (3))
#define AP_HANGUP		ERRNO(AP_ID, (4))
#define AP_AGAIN		ERRNO(AP_ID, (5))
#define AP_NOENV		ERRNO(AP_ID, (6))
#define AP_BADF			ERRNO(AP_ID, (7))
#define AP_NOMEM		ERRNO(AP_ID, (8))
#define AP_BADFREE		ERRNO(AP_ID, (9))
#define AP_BADATTRVAL		ERRNO(AP_ID, (10))
#define AP_NOWRITE		ERRNO(AP_ID, (11))
#define AP_NOATTR		ERRNO(AP_ID, (12))
#define AP_NOREAD		ERRNO(AP_ID, (13))
#define AP_BADCD_TOKENS		ERRNO(AP_ID, (14))
#define AP_BADCD_RES		ERRNO(AP_ID, (15))
#define AP_BADCD_DIAG		ERRNO(AP_ID, (16))
#define AP_BADCD_RES_SRC	ERRNO(AP_ID, (17))
#define AP_BADCD_RSN		ERRNO(AP_ID, (18))
#define AP_BADCD_EVT		ERRNO(AP_ID, (19))
#define AP_BADCD_PABORT_IND	ERRNO(AP_ID, (20))
#define AP_BADCD_SRC		ERRNO(AP_ID, (21))
#define AP_BADCD_RESYNC_TYPE	ERRNO(AP_ID, (22))
#define AP_BADCD_SYNC_P_SN	ERRNO(AP_ID, (23))
#define AP_BADCD_SYNC_TYPE	ERRNO(AP_ID, (24))
#define AP_BADKIND		ERRNO(AP_ID, (25))
#define AP_BADSAVEF		ERRNO(AP_ID, (26))
#define AP_BADSAVE		ERRNO(AP_ID, (27))
#define AP_BADRESTR		ERRNO(AP_ID, (28))
#define AP_BADENV		ERRNO(AP_ID, (29))
#define AP_BADROLE		ERRNO(AP_ID, (30))
#define AP_BADENC		ERRNO(AP_ID, (31))
#define AP_BADREF		ERRNO(AP_ID, (32))
#define AP_ACCES		ERRNO(AP_ID, (33))
#define AP_PDUREJ		ERRNO(AP_ID, (34))
#define AP_LOOK			ERRNO(AP_ID, (35))
#define AP_BADPARSE		ERRNO(AP_ID, (36))
#define AP_BADCD_ACT_ID		ERRNO(AP_ID, (37))
#define AP_BADCD_OLD_ACT_ID	ERRNO(AP_ID, (38))
#define AP_BADCD_OLD_CONN_ID	ERRNO(AP_ID, (39))
#define AP_BADFLAGS		ERRNO(AP_ID, (40))  /* invalid prim flags */
#define AP_NOSET		ERRNO(AP_ID, (41))  /* get env before set */

/* For HP implementation */
#define AP_INTERNAL		ERRNO(AP_ID, (42))  /* internal error */
#define AP_CANNOT_RESET_ENV	ERRNO(AP_ID, (43))  /* no ap_init_env() again */

#define AP_NERR		44	/* # of errors */
#endif /* _AP_ERR */


/*###########################################################################*/
/*
 *	ap_free.h -
 *	Constants used to identify data structures freed by ap_free()
 */

#ifndef _AP_FREE
#define _AP_FREE

#define OBJID_T			AP_CNTX_NAME
#define AP_PADDR_T		AP_BIND_PADDR
#define ANY_T			AP_CLD_AEQ
#define AP_DCN_T		AP_DPCN
#define AP_DCS_T		AP_DCS
#define AP_CDL_T		AP_PCDL
#define AP_CDRL_T		AP_PCDRL
#define AP_CLG_CONN_ID_T	AP_CLG_CONN_ID
#define AP_CLD_CONN_ID_T	AP_CLD_CONN_ID
#define AP_QOS_T		AP_QOS
#define A_ASSOC_REQ_CD_T	A_ASSOC_REQ
#define A_ASSOC_IND_CD_T	A_ASSOC_IND
#define A_ASSOC_RSP_CD_T	A_ASSOC_RSP
#define A_ASSOC_CNF_CD_T	A_ASSOC_CNF
#define A_ABORT_REQ_CD_T	A_ABORT_REQ
#define A_ABORT_IND_CD_T	A_ABORT_IND
#define A_PABORT_REQ_CD_T	A_PABORT_REQ
#define A_PABORT_IND_CD_T	A_PABORT_IND
#define A_RELEASE_REQ_CD_T	A_RELEASE_REQ
#define A_RELEASE_IND_CD_T	A_RELEASE_IND
#define A_RELEASE_RSP_CD_T	A_RELEASE_RSP
#define A_RELEASE_CNF_CD_T	A_RELEASE_CNF
#define P_TOKENGIVE_REQ_CD_T	P_TOKENGIVE_REQ
#define P_TOKENGIVE_IND_CD_T	P_TOKENGIVE_IND
#define P_TOKENPLEASE_REQ_CD_T	P_TOKENPLEASE_REQ
#define P_TOKENPLEASE_IND_CD_T	P_TOKENPLEASE_IND
#define P_RESYNC_REQ_CD_T	P_RESYNC_REQ
#define P_RESYNC_IND_CD_T	P_RESYNC_IND
#define P_RESYNC_RSP_CD_T	P_RESYNC_RSP
#define P_RESYNC_CNF_CD_T	P_RESYNC_CNF
#define P_SYNCMINOR_REQ_CD_T	P_SYNCMINOR_REQ
#define P_SYNCMINOR_IND_CD_T	P_SYNCMINOR_IND
#define P_SYNCMINOR_RSP_CD_T	P_SYNCMINOR_RSP
#define P_SYNCMINOR_CNF_CD_T	P_SYNCMINOR_CNF
#define P_SYNCMAJOR_REQ_CD_T	P_SYNCMAJOR_REQ
#define P_SYNCMAJOR_IND_CD_T	P_SYNCMAJOR_IND
#define P_SYNCMAJOR_RSP_CD_T	P_SYNCMAJOR_RSP
#define P_SYNCMAJOR_CNF_CD_T	P_SYNCMAJOR_CNF
#define P_ACTSTART_REQ_CD_T	P_ACTSTART_REQ
#define P_ACTSTART_IND_CD_T	P_ACTSTART_IND
#define P_ACTRESUME_REQ_CD_T	P_ACTRESUME_REQ
#define P_ACTRESUME_IND_CD_T	P_ACTRESUME_IND
#define P_ACTINTR_REQ_CD_T	P_ACTINTR_REQ
#define P_ACTINTR_IND_CD_T	P_ACTINTR_IND
#define P_ACTINTR_RSP_CD_T	P_ACTINTR_RSP
#define P_ACTINTR_CNF_CD_T	P_ACTINTR_CNF
#define P_ACTDISCARD_REQ_CD_T	P_ACTDISCARD_REQ
#define P_ACTDISCARD_IND_CD_T	P_ACTDISCARD_IND
#define P_ACTDISCARD_RSP_CD_T	P_ACTDISCARD_RSP
#define P_ACTDISCARD_CNF_CD_T	P_ACTDISCARD_CNF
#define P_ACTEND_REQ_CD_T	P_ACTEND_REQ
#define P_ACTEND_IND_CD_T	P_ACTEND_IND
#define P_ACTEND_RSP_CD_T	P_ACTEND_RSP
#define P_ACTEND_CNF_CD_T	P_ACTEND_CNF
#define P_CTRLGIVE_REQ_CD_T	P_CTRLGIVE_REQ
#define P_CTRLGIVE_IND_CD_T	P_CTRLGIVE_IND
#define P_UXREPORT_REQ_CD_T	P_UXREPORT_REQ
#define P_UXREPORT_IND_CD_T	P_UXREPORT_IND
#define P_PXREPORT_IND_CD_T	P_PXREPORT_IND
#endif /* _AP_FREE */

/*###########################################################################*/
/*  
 *  File: api_trace.h
 *  $Revision: 1.1 $
 *  $Date: 91/08/22 14:53:28 $
 *
 *  The flags word is partitioned as follows:
 *
 *        +---------+---------+---------+---------+
 *        |   API specific    |General Flags(Rsvd)|
 *        +---------+---------+---------+---------+
 *   bit  31                  15                  0
 *
 *   Each API may have specific flags for further control of the tracing 
 *   facility (i.e. MMS might use flags to control which of the various 
 *   management facilities are to be traced, Variable, Domain, Program, 
 *   Files, etc.)
 *
 *   The flags in the low order 16 bits are reserved for general tracing
 *   control.  The following flags are defined.
 *
 *     bit    flag         description	           #define
 *     ---    ----         -----------             -------
 *      0  0x00000001  Procedure entry/exit    	API_TR_ENTRY_EXIT
 *      1  0x00000002  Input parameters    	API_TR_INPUT
 *      2  0x00000004  Output parameters    	API_TR_OUTPUT
 *      3  0x00000008  Reserved
 *      4  0x00000010  Internal entry/exit    	API_TR_INT_ENTRY_EXIT
 *      5  0x00000020  Internal error    	API_TR_INT_ERROR
 *      6  0x00000040  Reserved
 *     ...    ...
 *     15  0x00008000  Reserved
 */
#ifndef _API_TR
#define _API_TR

#define API_TR_ENTRY_EXIT 	0x00000001  
#define API_TR_INPUT 		0x00000002  
#define API_TR_OUTPUT 		0x00000004  
#define API_TR_INT_ENTRY_EXIT 	0x00000010  
#define API_TR_INT_ERROR 	0x00000020  

#endif

#ifdef  __cplusplus
}
#endif
