/*
#ident "@(#)clns.h	1.5 01/02/97 SMI"
 *
 * Copyright 1994 Sun Microsystems, Inc. All Rights Reserved
 *
 * CLNS Management structure definition
 * (Subset of RFC 1238 which define MIB for CLNS)
 */
#ifdef  __cplusplus
extern "C" {
#endif
/*
 * Message for netbuf option field
 */
typedef	struct clnsopt {
	long	level;
	long	name;
	long	len;
} clnsopt_t;

/* 
 * Level definition
 */
#define	MIB_CLNS		0x0

/*
 * name definition
 */
#define	CLNP_ROUTE_ENTRY	0x01
#define	CLNP_NET_TO_MEDIA_ENTRY	0x02

/*
 * return structures
 */
#define	OCTET_LENGTH	32

typedef struct _octet {
	int	o_length;
	char	o_bytes[OCTET_LENGTH];
} PhysAddress;

#define	MAX_OID_LEN	2

typedef struct _oid {
	int	oid[MAX_OID_LEN];
} ObjectID;

#define	MAX_NSAP_LEN	20

typedef struct _clnp_address {
	int	len;
	char	nsap[MAX_NSAP_LEN];
} ClnpAddress;

typedef unsigned long	Counter;

typedef struct _clnpRouteEntry {
	ClnpAddress		clnpRouteDest;		/* clnpRouteEntry.1 */
	int			clnpRouteIfIndex;	/* clnpRouteEntry.2 */
	int			clnpRouteMetric1;	/* clnpRouteEntry.3 */
	int			clnpRouteMetric2;	/* clnpRouteEntry.4 */
	int			clnpRouteMetric3;	/* clnpRouteEntry.5 */
	int			clnpRouteMetric4;	/* clnpRouteEntry.6 */
	ClnpAddress		clnpRouteNextHop;	/* clnpRouteEntry.7 */
	int			clnpRouteType;		/* clnpRouteEntry.8 */
	int			clnpRouteProto;		/* clnpRouteEntry.9 */
	int			clnpRouteAge;		/* clnpRouteEntry.10 */
	int			clnpRouteMetric5;	/* clnpRouteEntry.11 */
	ObjectID		clnpRouteInfo;		/* clnpRouteEntry.12 */
} clnpRouteEntry;

typedef struct _clnpNetToMediaEntry {
	int		clnpNetToMediaIfIndex;		/* clnpNetToMediaEntry.1 */
	PhysAddress	clnpNetToMediaPhysAddress;	/* clnpNetToMediaEntry.2 */
	ClnpAddress	clnpNetToMediaNetAddress;	/* clnpNetToMediaEntry.3 */
	int		clnpNetToMediaType;		/* clnpNetToMediaEntry.4 */
	int		clnpNetToMediaAge;		/* clnpNetToMediaEntry.5 */
	int		clnpNetToMediaHoldTime;		/* clnpNetToMediaEntry.6 */
} clnpNetToMediaEntry;

/*
 * clnpRouteType
 */
#define	ROUTE_TYPE_OTHER	0x01
#define	ROUTE_TYPE_INVALID	0x02
#define	ROUTE_TYPE_DIRECT	0x03
#define	ROUTE_TYPE_REMOTE	0x04

/*
 * clnpRouteProto
 */
#define	ROUTE_PROTO_OTHER	0x01
#define	ROUTE_PROTO_LOCAL	0x02
#define	ROUTE_PROTO_NETMGMT	0x03
#define	ROUTE_PROTO_IS_IS	0x09

/*
 * clnpNetToMediaType
 */
#define	CLNP_MEDIA_TYPE_OTHER	0x01
#define	CLNP_MEDIA_TYPE_INVALID	0x02
#define	CLNP_MEDIA_TYPE_DYNAMIC	0x03
#define	CLNP_MEDIA_TYPE_STATIC	0x04

#ifdef  __cplusplus
}
#endif
