/*
 * Copyright 09 Nov 1994 Sun Microsystems, Inc.  All Rights Reserved.
 */

#ifndef _SYS_IEEEFP_H
#define _SYS_IEEEFP_H

#pragma ident	"@(#)ieeefp.h	2.7 94/11/09"

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * Sun types for IEEE floating point.
 */
#if defined(sparc) || defined(__sparc)
enum fp_direction_type {	/* rounding direction */
	fp_nearest	= 0,
	fp_tozero	= 1,
	fp_positive	= 2,
	fp_negative	= 3
};

enum fp_precision_type {	/* extended rounding precision */
	fp_extended	= 0,
	fp_single	= 1,
	fp_double	= 2,
	fp_precision_3	= 3
};

enum fp_exception_type {	/* exceptions according to bit number */
	fp_inexact	= 0,
	fp_division	= 1,
	fp_underflow	= 2,
	fp_overflow	= 3,
	fp_invalid	= 4
};

enum fp_trap_enable_type {	/* trap enable bits according to bit number */
	fp_trap_inexact	= 0,
	fp_trap_division	= 1,
	fp_trap_underflow	= 2,
	fp_trap_overflow	= 3,
	fp_trap_invalid	= 4
};
#endif	/* defined(sparc) || defined(__sparc) */

#if defined(i386) || defined(__i386)
enum fp_direction_type {	/* rounding direction */
	fp_nearest	= 0,
	fp_negative	= 1,
	fp_positive	= 2,
	fp_tozero	= 3
};

enum fp_precision_type {	/* extended rounding precision */
	fp_single	= 0,
	fp_precision_3	= 1,
	fp_double	= 2,
	fp_extended	= 3
};

enum fp_exception_type {	/* exceptions according to bit number */
	fp_invalid	= 0,
	fp_denormalized	= 1,
	fp_division	= 2,
	fp_overflow	= 3,
	fp_underflow	= 4,
	fp_inexact	= 5
};

enum fp_trap_enable_type {	/* trap enable bits according to bit number */
	fp_trap_invalid	= 0,
	fp_trap_denormalized	= 1,
	fp_trap_division	= 2,
	fp_trap_overflow	= 3,
	fp_trap_underflow	= 4,
	fp_trap_inexact	= 5
};
#endif	/* defined(i386) || defined(__i386) */

#if defined(__ppc)
enum fp_direction_type {	/* rounding direction */
	fp_nearest	= 0,
	fp_tozero	= 1,
	fp_positive	= 2,
	fp_negative	= 3
};

enum fp_precision_type {	/* extended rounding precision */
	fp_extended	= 0,
	fp_single	= 1,
	fp_double	= 2,
	fp_precision_3	= 3
};

enum fp_exception_type {	/* exceptions according to bit number */
	fp_invalid_cvi	=  8,
	fp_invalid_sqrt	=  9,
	fp_invalid_soft	= 10,
	fp_invalid_vc	= 19,
	fp_invalid_imz	= 20,
	fp_invalid_zdz	= 21,
	fp_invalid_idi	= 22,
	fp_invalid_isi	= 23,
	fp_invalid_snan	= 24,
	fp_inexact	= 25,
	fp_division	= 26,
	fp_underflow	= 27,
	fp_overflow	= 28,
	fp_invalid	= 29
};

enum fp_trap_enable_type {	/* trap enable bits according to bit number */
	fp_trap_inexact	= 3,
	fp_trap_division	= 4,
	fp_trap_underflow	= 5,
	fp_trap_overflow	= 6,
	fp_trap_invalid	= 7
};
#endif	/* defined(__ppc) */

enum fp_class_type {		/* floating-point classes */
	fp_zero		= 0,
	fp_subnormal	= 1,
	fp_normal	= 2,
	fp_infinity   	= 3,
	fp_quiet	= 4,
	fp_signaling	= 5
};

#ifdef  __cplusplus
}
#endif

#endif	/* !defined(_SYS_IEEEFP_H) */
