/*
 *      Copyright (c) 1994, Sun Microsystems, Inc.
 */

/*
 * dlm_user.h
 *
 *      Distributed lock manager (DLM) library interface.
 *
 * 	The DLM interface is based on The Oracle Lock Manager API (Simmons C.,
 *	Greenwald P. April 1994). Note that the Sun DLM implements only
 *	a subset of the Oracle API.
 */

#pragma ident   "@(#)dlm_user.h 1.43     95/03/28 SMI"

#ifndef	SYS_DLM_USER_H
#define	SYS_DLM_USER_H

#ifdef	__cplusplus
extern "C" {
#endif

/* XXX - we should replace these Oracle types by Solaris native types */
typedef int word;
typedef unsigned int uword;
typedef unsigned long ub4;
typedef unsigned short ub2;
typedef unsigned char ub1;

typedef unsigned char res_element_t;

#define	LK_RESNAMELEN 24
#define	LK_VALLEN     16 
#define	LK_EXTLEN      4 

/*
 * Make these structures so we can treat them as simple objects instead of
 * arrays.
 */
typedef struct resname {
        res_element_t   resname[LK_RESNAMELEN];
} lk_resname;

typedef struct valblk {
        char            valblk[LK_VALLEN];
} lk_valblk;

typedef struct extra {
        char            extra[LK_EXTLEN];
} lk_extra;

typedef unsigned long long lk_scn_t;
typedef void *lk_voidp;
typedef struct lk_lock *lk_lockp;       /* handle for a lock object */

/*
 * XXX - the server part should go away when we code finish cleanup.
 */
typedef void *lk_conp;                  /* handle for a connection object */
 
/* lock open options */
#define	LK_DEADLOCK 		0x01	/* open a deadlockable lock */
#define	LK_SCN			0x02	/* resource is a scn server */
#define	LK_VALBLKFAST		0x04	/* use optimal valblk algorithm */
#define	LK_FORCEMASTER		0x08	/* used only for testing */

/* lock release groups */
#define	LK_RELGROUP0		0x00
#define	LK_RELGROUP1		0x10
#define	LK_RELGROUP2		0x20
#define	LK_RELGROUP3		0x30
#define	LK_RELGROUP4		0x40
#define	LK_RELGROUP5		0x50
#define	LK_RELGROUP6		0x60
#define	LK_RELGROUP7		0x70
#define	LK_RELGROUPALL		0xf0

#define	LK_RELGROUP_MASK	0xf0
#define	LK_RELGROUP(flags)	((flags) & LK_RELGROUP_MASK)
#define	LK_RELGROUPNUM(flags) (LK_RELGROUP(flags) >> 4)

/* lock conversion options */
#define	LK_NOQUEUE         0x008	/* don't queue this lock */
#define	LK_EXPRESS         0x010	/* queue only if conflict */
#define	LK_NODEADLOCKWAIT  0x020	/* ignore lock if on convert queue */
#define	LK_NODEADLOCKBLOCK 0x040	/* ignore lock if granted */
 
#define	LK_VALUE_MASK     0x07		/* 3 bits are used for value field */
#define	LK_GETVALUE       0x01		/* read value block */
#define	LK_PUTVALUE       0x02		/* write value block */
#define	LK_NOVALUE        0x03		/* mark value block uninitialized */
#define	LK_DUBVALUE       0x04		/* mark value block dubious */
#define	LK_VMSVALUE       0x05		/* use VMS value block semantics */
 
#define	LK_VALUE_OPT(flags) ((flags) & LK_VALUE_MASK)
 
/* lk_close options include the value flags */
#define	LK_COOE            0x008	/* callback only on error */

/*
 * While it would be nice to define 'lk_level' as an enumerated type, it
 * isn't clear that all compilers support this, and it isn't clear that
 * compilers are smart enough to just use a single byte inside of structures.
 * Similarily for 'lk_valstate' and 'lk_lock_state'.
 */

typedef unsigned char lk_level;
#define	LK_NL 0				/* no permissions */
#define	LK_CR 1				/* concurrent read */
#define	LK_CW 2				/* concurrent write */
#define	LK_PR 3				/* protected read */
#define	LK_PW 4				/* protected write */
#define	LK_EX 5				/* exclusive access */

typedef unsigned char lk_valstate;
#define	LK_VS_NOVALUE	0		/* value uninitialized */
#define	LK_VS_DUBVALUE	1		/* value marked dubious */
#define	LK_VS_VALUE	2		/* value initialized */

/* status codes */
typedef unsigned char lk_stat;

#define	LK_STAT_DONE          0	/* successful */
#define	LK_STAT_ABORT         1	/* open_convert aborted by close or detach */
#define	LK_STAT_ATTACHED      2	/* attach attempted, but already attached */
#define	LK_STAT_BADADDRESS    3	/* address is invalid on create operation */
#define	LK_STAT_BADCON        4	/* invalid connection handle */
#define	LK_STAT_BADLEVEL      5	/* invalid level on conversion operation */
#define	LK_STAT_BADLOCK       6	/* invalid lock handle */
#define	LK_STAT_BADNAME       7	/* invalid name on create/destroy/attach */
#define	LK_STAT_BADOPTION     8	/* a specified option mask is invalid */
#define	LK_STAT_BADPROC       9	/* a specified pid was not attached */
#define	LK_STAT_BADRES       10	/* invalid resource handle */
#define	LK_STAT_BUSY         11	/* convert requested while one in progress */
#define	LK_STAT_CANCELLED    12	/* conversion request was cancelled */
#define	LK_STAT_COMM         13	/* a communications error occured */
#define	LK_STAT_CREATED      14	/* create attempted, but already created */
#define	LK_STAT_DEADLOCK     15	/* conversion request would cause a deadlock */
#define	LK_STAT_DISCONNECTED 16	/* lock manager disconnected */
#define	LK_STAT_DUBVALUE     17	/* convert succeeded: val block is dubious */
#define	LK_STAT_GOTVALUE     18	/* convert succeeded: val block is good */
#define	LK_STAT_IDLE         19	/* cancel requested, but no convert exists */
#define	LK_STAT_MAXLOCK      20	/* open would create too many locks */
#define	LK_STAT_MAXPROC      21	/* attach would create too many processes */
#define	LK_STAT_MAXRES       22	/* open would create too many resources */
#define	LK_STAT_MBZ          23	/* a parameter was not zero but must be zero */
#define	LK_STAT_MORE         24	/* more info follows in another message */
#define	LK_STAT_NOSPACE      25	/* out of memory */
#define	LK_STAT_NOTATTACHED  26	/* not attached to a lock manager */
#define	LK_STAT_NOTCREATED   27	/* destroy attempted; instance didn't exist */
#define	LK_STAT_NOTOWNER     28	/* process does not own the specified lock */
#define	LK_STAT_NOTQUEUED    29	/* LK_NOQUEUE specified but queueing needed */
#define	LK_STAT_NOVALUE      30	/* convert succeeded: val block has no value */
#define	LK_STAT_RESLEN       31	/* resource name too long on open request */
#define	LK_STAT_SHUTDOWN     32	/* lock manager shutting down; attach failed */
#define	LK_STAT_TIMEOUT      33	/* convert failed:  timeout expired */
#define	LK_STAT_EXTLEN       34	/* extra length too long on close request */

/* definitions of various function pointers */
typedef void (*lk_endfunp)(lk_voidp cookie, lk_stat endstat);
typedef void (*lk_notfunp)(lk_voidp cookie, lk_level level);
typedef void (*lk_closefunp)(lk_voidp cookie, lk_stat endstat, lk_voidp extrap);
typedef void (*lk_attachendfunp)(lk_voidp cookie, lk_stat endstat, lk_conp conp);
typedef void (*lk_discfunp)(lk_voidp cookie, lk_conp conp);
typedef void (*lk_openendfunp)(lk_voidp cookie, lk_stat endstat, lk_lockp lockp);
typedef void (*lk_adjscnendfunp)(lk_voidp cookie, lk_stat endstat, lk_scn_t scn);
typedef int (*lk_pollfunp)(lk_voidp cookie);

#ifndef	_KERNEL
/*
 * Asynchronous DLM operations.
 */
lk_stat lk_attach(char *name, lk_discfunp discfunp, lk_voidp disc_cookie,
    lk_attachendfunp attachendfunp, lk_voidp cookie);
lk_stat lk_detach(lk_conp conp, int dubious, lk_endfunp endfunp,
    lk_voidp cookie);
lk_stat lk_open(lk_conp conp, char *resname, size_t resnamelen, int options,
    lk_openendfunp openendfunp, lk_voidp cookie);
lk_stat lk_close(lk_conp conp, lk_lockp lockp, int options, lk_voidp lockvalp,
    lk_voidp extrap, size_t extralen, lk_closefunp endfunp, lk_voidp cookie);
lk_stat lk_convert(lk_conp conp, lk_lockp lockp, lk_level level, int options,
    unsigned int timeout, lk_voidp lockvalp, lk_notfunp notify_fp,
    lk_voidp notify_cookie, lk_endfunp endfunp, lk_voidp cookie);
lk_stat lk_open_convert(lk_conp conp, char *resname, size_t resnamelen,
    int openoptions, lk_level level, int convertoptions, unsigned int timeout,
    lk_voidp lockvalp, lk_notfunp notify_fp, lk_voidp notify_cookie,
    lk_openendfunp openendfunp, lk_endfunp endfunp, lk_voidp cookie);
lk_stat lk_cancel(lk_conp conp, lk_lockp lockp, int options,
    lk_endfunp endfunp, lk_voidp cookie);
lk_stat lk_async_adjscn(lk_conp conp, lk_lockp lockp, lk_scn_t *scnp,
	lk_scn_t incr, lk_adjscnendfunp endfunp, lk_voidp cookie);
lk_stat lk_wait(lk_conp conp, lk_pollfunp pollfunp, lk_voidp cookie);

/*
 * Synchronous versions of DLM operations.
 */
lk_stat lk_sync_attach(char *name, lk_discfunp discfunp, lk_voidp disc_cookie,
    lk_conp *conpp);
lk_stat lk_sync_detach(lk_conp conp, int dubious);
lk_stat lk_sync_open(lk_conp conp, char *resname, size_t resnamelen,
    int options, lk_lockp *lockpp);
lk_stat lk_sync_close(lk_conp conp, lk_lockp lockp, int options,
    lk_voidp lockvalp);
lk_stat lk_sync_convert(lk_conp conp, lk_lockp lockp, lk_level locklevel,
    int options, unsigned int timeout, lk_voidp lockvalp, lk_notfunp notify_fp,
    lk_voidp notify_cookie);
lk_stat lk_sync_open_convert(lk_conp conp, char *resname, size_t
    resnamelen, int openoptions, lk_level locklevel, int convertoptions,
    unsigned int timeout, lk_voidp lockvalp, lk_notfunp notify_fp,
    lk_voidp notify_cookie, lk_lockp *lockpp);
lk_stat lk_sync_cancel(lk_conp conp, lk_lockp lockp, int options);
lk_stat lk_adjscn(lk_conp conp, lk_lockp lockp, lk_scn_t *scnp,
    int incr);
lk_stat lk_adjscn_new(lk_conp conp, lk_lockp lockp, lk_scn_t *scnp,
    lk_scn_t incr);

/*
 * Support for system change number (SCN) generation.
 */
lk_stat lk_getscn(lk_conp conp, lk_scn_t *scnp);
lk_stat	lk_setscn(lk_conp conp, lk_scn_t scn);

#endif	/* !_KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* !SYS_DLM_USER_H */
