#!/bin/sh
# @(#)npcomm-ps.sh	1.16 97/08/28 
# Copyright Sun Microsystems, Inc.  All Rights Reserved.
#


trap "/usr/bin/rm -f $SPOOLDIR/ps_setup.$$ $SPOOLDIR/ps_setup.$$; exit 2" 1 2 3 15
ESC=""
FF="^L"
CR="\015"
FF="\014"
NL="\012"
EOT="%-12345X@PJL ENTER LANGUAGE = PostScript"

SWARCH=`uname -r | grep '^5' >/dev/null && echo solaris2 || echo solaris1`
ETHERCOMM=$NPHOME/printer_classes/$PRINTERNAME/bin.$ARCH/ethercomm
LOCALCOMM=$NPHOME/printer_classes/$PRINTERNAME/bin.$ARCH/psio

#if [ $SWARCH = "solaris1" ]; then
#    LOCALCOMM_ARGS="-d -e"
#fi

ps_setup()
{
    echo $EOT
    echo "%!PS-Adobe"
    echo "%%"
    echo "version (941215) eq {  "
    echo "/image { dup type /dicttype eq   "
    echo "        { systemdict /image get exec}  "
    echo "        {2 index 1 ne { systemdict /image get exec}   "
    echo "              {3 -1 roll pop false 3 1 roll  "
    echo "               systemdict /imagemask get exec}  "
    echo "              ifelse "
    echo "        } ifelse  "
    echo "  } bind def  "
    echo " } if "
    echo "statusdict begin "
    if [ -n "$DEFRES" ] ; then
	    echo "/setresolution where { pop $DEFRES setresolution } { { 1 dict dup /HWResolution [ $DEFRES $DEFRES ] put setpagedevice } stopped pop } ifelse "
    fi
    echo "{ "
    case "$DEFAULTTRAY" in
	    tray1 )
		    echo "0 setpapertray " ;;
	    tray2 )
		    echo "{ 1 setpapertray } stopped { 0 setpapertray } if " ;;
	    manual )
		    echo "{ 3 setpapertray } stopped { /manualfeed true def } if " ;;
	    manual_envelope )
		    echo "{ 4 setpapertray } stopped { /manualfeed true def } if " ;;
	    feeder )
		    echo "{ 2 setpapertray } stopped { { 3 setpapertray } stopped { /manualfeed true def } if } if " ;;
	    envelope )
		    echo "{ 2 setpapertray } stopped { { 4 setpapertray } stopped { /manualfeed true def } if } if " ;;
    esac
    echo "} stopped { (%%[ Warning: Request for $tray source failed -- using default. %%])= flush } if "

    echo "{ "
    case "$DEFPAPERSIZE" in
	    executive )     echo "executivetray " ;;
	    letter )        echo "lettertray " ;;
	    legal )         echo "legaltray " ;;
	    B5 )            echo "b5tray " ;;
	    A4 )            echo "a4tray " ;;
	    A5 )            echo "a5tray ";;
	    monarch_env )   echo "monarcenvelopetray " ;;
	    com10_env )     echo "com10envelopetray " ;;
	    com9_env )      echo "3.875x8.875envelopetray " ;;
	    DL_env )        echo "dlenvelopetray " ;;
	    C5_env )        echo "c5envelopetray " ;;
	    B5_env )        echo "176x250envelopetray " ;;
    esac
    echo "} stopped { (%%[ Warning: Request for form $paper_size failed -- using default. %%])= flush } if "

    echo "{ "
    case "$DEFDUPLEX" in
     duplex )       echo "true setduplexmode false settumble " ;;
     tumble )   echo "true setduplexmode true settumble " ;;
     simplex )      echo "false setduplexmode false settumble " ;;
    esac
    echo "} stopped { (%%[ Warning: Request for duplex $duplex failed -- printing simplex. %%])= flush } if "

    echo "end "
}

/usr/bin/rm -f $SPOOLDIR/eot.* $SPOOLDIR/ps_setup.*
ps_setup > $SPOOLDIR/ps_setup.$$
echo $EOT > $SPOOLDIR/eot.$$

Job_User=`echo ${user_name} | sed 's/.*\!//'` 

if [ $DEVTYPE = "ethernet" ]; then
             HANDLER="cat $SPOOLDIR/ps_setup.$$ -  | $ETHERCOMM  -u $Job_User -n $printer -r $request_id -s $ETHERNET_PRINTER_HOST_ADDRESS"

elif [ $DEVTYPE = "tty" ]; then
	HANDLER="cat $SPOOLDIR/ps_setup.$$ -  | $LOCALCOMM -w"
else
    HANDLER="cat $SPOOLDIR/ps_setup.$$ - | $LOCALCOMM"
fi

eval $HANDLER
/usr/bin/rm -f $SPOOLDIR/eot.$$ $SPOOLDIR/ps_setup.$$
exit 0
