#!/bin/sh
# @(#)npcomm-pcl.sh	1.13 1/17/97
# Copyright 1995 Sun Microsystems, Inc.  All Rights Reserved.



trap "/usr/bin/rm -f $SPOOLDIR/ascii_setup.$$ $SPOOLDIR/ascii_setup.$$; exit 2" 1 2 3 15

ESC=""
FF=""
EJ="E"
CR="\015"
FF="\014"
NL="\012"
EOT="%-12345X@PJL ENTER LANGUAGE = PostScript"
EPS="%!PS"

SWARCH=`uname -r | grep '^5' >/dev/null && echo solaris2 || echo solaris1`
ETHERCOMM=$NPHOME/printer_classes/$PRINTERNAME/bin.$ARCH/ethercomm
BPPCOMM=$NPHOME/printer_classes/$PRINTERNAME/bin.$ARCH/send_ascii

#if [ $SWARCH = "solaris1" ]; then
#    LOCALCOMM_ARGS="-d -e"
#fi


#####
#
# SERIAL PORTS:
# Initialize everything.
#
# PARALLEL PORTS:
# Don't initialize baud rate.
#
# It's not obvious how to tell if a port is parallel or serial.
# However, by splitting the initialization into two steps and letting
# the serial-only part fail nicely, it'll work.
#
# Another point: The output must be a ``tty'' device. If not, don't
# bother with any of this.
#####
initialize_serial(){

stty1= stty2=
tty 0<&1 1>/dev/null 2>&1 && {

	#####
	#
	# First set the default parameters,
	# then the requested parameters.
	#####

	################################################
	# Do not modify this comment
	#
	# Set serial line to the following specifications
	#######SERIAL OPTIONS#######
	# baud      = 9600
	# data_bits = 8
	# parity    = none
	# protocol  = xon/xoff
	##########END STTY##########
	stty 9600 \
		-cstopb -opost -echo cs8 -parenb ixon ixoff -ixany \
			 0<&1 2>/dev/null 1>&2

	if [ -n "${stty}" ]
	then
		if stty ${stty} 0<&1 1>/dev/null 2>&5
		then
			:
		else
			errmsg ERROR ${E_IP_STTY} \
				"stty option list failed" \
				"check the \"-o stty\" option you used,
		or consult your system administrator"
			exit 1
		fi
	fi

	#####
	#
	# Here you may want to add other port initialization code.
	# Some examples:
	#
	# estty	# for printer needing hardware flow control (3B2/EPORTS)
	# fctty	# for printer needing hardware flow control (3B15,3B20)
	#####
	#estty 0<&1
	#fctty 0<&1


	##########
	#
	# Find out if we have to turn off opost before initializing the
	# printer and on after. Likewise, check clocal.
	#
	# Turning OFF opost (output postprocessing) keeps the UNIX system
	# from changing what we try to send to the printer. Turning ON
	# clocal keeps the UNIX system from dropping what we are trying to
	# send if the printer drops DTR. An example of the former is the
	# AT&T 479, which wants to send a linefeed (ASCII 10) when a page
	# width of 10 is set; with opost on, this COULD BE turned into a
	# carriage-return/linefeed pair. An example of the latter is the
	# AT&T 455, which momentarily drops DTR when it gets the
	# initialization string, is2; with clocal off, the UNIX system
	# stops sending the rest of the initialization sequence at that
	# point.
	#
	# THIS CODE MUST FOLLOW THE REST OF THE PORT INITIALIZATION CODE.
	##########
	cur_stty=`stty -a 0<&3`
	expr "${cur_stty}" : '.*-opost' 1>/dev/null 2>&1 \
		|| stty1="${stty1} -opost" stty2="${stty2} opost"
	expr "${cur_stty}" : '.*-clocal' 1>/dev/null 2>&1 \
		&& stty1="${stty1} clocal" stty2="${stty2} -clocal"
	expr "${cur_stty}" : '.* opost.*' 1>/dev/null 2>&1 \
		|| banner_filter=${FIX386BD}

}
}

ascii_setup()
{
    case "$DEFRES" in
       300 )
	    echo "${ESC}%-12345X@PJL ENTER LANGUAGE = PCL"
	    echo "${ESC}%-12345X@PJL SET RESOLUTION = 300"
	    echo "@PJL ENTER LANGUAGE = PCL"
	    ;;
       600 )
	    echo "${ESC}%-12345X@PJL ENTER LANGUAGE = PCL"
	    echo "${ESC}%-12345X@PJL SET RESOLUTION = 600"
	    echo "@PJL ENTER LANGUAGE = PCL"
	    ;;
       * )
	    echo "%s" "${ESC}%-12345X@PJL enter language=PCL\n" ;;
    esac

   echo "${ESC}E"
   echo "${ESC}&k2G"


# Delete all temp fonts and macros

   echo "${ESC}*c1F${ESC}&f7X"

    case "$wrap_text" in
	    off )           echo "${ESC}&s1C" ;;
	    on )            echo "${ESC}&s0C" ;;
	     * )	    echo "${ESC}&s1C" ;;
    esac	

    case "$DEFDUPLEX" in
      duplex )
	case "$orientation" in
	  landscape | rlandscape ) echo "${ESC}&l2S" ;;
	  * )                      echo "${ESC}&l1S" ;;
	esac ;;
      tumble )
	case "$orientation" in
	  landscape | rlandscape ) echo "${ESC}&l1S" ;;
	  *)                       echo "${ESC}&l2S" ;;
	esac ;;
      simplex )    echo "${ESC}&l0S" ;;
	* )     echo "${ESC}&l0S" ;;
    esac

    case "$DEFPAPERSIZE" in
	    executive )    echo "${ESC}&l1A" ;;
	    letter )       echo "${ESC}&l2A" ;;
	    legal )        echo "${ESC}&l3A" ;;
	    B5 )           echo "${ESC}&l12A" ;;
	    A4 )           echo "${ESC}&l26A" ;;
	    A5 )           echo "${ESC}&l13A" ;;
	    monarch_env )  echo "${ESC}&l80A" ;;
	    com10_env )    echo "${ESC}&l81A" ;;
	    com9_env )     echo "${ESC}&l89A" ;;
	    DL_env )       echo "${ESC}&l90A" ;;
	    C5_env )       echo "${ESC}&l91A" ;;
	    B5_env )       echo "${ESC}&l99A" ;;
		*  )        echo "${ESC}&l2A" ;;
    esac

    case "$DEFAULTTRAY" in
	    tray1 )        echo "${ESC}&l1H" ;;
	    tray2)         echo "${ESC}&l4H" ;;
	    envelope )     echo "${ESC}&l6H" ;;
	    manual )       echo "${ESC}&l2H" ;;
	    feeder )       echo "${ESC}&l6H";;
	    manual_envelope )echo "${ESC}&l3H" ;;
	    * )echo "${ESC}&l1H" ;;
    esac

    case "$orientation" in
	    landscape )    echo "${ESC}&l1O" ;;
	    portrait )     echo "${ESC}&l0O" ;;
	    rlandscape )   echo "${ESC}&l3O" ;;
	    rportrait )    echo "${ESC}&l2O" ;;
	    * )      echo "${ESC}&l0O" ;;
    esac
    
    case "$pitch" in
	    10 )           echo "${ESC}(8U${ESC}(s0p10h12v0s0b3T" ;;
	    12 )           echo "${ESC}(8U${ESC}(s0p12h10v0s0b3T" ;;
	    16.5 )         echo "${ESC}(8U${ESC}(s0p16.67h8.5v0s0b0T" ;;
	    * )           echo "${ESC}(8U${ESC}(s0p10h12v0s0b3T" ;;
    esac

#    if [ "$pl66" = "on" ] ; then
    echo "${ESC}&l1E${ESC}&l64F${ESC}&l7.75C"
#    fi

    if [ -n "$top_margin" ] ; then
	    TOPM=`expr $top_margin + 1`
	   echo "${ESC}&l${TOPM}E"
    fi

    if [ -n "$page_length" ] ; then
	   echo "${ESC}&l${page_length}F"
    fi

#    if [ -n "$indent" ] ; then
#	   echo "${ESC}&a${indent}L"
#    fi
    echo "${ESC}&a0L"

    if [ -n "$page_width" ] ; then
	    if [ -n "$indent" ] ; then
		    WIDTH=`expr $page_width + $indent - 1`
	    else
		    WIDTH=`expr $page_width - 1`
	    fi
#	   echo "${ESC}&a${WIDTH}M"
    fi
  echo "${ESC}&a79M"


}

init_bpage() {
	echo "%-12345X@PJL ENTER LANGUAGE = PostScript" 

	echo "%!PS-Adobe"
	echo "statusdict begin "
	echo "/setresolution where { pop 300 setresolution } { { 1 dict dup /HWResolution [ 300 300 ] put setpagedevice } stopped pop } ifelse "

	echo "{ "
	case "$DEFAULTBANNERTRAY" in
		tray1 )
			echo "0 setpapertray " ;;
		tray2 )
			echo "{ 1 setpapertray } stopped { 0 setpapertray } if " ;;
	esac
	echo "} stopped { (%%[ Warning: Request for $tray source failed -- using default. %%])= flush } if "

	echo "end"
	date=`date`
	title=${title}
	Job_Host=`echo ${user_name} | sed 's/\!.*//'` 
	Job_User=`echo ${user_name} | sed 's/.*\!//'` 
	printer=${printer}

}


regular_banner_ps() 
{
init_bpage
cat - $NPHOME/printer_classes/$PRINTERNAME/C/include/separator.ps \
      $NPHOME/printer_classes/$PRINTERNAME/C/include/banner.ps <<EndOfBanner 
%!
userdict /Unix_Env 100 dict put
Unix_Env begin
    (STACKORDER)         ($STACKORDER) def
    (DEFDUPLEX)          ($DEFDUPLEX) def
    (DEFAULTTRAY)        ($DEFAULTTRAY) def
    (SPVERSION)          ($SPVERSION) def
    (PRODUCTNAME)        ($PRODUCTNAME) def
    (PRINTERNAME)        ($PRINTERNAME) def
    (DEFAULTBANNERTRAY)  ($DEFAULTBANNERTRAY) def
end
userdict /JobDict 100 dict put
JobDict begin
    /Job_Printer ($printer)  def
    /Job_Host    ($Job_Host) def
    /Job_User    ($Job_User) def
    /Job_Date    ($date)     def
    /Job_Job     ($title)    def
end
cleardictstack
EndOfBanner
###########################   BANNER   ##################################
}


/usr/bin/rm -f $SPOOLDIR/eot.* $SPOOLDIR/ascii_setup.* $SPOOLDIR/banner_setup.* $SPOOLDIR/trailer_setup.*

if [ "$nobanner" = no ]; then
     if [ $STACKORDER = "-f" ]; then
       eval "regular_banner_ps  > $SPOOLDIR/banner_setup.$$"
       touch $SPOOLDIR/trailer_setup.$$
     else
       eval "regular_banner_ps  > $SPOOLDIR/trailer_setup.$$"
       touch $SPOOLDIR/banner_setup.$$
     fi
else
    #   eval "regular_banner_ps  > $SPOOLDIR/trailer_setup.$$"
       touch $SPOOLDIR/banner_setup.$$ $SPOOLDIR/trailer_setup.$$
fi

ascii_setup >> $SPOOLDIR/ascii_setup.$$
echo $FF$EJ$EOT$EPS  >> $SPOOLDIR/eot.$$


if [ $DEVTYPE = "ethernet" ]; then
	    HANDLER="cat $SPOOLDIR/banner_setup.$$ $SPOOLDIR/ascii_setup.$$ - $SPOOLDIR/eot.$$ $SPOOLDIR/trailer_setup.$$ | $ETHERCOMM -u $Job_User -n $printer -r $request-id -s $ETHERNET_PRINTER_HOST_ADDRESS"

elif [ $DEVTYPE = "bpp" ]; then
	    HANDLER="cat $SPOOLDIR/banner_setup.$$ $SPOOLDIR/ascii_setup.$$  - $SPOOLDIR/trailer_setup.$$ | $BPPCOMM" 
else
    initialize_serial
    HANDLER="cat $SPOOLDIR/banner_setup.$$ $SPOOLDIR/ascii_setup.$$ - $SPOOLDIR/trailer_setup.$$"
fi

eval $HANDLER
/usr/bin/rm -f $SPOOLDIR/eot.$$ $SPOOLDIR/ascii_setup.$$ $SPOOLDIR/banner_setup.$$ $SPOOLDIR/trailer_setup.$$
exit 0

