/*
	Copyright 13 May 1994 Sun Microsystems, Inc. All Rights Reserved
*/
/* @(#)exception.h	1.4 */

#ifndef EXCEPTION_H
#define EXCEPTION_H

void terminate();
typedef void (*terminate_function)();
terminate_function set_terminate(terminate_function);

void unexpected();
typedef void (*unexpected_function)();
unexpected_function set_unexpected(unexpected_function);

// Predefined exceptions: xmsg and xalloc
#include <string.h>

class xmsg {
public:
    xmsg(const char*);
    virtual ~xmsg();

    const char* why() const;
    void raise();

protected:
    xmsg();
    const char* msg_;
};

class xalloc : public xmsg {
public:
    xalloc(const char *, size_t size = 0);
    ~xalloc();

    size_t requested() const;
    void raise();

private:
    size_t size_;
};

inline xmsg::xmsg()
    : msg_(0)
{
}

inline xmsg::xmsg(const char * str)
{
    msg_ = new char[strlen(str)+1];
    strcpy((char *) msg_, str);
}

inline xmsg::~xmsg()
{
    delete (char *)msg_;
}

inline const char* xmsg::why() const
{
    return msg_;
}

inline xalloc::~xalloc()
{
}

inline size_t xalloc::requested() const
{
    return size_;
}

inline void xalloc::raise()
{
    throw *this;
}

#endif
