#pragma ident "@(#)asn1_runtime.h	1.9 95/09/18 SMI"
/*
 * Copyright 18 Sep 1995 by Sun Microsystems, Inc.  All Rights Reserved. (c)
 * Copyright 1991 Marben Produit.  All rights reserved.
 */

/*******************************************************************/
/*                                                                 */
/* Definitions of common macros, constants, and types for use      */
/* with the ASN.1 runtime.                                         */
/*                                                                 */
/*******************************************************************/


/*******************************************************************/
/*                                                                 */
/*                           MACROS                                */
/*                                                                 */
/*******************************************************************/

/*-----------------------------------------------------------------*/
/* Conversion of an octet into an Asn_u_int, without sign extension*/
/*-----------------------------------------------------------------*/
#define ASN_OCTET_TO_U_INT(b)    (((Asn_u_int)(b)) & 0x00ff)

/*-----------------------------------------------------------------*/
/* Conversion of an octet into an Asn_int, with sign extension     */
/*-----------------------------------------------------------------*/
#define ASN_OCTET_TO_INT(b)      ((Asn_int)((char)(b)))

/*------------------------------------------------------------------*/
/* Conversion of an octet into an Asn_u_intx, without sign extension*/
/*------------------------------------------------------------------*/
#define ASN_OCTET_TO_U_INTX(b)   (((Asn_u_intx)(b)) & 0x0ff)

/*-----------------------------------------------------------------*/
/* Conversion of an octet into an Asn_intx, with sign extension    */
/*-----------------------------------------------------------------*/
#define ASN_OCTET_TO_INTX(b)     ((Asn_intx)((char)(b)))

/*-----------------------------------------------------------------*/
/* Allocation of memory for dynamic lists (set of ; sequence of)   */
/*-----------------------------------------------------------------*/
#define ASN_ALLOCMEM(p_p,s)      asn_allocmem((A*)(p_p),(Asn_u_intx)(s))

/*-----------------------------------------------------------------*/
/* Release of memory for dynamic lists (set of ; sequence of )     */
/* allocated through asn_allocmem.                                 */
/*-----------------------------------------------------------------*/
#define ASN_FREEMEM(p_p,s)       asn_freemem((A*)(p_p),(Asn_u_intx)(s))

/*-----------------------------------------------------------------*/
/* Handling of User defined exits                                  */
/*-----------------------------------------------------------------*/
#define ASN_EXIT(numex, p_v, numline) \
  asn_exit((Asn_u_intx)(numex),(A)(p_v),(Asn_u_intx)(numline))

/*-----------------------------------------------------------------*/
/* Difference of two pointers (computation of an offset)           */
/* Used by files generated by ASN.1 compiler for Low Level access. */
/*-----------------------------------------------------------------*/
#define ASN_PTR_DIFF(a,b)        (Asn_u_intx)(((A)(a))-(A)(b))

/*-----------------------------------------------------------------*/
/* Macro used only by generated decoding procedures                */
/* indicates Low level access to decoder                           */
/*-----------------------------------------------------------------*/
#define ASN_DLA(stat_m)          (stat_m)[0].ads_son = 0;

/*-----------------------------------------------------------------*/
/* Macro used only by generated encoding procedures                */
/* indicates Low level access to decoder                           */
/*-----------------------------------------------------------------*/
#define ASN_CLA(stat_m)          (stat_m)[0].acs_son = 0

/*-----------------------------------------------------------------*/
/* Macro used only by generated decoding procedures                */
/* Indicates that a given element shall not be decoded by kept as  */
/* a regular ANY                                                   */
/*-----------------------------------------------------------------*/
#define ASN_DASANY(stat_m, line, back_p) \
  (stat_m)[line].ads_skip = ASN_ASANY

/*-----------------------------------------------------------------*/
/* Macro used only by generated decoding procedures                */
/* Indicates that a given element shall be decoded regularly       */
/* if the opposite (ASN_DASANY) was specified before               */
/*-----------------------------------------------------------------*/
#define ASN_DRESTORE( stat_m, line, back_p) \
  (((stat_m)[line].ads_skip == ASN_ASANY)?((stat_m)[line].ads_skip = 0):0)

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~- */
/* Macro used only by generic encoding procedures                  */
/* indicates Symetric Low Level access to coder                    */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
#define ASN_CSA(stat_m)          (stat_m)[0].acs_son = 2

/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/* Macro used only by generic decoding procedures                  */
/* indicates Symetric Low Level access to decoder                  */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
#define ASN_DSA(stat_m)          (stat_m)[0].ads_son = 2

/*-----------------------------------------------------------------*/
/* Macros for memory management package                            */
/*-----------------------------------------------------------------*/

/*-------------------add space to front of buffer -------*/
#define ASN_BUF_ADD_SPACE(o,l)	 	asn_spcb((Asn_buffer *)(&(o)),l);

/*-------------------append two buffers------------------*/
#define ASN_BUF_APPEND(nptr,optr1,optr2)\
  asn_asmb((Asn_buffer *)(&(nptr)),(Asn_buffer *)(&(optr1)),(Asn_buffer *)(&(optr2)));

/*------------------create buffer for user data ---------*/
#define ASN_BUF_CREATE(nptr,data,ulg,rlg,off,id) \
  asn_bcre((Asn_buffer *)(&(nptr)),(A)data,ulg,rlg,off,id);

/*-------------------length of a  buffer ----------------*/
#define ASN_BUF_LENGTH(optr,lng) \
  if (!optr) (lng)=0;\
  else lng= ( (Asn_buffer)(optr) )->bufulg ;

/*-------------------get a buffer from pool--------------*/
#define ASN_BUF_NEW(nptr,lng)		asn_ngetb((Asn_buffer *)(&(nptr)),lng,1);

/*-------------------read octets from buffer ------------*/
#define ASN_BUF_READ(optr,ares,l)	asn_rdb(optr,(A)ares,l);

/*-------------------release buffer    ------------------*/
#define ASN_BUF_RELEASE(o)		asn_relb((Asn_buffer *)(&(o)));

/*-------------------remove heading octets from buffer --*/
#define ASN_BUF_REM_HEAD(o,l)		asn_remb((Asn_buffer *)(&(o)),l);

/*---------------- reset index in buffer-----------------*/
#define ASN_BUF_RESET(optr) \
  ((Asn_buffer)(optr))->bufcurr=((Asn_buffer)(optr))->buffirst;\
  ((Asn_buffer)(optr))->bufclg=\
  ((Asn_buf_frag)(((Asn_buffer)(optr))->buffirst))->bufdoff;

/*-------------------set index in buffer-----------------*/
#define ASN_BUF_SET_INDEX(optr,index) \
  ASN_BUF_RESET(optr); \
  asn_walk_buffer(optr, index, 0, 0);

/*-------------------split a buffer ---------------------*/
#define ASN_BUF_SPLIT(nptr1,nptr2,optr,lbg)\
  asn_frgb((Asn_buffer *)(&(nptr1)), (Asn_buffer *)(&(nptr2)),\
           (Asn_buffer *)(&(optr)),lbg);

/*-------------------write octets into buffer -----------*/
#define ASN_BUF_WRITE(optr,aorg,l)	asn_wrb(optr,(A)aorg,l);

/*-----------------------------------------------------------------*/
/* Miscellaneous defines (needed in include files generated by the */
/* ASN.1 compiler).                                                */
/*-----------------------------------------------------------------*/
#define ASN1
#define ASNXXLA
#define ASNXLA
#define ASNSLLA
#define ASNCNST
#define ASNREAL
#define NOSIAM

/*******************************************************************/
/*                                                                 */
/*                          CONSTANTS                              */
/*                                                                 */
/*******************************************************************/

/*-----------------------------------------------------------------*/
/* Decoding error codes                                            */
/*-----------------------------------------------------------------*/
#define  ASN_E_WGHEAD              1
#define  ASN_E_WGFORM              2
#define  ASN_E_WGUNDEF_L           3
#define  ASN_E_WGLSUBLENG          4
#define  ASN_E_WGBOOL_LENG         5
#define  ASN_E_WGNULL_LENG         6
#define  ASN_E_WGBSTR_LENG         7
#define  ASN_E_INTERM_BSTR_PADD    8
#define  ASN_E_WGSSUBSTRING        9
#define  ASN_E_MISCOMPON          10
#define  ASN_E_WGCOMPON           11
#define  ASN_E_WGEOC              12
#define  ASN_E_MISEOC             13
#define  ASN_E_WGLEOC_LENG        14
#define  ASN_E_OVRLENGTH          15
#define  ASN_E_OVRBOUND           16
#define  ASN_E_MAX_IMPL           17
#define  ASN_E_WGALLOC            18
#define  ASN_E_WGINT_LENG         19
#define  ASN_E_WGPADD             20
#define  ASN_E_EXIT               21
#define  ASN_E_OVERREAL           22
#define  ASN_E_WGREAL_LENG        23
#define  ASN_E_PRECISION_LOSS     24
#define  ASN_E_WGREAL             25
#define  ASN_E_MANTISSA_LENG      26
#define  ASN_E_BAD_MATRIX         27
#define  ASN_E_CNST               28
#define  ASN_E_DECREAL_NOT_IMP    29
#define  ASN_E_MEMORY             30

/*-----------------------------------------------------------------*/
/* Semantic codes for encoding/encoding matrix                     */
/* (Generated by ASN.1 compiler.)                                  */
/*-----------------------------------------------------------------*/
#define ASN_CBOOL    0
#define ASN_DBOOL    0
#define ASN_CINT     1
#define ASN_DINT     1
#define ASN_CS_OSTR  2
#define ASN_DSOSTR   2
#define ASN_CS_OID   3
#define ASN_DSOID    3
#define ASN_CS_BSTR  4
#define ASN_DSBSTR   4
#define ASN_CB_OSTR  5
#define ASN_DBOSTR   5
#define ASN_CB_BSTR  6
#define ASN_DBBSTR   6
#define ASN_CB_OID   7
#define ASN_DBOID    7
#define ASN_CANY     8
#define ASN_DANY     8
#define ASN_CREAL    9
#define ASN_DREAL    9
#define ASN_CENUM    ASN_CINT
#define ASN_DENUM    ASN_DINT
#define ASN_CCANY    10
#define ASN_DDANY    10
#define ASN_CFANY    11
#define ASN_DFANY    11


#define ASN_CDUMMY   20

#define ASN_CNULL     21
#define ASN_DNULL     21
#define ASN_CSEQ      22
#define ASN_DSEQ      22
#define ASN_CSET      23
#define ASN_DSET      23
#define ASN_CETIQ     24
#define ASN_DETIQ     24
#define ASN_CCHOICE   25
#define ASN_DCHOICE   25
#define ASN_CSEQOF    26
#define ASN_DSSEQOF   26
#define ASN_CSETOF    27
#define ASN_DSSETOF   27
#define ASN_CLSEQOF   28
#define ASN_DLSEQOF   28
#define ASN_CLSETOF   29
#define ASN_DLSETOF   29
#define ASN_CPSEQ     30
#define ASN_DPSEQ     30
#define ASN_CPSET     31
#define ASN_DPSET     31

#define ASN_CINVALID  99
#define ASN_DINVALID  99

/*-----------------------------------------------------------------*/
/* Definitions of possible values for header class                 */
/* (Generated by ASN.1 compiler.)                                  */
/*-----------------------------------------------------------------*/
#define ASN_NONE         0xFF
#define ASN_UNIVERSAL    0x00
#define ASN_APPLICATION  0x40
#define ASN_CONTEXT      0x80
#define ASN_PRIVATE      0xC0


/*-----------------------------------------------------------------*/
/* Definitions of interesting values for the ads_skip field of     */
/* the decoding matrix                                             */
/*-----------------------------------------------------------------*/
#define ASN_SKP          0x01
#define ASN_ASANY        0x02


/*-----------------------------------------------------------------*/
/* Definitions of possible values for a constraint element         */
/* (Generated by ASN.1 compiler.)                                  */
/*-----------------------------------------------------------------*/
#define ASN_CT_EXCEP    1	/*-- EXCEPT constraint     --*/
#define ASN_CT_UNION    2	/*-- UNION  constraint     --*/
#define ASN_CT_INTER    3	/*-- INTER  constraint     --*/
#define ASN_CT_ALLEX    4	/*-- ALL EXCEPT constraint --*/
#define ASN_CT_VALUE    5	/*-- value  constraint     --*/
#define ASN_CT_CONT     6	/*-- INCLUDE  constraint   --*/
#define ASN_CT_PERM     7	/*-- FROM constraint       --*/
#define ASN_CT_SIZE     8	/*-- SIZE constraint       --*/
#define ASN_CT_RANGE    9	/*-- range constraint      --*/
#define ASN_CT_INNER   10	/*-- inner constraint      --*/
#define ASN_CT_IN_EL   11	/*-- inner element         --*/
#define ASN_CT_PRES    12	/*-- optional element      --*/
#define ASN_CT_INFST   13	/*-- < operator (range)    --*/
#define ASN_CT_INFEQ   14	/*-- <= operator (range)   --*/
#define ASN_CT_SUPST   15	/*-- < max operator        --*/
#define ASN_CT_SUPEQ   16	/*-- <= max operator       --*/
#define ASN_CT_CAVAL   17	/*-- character value (perm)--*/


/*----------------------------------------------------------------------*/
/* Constants defining the operator of a presence  constraint            */
/* (Generated by ASN.1 compiler.)                                       */
/*----------------------------------------------------------------------*/
#define ASN_PRE_CP      1	/*-- present            --*/
#define ASN_OPT_CP      2	/*-- optional           --*/
#define ASN_ABS_CP      3	/*-- absent             --*/



/*******************************************************************/
/*                                                                 */
/*                            TYPES                                */
/*                                                                 */
/*******************************************************************/

#define u_char	      unsigned char

/*-----------------------------------------------------------------*/
/* One octet (needed for files output by ASN.1 compiler)           */
/*-----------------------------------------------------------------*/
#define X             unsigned char

/*-----------------------------------------------------------------*/
/* Generalized pointer (needed for files output by ASN.1 compiler) */
/*-----------------------------------------------------------------*/
typedef unsigned char *A;

/*-----------------------------------------------------------------*/
/* Type used for storing ASN.1 boolean decoded values              */
/*-----------------------------------------------------------------*/
typedef unsigned char Asn_bool ;

/*-----------------------------------------------------------------*/
/* Boolean used to store all boolean information other than ASN.1  */
/* decoded values.                                                 */
/*-----------------------------------------------------------------*/
typedef int           Asn_boolx ;

/*-----------------------------------------------------------------*/
/* Unsigned integer for ASN.1 integer values                       */
/*-----------------------------------------------------------------*/
typedef unsigned long Asn_u_int ;

/*-----------------------------------------------------------------*/
/* Signed integer for ASN.1 integer values                         */
/*-----------------------------------------------------------------*/
typedef long          Asn_int ;

/*-----------------------------------------------------------------*/
/* Unsigned integer used to store all information other than ASN.1 */
/* decoded values.                                                 */
/*-----------------------------------------------------------------*/
typedef unsigned int  Asn_u_intx ;

/*-----------------------------------------------------------------*/
/* Signed integer used to store all information other than ASN.1   */
/* decoded values.                                                 */
/*-----------------------------------------------------------------*/
typedef int           Asn_intx ;

/*-----------------------------------------------------------------*/
/* Real    (signed) for ASN.1 REAL values                          */
/*-----------------------------------------------------------------*/
typedef double        Asn_real  ;

/*-----------------------------------------------------------------*/
/* Definition for enumerated type  (encoding/decoding engines)     */
/*-----------------------------------------------------------------*/
typedef Asn_int       Asn_enum;

/*-----------------------------------------------------------------*/
/* Decoding static matrix                                          */
/*-----------------------------------------------------------------*/
typedef struct {
	u_char          ads_semant;
	Asn_u_intx      ads_hleng;
	u_char          ads_optional;
	u_char          ads_yet_dec;
	char           *ads_head;
        Asn_u_intx      ads_son;
        Asn_u_intx      ads_next;
	Asn_u_intx      ads_max_impl;
	Asn_u_intx      ads_exit;
	u_char         *ads_default;
	Asn_intx        ads_offset;
	Asn_intx        ads_sizeof;
	Asn_intx        ads_t_def;
	u_char          ads_skip;
}               Asn_decode_mtx_rec;
typedef Asn_decode_mtx_rec *Asn_decode_mtx;

/*-----------------------------------------------------------------*/
/* Encoding static matrix                                          */
/*-----------------------------------------------------------------*/
typedef struct {
	u_char          acs_sem;
	u_char          acs_class;
	Asn_u_intx      acs_cid;
	Asn_u_intx      acs_son;
	Asn_u_intx      acs_prev;
}               Asn_encode_mtx_rec;
typedef Asn_encode_mtx_rec *Asn_encode_mtx;

/*-----------------------------------------------------------------*/
/* Encoding instances matrix                                       */
/*-----------------------------------------------------------------*/
typedef union {
	Asn_u_intx      i;
	u_char         *p;
}               Asn_instance_mtx_rec;
typedef Asn_instance_mtx_rec *Asn_instance_mtx;

/*-----------------------------------------------------------------*/
/* Decoding static matrix for debugging                           */
/*-----------------------------------------------------------------*/
typedef struct {
	u_char         *asn_name;
}               Asn_debug_mtx_rec;

/*-----------------------------------------------------------------*/
/* Constraint matrix                                               */
/*-----------------------------------------------------------------*/
typedef struct {
	Asn_u_intx      ct_son;
	Asn_u_intx      ct_brother;
	u_char          ct_semant;
	Asn_u_intx      ct_dat1;
	u_char         *ct_dat2;
}               Asn_constraint_mtx_rec;
typedef Asn_constraint_mtx_rec *Asn_constraint_mtx;

/*-----------------------------------------------------------------*/
/* Universal information base                                      */
/*-----------------------------------------------------------------*/
typedef struct {
	Asn_u_intx      asn_int;
	u_char         *asn_ptr;
}               Asn_info_base_rec;
typedef Asn_info_base_rec *Asn_info_base;

/*-----------------------------------------------------------------*/
/* Buffer structure (for memory management)                        */
/*-----------------------------------------------------------------*/

typedef struct Asn_buffer_rec *Asn_buffer;
typedef struct Asn_buf_frag_rec *Asn_buf_frag;
typedef struct Asn_memory_rec *Asn_memory;

/*---------control part----------*/
typedef struct Asn_buffer_rec {
	Asn_buffer      bufnxt;	    /* when in use: next in a sub chain */
	                            /* when free:   next free           */
	int             bufulg;	    /* global length of data   */
	int             bufclg;	    /* r/w ind in current data element  */
	Asn_buf_frag    buffirst;   /* first data element      */
	Asn_buf_frag    buflast;    /* last data element       */
	Asn_buf_frag    bufcurr;    /* data element for r/w    */
	int             bufpri1, bufpri2;  /* private int1,2   */
	u_char         *bufprp;	    /* private ptr             */
} Asn_buffer_rec;

/*---------fragment descriptor   part----------*/
struct Asn_buf_frag_rec {
	Asn_buf_frag    bufdnxt;    /* next fragment descriptor   */
	int             bufdulg;    /* length used in the DE      */
	int             bufdrlg;    /* total length (used + unused)
				       of DE         */
	int             bufdoff;    /* data offset in the DE      */
	u_char         *bufddptr;   /* ptr to DE (data element)   */
	Asn_memory      bufdmptr;   /* ptr to MD element          */
} Asn_buf_frag_rec;

/*---------real memory descriptor element ---------*/
struct Asn_memory_rec {
	Asn_memory      bufmnxt;    /* next memory descriptor */
	u_char         *bufmptr;    /* ptr to data element    */
	int             bufmown;    /* reference count        */
	int             bufmid;     /* id (0 = OSIAM, ~0 = user) */
} Asn_memory_rec;

/*******************************************************************/
/*                                                                 */
/*                           Variables                             */
/*                                                                 */
/*******************************************************************/
extern Asn_u_intx	asn_error;


/*******************************************************************/
/*                                                                 */
/*                    Function declarations                        */
/*                                                                 */
/*******************************************************************/

#ifdef __STDC__
extern void		asn_freedata(char *, int);
extern Asn_u_intx	asn_allocmem(char **, Asn_u_intx);
extern void     	asn_freemem(char **, Asn_u_intx);
extern Asn_u_intx	asn_exit(Asn_u_intx, char *, Asn_u_intx);
extern int		asn_encode(Asn_encode_mtx, Asn_decode_mtx, Asn_u_intx,
				   char *, Asn_buffer *);
extern Asn_u_intx	asn_decode(Asn_encode_mtx, Asn_decode_mtx, Asn_u_intx,
				   Asn_buffer *, char *);
extern int		asn_encode_oid(char *, Asn_buffer *);
extern int		asn_decode_oid(Asn_buffer *, char *);
#else /* ! __STDC__ */
extern void		asn_freedata();
extern unsigned int	asn_allocmem();
extern void     	asn_freemem();
extern Asn_u_intx	asn_exit();
extern int		asn_encode();
extern Asn_u_intx	asn_decode();
extern int		asn_encode_oid();
extern int		asn_decode_oid();
#endif /* ! __STDC__ */


/*----------------------*/
/* Internal functions.  */
/*----------------------*/
extern int	asn_asmb();
extern Asn_memory asn_bcre();
extern Asn_u_intx asn_cod();
extern Asn_u_intx asn_dec();
extern int	asn_frgb();
extern int	asn_ngetb();
extern int	asn_rdb();
extern int	asn_relb();
extern int	asn_remb();
extern int	asn_spcb();
extern void	asn_trace_on();
extern int	asn_walk_buffer();
extern int	asn_wrb();
