#pragma ident "@(#)appli.c 1.8 95/06/19 Copyright SMI"

/*
 * Copyright 19 Jun 1995 Sun Microsystems, Inc.  All Rights Reserved
 * Copyright 1991 Marben Produit.
 */

/*****************************************************************/
/* SunLink ASN.1 1.0 demonstration program.                      */
/*                                                               */
/* This is an example application that uses the structures       */
/* generated by the ASN.1 compiler.  (This is the Symmetric      */
/* Low Level Access to the compiler.)  This sample application   */
/* encodes then decodes one of the ASN.1 syntaxes specified in   */
/* the file demo.x409.                                           */
/*                                                               */
/* Usage:   Run make on the makefile.  This will invoke PLC409   */
/* on the 'demo.x409' file, and generate an example application  */
/* called appli.                                                 */
/*****************************************************************/

#include <stdio.h>

#include "asn1_runtime.h"

/*-- Generated structures  --*/
#include "demo_types.h"

/*-- Generated references  --*/
#include "demo_type_ids.h"

/*-- Encoding and decoding matrices   --*/
#include "demo_enc_matrix.h"
#include "demo_dec_matrix.h"

/*-- Generated function : offset computation   --*/
#include "demo_fill_matrix.h"

/*-- a non-zero ID to give to ASN_BUF_CREATE   --*/
#define MEM_MGMT_ID	37

/*-- useful routine for printing a given buffer     --*/
printbuf(buffer)
	Asn_buffer      buffer;
{
	long		len;
	int		i;
	u_char		buf[2];

	if (buffer) {
		ASN_BUF_LENGTH(buffer, len);
		printf("BUFFER IS %d OCTETS LONG\n", len);
		printf("\n");
		ASN_BUF_RESET(buffer);
		for (i = 1; i <= len; i++) {
			ASN_BUF_READ(buffer, buf, 1);
			printf("0x%x\t", buf[0]);
			if (!(i & 0x07))
				printf("\n");
		}
		printf("\n");
	} else
		printf("NULL\n");
	printf("\n\n");
}


/*-- external definition of decoding error status indicator --*/
extern Asn_u_intx asnerr;

/*-- main --*/
main()
{

	Message		cme, dme;
	RegMsg		cre, dre;
	Asn_buffer      encodedmes, resulte, inbuf;
	char            trace, trace1;
	char		*pt;
	int		i;
	char		*my_buffer;
	int		length;

	/*--  First of all, we dynamically fill the matrix    --*/
	/*--  This will fill the offset fields of the matrix. --*/
	/*--  This can't be done at generation time           --*/
	/*--  because these offsets are dependant on the      --*/
	/*--  final target machine.                           --*/
	/*--  In order to do it, we just have to call a       --*/
	/*--  function generated by the compiler (which is    --*/
	/*--  defined in the file demo_fill_matrix.h).        --*/

	demo_fill_matrix();

	/*-------------------*/
	/*-- ENCODING PART --*/
	/*-------------------*/

	/*-- Encode a message to send                 --*/
	/*-- First encode the 'RegMsg' SEQUENCE       --*/

	printf("\nPREPARING REGISTRATION MESSAGE TO SEND\n");

	/*--  date --*/
	cre.date.asnlength = 8;
	strcpy(cre.date.asnvalue, "30/06/94");

	/*--  client --*/
	cre.client.id = 12045;
	ASN_BUF_NEW(cre.client.name, 12);
	ASN_BUF_WRITE(cre.client.name, "SunLink ASN.1", 12);

	/*--  account --*/
	cre.account.center.asnpresent = 0;
	cre.account.acnt = 23450;

	/*--  credit card --*/
	cre.ccard.asnpresent = 1;
	cre.ccard.asnvalue.datev.asnlength = 7;
	strcpy(cre.ccard.asnvalue.datev.asnvalue, "june 95");
	cre.ccard.asnvalue.num = 117;

	/*--  numbers            --*/
	/*-- Put the two numbers 3 and 5 in the list. --*/
	cre.numbers = (struct _Ts_30 *) malloc(sizeof(*cre.numbers));
	cre.numbers->asnvalue = 3;
	cre.numbers->asnnext = (struct _Ts_30 *) malloc(sizeof(*cre.numbers));
	cre.numbers->asnnext->asnvalue = 5;
	cre.numbers->asnnext->asnnext = NULL;

	resulte = 0;

	/*--  call the general encoder --*/
	asn_encode(demo_encode_matrix,	/*-- encoding matrix          --*/
		   demo_decode_matrix,	/*-- decoding matrix          --*/
		   Tr_RegMsg,		/*-- structure identifier     --*/
		   (char *) &cre,	/*-- filled structure         --*/
		   &resulte		/*-- resulting encoded message--*/ );


	/*-- Now encode the 'Message' CHOICE, which includes the  --*/
	/*-- 'RegMsg' SEQUENCE                                    --*/

	cme.asnalternative = 1;
	cme.asnvalue.regi = resulte;

	encodedmes = 0;

	/*--  call the general encoder --*/
	asn_encode(demo_encode_matrix,	/*-- encoding matrix          --*/
		   demo_decode_matrix,	/*-- decoding matrix          --*/
		   Tr_Message,		/*-- structure identifier     --*/
		   (char *) &cme,	/*-- filled structure         --*/
		   &encodedmes		/*-- resulting encoded message--*/ );

	/*-- print the encoded buffer --*/
	printf("\nSENDING MESSAGE\n");
	printf("Do you want to display encodings (y/n) ? ");
	trace = getchar();
	getchar();
	if (trace == 'y')
		printbuf(encodedmes);

	/*-- Now pull the entire encoded string out of the ASN.1     --*/
	/*-- memory management buffer.                               --*/
	ASN_BUF_LENGTH(encodedmes, length);
	my_buffer = (char *) malloc(length);
	if (!my_buffer) {
		printf("Could not malloc %d bytes\n", length);
		exit (1);
	}
	ASN_BUF_RESET(encodedmes);
	ASN_BUF_READ(encodedmes, my_buffer, length);

	ASN_BUF_RELEASE(encodedmes);

	/*-------------------*/
	/*-- DECODING PART --*/
	/*-------------------*/

	/*-- Now suppose we are presented with a buffer containing an --*/
	/*-- ASN.1-encoded string.  The first thing to do is to put   --*/
	/*-- the string under ASN.1 memory management, so that the    --*/
	/*-- general decoder can process it.  There are two ways to   --*/
	/*-- do this:                                                 --*/
	/*--   1) ASN_BUF_NEW(newbuf, length), followed by            --*/
	/*--           ASN_BUF_WRITE(newbuf, my_buffer, length)       --*/
	/*--   2) ASN_BUF_CREATE(newbuf, ...)                         --*/
	/*-- The second option is shown below.                        --*/

	inbuf = (Asn_buffer) 0;

	/*-- Note that MEM_MGMT_ID *must* be non-zero for             --*/
	/*-- asn_freedata to ever be called!                          --*/
	ASN_BUF_CREATE(inbuf, my_buffer, length, length, 0, MEM_MGMT_ID);

#ifdef ASN1_DEBUG
	/*-- put the traces on --*/
	printf("Do you want to trace decoding (y/n) ? ");
	trace = getchar();
	getchar();
	if (trace == 'y')
		asn_trace_on();
#endif /* ASN1_DEBUG */

	printf("\nMESSAGE RECEIVED\n");
	printf("Decoding of Message syntax:\n");

	/*--  initialize the structure --*/
	memset(&dme, 0, sizeof(Message));

	/*--  call the general decoder --*/
	if (asn_decode(demo_encode_matrix,  /*-- encoding matrix      --*/
		       demo_decode_matrix,  /*-- decoding matrix      --*/
		       Tr_Message,	    /*-- message reference    --*/
		       &inbuf,		    /*-- encoded message      --*/
		       (char *) &dme	    /*-- structure to fill    --*/ )) {
		printf("ERROR: DECODING *not* OK\n");
		printf("Error = %d\n", asn_error);
		exit(1);
	} else {
		if (dme.asnalternative != 1) {
			printf("\nOPERATION MESSAGE RECOGNIZED\n");
			printf("ERROR: Not a registration message\n");
			exit(1);
		} else {
			printf("\nREGISTRATION MESSAGE RECOGNIZED\n");


			/*-- decode a message : registration type --*/
			printf("Hit return to decode RegMsg syntax ");
			getchar();

			/*--  initialize the structure --*/
			for (i = 0, pt = (char *) &dre; i < sizeof(RegMsg); i++)
				*(pt + i) = 0;

			/*--  call the general decoder --*/
			if (asn_decode(demo_encode_matrix,
				       demo_decode_matrix,
				       Tr_RegMsg,
				       &dme.asnvalue.regi,
				       (char *) &dre)) {
				printf("\nERROR: DECODING IS *not* OK\n");
				printf("Error = %d\n", asn_error);
				exit(1);
			} else {
				printf("\nDECODING IS OK\n");
				/*
				 * Now that we're done, free the only
				 * remaining non-null Asn_buffer struct.
				 * (The 'inbuf' buffer is NULL at this point,
				 * because 'inbuf' was reused for
				 * dme.asnvalue.regi, which was itself
				 * reused for dre.client.name.)
				 */
				ASN_BUF_RELEASE(dre.client.name);
				exit(0);
			}
		}
	}
}


/*
 * asn_freemem() -- callback routine
 *
 * Called by the general encoder to free memory used by an element of a
 * 'SEQUENCE OF' or 'SET OF' list after that element has been encoded.
 * (Need to define this because the ASN.1 syntax for RegMsg
 * includes an element, 'numbers', which is a SEQUENCE OF
 * INTEGER.)
 */
void
asn_freemem(bufp, size)
	char		**bufp;
	Asn_u_intx	size;
{
	free(*bufp);
	*bufp = 0;
}


/*
 * asn_freemem() -- callback routine
 *
 * Called by the general decoder when memory for an element of a
 * 'SEQUENCE OF' or 'SET OF' list is allocated before that element
 * is decoded.
 * (Need to define this because the ASN.1 syntax for RegMsg
 * includes an element, 'numbers', which is a SEQUENCE OF
 * INTEGER.)
 */
Asn_u_intx
asn_allocmem(bufp, size)
	char		**bufp;
	Asn_u_intx	size;
{
	/*
	 * Use calloc() instead of malloc() to ensure that the memory is
	 * filled with zeros.
	 */
	*bufp = (char *) calloc(size, 1);
	return ((*bufp) ? 0 : 1);
}


/*
 * asn_freedata() -- callback routine
 *
 * Called by ASN_BUF_RELEASE to free the user buffer that was associated
 * to an ASN.1 memory management buffer with ASN_BUF_CREATE.
 */
void
asn_freedata(buf, id)
	char		*buf;
	int		id;
{
	if (id == MEM_MGMT_ID) {
		printf("Freeing user buffer\n");
		free(buf);
	}
}
