#pragma ident "@(#)appli.c 1.9 95/04/20 Copyright SMI"

/*
 * Copyright 20 Apr 1995 Sun Microsystems, Inc.  All Rights Reserved
 * Copyright 1991 Marben Produit.
 */

/*****************************************************************/
/* SunLink ASN.1 1.0 demonstration program.                      */
/*                                                               */
/* This is an example application that uses ASN.1 encoding and   */
/* decoding routines generated by the ASN.1 compiler.  (This is  */
/* the High Level Access to the compiler.)  This sample          */
/* application encodes then decodes one of the ASN.1 syntaxes    */
/* specified in the file demo.x409.                              */
/*                                                               */
/* Usage:   Run make on the makefile.  This will invoke PLC409   */
/* on the 'demo.x409' file, and generate an example application  */
/* called appli.                                                 */
/*****************************************************************/

#include <stdio.h>

#include "asn1_runtime.h"

/*-- prototype of the generated routines       --*/
#include "demo_prototype.h"


/*-- a non-zero ID to give to ASN_BUF_CREATE   --*/
#define MEM_MGMT_ID	37

/*-- useful routine for printing a given buffer     --*/
printbuf(buffer)
	Asn_buffer      buffer;
{
	long		len;
	int		i;
	u_char		buf[2];

	if (buffer) {
		ASN_BUF_LENGTH(buffer, len);
		printf("BUFFER IS %d OCTETS LONG\n", len);
		printf("\n");
		ASN_BUF_RESET(buffer);
		for (i = 1; i <= len; i++) {
			ASN_BUF_READ(buffer, buf, 1);
			printf("0x%x\t", buf[0]);
			if (!(i & 0x07))
				printf("\n");
		}
		printf("\n");
	} else
		printf("NULL\n");
	printf("\n\n");
}


/*-- external definition of decoding error status indicator --*/
extern Asn_u_intx asnerr;

/*-- main --*/
main()
{

	Asn_u_intx      tmess, len1, len2;
	Asn_int         center, count, id, cc;
	Asn_boolx       ccb;
	Asn_buffer      resulte, resultd, resulto, inbuf, outbuf, name;
	u_char		date1[20];
	u_char		date2[20];
	char            trace, trace1;
	char		*my_buffer;
	int		length;

	/*-------------------*/
	/*-- ENCODING PART --*/
	/*-------------------*/

	/*-- Encode a message to send                 --*/
	/*-- First encode the 'RegMsg' SEQUENCE       --*/

	printf("\nPREPARING REGISTRATION MESSAGE TO SEND\n");

	ASN_BUF_NEW(name, 13);
	ASN_BUF_WRITE(name, "SunLink ASN.1", 13);
	resulte = (Asn_buffer) 0;

	CRegMsg((Asn_u_intx) 8,		/* date length      */
		(u_char *) "30/06/94",	/* date value       */
		(Asn_int) 12045,	/* client id        */
		name,			/* client name      */
		(Asn_boolx) 0,		/* no center        */
		(Asn_int) 0,		/* center value     */
		(Asn_int) 23450,	/* account #        */
		(Asn_boolx) 1,		/* some credit card */
		(Asn_u_intx) 7,		/* exp date length  */
		(u_char *) "june 95",	/* exp date value   */
		(Asn_int) 117,		/* card #           */
		&resulte);		/* encoded buffer   */

	/*-- Now encode the 'Message' CHOICE, which includes the  --*/
	/*-- 'RegMsg' SEQUENCE                                    --*/
	outbuf = (Asn_buffer) 0;

	CMessage((Asn_u_intx) 1,	/* registration message  */
	         resulte,		/* message body          */
	         (Asn_buffer) 0,	/* no operation body     */
	         &outbuf);		/* message to send       */

	/*-- print the encoded buffer --*/
	printf("\nSENDING MESSAGE\n");
	printf("Do you want to display encodings (y/n) ? ");
	trace = getchar();
	getchar();
	if (trace == 'y')
		printbuf(outbuf);

	/*-- Now pull the entire encoded string out of the ASN.1     --*/
	/*-- memory management buffer.                               --*/
	ASN_BUF_LENGTH(outbuf, length);
	my_buffer = (char *) malloc(length);
	if (!my_buffer) {
		printf("Could not malloc %d bytes\n", length);
		exit (1);
	}
	ASN_BUF_RESET(outbuf);
	ASN_BUF_READ(outbuf, my_buffer, length);

	/*-- Free the ASN.1 memory management buffer.                --*/
	/*-- (Note: don't need to free 'resulte', as it is part of   --*/
	/*-- 'outbuf'						     --*/
	ASN_BUF_RELEASE(outbuf);

	/*-------------------*/
	/*-- DECODING PART --*/
	/*-------------------*/

	/*-- Now suppose we are presented with a buffer containing an --*/
	/*-- ASN.1-encoded string.  The first thing to do is to put   --*/
	/*-- the string under ASN.1 memory management, so that the    --*/
	/*-- general decoder can process it.  There are two ways to   --*/
	/*-- do this:                                                 --*/
	/*--   1) ASN_BUF_NEW(newbuf, length), followed by            --*/
	/*--           ASN_BUF_WRITE(newbuf, my_buffer, length)       --*/
	/*--   2) ASN_BUF_CREATE(newbuf, ...)                         --*/
	/*-- The second option is shown below.                        --*/

	inbuf = (Asn_buffer) 0;

	/*-- Note that MEM_MGMT_ID *must* be non-zero for             --*/
	/*-- asn_freedata to ever be called!                          --*/
	ASN_BUF_CREATE(inbuf, my_buffer, length, length, 0, MEM_MGMT_ID);

#ifdef ASN1_DEBUG
	/*-- put the traces on --*/
	printf("Do you want to trace decoding (y/n) ? ");
	trace = getchar();
	getchar();
	if (trace == 'y')
		asn_trace_on();
#endif /* ASN1_DEBUG */

	/*-- decode the whole message --*/

	printf("\nMESSAGE RECEIVED\n");
	printf("Decoding of Message syntax:\n");

	resultd = (Asn_buffer) 0;
	resulto = (Asn_buffer) 0;

	if (DMessage(&inbuf,		/* message received    */
		     &tmess,		/* regis(1)/oper(2)    */
		     &resultd,		/* registration body   */
		     &resulto)) {	/* operation body -- should be NULL */
		printf("ERROR: DECODING *not* OK\n");
		printf("Error = %d\n", asn_error);
		exit(1);
	} else {
		if (tmess != 1) {
			printf("OPERATION MESSAGE RECOGNIZED\n");
			printf("ERROR: Not a registration message\n");
			exit(1);
		} else {
			printf("\nREGISTRATION MESSAGE RECOGNIZED\n");

			/*-- decode a message : registration type --*/
			printf("Hit return to decode RegMsg syntax ");
			getchar();

			if (DRegMsg(&resultd, &len1, date1, &id, &name,
				    &center, &count, &ccb, &len2,
				    date2, &cc)) {
				printf("\nERROR: DECODING IS *not* OK\n");
				printf("Error = %d\n", asn_error);
				exit(1);
			} else {
				printf("\nDECODING IS OK\n");
				/*
				 * Now that we're done, free the only
				 * remaining non-null Asn_buffer struct.
				 * (The 'inbuf' and 'resultd' buffers
				 * are NULL at this point, because 'inbuf'
				 * was reused for 'resultd', and 'resultd'
				 * was reused for 'name'.)
				 */
				ASN_BUF_RELEASE(name);
				exit(0);
			}
		}
	}
}


/*
 * asn_freedata() -- callback routine
 *
 * Called by ASN_BUF_RELEASE to free the user buffer that was associated
 * to an ASN.1 memory management buffer with ASN_BUF_CREATE.
 */
void
asn_freedata(buf, id)
	char		*buf;
	int		id;
{
	if (id == MEM_MGMT_ID) {
		printf("Freeing user buffer\n");
		free(buf);
	}
}
