#ident "@(#)ex_xmpMacro.h	1.8 21 Feb 1994 SMI"
/*
 * Copyright 1993 Sun Microsystems, Inc. All Rights Reserved
 */

/******************************************************************************/
/***                                                                        ***/
/***  Name : ex_xmpMacro.h                                                  ***/
/***                                                                        ***/
/***                                                                        ***/
/***  Date : July 13 92                                                     ***/
/***                                                                        ***/
/******************************************************************************/
/***                                                                        ***/
/***  Description :                                                         ***/
/***       The current file contains different macro definitions used       ***/
/***       throughout the example code.                                     ***/
/***                                                                        ***/
/******************************************************************************/

#include <cmip/xmp_dbg.h>

/*------------------------------------------------------------------*/
/* The following structure is used to represent the attributes of a */
/* managed object (attribute identifier, attribute type, and value  */
/*------------------------------------------------------------------*/

typedef struct attribute {
	OM_string	id;
	OM_syntax	syntax;
	OM_value	val;
} attribute;

#include "ex_proto.h"

#define STATIC_BUFFER_SIZE 	4096
#define TIME_OUT		30*1000		/* Because the wait function works */
						/* in milli-seconds */

#define CHECK_OM_CALL(msg, name, ret) 					\
	if (ret!=OM_SUCCESS) {        					\
		(void) sprintf(msg,"%s failed with error: %s", name, xomerr(ret)); \
		return ret;                 					\
	}

#define CHECK_MP_CALL(status, workspace, session)			\
	if (status != MP_SUCCESS) {					\
		(void) mp_error_message(status, STATIC_BUFFER_SIZE, msg);	\
		printf("%s\n",  msg);					\
		mp_unbind(session);						\
		mp_shutdown(workspace);						\
		exit(0);							\
	}
