#ident "@(#)ex_init.c	1.11 21 Feb 1994 SMI"
/*
 * Copyright 1993 Sun Microsystems, Inc. All Rights Reserved
 */

/******************************************************************************/
/***                                                                        ***/
/***  Name : ex_init.c                                                      ***/
/***                                                                        ***/
/***  Date : July 31 92                                                     ***/
/***                                                                        ***/
/******************************************************************************/
/***                                                                        ***/
/***  Description :                                                         ***/
/***       The present file contains functions for building context objects.***/
/***                                                                        ***/
/******************************************************************************/

/******************************************************************************/
/***                          STANDARD INCLUDE                              ***/
/******************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <sys/systeminfo.h>

/******************************************************************************/
/***                          PACKAGE INCLUDE                               ***/
/******************************************************************************/
#include <cmip/xom.h>
#include <cmip/xmp.h>
#include <cmip/xmp_cmis.h>

/******************************************************************************/
/***                             USER INCLUDE                               ***/
/******************************************************************************/
#include "ex_xomTool.h"
#include "ex_xmpMacro.h"

#include "ex_coImp.h"
#include "ex_cmImp.h"

/******************************************************************************/
/***                        GLOBAL DEFINITION                               ***/
/******************************************************************************/

/******************************************************************************/
/***                                                                        ***/
/***  FUNCTION NAME :   changePublicAttribute                               ***/
/***                                                                        ***/
/***                                                                        ***/
/******************************************************************************/
OM_return_code changePublicAttribute(OM_type type, OM_value *val, OM_syntax syntax, OM_object object)
/*	OM_type			type;	*/
/*	OM_value		*val;	*/
/*	OM_syntax		syntax;	*/
/*	OM_object		object;	*/
{
while (object->type != OM_NO_MORE_TYPES) {
	if (object->type == type) {
		switch (syntax) {
		case OM_S_OCTET_STRING:
			object->value.string.length= val->string.length;
			object->value.string.elements= val->string.elements;
			break;
		case OM_S_INTEGER:
			object->value.integer= val->integer;
			break;
		default: /* to be completed with other types if necessary ..*/
			break;
		}
		return OM_SUCCESS;
	}
	object++;
}

return OM_SUCCESS;
}


/******************************************************************************/
/***                                                                        ***/
/***   FUNCTION NAME : chartohex                                            ***/
/***                                                                        ***/
/***                                                                        ***/
/******************************************************************************/
int chartohex(char c)
{
if (isdigit(c)) return (0xFF & (c-'0'));
return (10+(0xFF & (toupper(c)-'A')));
}

/******************************************************************************/
/***                                                                        ***/
/***   FUNCTION NAME : alphahexatostr                                       ***/
/***                                                                        ***/
/***                                                                        ***/
/******************************************************************************/
char *alphahexatostr(char *src, int *len)
/*	char	*src;	alphanumeric string to be converted */
/*	int	*len;	returned length of result           */
{
int	i= strlen(src);
int	j= i/2;
char	*res= (char *) malloc(sizeof(char)*j);
char	*ptr= res;

if (res==NULL) return(NULL);
*len = j;
while (i>0)
	if (isxdigit(*src) && isxdigit(*(src+1))) {
		*ptr++= (char) (chartohex(*src)<<4 | chartohex(*(src+1)));
		i-= 2; src+= 2;
	} else {
		free(res); return(NULL);
	}
return(res);
}

/******************************************************************************/
/***                                                                        ***/
/***  FUNCTION NAME :	initAttribute                                       ***/
/***                                                                        ***/
/***                                                                        ***/
/******************************************************************************/
OM_return_code initAttribute(char *argv, char *msg, int isnotset[], int setindex, char *strdescr, char *prog, OM_public_object ctx, OM_type typ)
/*	char			*argv;      */
/*	char			*msg;       */
/*	int			isnotset[]; */
/*	int			setindex;   */
/*	char			*strdescr;  */
/*	char			*prog;      */
/*	OM_public_object	ctx;        */
/*	OM_type			typ;        */
{
OM_value	val;

if (isnotset[setindex]==0) {
	(void) sprintf(msg, "Error on %s\nCommand syntax: %s [-n RnetworkAddress] [-t RtransportAddress] [-s RsessionAddress] [-p RpresentationAddress]\n\t[-N LnetworkAddress] [-T LtransportAddress] [-S LsessionAddress] [-P LpresentationAddress]\n", argv, prog);
	return OM_FUNCTION_DECLINED;
}
if (strncmp(argv, "0x", 2)) {
	val.string.length= strlen(argv);
	val.string.elements= argv;
} else if ((int) strlen(argv)%2) {
	sprintf(msg, "%s %s : must be of even length\n", strdescr, argv);
	return OM_FUNCTION_DECLINED;
} else if ((val.string.elements= alphahexatostr(argv+2, (int *) &(val.string.length)))==NULL) {
	(void) sprintf(msg, "%s %s : must be hexadecimal\n", strdescr, argv);
	return OM_FUNCTION_DECLINED;
}
changePublicAttribute(typ, &val, OM_S_OCTET_STRING, ctx);
isnotset[setindex] = 0;
return OM_SUCCESS;
}

/******************************************************************************/
/***                                                                        ***/
/***  FUNCTION NAME :   initContextSession                                  ***/
/***                                                                        ***/
/***                                                                        ***/
/******************************************************************************/
OM_return_code initContextSession(char *msg, OM_public_object ctx, OM_public_object ses, int *default_ses_not_used, int argc, char *argv[])
/*	char			*msg;                  */
/*	OM_public_object	ctx, ses;              */
/*	int			*default_ses_not_used; */
/*	int			argc;                  */
/*	char			*argv[];               */
{
OM_return_code		ret;
OM_value		val;
char			c, buf [100];
static int		ctx_isnotset[] = {1, 1, 1, 1};
static int		ses_isnotset[] = {1, 1, 1, 1};
char			*prog=strrchr(argv[0], '/');

if (prog==NULL) prog = argv[0]; else prog++;

while ((c = getopt(argc, argv, "n:t:s:p:N:T:S:P:"))!=EOF) {
	switch (c) {
	case 'n':
		/*------------------------------------*/
		/* Process the REMOTE network address */
		/*------------------------------------*/
		if ((ret = initAttribute(optarg, msg, ctx_isnotset, 0,
					"networkAddress", prog, ctx, MP_N_ADDRESSES))
		    !=OM_SUCCESS) return ret;
		break;
	case 't':
		/*--------------------------------------*/
		/* Process the REMOTE transport address */
		/*--------------------------------------*/
		if ((ret = initAttribute(optarg, msg, ctx_isnotset, 1,
					"transportAddress", prog, ctx, MP_T_SELECTOR))
		    !=OM_SUCCESS) return ret;
		break;
	case 's':
		/*------------------------------------*/
		/* Process the REMOTE session address */
		/*------------------------------------*/
		if ((ret = initAttribute(optarg, msg, ctx_isnotset, 2,
					"sessionAddress", prog, ctx, MP_S_SELECTOR))
		    !=OM_SUCCESS) return ret;
		break;
	case 'p':
		/*-----------------------------------------*/
		/* Process the REMOTE presentation address */
		/*-----------------------------------------*/
		if ((ret = initAttribute(optarg, msg, ctx_isnotset, 3,
					"presentationAddress", prog, ctx, MP_P_SELECTOR))
		    !=OM_SUCCESS) return ret;
		break;
	case 'N':
		/*-----------------------------------*/
		/* Process the LOCAL network address */
		/*-----------------------------------*/
		if ((ret = initAttribute(optarg, msg, ses_isnotset, 0, "networkAddress", prog, ses, MP_N_ADDRESSES))!=OM_SUCCESS) return ret;
		*default_ses_not_used = 1;
		break;
	case 'T':
		/*-------------------------------------*/
		/* Process the LOCAL transport address */
		/*-------------------------------------*/
		if ((ret = initAttribute(optarg, msg, ses_isnotset, 1, "transportAddress", prog, ses, MP_T_SELECTOR))!=OM_SUCCESS) return ret;
		*default_ses_not_used = 1;
		break;
	case 'S':
		/*-----------------------------------*/
		/* Process the LOCAL session address */
		/*-----------------------------------*/
		if ((ret = initAttribute(optarg, msg, ses_isnotset, 2, "sessionAddress", prog, ses, MP_S_SELECTOR))!=OM_SUCCESS) return ret;
		*default_ses_not_used = 1;
		break;
	case 'P':
		/*----------------------------------------*/
		/* Process the LOCAL presentation address */
		/*----------------------------------------*/
		if ((ret = initAttribute(optarg, msg, ses_isnotset, 3, "presentationAddress", prog, ses, MP_P_SELECTOR))!=OM_SUCCESS) return ret;
		*default_ses_not_used = 1;
		break;
	default:
		(void) sprintf(msg, "Command syntax: %s [-n RnetworkAddress] [-t RtransportAddress] [-s RsessionAddress] [-p RpresentationAddress]\n\t[-N LnetworkAddress] [-T LtransportAddress] [-S LsessionAddress] [-P LpresentationAddress]\n", prog);
		return OM_FUNCTION_DECLINED;
		break;
	} /* switch */
} /* while */

/* REMOTE Network address not set by user: use LLC1 default */
if (ctx_isnotset[0]) {
	if (sysinfo(SI_HW_SERIAL, buf, 100) < 0) {
		sprintf(msg, "Cannot find hostid\n");
		return OM_FUNCTION_DECLINED;
	}
	sprintf(buf, "49%x01", atol(buf));
	if ((val.string.elements= alphahexatostr(buf, (int *) &(val.string.length)))==NULL) {
		sprintf(msg, "networkAddress %s : must be hexadecimal\n", buf);
		return OM_FUNCTION_DECLINED;
	}
	changePublicAttribute(MP_N_ADDRESSES, &val, OM_S_OCTET_STRING, ctx);
}

/* LOCAL Network address not set by user: use LLC1 default */
if (ses_isnotset[0]) {
	if (sysinfo(SI_HW_SERIAL, buf, 100) < 0) {
		sprintf(msg, "Cannot find hostid\n");
		return OM_FUNCTION_DECLINED;
	}
	sprintf(buf, "49%x01", atol(buf));
	if ((val.string.elements= alphahexatostr(buf, (int *) &(val.string.length)))==NULL) {
		sprintf(msg, "networkAddress %s : must be hexadecimal\n", buf);
		return OM_FUNCTION_DECLINED;
	}
	changePublicAttribute(MP_N_ADDRESSES, &val, OM_S_OCTET_STRING, ses);
}
return OM_SUCCESS;
}
