; RE_SID: @(%)/files/nfs/pcnfs/win/telnetw/em320wlb/SCCS/s.emvt.asm 1.2 94/03/05 18:25:55 SMI
		page    ,132
		TITLE   EMVT

; IMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM;
; :                                                                        :
; :      COPYRIGHT (c) DIVERSIFIED COMPUTER SYSTEMS, INC. 1983-1992        :
; :                                                                        :
; :     All rights reserved.  Unauthorized distribution is Prohibited.     :
; :                                                                        :
; HMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM<
;
;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3Modification History                                                          3
;3                                                                              3
;3                                                                              3
;3 08/06/93     T. Bigelow      Derived this from em.asm (moved vt_emulate,em_vt3
;3                              em_cs_debug to here.                            3
;3 08/12/93     B. Bigelow      Changed edit stuff to more meaningful names.    3
;3 08/12/93     B. Bigelow      Changed call to mov_cur to Move_Emul_Cursor     3
;3 08/14/93     B. Bigelow      Removed unused extern reset and others          3
;3 08/15/93     B. Bigelow      Changed alloc_scr_mem to Allocate_Scrollback_Buf3
;3 08/18/93     B. Bigelow      Cursor changes.                                 3
;3 08/18/93     T. Bigelow      Replaced call 'pos_cur' with                    3
;3                              '_Position_Emul_Cursor'                         3
;3 08/23/93     T. Bigelow      Converted part of 'vt_em_edit' to C             3
;3 08/26/93     B. Bigelow      Removed unused extrn cr_flag                    3
;3 08/27/93     B. Bigelow      Took out usage of su_tek_autosw                 3
;3 08/30/93     T. Bigelow      Converted bell to _Bell (.ASM to .C)            3
;3                              Converted ers_line to _Erase_Line (.ASM to .C)  3
;3 09/03/93     T. Bigelow      Replaced call to 'con_in' with equivalent code  3
;3 09/07/93     B. Bigelow      Took out ifdefs                                 3
;3                              Changed call to ccall for Erase_Line            3
;3 09/23/93     B. Bigelow      2.01 Removed commented code.                    3
;3 10/19/93     S. Gill         Changed set scrolling region to call updwnd_f   3
;3                              prior to changing scrolling vars.               3
;3 11/15/93     B. Bigelow      Converted em_test_pat to "C"                    3
;3                                                                              3
;3 12/27/93     S. Gill         invalid esc sequence did not reset esc sequence 3
;3                              Non erasable character was setting wrong bit    3
;3                              it was still using old attribute bit            3
;3 03/01/94     S. Gill         Added an update throttle to main loop (sun only)3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY

		include attrib.def
		include cmac.def
		include emcomm.def
		include emdef.def
		include emulbuf.def
		include fkey.def
		include macdef.def
		include slstate.ash
		include win.def

		extrn   calc_line_desc_adr:far
		extrn   kb_in:far
		extrn   connect_chk:far
		extrn   conv_dw_line:far
		extrn   conv_nf:far
		extrn   conv_sw_line:far
;;              extrn   _EM_Test_Pat:far
		extrn   em_test_pat:far
		extrn   em_fk_lookup:far
		extrn   em_kb_in:far
		extrn   em_soft_reset:far
		extrn   emkbin_esc:far
;;              extrn   _Erase_Line:far
		extrn   ers_line:far
		extrn   get_rcvchr:far
		extrn   get_udk:far
		extrn   kbd_out:far
		extrn   ld_cmd_file:far
		extrn   logical_print_byte:far
		extrn   pbk_log_char:far
		extrn   _Position_Emul_Cursor:far
		extrn   prt_line:far
		extrn   prt_out:far
		extrn   reset_func:far
		extrn   scroll_dn:far
		extrn   scroll_up:far
		extrn   sel_nrc_gl:far
		extrn   sio_xmtmsg:far
		extrn   wp_check:far
		extrn   updwnd_f:far
		extrn   wrt_stat_line:far
		extrn   xlc_xlat_in:far
		extrn   xlc_xlat_out:far

		extrn   GlobalFree:far
		extrn   GlobalLock:far
		extrn   GlobalUnlock:far

		extrn   _Allocate_Scrollback_Buf:far
		extrn   _Disable_Emul_Cursor:far
		extrn   _Enable_Emul_Cursor:far

		extrn   _Move_Emul_Cursor:far
		extrn   _Printer_NR:far
		extrn   _Snap_Out_Of_Scrollback:far

		extrn   _Update_Status_Line_Row_Column:far
		extrn   _Update_Status_Line_Section:far
		extrn   _Write_MSg_line:far
		extrn   _Write_Msg_line_Msg:far
		extrn   _Process_Paste_Or_Send:far

;Externals called from the control sequence tables

		extrn   dcs_sl_char:far
		extrn   em_aprtoff:far
		extrn   em_aprton:far
		extrn   em_break:far
		extrn   em_char:far
		extrn   em_clprt:far
		extrn   em_cntrlq:far
		extrn   em_cntrls:far
		extrn   em_cr:far
		extrn   em_cprton:far
		extrn   em_del_char:far
		extrn   em_delkey:far
		extrn   em_dcs_char:far
		extrn   em_dcs_proc:far
		extrn   em_dcs_private:far
		extrn   em_dsr:far
		extrn   em_era_chrs:far
		extrn   em_eralin:far
		extrn   em_erascr:far
		extrn   em_g0:far
		extrn   em_g1:far
		extrn   em_g2:far
		extrn   em_g3:far
		extrn   em_g1_96:far
		extrn   em_g2_96:far
		extrn   em_g3_96:far
		extrn   em_init:far
		extrn   em_ins_char:far
		extrn   em_lbreak:far
		extrn   em_lf:far
		extrn   em_ls2:far
		extrn   em_ls3:far
		extrn   em_ls1r:far
		extrn   em_ls2r:far
		extrn   em_ls3r:far
		extrn   em_pause:far
		extrn   em_pprt:far
		extrn   em_print:far
		extrn   em_rescur:far
		extrn   em_resmode:far
		extrn   em_rqm:far
		extrn   em_rqpsr:far
		extrn   em_rqtsr:far
		extrn   em_rqupss:far
		extrn   em_savcur:far
		extrn   em_set_compat:far
		extrn   em_setatt:far
		extrn   em_setmode:far
		extrn   em_ss2:far
		extrn   em_ss3:far
		extrn   em_stat_disp:far
		extrn   em_stat_type:far
		extrn   em_vt52_eos:far
		extrn   em_vt52_eol:far
		extrn   em_wau:far

		extrn   cf_cmp_str:byte
		extrn   cmd_abort_flag:byte
		extrn   con_att_code:byte
		extrn   con_mode:byte
		extrn   dcs_call_adr:word
		extrn   dcs_state_flag:byte
		extrn   debug_word:word
		extrn   deverr_flag:byte
		extrn   eminit_flag:byte
		extrn   emul_ret_opt:byte
		extrn   esc_ptr:word
		extrn   on_exit:byte
		extrn   su_mode:byte
		extrn   su_screen:byte
		extrn   su_tabs:byte
		extrn   su_xlat_mode:byte
		extrn   su_u_features:byte
		extrn   su_vt_response:byte
		extrn   syserr_proc:byte
		extrn   sysexit_proc:byte
		extrn   scroll_cnt:byte
		extrn   _edit_state:word
		extrn   _KBEvent:byte
		extrn   _hEditSendMemory:word

;Data and stack segment

DGROUP  GROUP   em_data

em_data         segment word public 'data'

dbg_esc_msg     db      '<ESC>',0
dbg_csi_msg     db      '<CSI>',0
dbg_dcs_msg     db      '<DCS>',0

		msg     vt52id_msg,1bh,'/Z'

;VT220 control sequence table for escape sequences NOT containing ESC [

;Search sequence is two bytes long
;Characters following the ESCAPE character are checked for matching sequence
; Second byte =  0 - If single character sequence
;             = -1 - If single character sequence with characters following

cs_tab1         db      'c',-1                  ;reset
		dd      em_reset
		db      'D',-1                  ;index
		dd      em_index
		db      'E',-1                  ;new line
		dd      em_newlin
		db      'H',-1                  ;set tab
		dd      em_settab
		db      'M',-1                  ;reverse index
		dd      em_revind
		db      'N',-1                  ;single shift ss2
		dd      em_ss2
		db      'O',-1                  ;single shift ss3
		dd      em_ss3
		db      'P',-1                  ;DCS - device control string
		dd      em_dcs_proc
		db      'Z',-1                  ;what are you
		dd      em_wau
		db      'n',-1                  ;LS2 - G2 to GL
		dd      em_ls2
		db      'o',-1                  ;LS3 - G3 to Gl
		dd      em_ls3
		db      '7',-1                  ;save cursor and attributes
		dd      em_savcur
		db      '8',-1                  ;restore cursor and attributes
		dd      em_rescur
		db      '<',-1                  ;ANSI mode
		dd      em_ansi
		db      '=',-1                  ;set keypad mode
		dd      em_setkpd
		db      '>',-1                  ;reset keypad mode
		dd      em_reskpd
		db      '~',-1                  ;LS1R - G1 to GR
		dd      em_ls1r
		db      '}',-1                  ;LS2R - G2 to GR
		dd      em_ls2r
		db      '|',-1                  ;LS3R - G3 to GR
		dd      em_ls3r
		db      '\',-1                  ;7 bit ST equiv
		dd      em_ignore
		db      '#3'                    ;dwdh top half
		dd      em_tdwdh
		db      '#4'                    ;dwdh bot half
		dd      em_bdwdh
		db      '#5'                    ;swsh
		dd      em_swsh
		db      '#6'                    ;dwsh
		dd      em_dwsh
		db      '#8'                    ;screen alignment test
		dd      simulate_em_test_pat
		db      ' F'                    ;Select seven bit C1
		dd      em_sel_7c1
		db      ' G'                    ;Select eight bit C1
		dd      em_sel_8c1

;94 character set sequences

		db      '(',-1                  ;g0
		dd      em_g0
		db      ')',-1                  ;g1
		dd      em_g1
		db      '*',-1                  ;g2
		dd      em_g2
		db      '+',-1                  ;g3
		dd      em_g3

;96 character set sequences

		db      '-',-1                  ;g1 96 character size
		dd      em_g1_96
		db      '.',-1                  ;g2 96 character size
		dd      em_g2_96
		db      '/',-1                  ;g3 96 character size
		dd      em_g3_96
cs_tab1_siz     equ     ($-cs_tab1)/6

;Control sequence transfer table for escape sequence containing ESC [

;Search sequence is two bytes long
;Characters terminating the ESCAPE sequence are checked for matching sequence
; Second byte =  0 - If single character sequence

cs_tab2         db      'A',0                   ;cursor up
		dd      em_curup
		db      'B',0                   ;cursor down
		dd      em_curdn
		db      'C',0                   ;cursor forward
		dd      em_curfo
		db      'D',0                   ;cursor backward
		dd      em_curbck
		db      'G',0                   ;move cursor to column
		dd      em_curcol
		db      'H',0                   ;direct cursor
		dd      em_curdir
		db      'J',0                   ;erase screen functions
		dd      em_erascr
		db      'K',0                   ;erase line functions
		dd      em_eralin
		db      'L',0                   ;insert Line
		dd      em_inslin
		db      'M',0                   ;delete line
		dd      em_dellin
		db      'P',0                   ;delete character
		dd      em_delchr
		db      'S',0                   ;scroll screen down
		dd      em_scrdn
		db      'T',0                   ;scroll screen up
		dd      em_scrup
		db      'X',0                   ;erase characters
		dd      em_era_chrs
		db      'c',0                   ;what are you
		dd      em_wau
		db      'f',0                   ;Direct cursor
		dd      em_curdir
		db      'g',0                   ;clear tab functions
		dd      em_clrtab
		db      'h',0                   ;set mode functions
		dd      em_setmode
		db      'i',0                   ;printer port functions
		dd      em_print
		db      'l',0                   ;reset mode functions
		dd      em_resmode
		db      'm',0                   ;set attributes
		dd      em_setatt
		db      'n',0                   ;device status report
		dd      em_dsr
		db      '"p'			;set compatibility level
		dd      em_set_compat
		db      '"q'			;select character attributes
		dd      em_sel_chr_att
		db      'r',0                   ;set scrolling region
		dd      em_setscr
		db      '!p'                    ;soft reset
		dd      em_soft_reset
		db      '$p'                    ;request mode
		dd      em_rqm
		db      '$u'                    ;request terminal state report
		dd      em_rqtsr
		db      '&u'                    ;request user-prefered
		dd      em_rqupss               ;supplemental character set
		db      '$w'                    ;request presentation state
		dd      em_rqpsr
		db      '$}'                    ;select active status display
		dd      em_stat_disp
		db      '$~'                    ;select status line type
		dd      em_stat_type
		db      'y',0                   ;tests
		dd      em_tests
		db      '@',0                   ;Insert characters
		dd      em_inschr
		db      '|',0                   ;DCS Private
		dd      em_dcs_private

cs_tab2_siz     equ     ($-cs_tab2)/5

;C1 Control Table

c1_tab          db      ind                     ;index
		dd      em_index
		db      nel                     ;new line
		dd      em_newlin
		db      hts                     ;hor tab set
		dd      em_settab
		db      ri                      ;reverse index
		dd      em_revind
		db      ss2                     ;single shift g2 ss2
		dd      em_ss2
		db      ss3                     ;single shift g3 ss3
		dd      em_ss3
		db      dcs                     ;udk definition
		dd      em_dcs_proc
c1_tab_size     equ     ($-c1_tab)/5

;VT52 escape sequence table

vt52_tab        db      '='                     ;alternate keypad mode
		dd      em_setkpd
		db      '>'                     ;reset keypad mode
		dd      em_reskpd
		db      '<'                     ;ansi mode
		dd      em_vt52_ansi
		db      '^'                     ;auto print on
		dd      em_aprton
		db      '-'                     ;auto print off
		dd      em_aprtoff
		db      ']'                     ;crt page print
		dd      em_pprt
		db      'A'                     ;cursor up
		dd      em_vt52_cu
		db      'B'                     ;cursor down
		dd      em_vt52_cd
		db      'C'                     ;cursor right
		dd      em_vt52_cf
		db      'D'                     ;cursor left
		dd      em_vt52_cb
		db      'F'                     ;graphics mode
		dd      em_vt52_decgr
		db      'G'                     ;graphics off
		dd      em_vt52_ascii
		db      'H'                     ;home cursor
		dd      em_vt52_home
		db      'I'                     ;reverse index
		dd      em_revind
		db      'J'                     ;erase to eos
		dd      em_vt52_eos
		db      'K'                     ;erase to eol
		dd      em_vt52_eol
		db      'W'                     ;controller print on
		dd      em_cprton
		db      'V'                     ;print cursor line
		dd      em_clprt
		db      'Y'                     ;direct cursor
		dd      em_vt52_dcur
		db      'Z'                     ;identify
		dd      em_vt52_id
vt52_tab_siz    equ     ($-vt52_tab)/5

em_data         ends

;Code Segment

em              segment word public 'code'
		assume  cs:em
		assume  ds:DGROUP

;IMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM;
;:                                              :
;: VT_EMULATE - INPUT/OUTPUT EMULATION LOOP     :
;:                                              :
;LMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM9
;:                                              :
;:  Inputs                                      :
;:                                              :
;:    none                                      :
;:                                              :
;:  Outputs                                     :
;:                                              :
;:    carry set if return caused by disconnect  :
;:                                              :
;HMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM<

		public  vt_emulate

vt_emulate      proc    far


;Insure ld_cmd_file executed if EMULATE used in EMINIT or SESS_LOAD

		cmp     eminit_flag,0           ;check if em in initialization
		je      vt_em_init              ;skip if not

;Execute load setup command file

		call    ld_cmd_file             ;execute load setup command file

;Insure status line reset if EMULATE used in SESS_LOAD

		cmp     eminit_flag,2           ;check if em in sess_load
		jne     vt_em_init              ;skip if not
		mov     ax,word ptr cursor_line ;restore cursor
;               call    pos_cur                 ;...
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;...
		pop     ax

vt_em_init:     mov     eminit_flag,0           ;reset em init flag
		push    ax
		ccall   _Enable_Emul_Cursor     ;turn cursor on
		pop     ax

;Update Caps Lock status

vt_em_lp:

;Call System Dispatcher to process event messages

;Read the keyboard
;KB_IN will call System Dispatcher to process event messages

		call    em_kb_in                ;read keyboard character
		jnz     vt_em_kbd               ;skip if a kb character

;=======================================================
;EDIT_PASTE_IN_PROGRESS and EDIT_SEND_IN_PROGRESS LOOP |
;=======================================================

vt_em_edit:     cmp     _edit_state,EDIT_PASTE_IN_PROGRESS ;for speed purposes
						;check edit state here.
		jb      vt_em_rcv               ;if not in paste or send mode,
						;then jump

		ccall   _Process_Paste_Or_Send  ;Returns 0 if ok
						;Returns 1 if device error
		or      ax,ax                   ;error ?
		jz      vt_emulate_end          ;yes, then skip

;Check for hold (pause)

vt_em_rcv:      cmp     ts_pause,0              ;check for pause condition
		jnz     vt_em_rcv_idle          ;do not process chars if is

;ZDDDDDDDDDDDDDDDDDDDD?
;3DATA RECEIVE LOOP   3
;@DDDDDDDDDDDDDDDDDDDDY
char_upd_cnt    equ     140                     ;keyboard sample rate and display throttle

		mov     dl,char_upd_cnt         ;reset throttle character count
vt_em_rcv_lp:   dec     dl                      ;count down data received
		jnz     vt_em_rcv_lp1           ;skip if count not reached

		call    em_kb_in                ;check for key message or
		jnz     vt_em_kbd               ;buffered key stroke
		cmp     scroll_cnt,0            ;do not force update, if a scroll is pending
		jnz     vt_em_rcv_lp0           ;If we don't do this, jump scroll will be defeated
		call    updwnd_f                ;update window
vt_em_rcv_lp0:  mov     dl,char_upd_cnt         ;reset read throttle counter

vt_em_rcv_lp1:  call    get_rcvchr              ;get a receive character
		jz      vt_em_rcv_idle          ;skip if no data

		push    ax
		ccall   _Disable_Emul_Cursor    ;disable cursor
		ccall   _Snap_Out_Of_Scrollback ;get out of scrollback
		pop     ax

		call    em_vt                   ;process character

;Check return string option

		cmp     emul_ret_opt,1          ;check emulate return option
		jne     vt_em_rcv_lp            ;skip if not
		cmp     cf_cmp_str,0            ;check for match string
		jnz     vt_em_rcv_lp            ;skip if no match
		jmp     vt_emulate_end          ;skip if deverr, cmd redirection
 
;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3IDLE LOOP  (No Receive data, no Keyboard input)   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY

vt_em_kb_idle:  cmp     DGROUP:_KBEvent,0       ;check for repeat key character
		jne     vt_em_rcv_idle          ;skip if keys waiting

vt_em_rcv_idle: call    updwnd_f                ;update window

		push    ax
		ccall   _Enable_Emul_Cursor     ;set cursor
		ccall   _Update_Status_Line_Row_Column ;Update the row & column
		pop     ax

		cmp     deverr_flag,1           ;check if rcv device error
		je      vt_emulate_end          ;skip if deverr, cmd redirection

;Check Connect Status

vt_em_idle10:   call    connect_chk             ;check modem connect status
		jc      vt_emulate_ret          ;skip if disconnect, cmd
						;redirection

;Check Auto Scroll

ifdef VERSIONS_BEFORE_2_00
; FIGURE OUT HOW TO HANDLE THIS LATER
;               call    hs_auto_scroll          ;check for auto hor scroll
endif
		jmp     vt_em_lp

;ZDDDDDDDDDDDDDDDDDDDDDDDDD?
;3KEYBOARD CHARACTER READY 3
;@DDDDDDDDDDDDDDDDDDDDDDDDDY

;Keyboard character

;If more characters waiting, disable cursor

vt_em_kbd:      cmp     DGROUP:_KBEvent,0       ;check for repeat key character
		je      vt_kbd2                 ;skip if keys not waiting
		push    ax
		ccall   _Disable_Emul_Cursor    ;disable cursor
		pop     ax
		jmp     vt_kbd3
vt_kbd2:        push    ax
		ccall   _Enable_Emul_Cursor     ;set cursor
		pop     ax

;Check for function key

vt_kbd3:        cmp     ah,2                    ;check for function key
		je      vt_kbd30                ;skip if token

;Check for delete key

vt_kbd20:       cmp     dl,t_del                ;check for delete
		jne     vt_kbd30                        ;skip if not
		call    em_delkey               ;call delete key
		jmp     vt_em_kb_idle           ;update display

;Check for WP mode

vt_kbd30:       call    wp_check                ;check for wp mode key
		jnc     vt_kbd40                        ;skip if not
		jmp     vt_em_kb_idle           ;update display

;Check for function keys

vt_kbd40:       mov     cx,ax                   ;save key values
		or      dl,dl                   ;check for token
		jz      vt_kbd50                ;skip call if not
		mov     ah,fke_em               ;set for emulation mode lookup
		call    em_fk_lookup            ;check for a function key
		jnc     vt_kbd50                ;skip if not found

;Call function key routine

		call    updwnd_f                ;force window update
		mov     cmd_abort_flag,0        ;clear the abort flag
		call    dword ptr [bx]          ;call function routine
		cmp     deverr_flag,1           ;check if device error
		je      vt_emulate_end          ;skip if deverr, cmd redirection
		mov     on_exit,0               ;reset on_exit flag
		mov     syserr_proc,0           ;reset syserr_proc flag
		mov     sysexit_proc,0          ;reset sysexit_proc flag
		jmp     vt_em_kb_idle           ;key executed - update display
						;and loop again

;Check for UDK

vt_kbd50:       call    get_udk                 ;check for udk
		jz      vt_kbd100               ;skip if not one

;Process UDK

		or      al,al                   ;check for no user defined data
		jz      vt_kbd90                ;return to loop if no data
		mov     cl,al                   ;count to cl
vt_kbd60:       mov     al,[bx]                 ;get udk character
		call    xlc_xlat_out            ;translate character
		call    kbd_out                 ;send character
vt_kbd70:       call    get_rcvchr              ;get receive character
		jz      vt_kbd80                ;skip if none
		call    em_vt                   ;process character
		cmp     deverr_flag,1           ;check if device error
		je      vt_emulate_end          ;skip if deverr, cmd redirection
		jmp     vt_kbd70                ;look for another

vt_kbd80:       inc     bx                      ;inc udk data pointer
		dec     cl                      ;dec count
		jnz     vt_kbd60                ;do next
vt_kbd90:       jmp     vt_em_kb_idle           ;update display

;Process Input Character

vt_kbd100:      mov     ax,cx                   ;get key value back
		call    xlc_xlat_out            ;translate character for output
		call    kbd_out                 ;process keyboard character
		jmp     vt_em_kb_idle           ;update display

vt_emulate_end: clc
vt_emulate_ret: pushf
		call    updwnd_f                ;force window update
		popf
		ret

vt_emulate      endp

page

;IMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM;
;:EM_VT - PROCESS RECEIVED CHARACTER, THEN RETURN  :
;LMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM9
;: Inputs                                          :     
;:                                                 :     
;:   al = character                                :
;:                                                 :
;: Outputs                                         :
;:                                                 :
;:   none                                          :     
;:                                                 :
;HMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM<

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3This routine is located here due to historical reasons, at one time it wasn't   3
;3even a subroutine.                                                              3
;3                                                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY

		public  em_vt

em_vt           proc    far

		push    ax
		push    bx
		push    cx
		push    dx
		push    si
		push    di
		mov     di,esc_ptr              ;restore escape pointer

;Check for escape or escape processing in progress

;Mask to 7 bits if not 8 bit mode

em121:          cmp     su_mode,vt200_7_mode    ;check for vt200 or vt300
		jae     em122                   ;skip if is
		and     al,7fh                  ;mask to seven
em122:          mov     em_char_save,al         ;save character

		test    debug_word,20h          ;contol character xlat allowed?
		jz      em122aa                 ;skip if not
		call    xlc_xlat_in             ;call translation

;Check for UDK string in process

em122aa:        cmp     dcs_state_flag,0        ;check for dcs (dev crtl str) in
						;progress
		jz      em122a                  ;skip if not
		call    em_dcs_char             ;process dcs character
		jnz     em122b                  ;process character if non zero
						;return
		jmp     em140                   ;get next character

;Check for user defined status line write in progress

em122a:         cmp     dcs_call_adr,0          ;check for dcs private call
		jz      em122b                  ;skip if not
		call    dword ptr dcs_call_adr  ;process dcs character
		jnz     em122a                  ;process character if non zero
						;ret
		jmp     em140

;Check for Escape

em122b:         cmp     al,01bh                 ;check for an escape
		jne     em123                   ;skip if not escape
		call    pbk_log_char            ;log the character
		call    emkbin_esc              ;set esc seq flag
		mov     esc_seqcnt,1            ;set escape sequence count/flg
		mov     di,offset esc_buf       ;set esc buffer address
		mov     word ptr [di],'  '      ;init esc to 2 blanks
		mov     cs_start_char,al        ;store lead-in character
		jmp     em140                   ;finish process loop

;Check for CSI

em123:          cmp     al,csi                  ;check for eight bit lead in
		jne     em123a                  ;skip if not
		cmp     su_xlat_mode,0          ;skip if not IBM mode
		jne     em123_0                 ;...
		call    xlc_xlat_in             ;output character
		jc      em125                   ;skip if translation
em123_0:        call    pbk_log_char            ;log csi
		mov     esc_seqcnt,2            ;setup as if 7 bit csi
		mov     di,offset esc_buf       ;...
		mov     word ptr [di], ' ['     ;...
		inc     di                      ;...
		mov     cs_start_char,al        ;store lead-in char
		jmp     em140                   ;...

;Check for other Eight Bit Codes

em123a:         cmp     ts_prtmode,2            ;check controller print mode
		je      em125                   ;skip if is
		cmp     al,80h                  ;check for eight bit code
		jb      em125                   ;skip if not
		cmp     al,9fh                  ;check upper bound
		ja      em125                   ;skip if not

;Allow C1 translation if IBM mode

		test    debug_word,20h          ;xlat option set?
		jne     em123aa                 ;if is, xlat already happened
		cmp     su_xlat_mode,0          ;skip if not IBM mode
		jne     em123aa                 ;...
		call    xlc_xlat_in             ;output character
		jc      em125                   ;skip if translation

;Process eight bit c1 code

em123aa:        call    pbk_log_char            ;log character
		mov     bx,offset c1_tab        ;set start of c1 table
		mov     cx,c1_tab_size          ;set size of table
em123b:         cmp     al,[bx]                 ;check for match
		jne     em124                   ;skip if not
		mov     cs_start_char,al        ;store start character
		call    dword ptr 1[bx]         ;call processor
		mov     esc_seqcnt,0            ;reset sequence in prog
		jmp     em140

em124:          add     bx,5                    ;inc pointer
		loop    em123b                  ;look til no more entries
		jmp     em140                   ;skip character

;Not 7 or eight bit lead-in - check for control sequence in progress

em125:          cmp     esc_seqcnt,0            ;check for esc seq in progress
		jne     em230                   ;skip if is

;Process character

em130:          mov     al,em_char_save         ;get char
		cmp     ts_prtmode,2            ;check for controller print
		jne     em132                   ;skip if not set
		call    logical_print_byte      ;send char to printer
		jnc     em131                   ;skip if printer ready
em130a:
		ccall   _Printer_NR             ;printer not ready
		mov     ts_prtmode,0            ;reset controller mode
		mov     ts_print_flag,0         ;reset print flag

		push    ax
		ccall   _Update_Status_Line_Section SL_SECT_PRINT
		pop     ax

em131:          jmp     em140                   ;finish loop

em132:          call    em_char                 ;call character processor

;Update window rectangle

em140:          cmp     esc_seqcnt,0            ;check for esc seq in progress
		je      em150                   ;skip if not

;Complete processing loop

em150:          mov     esc_ptr,di              ;save escape pointer

;Return

		pop     di
		pop     si
		pop     dx
		pop     cx
		pop     bx
		pop     ax
		ret

;Escape sequence in progress

em230:          cmp     ts_prtmode,2            ;check printer controller mode
		je      em230a                  ;skip if controller mode
		cmp     al,20h                  ;check for control char
		jb      em230a0                 ;skip if control char
		call    pbk_log_char            ;log the character
		jmp     em234                   ;not control char

;Check for tek erase (ESC FF)

em230a0:        cmp     al,ff                   ;check for form feed
		jne     em132                   ;skip if not
		cmp     esc_seqcnt,1            ;tek esc ff ?
		jne     em132                   ;skip if not
		mov     esc_seqcnt,0            ;reset escape

;Printer controller mode in effect

em230a:         call    pbk_log_char            ;log the character
		or      al,al                   ;check for null
		jz      em140                   ;skip if null
		cmp     su_mode,vt52_mode       ;check for vt52
		je      em233                   ;skip if is


;Check for ansi printer controller mode terminate

		mov     [di],al                 ;store char in esc buf
		mov     dh,esc_seqcnt           ;get the esc seq cnt
		cmp     dh,1                    ;check cnt=1
		jne     em230d                  ;skip if not
		cmp     al,'['                  ;check first char
		jne     em233c                  ;skip if no match
em230d:         cmp     dh,2                    ;check for cnt=2
		jne     em230f                  ;skip if not
		cmp     al,'5'                  ;check for enable controller mode
		je      em230f                  ;skip if is
		cmp     al,'6'                  ;check for pr receive mode off
		je      em230f                  ;skip if is
		cmp     al,'7'                  ;check for pr receive mode on
		je      em230f                  ;skip if is
		cmp     al,'4'                  ;check for the second term char
		jne     em233c                  ;skip if not
em230f:         cmp     dh,3                    ;check for esc len=3
		je      em231                   ;skip if is
		inc     esc_seqcnt              ;bump the count
		inc     di                      ;and pointer
		jmp     em140                   ;finish loop

em231:          cmp     al,'i'                  ;check the last char of seq
		jne     em233c                  ;skip if no match
		cmp     esc_buf+1,'4'           ;check for reset controller mode
		je      em232                   ;if match - reset controller mode
		cmp     esc_buf+1,'5'           ;check for enable controller mode
		je      em232a                  ;ignore if is
		cmp     esc_buf+1,'6'           ;check for printer receive mode off
		je      em232a                  ;if is - ignore sequence
		cmp     esc_buf+1,'7'           ;check for printer receive mode on
		je      em232a                  ;if is - ignore sequence
		jmp     em233c                  ;no match

em232:          mov     ts_prtmode,0            ;reset controller print
		mov     ts_print_flag,0         ;clear printing flag

		push    ax
		ccall   _Update_Status_Line_Section SL_SECT_PRINT
		pop     ax

em232a:         mov     esc_seqcnt,0            ;clear escape count/flag
em232b:         jmp     em140                   ;finish loop

;Check for vt52 printer controller terminate

em233:          cmp     al,'X'                  ;check for terminator
		je      em232                   ;skip if match
em233c:         mov     al,esc_char             ;send the escape to the printer
		call    logical_print_byte      ;...
		jnc     em233e                  ;skip if ok
em233d:
		ccall   _Printer_NR             ;printer not ready
		jmp     em232

em233e:         mov     dl,esc_seqcnt           ;print esc sequence
		mov     ax,offset esc_buf       ;...
		call    prt_out                 ;...
		jc      em233d                  ;skip if not ready
		jmp     em232a

;Escape sequence processing

em234:          cmp     su_mode,vt52_mode       ;check for vt52
		jne     em235                   ;skip if not
		jmp     em400

em235:          cmp     al,'['                  ;check for left bracket
		jne     em250                   ;skip if not
		cmp     esc_seqcnt,1            ;check for first char
		je      em245                   ;skip if 1st char after esc
em243:          mov     esc_seqcnt,0            ;reset esc seq in prog
		jmp     em130                   ;process char

;ESC [ sequence

em245:          mov     [di],al                 ;store esc char
		cmp     esc_seqcnt,80           ;check for max count
		jae     em247
		inc     di                      ;bump pointer
		inc     esc_seqcnt              ;bump esc cnt
em247:          jmp     em140                   ;finish loop

em250:          cmp     al,3fh                  ;check for ending char
		ja      em270                   ;skip if it is
		cmp     al,20h                  ;check for 20h or less
		jl      em243                   ;skip if < 20 - seq no good

;Escape sequence intermediate processing

		cmp     al,2fh                  ;check for 2/0 - 2/15
		jbe     em245                   ;skip if is
		cmp     esc_buf,'['             ;check for [ first character
		je      em245                   ;if was, store char in sequence
em270:          mov     [di],al                 ;store as terminating char
		mov     esc_term_chr,al         ;save terminating character

;Process escape sequence - check for debug

		cmp     ts_debug,0              ;check for debug
		je      em280                   ;skip if not

;Control Sequence Debug

		call    em_cs_debug             ;call control seq debug

;Ready to process escape sequence containing [

;Check for ESC [ or CSI

em280:          mov     bx,offset cs_tab2       ;set table address
		mov     cx,cs_tab2_siz          ;set table size
		mov     ah,-1[di]               ;get second to last char
		cmp     esc_buf,'['             ;check for left bracket sequence
		je      em300                   ;skip if is

;Process escape sequence not containing [

		mov     bx,offset cs_tab1       ;set table start
		mov     cx,cs_tab1_siz
		mov     ax,word ptr esc_buf     ;get second to last char
		xchg    al,ah

;Find matching character(s)

em300:          cmp     byte ptr 1[bx],0        ;check last char only?
		jne     em310                   ;skip if not
		cmp     [bx],al                 ;check last character
		je      em315                   ;skip if match
		jmp     em320                   ;check next

em310:          cmp     byte ptr 1[bx],-1       ;check second to last char only?
		jne     em312                   ;skip if not
		cmp     [bx],ah                 ;check second to last character
		je      em315                   ;skip if match
		jmp     em320                   ;check next

em312:          cmp     [bx],ah                 ;check second to last character
		jne     em320                   ;skip if no match
		cmp     1[bx],al                ;check last character
		jne     em320                   ;skip if no match
em315:          call    dword ptr 2[bx]         ;goto routine
		mov     esc_seqcnt,0            ;clear escape in progress flag
		jmp     em140                   ;finish loop

em320:          add     bx,6                    ;update pointer
		loop    em300                   ;loop if count not 0

;Invalid escape sequence

em390:          mov     esc_seqcnt,0            ;reset esc sequence
		jmp     em140                   ;finish loop

;VT52 ESCAPE SEQUENCE

em400:
		cmp     esc_buf,'Y'             ;check for dir cur in progress
		je      em405                   ;skip if is
		cmp     al,'Y'                  ;check for direct cursor
		jne     em418                   ;skip if not
em405:          mov     [di],al                 ;store char in esc buff
		inc     esc_seqcnt              ;bump the seq cnt
		inc     di                      ;bump buffer pointer
		cmp     esc_seqcnt,4            ;check for seq of 4
		jne     em425                   ;get next char if not
		mov     al,esc_buf              ;get beginning char of seq
em418:          mov     bx,offset vt52_tab      ;get table address
		mov     cx,vt52_tab_siz         ;get size
em420:          cmp     al,[bx]                 ;check terminator for match
		jne     em430                   ;skip if not
		call    dword ptr 1[bx]         ;call routine
		mov     esc_seqcnt,0            ;clear sequence
em425:          jmp     em140                   ;finish loop

em430:          add     bx,5                    ;update pointer
		loopnz  em420                   ;loop til all checked
		jmp     em390                   ;no good

;DIRECT CURSOR POSITION

em_curdir:      mov     si,offset esc_buf+1     ;set escape buffer adr
		call    conv_nf                 ;get line
		xor     ch,ch                   ;clear column
		mov     cl,al                   ;move line to cl
		cmp     dl,';'                  ;check for semicolon
		jne     em_curdir30             ;skip if not
		call    conv_nf                 ;get column
		mov     ch,al                   ;move column to ch
em_curdir30:    cmp     dl,'f'                  ;check for proper terminator
		je      em_curdir40             ;skip if terminator
		cmp     dl,'H'                  ;check for other terminator
		je      em_curdir40             ;skip if terminator
		cmp     dl,';'                  ;check for semicolon
		jne     em_curdir55             ;return if not
		call    conv_nf                 ;get terminator
		jmp     em_curdir30             ;look for terminator

em_curdir40:    or      cl,cl                   ;check for 0 line
		jne     em_curdir42             ;skip if not
		inc     cl                      ;set to line 1
em_curdir42:    or      ch,ch                   ;check for 0 column
		jne     em_curdir45             ;skip if not
		inc     ch                      ;set to column 1
em_curdir45:    cmp     ts_orgmod,0             ;check for origin set
		jne     em_curdir60             ;if set, go to process it

;Origin is  top left of screen

		cmp     cl,ts_screen_bot        ;check for max line
		jbe     em_curdir50             ;skip if not above
		mov     cl,ts_screen_bot        ;set to bottom

;Check for dw line

em_curdir50:    mov     al,cl                   ;line # to al
		call    calc_line_desc_adr      ;calculate line desc address
		cmp     ld_attrib[bx],latt_swsh ;check for single width and height
		je      em_curdir51             ;skip if not
		shl     ch,1                    ;double cur col
		dec     ch                      ;minus 1
em_curdir51:    cmp     ch,col_max              ;check for max column
		jbe     em_curdir52             ;skip if below
		mov     ch,col_max              ;set to max
em_curdir52:    mov     ax,cx                   ;position cursor
		cmp     al,cursor_line          ;change in cursor line position?
		je      em_curdir54             ;skip if not

;Autoprint mode for IBM systems that use direct cursor positioning instead
;of cr lf.

		cmp     ts_prtmode,1            ;check for auto print on
		jne     em_curdir54             ;skip if not set
		push    ax                      ;save current position
		mov     al,cursor_line          ;previous line
		call    prt_line                ;print line
		jnc     em_curdir53             ;skip if printer ready
		mov     ts_prtmode,0            ;set print mode off
		mov     ts_print_flag,0         ;...

		push    ax
		ccall   _Update_Status_Line_Section SL_SECT_PRINT
		pop     ax

		ccall   _Printer_NR             ;printer not ready
em_curdir53:    pop     ax                      ;restore new position
em_curdir54:
;               call    pos_cur                 ;...
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;...
		pop     ax
em_curdir55:    ret

;Origin mode

em_curdir60:    add     cl,scroll_top           ;calculate correct orgin
		dec     cl                      ;adjust
		cmp     cl,scroll_bot           ;check for > bottom
		jbe     em_curdir50             ;skip if not
		mov     cl,scroll_bot           ;set to bottom
		jmp     em_curdir50

;SET SCROLLING REGION

;If scroll top = 0, then scroll top =1
;if scroll bot = 1, then scroll bot = dialog bot

em_setscr:      call    updwnd_f                ;force update of screen
		xor     cx,cx                   ;clear reg
		mov     si,offset esc_buf+1     ;set escape buffer address
		call    conv_nf                 ;process numeric field
		mov     cl,al                   ;save top value
		cmp     dl,';'                  ;check for semi-colon
		jne     em_setscr12             ;skip if it is
		call    conv_nf                 ;get bottom
		mov     ch,al                   ;save it
em_setscr12:    cmp     dl,'r'                  ;check for terminator
		jne     em_setscr30             ;skip if error
		or      cl,cl                   ;check for top=0
		jnz     em_setscr15             ;skip if not
		inc     cl                      ;set to 1
em_setscr15:    cmp     cl,ts_screen_bot        ;check for max value
		jae     em_setscr30             ;ignore seq if >=
		or      ch,ch                   ;check for bot=0
		jnz     em_setscr20             ;skip if not
		mov     ch,ts_screen_bot        ;set default
em_setscr20:    cmp     ch,ts_screen_bot        ;check for max value
		ja      em_setscr30             ;ignore seq if >
		mov     al,ch                   ;copy scroll bot
		sub     al,cl                   ;sub top from bottom
		cmp     al,1                    ;check for two or > inclusive
		jl      em_setscr30             ;ignore if invalid
		mov     word ptr scroll_top,cx  ;save scrolling region
		mov     ax,0101h                ;set default line and col
		cmp     ts_orgmod,0             ;check for orgin mode off
		je      em_setscr25             ;skip if off
		mov     al,cl                   ;set line to top of region
em_setscr25:
;               call    pos_cur                 ;...
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;...
		pop     ax
em_setscr30:    ret

;CURSOR FORWARD

em_vt52_cf:     mov     al,1                    ;vt52 entry
		jmp     em_curfo2

em_curfo:       mov     si,offset esc_buf+1     ;set to esc arg
		call    conv_nf                 ;convert value
		cmp     dl,'C'                  ;check for correct terminator
		jne     em_curfo10              ;skip if not equal
		or      al,al                   ;check for 0 value
		jnz     em_curfo2               ;skip if not
		inc     al                      ;set to 1
em_curfo2:      mov     ah,al                   ;col to ah
		mov     al,cursor_line          ;get current line
		call    calc_line_desc_adr      ;calc line desc address
		cmp     ld_attrib[bx],latt_swsh ;check for single width and height
		je      em_curfo3               ;skip if is
		shl     ah,1                    ;double count
em_curfo3:      add     ah,cursor_col           ;add in current column
		cmp     ah,col_max              ;exceed max cursor?
		jbe     em_curfo5               ;skip if not exceeded
		mov     ah,col_max              ;set to max
		inc     ah                      ;set to max +1
em_curfo5:      mov     al,cursor_line          ;set to current line
;               call    pos_cur                 ;position cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;position cursor
		pop     ax
em_curfo10:     ret

;CURSOR BACKWARD

em_vt52_cb:     mov     al,1                    ;vt52 entry
		jmp     em_curbck2

em_curbck:      mov     si,offset esc_buf+1     ;set esc arg
		call    conv_nf                 ;convert the numeric field
		cmp     dl,'D'                  ;check for correct terminator
		jne     em_curbck10             ;Ignore if not
		or      al,al                   ;test for zero arg
		jnz     em_curbck2              ;skip if not
		inc     al                      ;set to 1
em_curbck2:     mov     ah,al                   ;col to ah
		mov     al,cursor_line          ;get current line
		call    calc_line_desc_adr      ;calc line desc address
		cmp     ld_attrib[bx],latt_swsh ;check for single width and height
		je      em_curbck3              ;skip if is
		shl     ah,1                    ;double count
em_curbck3:     xor     bh,bh                   ;clear to aviod sign
		mov     al,ah                   ;col count to al
		xor     ah,ah                   ;...
		mov     bl,cursor_col           ;get current col
		cmp     bl,col_max              ;check for > max
		jbe     em_curbck4              ;skip if not > max
		mov     bl,col_max              ;set to max
em_curbck4:     sub     bx,ax                   ;form new position
		cmp     bx,1                    ;check for < 1
		jge     em_curbck5              ;skip if above 1
		mov     bx,1                    ;set to 1
em_curbck5:     mov     ah,bl                   ;column to ah
		mov     al,cursor_line          ;set to current line
;               call    pos_cur                 ;positon cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;positon cursor
		pop     ax
em_curbck10:    ret

;CURSOR UP

em_vt52_cu:     mov     al,1                    ;vt52 entry
		jmp     em_curup2

em_curup:       mov     si,offset esc_buf+1     ;set arg address
		call    conv_nf                 ;convert to numeric field
		cmp     dl,'A'                  ;check for correct terminator
		jne     em_curup4               ;skip if not
		or      al,al                   ;check for zero value
		jnz     em_curup2               ;skip if not
		inc     al                      ;set to 1
em_curup2:      mov     ah,cursor_line          ;get cursor line
		mov     dl,ah                   ;save it
		sub     ah,al                   ;form new cursor adr
		mov     al,ah                   ;
		cmp     dl,scroll_top           ;old pos < scroll top?
		jae     em_curup5               ;skip if not
		cmp     al,1                    ;new pos < 1
		jge     em_curup3               ;skip if not
		mov     al,1                    ;set to 1
em_curup3:      mov     ah,cursor_col           ;and current col
;               call    pos_cur                 ;position cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;position cursor
		pop     ax
em_curup4:      ret
em_curup5:      cmp     al,scroll_top           ;new pos < scroll top
		jge     em_curup3               ;skip if not
		mov     al,scroll_top           ;set to scroll top
		jmp     em_curup3

;CURSOR DOWN

em_vt52_cd:     mov     al,1                    ;vt52 entry
		jmp     em_curdn2

em_curdn:       mov     si,offset esc_buf+1     ;set esc arg adr
		call    conv_nf                 ;convert numeric arg
		cmp     dl,'B'                  ;insure correct term
		jne     em_curdn4               ;return if not
		or      al,al                   ;test for zero value
		jnz     em_curdn2               ;skip if not
		inc     al                      ;set to 1
em_curdn2:      mov     ah,cursor_line          ;get cursor line
		mov     dl,ah                   ;save it
		add     al,ah                   ;form new cursor adr
		cmp     dl,scroll_bot           ;old pos > scroll bottom?
		jbe     em_curdn5               ;skip if not
		cmp     al,ts_screen_bot        ;check for gtr than bottom
		jle     em_curdn3               ;skip if not
		mov     al,ts_screen_bot        ;set to bottom
em_curdn3:      mov     ah,cursor_col           ;set to cursor column
;               call    pos_cur                 ;position cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;position cursor
		pop     ax
em_curdn4:      ret
em_curdn5:      cmp     al,scroll_bot           ;new position > scroll bot?
		jle     em_curup3               ;skip if not
		mov     al,scroll_bot           ;set to bottom
		jmp     em_curup3               ;

;INDEX CURSOR

em_index:       mov     al,cursor_line          ;get current line
		cmp     al,scroll_bot           ;greater than scroll bottom?
		jbe     em_index5               ;skip if not
		cmp     al,ts_screen_bot        ;end of screen?
		je      em_index10              ;ignore seq if yes
		jmp     em_index8               ;index a line

em_index5:      jne     em_index8               ;skip if neq to scroll bot
		call    scroll_up               ;scroll screen
		jmp     em_index10              ;return

em_index8:      inc     al                      ;bump line
		mov     ah,cursor_col           ;and use same column
;               call    pos_cur                 ;position cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;position cursor
		pop     ax
em_index10:     ret

;REVERSE INDEX CURSOR

em_revind:      mov     al,cursor_line          ;get current line
		cmp     al,scroll_top           ;less than top?
		jae     em_revind5              ;skip if not
		cmp     al,1                    ;check for top of screen
		je      em_revind10             ;exit if yes
		jmp     em_revind8              ;rev index a line

em_revind5:     jne     em_revind8              ;skip if not eq to scroll top
		call    scroll_dn               ;scroll down
		jmp     em_revind10             ;return

em_revind8:     dec     al                      ;decrement line
		mov     ah,cursor_col           ;and use current column
;               call    pos_cur                 ;position the cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;position the cursor
		pop     ax
em_revind10:    ret

;NEW LINE (NEXT LINE)

em_newlin:      mov     al,cursor_line          ;get current line
		cmp     al,scroll_bot           ;at scroll bottom?
		je      em_newlin5              ;skip if yes
		inc     al                      ;set to next line
em_newlin2:     mov     ah,1                    ;column 1
;               call    pos_cur                 ;position cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;position cursor
		pop     ax
		ret
em_newlin5:     call    scroll_up               ;scroll the display
		mov     al,cursor_line          ;get line back
		jmp     em_newlin2

;MOVE CURSOR TO COLUMN

em_curcol:      mov     si,offset esc_buf+1     ;set to esc arg
		call    conv_nf                 ;convert value
		mov     ah,al                   ;col to ah
		cmp     dl,'G'                  ;check for correct terminator
		jne     em_curcol10             ;skip if not equal
		or      ah,ah                   ;check for 0 value
		jnz     em_curcol2              ;skip if not
		inc     ah                      ;set to 1
em_curcol2:     cmp     ah,col_max              ;check for past col max
		jbe     em_curcol8              ;skip if below
		mov     ah,col_max              ;set to max
em_curcol8:     mov     al,cursor_line          ;position cursor
;               call    pos_cur                 ;...
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;...
		pop     ax
em_curcol10:    ret



;INSERT LINE

em_inslin:      mov     si,offset esc_buf+1     ;set arg adr
		call    conv_nf                 ;convert argument
		cmp     dl,'L'                  ;check for correct term
		jnz     em_inslin10             ;skip if not
		or      al,al                   ;check for zero value
		jnz     em_inslin5              ;skip if not
		mov     al,1                    ;set to one line
em_inslin5:     mov     ah,cursor_line          ;get current line
		cmp     ah,scroll_top           ;check for above region top
		jb      em_inslin10             ;ignore if is
		cmp     ah,scroll_bot           ;check for below region bot
		ja      em_inslin10             ;skip if is
		call    updwnd_f                ;have to update window before scroll
		push    word ptr scroll_top     ;save region
		mov     ah,cursor_line          ;set scroll top to cursor line
		mov     scroll_top,ah           ;....
		xor     ch,ch
		mov     cl,al                   ;line count to cx
em_inslin7:     call    scroll_dn               ;scroll up to delete line
		loop    em_inslin7              ;until count exhausted
		pop     word ptr scroll_top     ;restore original region
		mov     al,cursor_line          ;cursor to bol
		mov     ah,1                    ;...
		ccall   _Position_Emul_Cursor ax;...
em_inslin10:    ret

;DELETE LINE

em_dellin:      mov     si,offset esc_buf+1     ;set arg adr
		call    conv_nf                 ;convert argument
		cmp     dl,'M'                  ;check for correct term
		jnz     em_dellin10             ;skip if not
		or      al,al                   ;check for zero value
		jnz     em_dellin5              ;skip if not
		mov     al,1                    ;set to one line
em_dellin5:     mov     ah,cursor_line          ;get line of cursor
		cmp     ah,scroll_top           ;check for above region top
		jb      em_dellin10             ;ignore if is
		cmp     ah,scroll_bot           ;check for below region bot
		ja      em_dellin10             ;skip if is
		call    updwnd_f                ;have to update window before scroll
		push    word ptr scroll_top     ;save region
		mov     ah,cursor_line          ;set scroll top to cursor line
		mov     scroll_top,ah           ;....
		xor     ch,ch
		mov     cl,al                   ;line count to cx
em_dellin7:     call    scroll_up               ;scroll up to delete line
		loop    em_dellin7              ;until count exhausted
		mov     al,cursor_line          ;set cursor to col 1
		mov     ah,1                    ;...
;               call    pos_cur                 ;...
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;...
		pop     ax
		pop     word ptr scroll_top     ;restore original region
em_dellin10:    ret

;SCROLL SCREEN DOWN

em_scrdn:       mov     si,offset esc_buf+1     ;set arg adr
		call    conv_nf                 ;convert argument
		cmp     dl,'S'                  ;check for correct term
		jnz     em_scrdn10              ;skip if not
		or      al,al                   ;check for zero value
		jnz     em_scrdn5               ;skip if not
		mov     al,1                    ;set to one line
em_scrdn5:      cmp     al,ts_screen_bot        ;check for max
		jb      em_scrdn6               ;skip if over
		mov     al,ts_screen_bot        ;set to max
em_scrdn6:      xor     ch,ch
		mov     cl,al                   ;line count to cx
em_scrdn7:      call    scroll_dn               ;scroll dn n lines
		loop    em_scrdn7               ;until count exhausted
em_scrdn10:     ret

;SCROLL SCREEN UP

em_scrup:       mov     si,offset esc_buf+1     ;set arg adr
		call    conv_nf                 ;convert argument
		cmp     dl,'T'                  ;check for correct term
		jnz     em_scrup10              ;skip if not
		or      al,al                   ;check for zero value
		jnz     em_scrup5               ;skip if not
		mov     al,1                    ;set to one line
em_scrup5:      cmp     al,ts_screen_bot        ;check for max
		jb      em_scrup6               ;skip if over
		mov     al,ts_screen_bot        ;set to max
em_scrup6:      xor     ch,ch
		mov     cl,al                   ;line count to cx
em_scrup7:      call    scroll_up               ;scroll up n lines
		loop    em_scrup7               ;until count exhausted
em_scrup10:     ret

;DELETE CHARACTER

em_delchr:      mov     si,offset esc_buf+1     ;set arg adr
		call    conv_nf                 ;convert arg
		or      al,al                   ;check for 0
		jnz     em_delchr5              ;skip if not
		inc     al
em_delchr5:     call    em_del_char             ;delete character
		ret

;INSERT CHARACTER

em_inschr:      mov     si,offset esc_buf+1     ;set arg adr
		call    conv_nf                 ;convert arg
		or      al,al                   ;check for 0
		jnz     em_inschr5              ;skip if not
		inc     al
em_inschr5:     mov     dl,al                   ;set number of characters to insert
		mov     ah,0                    ;set normal video
		cmp     su_screen,0             ;check for normal screen
		je      em_inschr6              ;skip if is
		mov     ah,con_att_rev          ;reset reverse video
em_inschr6:     mov     al,' '                  ;set to a blank
		mov     dh,con_mode             ;set color attributes
		call    em_ins_char             ;delete character
		ret

page

;SET KEYPAD MODE

em_setkpd:      mov     ts_keypad,1             ;set keypad on
		ret

;RESET KEYPAD MODE

em_reskpd:      mov     ts_keypad,0             ;reset keypad mode
		ret

;SELECT SEVEN BIT C1 CODE

em_sel_7c1:     test    su_mode,vt200_7_mode+vt200_8_mode ;check for vt200
		je      em_sel_7c1a             ;skip if not
		mov     su_mode,vt200_7_mode    ;set vt300 seven
		jmp     em_sel_7c1b

em_sel_7c1a:    test    su_mode,vt300_7_mode+vt300_8_mode ;check for vt300
		je      em_sel_7c1c             ;skip if not
		mov     su_mode,vt300_7_mode    ;set vt300 seven

		push    ax
		ccall   _Update_Status_Line_Section SL_SECT_TERM_TYPE
		pop     ax

em_sel_7c1b:    mov     ts_c1_select,0          ;set 7 bit
em_sel_7c1c:    push    ax
		ccall   _Update_Status_Line_Section SL_SECT_TERM_TYPE
		pop     ax

		ret

em_sel_8c1:     test    su_mode,vt200_7_mode+vt200_8_mode ;check for vt200
		je      em_sel_8c1a             ;skip if not
		mov     su_mode,vt200_8_mode    ;set vt300 seven
		jmp     em_sel_8c1b

em_sel_8c1a:    test    su_mode,vt300_7_mode+vt300_8_mode ;check for vt300
		je      em_sel_8c1c             ;skip if not
		mov     su_mode,vt300_8_mode    ;set vt300 seven

		push    ax
		ccall   _Update_Status_Line_Section SL_SECT_TERM_TYPE
		pop     ax

em_sel_8c1b:    mov     ts_c1_select,1          ;set 8 bit
em_sel_8c1c:    push    ax
		ccall   _Update_Status_Line_Section SL_SECT_TERM_TYPE
		pop     ax

		ret

;SELECT CHARACTER ATTRIBUTES

em_sel_chr_att: cmp     su_mode,vt200_7_mode    ;test for VT200 or vt300 mode
		jb      em_sel_chr_a10          ;skip if not
		mov     si,offset esc_buf+1     ;set sequence pointer
		call    conv_nf                 ;get arg
		cmp     dl,'"'			;check for quote terminator
		jne     em_sel_chr_a10          ;ignore if not
		or      al,al                   ;check for clear all attributes
		jnz     em_sel_chr_a5           ;skip if not
		mov     ts_char_att,al          ;clear all attributes
		jmp     em_sel_chr_a10

em_sel_chr_a5:  cmp     al,1                    ;check for not erasable
		jne     em_sel_chr_a6           ;skip if not
		or      ts_char_att,eb_misc_noerase ;set eraseable bit
		jmp     em_sel_chr_a10

em_sel_chr_a6:  cmp     al,2                    ;check for clear noerase
		jne     em_sel_chr_a10
		and     ts_char_att,0ffh-eb_misc_noerase ;clear non eraseable
em_sel_chr_a10: ret


;DOUBLE WIDTH DOUBLE HEIGHT LINE - TOP

em_tdwdh:       mov     cl,latt_tdwdh           ;get attribute code
		mov     al,cursor_line          ;get line
		call    calc_line_desc_adr      ;calc line desc address
		call    conv_dw_line            ;convert line to double width
						;and store attribute
em_tdwdh11:     ret

;DOUBLE WIDTH DOUBLE HEIGHT - BOTTOM

em_bdwdh:       mov     cl,latt_bdwdh           ;set bottom dwdh attribute
		mov     al,cursor_line          ;get line
		call    calc_line_desc_adr      ;calc line desc address
		call    conv_dw_line            ;convert line to double width
						;and store attribute
em_bdwdh11:     ret

;SINGLE WIDTH SINGLE HEIGHT

em_swsh:        mov     ax,word ptr cursor_line ;get line
		call    calc_line_desc_adr     ;get line desc address
		cmp     ld_attrib[bx],latt_swsh ;was it double width before
		je      em_swsh5                ;skip if not
		call    conv_sw_line            ;convert to single width
						;and store attribute
;               mov     ld_attrib[bx],latt_swsh ;set to swsh
em_swsh5:       ret

;DOUBLE WIDTH SINGLE HIEGHT

em_dwsh:        mov     cl,latt_dwsh            ;sety line attribute
		mov     al,cursor_line          ;get line
		call    calc_line_desc_adr      ;calc line desc address
		call    conv_dw_line            ;convert line to double width
						;and store attribute
em_dwsh11:      ret

;RESET

em_reset:       call    reset_func              ;reset the emulator
		ret

;SET TAB

em_settab:      cmp     su_u_features,0         ;check for locked
		jnz     em_settab5              ;skip if locked
		mov     bl,cursor_col           ;get cursor column
		xor     bh,bh
		mov     su_tabs-1[bx],1         ;set tab
em_settab5:     ret

;CLEAR TAB

em_clrtab:      cmp     su_u_features,0         ;check for locked
		jnz     em_clrtab10             ;skip if not
		mov     si,offset esc_buf+1     ;set arg adr
		call    conv_nf                 ;convert numeric field
		cmp     dl,'g'                  ;check for correct term
		jne     em_clrtab10             ;skip if not
		cmp     al,0                    ;check for clear a tab
		jne     em_clrtab5              ;skip if not
		mov     bl,cursor_col           ;get column
		xor     bh,bh                   ;...
		mov     su_tabs-1[bx],0         ;clear the tab
		jmp     em_clrtab10             ;return

em_clrtab5:     cmp     al,3                    ;check for clear all tabs
		jne     em_clrtab10             ;ignore seq if not

;clear all tabs

		mov     di,offset su_tabs       ;set table adr
		mov     cx,132                  ;set size
		xor     al,al                   ;set to 0
		rep stosb                       ;clear tabs
em_clrtab10:    ret

page

;VT52 ANSI

em_vt52_ansi:   mov     al,su_vt_response       ;get vt100 or 102 mode
		mov     su_mode,al              ;set ansi mode
		call    sel_nrc_gl              ;set character set

		push    ax
		ccall   _Update_Status_Line_Section SL_SECT_TERM_TYPE
		pop     ax

		ret

;VT52 HOME CURSOR

em_vt52_home:   mov     ax,0101h                ;set to home position
;               call    pos_cur                 ;position cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;position cursor
		pop     ax
		ret

;VT52 DIRECT CURSOR

em_vt52_dcur:   mov     al,esc_buf+1            ;get line
		sub     al,01fh
		cmp     al,0                    ;check for above 0
		jbe     vt52_dcur10             ;ignore if not
		cmp     al,ts_screen_bot        ;check for screen bottom or less
		jbe     vt52_dcur3              ;skip if is
		mov     al,cursor_line          ;set to same line
vt52_dcur3:     mov     ah,esc_buf+2            ;get col
		sub     ah,01fh                 ;sub base
		cmp     ah,0                    ;check col above 0
		jbe     vt52_dcur10             ;ignore if not
		cmp     ah,80                   ;check for 80 or less
		jbe     vt52_dcur5              ;skip if is
		mov     ah,80                   ;set to max
vt52_dcur5:
;               call    pos_cur                 ;;position cursor
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;;position cursor
		pop     ax
vt52_dcur10:    ret

;VT52 IDENTIFY

em_vt52_id:     mov     ax,offset vt52id_msg
		call    sio_xmtmsg              ;identify
		ret

;VT52 DEC Graphics On

em_vt52_decgr:  mov     ts_gl,nrc_decgr         ;set dec graphics
		ret

;VT52 DEC GRAPHICS OFF  (ASCII ON)

em_vt52_ascii:  mov     ts_gl,nrc_ascii         ;set ascii set
		ret

;IGNORED ESCAPE SEQUENCES
						;screen allignment
em_tests:                                       ;invoke tests
em_ansi:                                        ;ansi mode in ansi mode
em_led:
em_ignore:
		mov     esc_seqcnt,0
		ret

em_vt           endp


;Control Sequence Debug Local Subroutine

em_cs_debug     proc    near

		push    ax
		push    bx
		push    cx
		push    dx
		push    word ptr con_att_code   ;...
		push    word ptr cursor_line    ;and cursor
		mov     dh,esc_buf              ;save first escape character
		mov     al,ts_status_line       ;pos cursor to status line
		mov     ah,1
		ccall   _Move_Emul_Cursor ax    ;move cursor to position
;;              ccall   _Erase_Line             ;erase line
		call    ers_line
		mov     bx,offset esc_seqcnt    ;set escape buffer
		mov     ax,offset dbg_esc_msg   ;escape message
		cmp     cs_start_char,esc_char  ;check for escape
		jne     cs_debug10              ;...
cs_debug10:     cmp     cs_start_char,csi       ;check for csi
		jne     cs_debug20              ;...
		mov     ax,offset dbg_csi_msg   ;...
		inc     bx                      ;bump message pointer
		mov     dl,esc_seqcnt           ;move count for msg format
		dec     dl                      ;...
		mov     esc_buf,dl              ;...
cs_debug20:     cmp     cs_start_char,dcs       ;check for device control
		jne     cs_debug50              ;...
		mov     ax,offset dbg_dcs_msg   ;...
cs_debug50:     ccall   _Write_Msg_Line ax ds   ;start message
		ccall   _Write_Msg_Line_Msg bx ds -1   ;output esc sequence
		mov     esc_buf,dh              ;restore first char of esc buffer
		pop     ax                      ;get cursor pos
;               call    pos_cur                 ;...
		push    ax
		ccall   _Position_Emul_Cursor ax                        ;...
		pop     ax
		pop     word ptr con_att_code   ;restore attributes

		xor     al,al                   ;wait for ok to proceed
		call    kb_in                   ;get kb input
		cmp     dl,t_debug              ;check for debug key
		jne     cs_debug60              ;skip if not debug on/off
cs_debug55:     mov     ts_debug,0              ;clear debug
cs_debug60:     call    wrt_stat_line           ;clear the emulation window's
						;host writable status line

		pop     dx
		pop     cx
		pop     bx
		pop     ax
		ret

em_cs_debug     endp

simulate_em_test_pat proc far

		push    ax
		call    em_test_pat
		pop     ax

		ret

simulate_em_test_pat endp

em              ends

		end
