#ifndef lint
static  char sccsid[] = "@(#)llc_test.c 8.5 93/11/02 Copyr 1993 Sun Micro";
#endif

/*
** Copyright (c) 1993 Sun Microsystems, Inc.  All Rights Reserved.
** Sun considers its source code as an unpublished, proprietary trade
** secret, and it is available only under strict license provisions.
** This copyright notice is placed here only to protect Sun in the event
** the source is deemed a published work.  
**
** RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
** Government is subject to restrictions as set forth in subparagraph
** (c)(1)(ii) of the Rights in Technical Data and Computer Software
** clause at DFARS 52.227-7013 and in similar clauses in the FAR and
** NASA FAR Supplement.
*/

/* llc_test.c is a sample program that interfaces with snacommd
 * and LLC2 driver.  Note that this is only an example and
 * does not contain all that are needed.  Refer to the
 * DLPI interface manual, snacommd API manual and LLC2 API
 * manual for more information.
 */

#include <rpc/rpc.h>
#include <sys/dlpi.h>
#include <sys/stropts.h>
#include <sys/errno.h>
#include "uint.h"
#include "ll_proto.h"
#include "ll_control.h"
#include "timer.h"
#include "llc2.h"

#include "snacommd_dlc.h"

#define MAXDATA 2042

extern int errno;

void
attach_dlc(struct strbuf *ctlbuf, struct strbuf *databuf, int ppa, int llc_fd)

{
	register dl_attach_req_t	*areq;
	register union DL_primitives *pptr;
	int flag = 0;
	int retval = 0;
	int rc;
	int i;

	areq = (dl_attach_req_t *)ctlbuf->buf;
	areq->dl_primitive = DL_ATTACH_REQ;

	/* ppa is the instance number of the physical device. */

	areq->dl_ppa = ppa;
	ctlbuf->len = DL_ATTACH_REQ_SIZE;

	do {
		rc = putmsg(llc_fd, ctlbuf, NULL, 0);
	} while(rc == -1 && errno == EINTR);
	if (rc < 0) {
		printf("ERROR: attach dlc\n");
		perror("putmsg");
		exit(1);
	}

	do {
		rc = getmsg(llc_fd, ctlbuf, databuf, &flag);
	} while(rc == -1 && errno == EINTR);
	if (rc < 0) {
		printf("ERROR: attach dlc\n");
		perror("getmsg");
		exit(1);
	} else {
		pptr = (union DL_primitives *)ctlbuf->buf;
		switch(pptr->dl_primitive) {
		case DL_OK_ACK:
			if (pptr->ok_ack.dl_correct_primitive != DL_ATTACH_REQ) {
				printf("attach_dlc: invalid primitive for DL_OK_ACK.\n");
				exit(1);
			}
			break;
		case DL_ERROR_ACK:
			printf("attach_dlc: DL_ERROR_ACK\n");
			exit(1);
		default:
			printf("attach_dlc: unsupported primitive = %x\n", 
				pptr->dl_primitive);
			break;
		}
	}
}

void
bind_dlc(struct strbuf *ctlbuf, struct strbuf *databuf, 
	int llc_fd, u_char sap)

{
	register dl_bind_req_t	*breq;
	register union DL_primitives *pptr;
	int rc;
	int flag = 0;
	int retval = 0;

	breq = (dl_bind_req_t *)ctlbuf->buf;
	breq->dl_primitive = DL_BIND_REQ;
	breq->dl_sap = sap;
	breq->dl_max_conind = 1; 
	breq->dl_service_mode = DL_CODLS;
	breq->dl_conn_mgmt = 0;
	breq->dl_xidtest_flg = 0;
	ctlbuf->len = DL_BIND_REQ_SIZE;

	do {
		rc = putmsg(llc_fd, ctlbuf, NULL, 0);
	} while(rc == -1 && errno == EINTR);
	if (rc < 0) {
		printf("ERROR: bind_dlc\n");
		perror("putmsg");
		exit(1);
	}

	do {
		rc = getmsg(llc_fd, ctlbuf, databuf, &flag);
	} while(rc == -1 && errno == EINTR);
	if (rc < 0) {
		printf("ERROR: bind_dlc\n");
		perror("getmsg");
		exit(1);
	}

	pptr = (union DL_primitives *)ctlbuf->buf;
	switch(pptr->dl_primitive) {
	case DL_BIND_ACK:
		break;
	case DL_ERROR_ACK:
		printf("bind_dlc: DL_ERROR_ACK\n");
		exit(1);
	default:
		printf("bind_dlc: unsupported primitive %x\n", pptr->dl_primitive);
		break;
	}
}  

void
readconnect(struct strbuf *ctlbuf, struct strbuf *databuf, int llc_fd)
{
	register union DL_primitives *pptr;
	register dl_connect_ind_t *cind;
	register dl_connect_res_t *cres;
	int rc;
	int flag = 0;
	int correlation = 0;

	do {
		rc = getmsg(llc_fd, ctlbuf, databuf, &flag);
	} while(rc == -1 && errno == EINTR);
	if (rc < 0) {
		printf("ERROR: readconnect\n");
		perror("getmsg");
		exit(1);
	} else {
		pptr = (union DL_primitives *)ctlbuf->buf;
		if (pptr->dl_primitive != DL_CONNECT_IND) {
			printf("Didn't receive DL_CONNECT_IND\n");
			exit(1);
		} 
		
		printf("Received DL_CONNECT_IND\n");
		cind = (dl_connect_ind_t *)ctlbuf->buf;
		correlation = cind->dl_correlation;
		cres = (dl_connect_res_t *)ctlbuf->buf;
		cres->dl_primitive = DL_CONNECT_RES;
		cres->dl_correlation = correlation;
		cres->dl_resp_token = 0;
		cres->dl_qos_length = DL_QOS_DONT_CARE;    
		cres->dl_qos_offset = 0;
		cres->dl_growth = 0;
		ctlbuf->len = DL_CONNECT_RES_SIZE;

		do {
			rc = putmsg(llc_fd, ctlbuf, NULL, 0);
		} while(rc == -1 && errno == EINTR);
		if (rc < 0) {
			printf("ERROR: readconnect\n");
			perror("putmsg");
			exit(1);
		}
	}
}

void
sendconnect(struct strbuf *ctlbuf, struct strbuf *databuf, int llc_fd, 
		u_char *remote_addr, u_char dsap)
{
	register union DL_primitives *pptr; 
	register dl_connect_req_t *creq;
	register dl_connect_con_t *ccon;
	char *addrp;
	int flag = 0;
	int rc;
	int i;
	
	creq = (dl_connect_req_t *)ctlbuf->buf;

	ctlbuf->len = DL_CONNECT_REQ_SIZE + 7;

	creq->dl_primitive = DL_CONNECT_REQ;
	creq->dl_dest_addr_length = 7;
	creq->dl_dest_addr_offset = DL_CONNECT_REQ_SIZE;
	creq->dl_qos_length = DL_QOS_DONT_CARE;
	creq->dl_qos_offset = 0;
	creq->dl_growth = 0;

	addrp = ctlbuf->buf + DL_CONNECT_REQ_SIZE;

	memcpy(addrp, remote_addr, 6);
	*(addrp+6) = dsap;

	for (i = 0; i < 7; i++)
		printf("%x ", addrp[i]);
	printf("\n");

	do {
		rc = putmsg(llc_fd, ctlbuf, NULL, 0);
	} while(rc == -1 && errno == EINTR);
	if (rc < 0) {
		printf("ERROR: sendconnect\n");
		perror("putmsg");
		exit(1);
	} 
		
	do {
		rc = getmsg(llc_fd, ctlbuf, databuf, &flag);
	} while(rc == -1 && errno == EINTR);
	if (rc < 0) {
		printf("ERROR: sendconnect\n");
		perror("getmsg");
		exit(1);
	}

	pptr = (union DL_primitives *)ctlbuf->buf;

	if (pptr->dl_primitive != DL_CONNECT_CON) {
		printf("Didn't get DL_CONNECT_CON: primitive = 0x%x\n", 
			pptr->dl_primitive);
		for (i = 0; i < ctlbuf->len; i++) {
			printf("%2x ", ctlbuf->buf[i]);
		}
		printf("\n");
		exit(1);
	}

}
		

main(argc, argv)
int argc;
char *argv[];

{
	CLIENT *cl;
	int *result;
	request_ret_t *result1;
	int role = SECONDARY_ROLE;

	char *server = "localhost";
	u_char remote_addr[6];
	u_char dsap = 0x8;
	u_char ssap = 0x4;

	connect_arg_t *param;
	request_arg_t *param2;
	extern int sys_nerr;
	extern char *sys_errlist[];

	int llc_fd = -1;

	struct strbuf ctlbuf, databuf;

	if (argc != 4) {
		fprintf(stderr,
		"usage: %s role mac_type mac_inst\n", argv[0]);
		exit(1);
	}
	param = (connect_arg_t *)malloc(sizeof(connect_arg_t));
	param2 = (request_arg_t *)malloc(sizeof(request_arg_t));
	param->mac_type = argv[2][0] - '0';
	param->mac_inst = argv[3][0] - '0';
	param->linkid = 0;
	param2->mac_type = argv[2][0] - '0';
	param2->mac_inst = argv[3][0] - '0';
	printf("%d, %d\n", param->mac_type, param->mac_inst);

	switch (argv[1][0]) {
	case 's':
		role = SECONDARY_ROLE;
		ssap = 0x4;
		dsap = 0x8;
		break;
	case 'p':
		role = PRIMARY_ROLE;
		ssap = 0x8;
		dsap = 0x4;
		break;
	case 'n':
		role = NEGOTIABLE_ROLE;
		break;
	default:
		printf("Unsupported role. \n");
		exit(1);
	}

	/* create RPC client handle to snacommd */
	cl = clnt_create(server, COMMDPROG, COMMDVERS, "visible");		
	if (cl == (CLIENT *)NULL) {
		clnt_pcreateerror(server);
		exit(1);
	}

	/* connect to snacommd */
	result = comm_conf_connect(param, cl);
	if (result == (int *) NULL) {
		clnt_perror(cl, server);
		exit(1);
	}
	if (*result == -1) {
		fprintf(stderr, "connect failed\n");
		exit(1);
	}

	/* lltune(1M) is used for tuning LLC2. */

	/* configuration request to snacommd*/
	result1 = comm_conf_request(param2, cl);
	if (result1 == (request_ret_t *) NULL) {
		clnt_perror(cl, server);
		exit(1);
	}
	if (result1->status == -1) {
		fprintf(stderr, "request failed\n",
				argv[0], server);
		exit(1);
	}

	/* open to llc2 */
	do {
		llc_fd = open("/dev/llc2", O_RDWR);
	} while(llc_fd == -1 && errno == EINTR);
	if (llc_fd < 0) {
		printf("Can't open /dev/llc2\n");
		exit(1);
	}

	/* allocate memory for control buffer */
	if (!(ctlbuf.buf = (char *)memalign(4, sizeof(union DL_primitives)))) {
		printf("Can't allocate memory for ctlbuf.buf\n");
		exit(1);
	}

	/* allocate memory for data buffer */
	if (!(databuf.buf = (char *)memalign(4, MAXDATA))) {
		printf("Can't allocate memory for databuf.buf\n");
		exit(1);
	}

	ctlbuf.maxlen = sizeof(union DL_primitives);
	databuf.maxlen = MAXDATA;

	/* attach to llc2 */
	attach_dlc(&ctlbuf, &databuf, param->mac_inst, llc_fd);

	/* bind to llc2 with source sap number */
	bind_dlc(&ctlbuf, &databuf, llc_fd, ssap);

	/* Primary stations will send connection requests to secondary stations. 
	 * Note that TEST and XID exchanges should be done before connection 
	 * establishment which is not shown here. 
	 */
	if (role == SECONDARY_ROLE) 
		readconnect(&ctlbuf, &databuf, llc_fd);
	else if (role == PRIMARY_ROLE) {
		remote_addr[0] = 0x40;
		remote_addr[1] = 0x0;
		remote_addr[2] = 0x31;
		remote_addr[3] = 0x74;
		remote_addr[4] = 0x0;
		remote_addr[5] = 0x2;
		sendconnect(&ctlbuf, &databuf, llc_fd, remote_addr, dsap);
	}

	printf("Connection established.\n");

	for (;;) ;
}
