/* sccsid[] = "@(#)cpic_proto.h 1.6 94/06/28 Copyr 1993 Sun Micro"; */

/*
        Copyright (c) 1993, Sun Microsystems, Inc.  All Rights Reserved.
        Sun considers its source code as an unpublished, proprietary
        trade secret, and it is available only under strict license
        provisions.  This copyright notice is placed here only to protect
        Sun in the event the source is deemed a published work.
 
        RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
        Government is subject to restrictions as set forth in subparagraph
        (c)(1)(ii) of the Rights in Technical Data and Computer Software
        clause at DFARS 52.227-7013 and in similar clauses in the FAR and
        NASA FAR Supplement.
*/
 
/*
 *  accept_conversation
 */

void
CMACCP (u_char *conversation_id, int *return_code);

/*
 *  initialize_conversation
 */

void
CMINIT (u_char *conversation_id, char *sym_dest_name, int *return_code);


/*
 *  allocate
 */

void
CMALLC (u_char *conversation_id, int *return_code);


/*
 *  confirm
 */

void
CMCFM (u_char *conversation_id, int *request_to_send_received, int *return_code);


/*
 *  confirmed
 */

void
CMCFMD (u_char *conversation_id, int *return_code);


/*
 *  deallocate
 */

void
CMDEAL (u_char *conversation_id, int *return_code);


/*
 *  flush
 */

void
CMFLUS (u_char *conversation_id, int *return_code);


/*
 *  prepare to receive
 */

void
CMPTR (u_char *conversation_id, int *return_code);


/*
 *  receive
 */

void
CMRCV (u_char *conversation_id, u_char *buffer, int *requested_length,
		int *data_received, int *received_length, int *status_received,
		int *request_to_send_received, int *return_code);


/*
 *  request to send
 */

void
CMRTS (u_char *conversation_id, int *return_code);


/*
 *  send data
 */

void
CMSEND (u_char *conversation_id, u_char *buffer, int *send_length,
		int *request_to_send_received, int *return_code);


/*
 *  send error
 */

void
CMSERR (u_char *conversation_id, int *request_to_send_received,
		int *return_code);


/*
 *  test request to send received
 */

void
CMTRTS (u_char *conversation_id, int *request_to_send_received,
		int *return_code);


/*
 *  the 'set' and 'extract' commands
 */

/*
 *  extract conversation state
 */

void
CMECS (u_char *conversation_id, int *conversation_state, int *return_code);


/*
 *  set conversation type
 */

void
CMSCT (u_char *conversation_id, int *conversation_type, int *return_code);


/*
 *  extract conversation type
 */

void
CMECT (u_char *conversation_id, int *conversation_type, int *return_code);


/*
 *  set deallocate type
 */

void
CMSDT (u_char *conversation_id, int *deallocate_type, int *return_code);


/*
 *  set error direction
 */

void
CMSED (u_char *conversation_id, int *error_direction, int *return_code);


/*
 *  set fill
 */

void
CMSF (u_char *conversation_id, int *fill, int *return_code);


/*
 *  set log data
 */

void
CMSLD (u_char *conversation_id, char *log_data, int *log_data_length,
		int *return_code);


/*
 *  set mode name
 */

void
CMSMN (u_char *conversation_id, char *mode_name, int *mode_name_length,
		int *return_code);


/*
 *  extract mode name
 */

void
CMEMN (u_char *conversation_id, char *mode_name, int *mode_name_length,
		int *return_code);


/*
 *  set partner lu name
 */

void
CMSPLN (u_char *conversation_id, char *partner_lu_name,
		int *partner_lu_name_length, int *return_code);


/*
 *  extract partner lu name
 */

void
CMEPLN (u_char *conversation_id, char *partner_lu_name,
		int *partner_lu_name_length, int *return_code);


/*
 *  set prepare to receive type
 */

void
CMSPTR (u_char *conversation_id, int *prepare_to_receive_type, int *return_code);


/*
 *  set receive type
 */

void
CMSRT (u_char *conversation_id, int *receive_type, int *return_code);


/*
 *  set return control
 */

void
CMSRC (u_char *conversation_id, int *return_control, int *return_code);


/*
 *  set send type
 */

void
CMSST (u_char *conversation_id, int *send_type, int *return_code);


/*
 *  set sync level
 */

void
CMSSL (u_char *conversation_id, int *sync_level, int *return_code);


/*
 *  extract sync level
 */

void
CMESL (u_char *conversation_id, int *sync_level, int *return_code);


/*
 *  set tp name
 */

void
CMSTPN (u_char *conversation_id, char *tp_name, int *tp_name_length,
		int *return_code);


/*
 *  the conversation level security commands
 */

/*
 *  extract_conversation_security_type
 */

void
XCECST (u_char *conversation_id, int *conversation_security_type,
		int *return_code);

/*
 *  extract_conversation_security_user_id
 */

void
XCECSU (u_char *conversation_id, char *security_user_id,
		int *security_user_id_length, int *return_code);

/*
 *  set_conversation_security_password
 */

void
XCSCSP (u_char *conversation_id, char *security_password,
		int *security_password_length, int *return_code);

/*
 *  set_conversation_security_type
 */

void
XCSCST (u_char *conversation_id, int *conversation_security_type,
		int *return_code);

/*
 *  set_conversation_security_user_id
 */

void
XCSCSU (u_char *conversation_id, char *security_user_id,
		int *security_user_id_length, int *return_code);


