#ifndef lint
static char sccsid[] = "@(#)tp_parent.c	8.9 01 Sep 1993 Copyr 1992-1993 Sun Micro";
#endif

/*
        Copyright (c) 1992-1993, Sun Microsystems, Inc.  All Rights Reserved.
        Sun considers its source code as an unpublished, proprietary
        trade secret, and it is available only under strict license
        provisions.  This copyright notice is placed here only to protect
        Sun in the event the source is deemed a published work.
 
        RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
        Government is subject to restrictions as set forth in subparagraph
        (c)(1)(ii) of the Rights in Technical Data and Computer Software
        clause at DFARS 52.227-7013 and in similar clauses in the FAR and
        NASA FAR Supplement.
*/

/*************************************************************
*  tp_parent.c is a test driver to test tpswitch functionality
*  How to use it:    a) run "test_p2p appc_pri in first window
*                    b) run "tp_parent appc_sec" in other window
*                       wait for message "tp_parent: Issue tp_wait_
*                         remote_start
*                    c) Issue ALLOCATE verb in test_p2p window:
*                        is_iso is 1
*                        tp_name is p
*                        unique session name is m1
*                        subtype 32 (immediate)
*                        pip data is 0
*                        security is none (0)
*                     d) Issue FLUSH verb in test_p2p window:
*                     e) should see the messages from tp_child 
*                        the procedure that was forked after the
*                        test_p2p ALLOCATE. tp_child will have
*                        a receive and wait message.
*                     f) Issue DEALLOCATE CONFIRM or
*                        Issue SEND DATA ( no more than 1200 bytes)
*                        from test_p2p. And you are on your own.
*                     g) The sun_pri_config and sun_sec_config has
*                        to be set for multiple sessions and with
*                        the switch convid facility of test_p2p
*                        option (300) it is possible to have
*                        multiple conversations  between test_p2p  
*                        and tp_parent. Just issue Allocate and
*                        write down the conversation id; then 
*                        switch back and forth with verb '300' in
*                        test_p2p. 
*******************************************************************/
 
#include <sys/types.h>
#include "api_const.h"
#include "api.h"
#include "api_proto.h"
#include <fcntl.h>

extern u_long  appc_errno;
extern int errno;
 
int cid = 0;
pid_t    tpid = 0;
u_char pipdata[128];
u_char i;

u_long gatefd;
u_long remconvid;
char fdstr [10];
char convidstr [10];
 
TP_START start;
TP_WAIT_REMOTE_START wrs;
TP_LISTEN listn;

main(int argc, char *argv[])
{
        u_long uli;
         
        if ( argc < 2 ) {
                printf ("Usage: tp_parent gateway_name \n");
                printf ("where gateway_name is the name of APPC server\n");
                exit (0);
        }

        i = '0';                /* For unique iso TP Name */ 
       
        while (1)
        {
 
           strcpy (start.log_tp_name, "TP_RECV.");
           start.log_tp_name [8] = i;
           start.log_tp_name [9] = 0;

           strcpy (start.gateway_name, argv[1]);
 
           /*
            *  attach this TP to the specified gateway
            */
           printf("\ntp_parent: Issue tp_start\n");
 
           uli = tp_start (&start, argv[1]);

           if (uli) {
                appc_error ((u_char *)"tp_parent: tp_start"); /* if an error */
                exit (0);
           }
           gatefd = start.gateway_fd;
           printf("\ntp_parent: tp_start: gateway fd is %x\n",gatefd);
 
           /*
            *  register a TP name for which to listen on the gateway
            */
        
           listn.tp_name_is_iso = 1;
           listn.tp_name[0] = 0;
           listn.queue_depth = 255;
           listn.sync_level = SYNC_NONE;           /* no confirm capability */
           listn.conv_type = BASIC_CONVERSATION;   /* basic conversation verbs*/
 
           printf("\ntp_parent: Issue tp_listen\n");

           uli = tp_listen (&listn);

           if (uli) {
                appc_error ((u_char *)"tp_parent: tp_listen");/* if an error */
                exit (0);
           }
 
           /*
            *  Now wait for the incoming allocate for my TP
            */
        
           wrs.listen_conv_id = listn.listen_conv_id;
 
           wrs.pip_data = 0;
           wrs.pip_length = 0;
           printf("\ntp_parent: Issue tp_wait_remote_start\n");

           uli = tp_wait_remote_start (&wrs);

           if (uli) {
                   appc_error ((u_char *)"tp_parent: tp_wait_remote_start");
                   exit (0);
           }
           remconvid = wrs.conv_id;
           printf("tp_parent: rem start conv_id %x\n",remconvid);

           /* Create new process to handle the conversation */
            
           if (tpid = fork()) {

              switch (tpid){

              case -1:
           
		 tp_end_proc();
                 printf("\ntp_parent: Fork failed errno = %x\n",errno);
                 break;   

	      default:		/* parent */

		 close(gatefd);
                 printf("\ntp_parent: Fork OK pid = %x\n",tpid);
		 break;

              }
           }
	   else {                /* Child */

                 sprintf(fdstr,"%d", gatefd); /* convert to string */
                 sprintf(convidstr,"%d", remconvid);

                 execl ("./tp_child", "tp_child",&fdstr[0],&convidstr[0], (char *)0);
                 printf("\ntp_parent: execl failed errno = %x\n",errno);
                 exit(0);
	   }
           i += 1;
           cid += 1;
           printf("\ntp_parent: back from the fork\n");
        } 
}
