#ifndef lint
static char sccsid[] = "@(#)tp_echo.c	8.7 15 Sep 1994 Copyr 1987-1993 Sun Micro";
#endif

/*
        Copyright (c) 1987-1993, Sun Microsystems, Inc.  All Rights Reserved.
        Sun considers its source code as an unpublished, proprietary
        trade secret, and it is available only under strict license
        provisions.  This copyright notice is placed here only to protect
        Sun in the event the source is deemed a published work.
 
        RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
        Government is subject to restrictions as set forth in subparagraph
        (c)(1)(ii) of the Rights in Technical Data and Computer Software
        clause at DFARS 52.227-7013 and in similar clauses in the FAR and
        NASA FAR Supplement.
*/

#include <sys/types.h>
#include "api_const.h"
#include "api.h"
#include "api_proto.h"
#include <fcntl.h>

extern u_long  appc_errno;
extern int errno;

u_char	rts_rcvd;
u_char	wr_flag_type;
u_char	wr_data_type;

#define MAXRECV 252
#define MAXSEND 252
#define GDS_APPL_DATA   0x12ff  /* application data */

u_long  gatefd;
TP_START start;
TP_ACCEPT apt;
char tp_name[MAX_TP_NAME + 1] ;
u_char pip_data[256];
char filename[64];

main(int argc, char *argv[])
{
	u_long uli, recv_conv_id;
	int send_fd, recv_fd, i, i2, total_bytes = 0;
	u_char recvbuf[MAXRECV+4];
	TP_START start;
	TP_END end;
	TP_LISTEN listn;
	TP_WAIT_REMOTE_START wrs;
	MC_RECEIVE_AND_WAIT raw;
	MC_SEND_DATA snd;
	MC_DEALLOCATE dealloc;
	char *tp;

	if ( argc < 2 ) {
		printf ("Usage: tp_echo gateway_name output_file_name\n");
		printf ("       where gateway_name is the name of APPC server\n");
		printf ("       and output_file_name is the name of file into which\n");
		printf ("       to store the received data\n");
		exit (1);
	}

	/*
	 *  open the output file specified to store
	 */
	
	strcpy(filename, mktemp("tp_echo.XXXXXX"));
	recv_fd = open (filename, O_WRONLY | O_CREAT, 0777);
	if (recv_fd == -1) {
		printf ("Error %d returned when attempting to open file %s\n",
			errno, argv[2]);
		exit (2);
	}


	i = '0';                /* For unique ascii TP Name */ 
       
	strcpy (start.log_tp_name, "TP_RECV.");
	start.log_tp_name [8] = i;
	start.log_tp_name [9] = 0;

	/* we can get gateway name from environment entry APPC_GATEWAY or argv[1] */ 
	if ((tp = (char *)getenv(APPC_GATEWAY)) == (char *)0) {
		printf("tp_echo: gateway name not found\n");
		exit(0);
	} else
		printf("tp_echo: gateway name %s\n",tp);

	strcpy (start.gateway_name, tp);
 
	/* get tp_name from environment entry TP_ACCEPT_NAME or argv[2] */
	if ((tp = (char *)getenv(TP_ACCEPT_NAME)) == (char *)0) {
		printf("tp_echo: tp name not found\n");
		printf ("tp_echo: issue tp_end\n");
		uli = tp_end_proc ();
		close(recv_fd);
		exit(0);
	} else
		printf("tp_echo: tp name %s\n",tp);

	strcpy(apt.tp_name, argv[2]);	

	/*
	 *  attach this TP to the specified gateway
	 */
 
	uli = tp_start (&start, argv[1]);

	if (uli) {
		appc_error ((u_char *)"tp_echo:tp_start");  /* if an error */
		close(recv_fd);
		exit (0);
	}
	gatefd = start.gateway_fd;
 
	/*
	 *  Now wait for the incoming allocate for my TP
	 */
        
 
	apt.pip_data = 0;
	apt.pip_length = 256;
	apt.pip_data = pip_data;
	apt.tp_name_is_iso = 1;	

	uli = tp_accept(&apt);

	if (uli) {
		appc_error ((u_char *)"tp_echo:tp_accept");
		printf ("tp_echo: issue tp_end\n");
		uli = tp_end_proc ();
		close(recv_fd);
		exit (0);
	}

	recv_conv_id = apt.conv_id;

	printf ("receive conversation id = %08x\n", recv_conv_id);

	/*
	 *  ready to start receiving the contents of the file
	 */
	
	raw.conv_id = recv_conv_id;
	raw.type = SUB_NONE;
	raw.length = MAXRECV+4;
	raw.data = recvbuf;
	raw.what_received_flag_type = 0;	/* init for while loop */

	while (((uli = mc_receive_and_wait (&raw)) == OK) &&
			(raw.what_received_flag_type != WR_SEND)) {
		i = write (recv_fd, recvbuf, (int)raw.length);
		total_bytes += i;
		if (i != (int)raw.length) {
			printf ("error %d when trying to write to file %s\n",
				errno, argv[2]);
			close(recv_fd);
			uli = tp_end_proc ();
			exit (6);
		}
	}

	i = close (recv_fd);
	if (i) {
		printf ("Error %d returned when attempting to close file %s\n",
			errno, argv[2]);
		uli = tp_end_proc ();
		exit (7);
	}
	printf("Receives %d bytes of data\n",total_bytes);
	if (uli) {
		if (uli == DEALLOCATE_NORMAL) {
			printf("Receives Deallocate Normal\n");
		} else if (uli == DEALLOCATE_ABEND_PROG) {
			printf("Receives Deallocate Abend Prog\n");
		} else
			appc_error ((u_char *)"tp_echo:receive_and_wait");	
		uli = tp_end_proc ();
		exit(-1);
	}

	/*
	 *  reopen the file for reading, so we can send it back to the
	 *  remote TP.
	 */

	send_fd = open (filename, O_RDONLY);
	if (send_fd == -1) {
		printf ("Error %d returned when attempting to open file %s\n",
			errno, argv[2]);
		uli = tp_end_proc ();
		exit (8);
	}

	total_bytes = 0;

	/*
	 *  now start sending the received file's contents
	 */
	
	while ((i = read (send_fd, recvbuf, MAXSEND))) {
		
		/*
		 *  first two bytes = length
		 */
		
		i2 = i;		/* header */

		/*
		 *  now send this chunk of the file
		 */
		
		snd.conv_id = recv_conv_id;
		snd.type = SUB_NONE;   /* send it now */
		snd.nbio = 0;           /* block i/o */
		snd.length = i2;
		snd.data = recvbuf;
		snd.map_name[0] = 0;

		uli = mc_send_data (&snd);
		if (uli) {
			appc_error ((u_char *)"tp_echo:send_data");    /* if an error */
			close(send_fd);
			uli = tp_end_proc ();
			exit (9);
		}

		total_bytes += i;
	}

	printf ("Sent %d bytes of data\n", total_bytes);

	i = close (send_fd);
	if (i) {
		printf ("Error %d returned when attempting to close file %s\n",
			errno, argv[2]);
		uli = tp_end_proc ();
		exit (10);
	}

	/*
	 *  deallocate the conversation
	 */
	
	dealloc.conv_id = recv_conv_id;
	dealloc.type = SUB_FLUSH;           /* don't need an explicit flush() */
	dealloc.log_data_length = 0;

	uli = mc_deallocate (&dealloc);
	if (uli) {
		appc_error ((u_char *)"tp_echo:dealloc");  /* if an error */
		uli = tp_end_proc ();
		exit (11);
	}

	printf ("Conversation deallocated\n");

	/*
	 *  detach this TP from the gateway
	 */

	uli = tp_end (&end);
	return (0);
}


