#ifndef lint
static char sccsid[] = "@(#)test_p2p.c	1.8 15 Sep 1994 Copyr 1987-1993 Sun Micro";
#endif

/*
        Copyright (c) 1987-1993, Sun Microsystems, Inc.  All Rights Reserved.
        Sun considers its source code as an unpublished, proprietary
        trade secret, and it is available only under strict license
        provisions.  This copyright notice is placed here only to protect
        Sun in the event the source is deemed a published work.
 
        RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
        Government is subject to restrictions as set forth in subparagraph
        (c)(1)(ii) of the Rights in Technical Data and Computer Software
        clause at DFARS 52.227-7013 and in similar clauses in the FAR and
        NASA FAR Supplement.
*/
 
#include <sys/types.h>
#include <locale.h>
#include "api_const.h"
#include "api.h"
#include "api_proto.h"


extern int err_file;
extern u_long  appc_errno;

#define MAX_PIP	300

u_char	gateway[MAX_TP_NAME+1];
u_char	data_buf[32767]; /* data */
u_char	buf[32767]; /* verb parameters */
u_char	tp_name[MAX_TP_NAME+1]; /* tp_name of allocate and listen */
u_long	listen_conv_id;
FILL	fill;
u_char	rts_rcvd;
u_char	wr_flag_type;
u_char	wr_data_type;
u_char	*pip_data;


u_char	has_tp;
long	tmp_conv_id, conv_id, conv_id1;
u_char	request_to_send_received;
u_long  uli;

int use_long = 1;	/* short(0) or long(1) output */

int iscan;
char cc;

void check_scan ();
void set_data( u_char *buf, u_long len);
void set_ll( u_char *buf, u_long ll_len, u_long len );
void print_flags (int len, u_char rts_flag, u_char wr_flag, u_char wr_data);
u_char get_iso_ebcdic_string (u_char *string_namep, u_char *stringp, 
                               u_long max_length);
void process_verb( int verb );
void print_menu ();

void
check_scan ()
{
	if (iscan != 1) {
		while ((cc = getchar()) != '\n');
		printf ("Input error\n");
	}
}

void
set_data( u_char *buf, u_long len)
{
	register u_long i;
	register u_char *p;

	p = &buf[0];
	for ( i= 0; i< len; i++ )
		*p++ = i;
}

/* set up LL */
void
set_ll( u_char *buf, u_long ll_len, u_long len )
{
	register u_long i;
	register u_char	*p;

	if ( ll_len )
		p = &buf[2];
	else
		p = buf;
	for ( i= 0; i< len; i++ )
		*p++ = i;
	if ( ll_len ) {
		buf[0] = ll_len >> 8;
		buf[1] = ll_len;
	}
}

void
print_flags (int len, u_char rts_flag, u_char wr_flag, u_char wr_data)
{
	printf ("len = %d RTS rcvd = %d wr_flag = ", len, rts_rcvd);
	switch (wr_flag) {
		case WR_NONE:
			printf ("WR_NONE ");
			break;
		case WR_CONFIRM:
			printf ("WR_CONFIRM ");
			break;
		case WR_CONFIRM_DEALLOCATE:
			printf ("WR_CONFIRM_DEALLOCATE ");
			break;
		case WR_CONFIRM_SEND:
			printf ("WR_CONFIRM_SEND ");
			break;
		case WR_SEND:
			printf ("WR_SEND ");
			break;
		default:
			printf ("%d ", wr_flag);
	}
	printf ("wr_data = ");
	switch (wr_data) {
		case WR_NONE:
			printf ("WR_NONE\n");
			break;
		case WR_DATA:
			printf ("WR_DATA\n");
			break;
		case WR_DATA_COMPLETE:
			printf ("WR_DATA_COMPLETE\n");
			break;
		case WR_DATA_INCOMPLETE:
			printf ("WR_DATA_INCOMPLETE\n");
			break;
		default:
			printf ("%d\n", wr_data);
	}
}

u_char
get_iso_ebcdic_string (u_char *string_namep, u_char *stringp, u_long max_length)
{
	int i, j, len;
	char c;

	iscan = 0;
	while (iscan != 1) {
		printf (gettext("   Enter %s_is_iso "), string_namep);
		printf ("(1=ISO, 0=EBCDIC):  ");
		iscan = scanf("%d", &i);
		check_scan ();
	}

	iscan = 0;
	if ( i ) {
		while (iscan != 1) {
			printf(gettext("   Enter %s (1-%d ISO chars):  "),
					string_namep, max_length);
			iscan = scanf("%s", stringp);
			check_scan ();
		}
	} else {
		printf(gettext("   Enter %s\n	"), string_namep);
		printf (gettext("(hex chars, separated by spaces,"));
		printf (gettext("terminate with 0):  "));
		for ( len=0;;len++) {
			scanf(" %x", &j);
			*stringp++ = j;
			if (j == 0x00) break;
		}
	}
	iscan = scanf ("%c", &c);	/* eat <cr> */
	return ((u_char)i);	/* return iso_ebcdic indicator */
}

u_char	pu_name[MAX_TYP_NAME + 1 ];
int	lu_local_address = 1;

void
process_verb( int verb )
{
	long i, len, j, k;
	u_char	log_data[MAX_TP_NAME+1];
	u_char	file_name[32];
	DISPLAY_SYSTEM  dsp_sys;
	DISPLAY_LOCAL_LU	dsp_lu;
	DISPLAY_PARTNER_LU  dsp_part;
	DISPLAY_MODE	dsp_mode;
	DISPLAY_TP	dsp_tp;
	int sub_type, lu_addr;
	u_long	gateway_fd;

	switch ( verb ) {

	case VERB_CNOS: { 
		CNOS	param;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter all_mode_names(1=yes, 0=no):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.all_mode_names = (u_char)i;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter pu_name (1-8 ISO chars):  "));
			iscan = scanf("%s", &param.pu_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter lu_address (1-8 ISO chars):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.lu_local_address = (u_char)i;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Fully qualified partner LU name is composed of an\n"));
			printf(gettext("   optional Network Name, followed by a period and the\n"));
			printf(gettext("   LU Name.  Both names are 8 characters in length.\n"));
			printf(gettext("   Enter fql_partner_lu_name "));
			printf(gettext("([<network_name>.]<lu_name>):  "));
			iscan = scanf("%s", &param.fql_partner_lu_name);
			check_scan ();
		}
		if (!param.all_mode_names) {
			iscan = 0;
			while (iscan != 1) {
				printf(gettext("   Enter mode_name (1-8 ISO chars):  "));
				iscan = scanf("%s", &param.mode_name );
				check_scan ();
			}
		} else
			param.mode_name[0] = 0;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter lu_mode_session_limit(0-254):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.lu_mode_session_limit = (short)i;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter min_conwinner_source(0-254):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.min_conwinner_source = (short)i;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter min_conwinner_target(0-254):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.min_conwinner_target = (short)i;
		param.auto_activate = 0;
		param.set_negotiable = 0;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter target_deact_session(1=yes, 0=no):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.target_deact_session = (u_char)i;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter drain_source(1=yes, 0=no):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.drain_source = (u_char)i;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter drain_source(1=yes, 0=no):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		param.drain_target = (u_char)i;
		param.force = 0;
		uli = cnos(&param);
		appc_error ((u_char *)"cnos");
		break;
	}
	case VERB_DELETE: {
		DELETE	param;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter whole_system (1=yes, 0=no):  "));
			iscan = scanf("%d", &j);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter pu_name (1-8 ISO chars):  "));
			iscan = scanf("%s", &param.pu_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter lu_address (1-8 ISO chars):  "));
			iscan = scanf("%d", &i );
			check_scan ();
		}
		param.whole_system = j;
		param.lu_local_address = i;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Fully qualified partner LU name is composed of an\n"));
			printf(gettext("   optional Network Name, followed by a period and the\n"));
			printf(gettext("   LU Name.  Both names are 8 characters in length.\n"));
			printf(gettext("   Enter fql_partner_lu_name "));
			printf(gettext("([<network_name>.]<lu_name>):  "));
			iscan = scanf("%s", &param.fql_partner_lu_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter mode_name (1-8 ISO chars):  "));
			iscan = scanf("%s", &param.mode_name );
			check_scan ();
		}
		delete( &param );
		appc_error((u_char *)"delete");
		break;
	}
	case VERB_DISPLAY_TP:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter tp_id (returned by TP_START verb):  0x"));
			iscan = scanf("%x", &dsp_tp.tp_id );
			check_scan ();
		}
		uli = display_tp( &dsp_tp );
		if (uli) appc_error ((u_char *)"display_tp");
		else {
			printf("log tp name='%s'\n", dsp_tp.log_tp_name);
			printf("host name='%s'\n", dsp_tp.host_name);
			printf("login name='%s'\n", dsp_tp.login_name);
			printf("listen_conv_id=0x%x\n",dsp_tp.listen_conv_id );
			printf("conv_ids: ");
			for (i=0;i<dsp_tp.conv_id_count;i++)
				printf("0x%x ",dsp_tp.conv_id_list[i]);
			printf("\n");
		}
		break;
	case VERB_DISPLAY_SYSTEM: 
		dsp_sys.flags = 0;
		uli = display_system( &dsp_sys );
		if (uli) appc_error ((u_char *)"display_system");
		else {
			if ( dsp_sys.tp_count ) {
				printf(gettext("Active TPs: %d\n"), dsp_sys.tp_count);
				printf("tp_id: ");
				for (i=0;(u_char)i<dsp_sys.tp_count;i++)
					printf("0x%x ",dsp_sys.tp_id_list[i]);
				printf("\n");
			}
			if ( dsp_sys.pu_count == 1 ) {
				strcpy( pu_name, dsp_sys.pu_name_list[0] );
				printf("pu_name='%s'\n",pu_name );
			}
		}
		break;
	case VERB_DISPLAY_LOCAL_LU:
		iscan = 0;
		while (iscan != 1) {
 			printf (gettext("   Enter pu_name (1-16 ISO chars):  "));
 			iscan = scanf ("%s", dsp_lu.pu_name);
 			check_scan ();
		}

		iscan = 0;
		while (iscan != 1) {
			printf (gettext("   Enter lu_local_address (1-8 ISO chars):  "));
			iscan = scanf("%d", &lu_addr);
			check_scan ();
		}
		dsp_lu.lu_local_address = (u_char)lu_addr;
		uli = display_local_lu( &dsp_lu );
		if (uli) appc_error( (u_char *)"display_local_lu" );
		else {
			printf("fql_lu_name=%s\n", dsp_lu.fql_lu_name );
			printf ("conv_ids:");
			for (i = 0; i < MAX_SESSION_PER_LU; i++) {
				if (dsp_lu.conv_id[i] == 0) break;
				printf ("  %08x", dsp_lu.conv_id[i]);
			}
			printf ("\n");
			printf(gettext("session_limit=%d session_count=%d\n"),
					dsp_lu.lu_session_limit, dsp_lu.lu_session_count);
			for (i = 0; i < dsp_lu.partner_lu_name_count; i++)
				printf("partner_lu=%s\n", dsp_lu.partner_lu_name_list[i]);
		}
		break;
	case VERB_DISPLAY_PARTNER_LU:
		iscan = 0;
		while (iscan != 1) {
 			printf (gettext("   Enter pu_name (1-16 ISO chars):  "));
 			iscan = scanf ( "%s", dsp_part.pu_name);
 			check_scan ();
		}

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter lu_local_address (1-8 ISO chars):  "));
			iscan = scanf("%d", &lu_addr);
			check_scan ();
		}
		dsp_part.lu_local_address = (u_char)lu_addr;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Fully qualified partner LU name is composed of an\n"));
			printf(gettext("   optional Network Name, followed by a period and the\n"));
			printf(gettext("   LU Name.  Both names are 8 characters in length.\n"));
			printf(gettext("   Enter fql_partner_lu_name "));
			printf(gettext("([<network_name>.]<lu_name>):  "));
			iscan = scanf("%s", dsp_part.fql_partner_lu_name );
			check_scan ();
		}
		uli = display_partner_lu( &dsp_part );
		if (uli) appc_error( (u_char *)"display_partner_lu" );
		else {
			printf(gettext(" uninterpreted_lu_name=%s\n"),
					dsp_part.uninterpreted_lu_name );
			printf(gettext(" lu_is_dependent = %d\n"), 
					dsp_part.remote_is_sscp ? gettext("yes"): gettext("no"));
			for ( i=0; i<dsp_part.mode_name_count; i++ ) {
				printf(gettext(" unique_session_name=%s mode_name=%s\n"), 
					dsp_part.unique_session_name_list[i],
					dsp_part.mode_name_list[i] );
			}
		}
		break;
	case VERB_DISPLAY_MODE: 
		iscan = 0;
		while (iscan != 1) {
 			printf (gettext("   Enter pu_name (1-16 ISO chars):  "));
 			iscan = scanf ( "%s", dsp_mode.pu_name);
 			check_scan ();
		}

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter lu_local_address (1-8 ISO chars):  "));
			iscan = scanf("%d", &lu_addr);
			check_scan ();
		}
		dsp_mode.lu_local_address = (u_char)lu_addr;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Fully qualified partner LU name is composed of an\n"));
			printf(gettext("   optional Network Name, followed by a period and the\n"));
			printf(gettext("   LU Name.  Both names are 8 characters in length.\n"));
			printf(gettext("   Enter fql_partner_lu_name "));
			printf(gettext("([<network_name>.]<lu_name>):  "));
			iscan = scanf("%s", dsp_mode.fql_partner_lu_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter mode_name (1-8 ISO chars):  "));
			iscan = scanf("%s", dsp_mode.mode_name );
			check_scan ();
		}
		uli = display_mode( &dsp_mode );
		if (uli)
			appc_error( (u_char *)"display_mode" );
		else {
			printf(gettext("unique_session_name=%s\n"), dsp_mode.unique_session_name );
			printf(gettext("snd_pac_window=%d rcv_pac_window=%d "),
				dsp_mode.snd_pac_window, dsp_mode.rcv_pac_window);
			printf(gettext("snd_max_ru=%d rcv_max_ru=%d\n"),
				dsp_mode.snd_max_ru_size, dsp_mode.rcv_max_ru_size );
			printf(gettext("auto=%d sesslim=%d conwinner=%d conloser=%d\n"),
				dsp_mode.conwinner_auto_activate_limit, dsp_mode.session_limit,
				dsp_mode.min_conwinner_limit, dsp_mode.min_conloser_limit );
			printf(gettext("lock=%d sess_count=%d conwinner_count=%d"),
				dsp_mode.lock, dsp_mode.session_count,
				dsp_mode.conwinners_session_count);
			printf (gettext(" conloser_count=%d\n"), dsp_mode.conlosers_session_count);
			for ( i=0; i<dsp_mode.session_id_count; i++ )
				printf(gettext(" session_id=%x\n"), dsp_mode.session_id_list[i] );
		}
		break;
	case VERB_DISPLAY_PU: {
		DISPLAY_PU dp_param;
		short si;

		iscan = 0;
		while (iscan != 1) {
 			printf (gettext("   Enter pu_name (1-16 ISO chars):  "));
 			iscan = scanf ( "%s", dp_param.pu_name);
 			check_scan ();
		}

		uli = display_pu (&dp_param);
		appc_error ((u_char *)"display_pu");
		if (!uli) {
			printf ("net_name = %s\n", dp_param.net_name);
			printf ("node_id = %s\n", dp_param.node_id);
			printf ("contents_id = %s\n", dp_param.contents_id);
			printf ("dlc_name = %s\n", dp_param.dlc_name);
			printf ("als_name = %s\n", dp_param.als_name);
			printf ("local_pu = %d\n", dp_param.local_pu);
			printf ("pums_supported = %s\n", dp_param.pums_supported ? "yes" : "no");
			printf ("local_lu_count = %d\n", dp_param.local_lu_count);
			printf ("index	lu addr		fully qualified lu_name\n");
			for (si = 0; si < dp_param.local_lu_count; si++) {
					printf ("%02d	%02x		%s\n",
								si,
								dp_param.lu_local_address_list[si],
								&dp_param.fql_lu_name_list[si][0]);
			}
		} else {
			printf (gettext("error %08x\n"), uli);
		}
	}
			break;
	
	case VERB_TP_LISTEN:
	{
		TP_LISTEN xparam;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter tp_name ('0' for promiscuous name):  "));
			iscan = scanf("%s", xparam.tp_name );
			check_scan ();
		}
		if ( !strcmp( xparam.tp_name, "0" ) )
			xparam.tp_name[0] = 0; /* null tp name */
		xparam.tp_name_is_iso = 1;
		xparam.queue_depth = 4;
		xparam.sync_level = SYNC_NONE;
		xparam.conv_type = BASIC_CONVERSATION;
		iscan = 0;
		while (iscan != 1) {
			printf (gettext("    Enter Security Required:  NONE[0]/CONV[1]/\n"));
			printf (gettext("                              ACCESS_PROFILE[2]/\n"));
			printf (gettext("                              ACCESS_USER_ID[3]/\n"));
			printf (
			gettext("                              ACCESS_USER_ID_PROFILE[4]:  "));
			iscan = scanf ("%d", &xparam.security_required);
			check_scan();
		}
		if (xparam.security_required > SECURITY_REQ_CONV) {
			int i;

			i = iscan = 0;

			printf (gettext("   Enter Userid Profile pairs.  Use `NULL' to"));
			printf (gettext(" specify that either is\n    nonexistent; "));
			printf (gettext("`NULL NULL' is the last entry.\n"));
			while (iscan != 1) {
				printf (gettext("	Enter pair #%d:  "), i);
				iscan = scanf ("%s %s", xparam.security_userids[i].user_id,
										xparam.security_profiles[i].profile);
				if (iscan != 2) {
					while ((cc = getchar()) != '\n');
					printf (gettext("Input error\n"));
				}
				if (!strcmp (xparam.security_userids[i].user_id, "NULL"))
					xparam.security_userids[i].user_id[0] = 0;
				if (!strcmp (xparam.security_profiles[i].profile, "NULL"))
					xparam.security_profiles[i].profile[0] = 0;
				if (!xparam.security_userids[i].user_id[0] &&
						!xparam.security_profiles[i].profile[0]) {
					break;
				}
				i++;
			}
		}

		uli = tp_listen (&xparam);
		if (uli) {
			appc_error((u_char *)"tp_listen");
			printf (" Return_code = 0x%08x\n", uli);
		} else {
			listen_conv_id = xparam.listen_conv_id;
			printf("Listen conv_id = %x\n", listen_conv_id );
		}
	}
		break;
	case VERB_TP_WAIT_REMOTE_START: {
		u_long	pip_length;
		int pip_number, ipip, colcnt;
		long llen, llen2;
		u_char *pipdatap;
		CONV_TYPE conv_type;
		TP_WAIT_REMOTE_START sparam;


		has_tp++;
		conv_id1 = conv_id;
		sparam.listen_conv_id = listen_conv_id;
		sparam.pip_data = pip_data;
		sparam.pip_length = MAX_PIP;

		uli = tp_wait_remote_start (&sparam);
		if (uli)
		{
			appc_error((u_char *)"tp_wait_remote_start");
			printf (gettext(" Return_code = 0x%08x\n"), uli);
			break;	
		}
		conv_id = sparam.conv_id;

		printf(" New conv_id = %x,", conv_id );
		uli = get_type_proc (conv_id, &conv_type);
		if (uli)
		{
			appc_error((u_char *)"tp_wait_remote_start");
			printf (gettext(" Return_code = 0x%08x\n"), uli);
			break;	
		}
		if (conv_type == MAPPED_CONVERSATION)
			printf (gettext(" MAPPED"));
		else
			printf (gettext(" BASIC"));
		printf (gettext(" CONVERSATION\n"));
		if (sparam.pip_length) {
			pip_number = pipnumber(pip_data);
			if (pip_number) {
				printf (gettext("Number of PIP subfields:  %d\n"), pip_number);
				for (ipip = 1; ipip <= pip_number; ipip++) {
					pipdatap = peekpip (pip_data, ipip, &llen);
					printf (gettext("PIP subfield %d (len = %d):\n	 "), ipip, llen);
					colcnt = 0;
					for (llen2 = 0; llen2 < llen; llen2++) {
						printf ("%02x ", *pipdatap++);
						colcnt++;
						if (colcnt == 16) {
							printf ("\n	");
							colcnt = 0;
						}
					}
					printf ("\n");
				}
				printf ("pip_data[] =\n");
				colcnt = 0;
				llen2 = 0;
				while (sparam.pip_length) {
					printf ("%02x ", pip_data[llen2]);
					colcnt++;
					llen2++;
					if (colcnt == 16) {
						printf ("\n");
						colcnt = 0;
					}
					sparam.pip_length--;
				}
				printf ("\n");
			} else {
				printf (gettext("eh? pip_length = %d, but pip_number = %d\n"));
			}
		} else {
			printf (gettext("No PIP data\n"));
		}
		printf (gettext("Security Acceptance = "));
		switch (sparam.security_acceptance) {
			case SECURITY_ACCEPT_NONE:
				printf ("NONE\n");
				break;
			case SECURITY_ACCEPT_CONV:
				printf ("CONVERSATION\n");
				break;
			case SECURITY_ACCEPT_ALREADY_VERIFIED:
				printf ("ALREADY_VERIFIED\n");
				break;
			default:
				printf (gettext("UNKNOWN (%d)\n"), sparam.security_acceptance);
		}
		printf (gettext("Security userid and profile:\n"));
		if (sparam.security_userid.user_id[0]) {
			printf ("%s ", sparam.security_userid.user_id);
		} else {
			printf ("NULL ");
		}
		if (sparam.security_profile.profile[0]) {
			printf ("%s\n", sparam.security_profile.profile);
		} else {
			printf ("NULL\n");
		}

		break;
	}
	case VERB_DEFINE_APPC_ERROR: {
		int flag, db_data;

		printf(gettext("    bit 0 of flag = 0  create a new file_name\n"));
        printf(gettext("                  = 1  append msg on file_name\n"));
		printf(gettext("    bit 1 of flag = 0  data is in ISO code\n"));
        printf(gettext(gettext("                  = 1  data is in EBCDIC code\n")));
		printf(gettext("    bit 3 of flag = 0  all data is printed\n"));
        printf(gettext("                  = 1  up to 16-byte data is printed\n"));
        printf(gettext("    bit 8 of flag = 0  no trace msg when rc is OK\n"));
        printf(gettext("                  = 1  trace msg when rc is OK\n"));
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("    Enter file_name (1-32 chars):  "));
			iscan = scanf("%s", file_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("    Enter flags (1-4 hex digits):  "));
			iscan = scanf("%x", &flag);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("    Enter db_data (1=yes, 0=no):  "));
			iscan = scanf("%d", &db_data );
			check_scan ();
		}
		define_appc_error_proc( file_name, flag, db_data );
		break;
	}

	case VERB_DB_MSG: {
		int flag, db_pc, db_mail, db_api_verb, db_dev, db_buf, db_tp_info;
		int db_max_trc_sz;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter file_name (1-32 chars):  "));
			iscan = scanf("%s", file_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("    bit 0 of flag = 0  create a new file_name\n"));
        	printf(gettext("                  = 1  append msg on file_name\n"));
			printf(gettext("    bit 1 of flag = 0  data is in ISO code\n"));
        	printf(gettext("                  = 1  data is in EBCDIC code\n"));
			printf(gettext("    bit 3 of flag = 0  all data is printed\n"));
        	printf(gettext("                  = 1  up to 16-byte data is printed\n"));
			printf(gettext("   Enter flags (hex char):  "));
			iscan = scanf("%x", &flag);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter pc (1=log PC data, 0=no):  "));
			iscan = scanf("%d", &db_pc);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter mail (1=log mail between layers, 0=no):  "));
			iscan = scanf("%d", &db_mail);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter api (1=log API verbs, 0=no):  "));
			iscan = scanf("%d", &db_api_verb);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter dev (1=log SDLC info, 0=no):  "));
			iscan = scanf("%d", &db_dev);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter buf (1=log buffer (de)allocation, 0=no):  "));
			iscan = scanf("%d", &db_buf);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf (gettext("   Enter tp_info (1=log machine/login/local_tp names,"));
			printf (gettext(" 0=no):  "));
			iscan = scanf("%d", &db_tp_info);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter maximum trace size (in megabytes):  "));
			iscan = scanf("%d", &db_max_trc_sz);
			check_scan ();
		}
		(void)db_msg_proc (file_name, flag, (u_char)db_pc, (u_char)db_mail,
					(u_char)db_api_verb, (u_char)db_dev,
					(u_char)db_buf, (u_char)db_tp_info,
					(u_char)db_max_trc_sz, (u_char)0, 0);
		break;
	}

	case VERB_GET_STATE: {
		u_char	conv_state;

		get_state_proc( conv_id, &conv_state );
		printf("state=%d\n", conv_state);
		break;
	}

	case VERB_GET_TYPE: {
		CONV_TYPE	conv_type;

		get_type_proc( conv_id, &conv_type );
		printf("type=%d\n", conv_type);
		break;
	}

	case VERB_GET_APPC_ERROR_MSG:
	{
		GET_APPC_ERROR_MSG gaem;

		iscan = 0;
		while (iscan != 1) {
			printf (gettext("	Enter error value (in hex):  0x"));
			iscan = scanf ("%x", &gaem.error_return_code);
			check_scan ();
		}
		uli = get_appc_error_msg (&gaem);
		printf (gettext("Error message = %s"), gaem.msg);
	}
		break;

	case VERB_PEEK:
		peek_proc(listen_conv_id);
		break;

	case VERB_TP_SWITCH:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter new gateway_fd (returned by tp_start):  0x") );
			iscan = scanf("%x",  &gateway_fd);
			check_scan ();
		}
		tp_switch_proc(gateway_fd);
		break;
	case VERB_TP_END:
		tp_end_proc();
		break;
	case VERB_TP_START:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter gateway_name (1-64 chars):  ") );
			iscan = scanf("%s",  gateway);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter log_name (1-64 chars):  ") );
			iscan = scanf("%s",  log_data);
			check_scan ();
		}
		tp_start_proc( gateway, log_data, &gateway_fd );
		printf(gettext("gateway_fd is 0x%x\n"), gateway_fd);
		break;
	case VERB_WAIT: {
		int	nbio, conv_id1, conv_id2, conv_id3, conv_id1_rw, conv_id2_rw,
			conv_id3_rw;
		short	i;
		register WAIT	*param;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter nbio (1=nonblocking, 0=blocking):  ") );
			iscan = scanf("%d", &nbio);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter conv_id1 (hex rtnd by tp_wait_remote_start"));
			printf (gettext(" or allocate):  ") );
			iscan = scanf("%x", &conv_id1);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter conv_id1_rw (1=WRITABLE, 0=READABLE):  ") );
			iscan = scanf("%d", &conv_id1_rw);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter conv_id2 (hex rtnd by tp_wait_remote_start"));
			printf (gettext(" or allocate):  ") );
			iscan = scanf("%x", &conv_id2);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter conv_id2_rw (1=WRITABLE, 0=READABLE):  ") );
			iscan = scanf("%d", &conv_id2_rw);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter conv_id3 (hex rtnd by tp_wait_remote_start"));
			printf (gettext(" or allocate):  ") );
			iscan = scanf("%x", &conv_id3 );
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter conv_id3_rw (1=WRITABLE, 0=READABLE):  ") );
			iscan = scanf("%d", &conv_id3_rw);
			check_scan ();
		}

		param = (WAIT *)buf;
		param->number_of_conv_ids = 0;
		param->nbio = nbio;
		i = 0;
		if ( conv_id1 ) {
			param->conv_id_list[i] = conv_id1;
			param->conv_id_rw_list[i++] = conv_id1_rw;
			param->number_of_conv_ids++;
		}
		if ( conv_id2 ) {
			param->conv_id_list[i] = conv_id2;
			param->conv_id_rw_list[i++] = conv_id2_rw;
			param->number_of_conv_ids++;
		}
		if ( conv_id3 ) {
			param->conv_id_list[i] = conv_id3;
			param->conv_id_rw_list[i++] = conv_id3_rw;
			param->number_of_conv_ids++;
		}
		appc_wait( param );
		printf(gettext("posted conv_id=%x\n"),param->posted_conv_id );
		appc_error( (u_char *)"wait" );
		break;
	}

/************************************************/
/*      Basic conversation verbs                */
/************************************************/

	case VERB_SEND_DATA: {
		int ll_len, nbio;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Sub_type (0=NONE, 2=FLUSH, 3=CONFIRM,\n"));
			printf(gettext("                   10=PREP-TO-RCV-FLSH,\n"));
			printf(gettext("                   11=PREP-TO-RCV-CONFIRM-SHORT,\n"));
			printf(gettext("                   12=PREP-TO-RCV-CONFIRM-LONG):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Note that total length will be real_data_len + 2\n"));
			printf(gettext("   Enter real_data_len (0-32765):  "));
			iscan = scanf("%d", &len);
			check_scan ();
		}
		ll_len = len + 2;
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter nbio (1=nonblocking, 0=blocking):  "));
			iscan = scanf("%d", &nbio );
			check_scan ();
		}
		set_ll( data_buf, ll_len, len );
		/* plus 2-byte LL header */
		if ( ll_len )
			len += 2;
		uli = send_data_proc( conv_id, i, ll_len, data_buf,
							&request_to_send_received, nbio );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		if ( request_to_send_received )
			printf(gettext(" RTS received\n") );
		break;
	}
	case VERB_TEST: {
		int 

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Sub_type (56=POSTED, 57=SUB_REQUEST_TO_SEND_RECEIVED): "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		uli = appc_test_proc( conv_id, i, &wr_data_type );
		if (uli) {
			printf (gettext(" Return_code = %08x\n"), uli);
		}
		if ( appc_errno == DEALLOCATE_NORMAL ) {
			printf(gettext(" DEALLOCATE_NORMAL received\n") );
		} 
		else if (!uli) {
			if (i == SUB_POSTED) {
				printf ("wr_data = ");
				switch (wr_data_type) {
				case WR_NOT_DATA:
					printf ("WR_NOT_DATA ");
					break;
				case WR_DATA:
					printf ("WR_DATA\n");
					break;
				default:
					printf (gettext("*** Invalid Value ***\n"));
				}
			}
			else
				printf("REQUEST_TO_SEND_RECEIVED\n");
		}
		break;
	}
	case VERB_RECEIVE_IMMEDIATE:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Type (0=NONE, 20=CONFIRMED_ON_CONFIRM):  "));
			iscan = scanf("%d", &j);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Len (1-32767):  "));
			iscan = scanf("%d", &len);
			check_scan ();
			if (len > 32767) iscan = 0;
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Fill (0=LL, 1=BUFFER):  "));
			iscan = scanf("%d", &i );
			check_scan ();
		}
		if ( i )
			fill = BUFFER;
		else
			fill = LL;
		uli = receive_immediate_proc( conv_id, j, fill, data_buf, &len,
			&rts_rcvd, &wr_flag_type, &wr_data_type );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		print_flags (len, rts_rcvd, wr_flag_type, wr_data_type);
		if ( appc_errno == DEALLOCATE_NORMAL ) {
			printf(gettext(" DEALLOCATE_NORMAL received\n") );
		} else {
			if (!uli) {
				if (use_long)
					print_in_format( data_buf, len, err_file );
			}
		}
		break;
	case VERB_RECEIVE_AND_WAIT:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Type (0=NONE, 20=CONFIRMED_ON_CONFIRM):  "));
			iscan = scanf("%d", &j);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Len (1-32767):  "));
			iscan = scanf("%d", &len);
			check_scan ();
			if (len > 32767) iscan = 0;
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Fill (0=LL, 1=BUFFER):  "));
			iscan = scanf("%d", &i );
			check_scan ();
		}
		if ( i )
			fill = BUFFER;
		else
			fill = LL;
		uli = receive_and_wait_proc( conv_id, j, fill, data_buf, &len,
			&rts_rcvd, &wr_flag_type, &wr_data_type );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		print_flags (len, rts_rcvd, wr_flag_type, wr_data_type);
		if ( appc_errno == DEALLOCATE_NORMAL ) { 
			printf(gettext(" DEALLOCATE_NORMAL received\n") );
		}
		if (use_long)
			print_in_format( data_buf, len, err_file );
		break;
	case VERB_CONFIRM:
		uli = confirm_proc( conv_id, &request_to_send_received );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		if ( request_to_send_received )
			printf(gettext(" RTS received\n") );
		break;
	case VERB_CONFIRMED:
		uli = confirmed_proc( conv_id );
		if (uli) {
			printf (gettext(" Return_code = %08x\n"), uli);
		}
		break;
	case VERB_GET_ATTRIBUTES: {
		register GET_ATTRIBUTES	*param;

		param = (GET_ATTRIBUTES *)buf;
		param->conv_id = conv_id;
		uli = get_attributes( param );
		if (uli) appc_error ((u_char *)"get_attributes");
		else {
			printf("pu_name=%s\n", param->pu_name );
			printf("lu_local_address=%d\n", param->lu_local_address );
			printf("fql_partner_lu_name=%s\n", param->fql_partner_lu_name );
			printf("unique_session_name=%s\n", param->unique_session_name );
			printf("mode_name=%s\n", param->mode_name );
			printf("sync_level=%d\n", (long)param->sync_level );
			printf("tp_name_is_iso=%d\n", param->tp_name_is_iso );
			if ( param->tp_name_is_iso )
				printf("tp_name=%s\n", param->tp_name );
			else {
				printf("tp_name:  ");
				for ( i=0;param->tp_name[i]!=0x40;i++)
					printf(" 0x%02x", param->tp_name[i] );
				printf("\n");
			}
			printf("state=%d\n", param->state );
		}
		break;
	}

	case VERB_SEND_ERROR:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Sub_type (50=PROG, 51=SVC, 52=PROG_FLUSH\n"));
			printf(gettext("                   53=SVC_FLUSH, 54=PROG_CONFIRM,\n"));
			printf(gettext("                   55=SVC_CFRM):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter dont_flush_fmh7 (1=don't flush, 0=do flush):  "));
			iscan = scanf("%d", &j);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter log_len (0-64, 0=none):  "));
			iscan = scanf("%d", &len );
			check_scan ();
		}
		send_error_proc( conv_id, i, j, len, log_data,
			&request_to_send_received, 0 );
		if ( request_to_send_received )
			printf(gettext(" RTS received\n") );
		break;
	case VERB_REQUEST_TO_SEND:
		uli = request_to_send_proc( conv_id );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		break;
	case VERB_PREPARE_TO_RECEIVE:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Sub_type (1=SYNC_LEVEL, 2=FLUSH, 3=CONFIRM):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Locks (SHORT=0, LONG=1):  "));
			iscan = scanf("%d", &len );
			check_scan ();
		}
		uli = prepare_to_receive_proc( conv_id, i , len );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		break;
	case VERB_FLUSH:
		uli = flush_proc( conv_id );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		if ( request_to_send_received )
			printf(gettext(" RTS received\n") );
		break;
	case VERB_DEALLOCATE:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Sub_type (1=SYNC_LEVEL, 2=FLUSH, 3=CONFIRM, "));
			printf(gettext("42=LOCAL):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter log_len (0-64, 0=none):  "));
			iscan = scanf("%d", &len );
			check_scan ();
		}
		deallocate_proc( conv_id, i, len, log_data );
		break;
	case VERB_POST_ON_RECEIPT:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter FILL (0=LL, 1=BUFFER):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter len:  "));
			iscan = scanf("%d", &len );
			check_scan ();
		}
		post_on_receipt_proc( conv_id, i, len );
		break;

	case VERB_ALLOCATE: {
		ALLOCATE s_param;
		int ix;
		char answer;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter tp_name_is_iso (1=ISO, 0=EBCDIC):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		if ( i ) {
			while (iscan != 1) {
				printf(gettext("   Enter tp_name (1-64 ISO chars):  "));
				iscan = scanf("%s", s_param.tp_name);
			check_scan ();
			}
		} else {
			printf(gettext("   Enter tp_name\n	"));
			printf (gettext("(hex chars, separated by spaces, terminate with 40):  "));
			for ( len=0;;len++) {
				scanf(" %x", &j);
				s_param.tp_name[len] = j;
				if (j == 0x40) break;
			}
			s_param.tp_name[len+1] = 0x00;
		}
		s_param.tp_name_is_iso = (u_char)i;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter unique_session_name (1-16 ISO chars):  "));
			iscan = scanf("%s", s_param.unique_session_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter sub_type (30=when allocated, 31=delayed,"));
			printf (gettext(" 32=immediate):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		s_param.type = (u_char)i;

		iscan = 0;

		for (ix = 0; ix < MAX_PIP; ix++) {
			pip_data[ix] = 0x00;
		}

		while (iscan != 1) {
			printf(gettext("   PIP data is automatically generated (0-x), where\n"));
			printf(gettext("   x = length specified, max 300.\n"));
			printf(gettext("   Enter pip data length (0 to stop):  "));
			iscan = scanf("%d", &len);
			check_scan ();
			if (len > MAX_PIP) iscan = 0;
		}

		if ( len ) {
			u_char pipnumbers = 0x00;

			startpip( pip_data, MAX_PIP );
			do {
				u_char	subfield[MAX_PIP];
	
				if (len) {
					int i;
	
					for (i=0;i<len;i++)
						subfield[i] = pipnumbers++;

					if (addpip( pip_data, subfield, len )) {
						printf(gettext("addpip fails\n"));
						break;
					}
				}

				iscan = 0;
				while (iscan != 1) {
					printf(gettext("   Enter next pip data length (0 to stop):  "));
					iscan = scanf("%d", &len);
					check_scan ();
					if (len > MAX_PIP) iscan = 0;
				}
			} while (len);
		}

		has_tp++;
		conv_id1 = conv_id;

		s_param.conv_type = BASIC_CONVERSATION;
		s_param.sync_level = SYNC_CONFIRM;
		s_param.timeout = 100;
		s_param.pip_length = endpip (pip_data);
		s_param.pip_data = pip_data;

		/*
		 *  get security select (SECURITY_[NONE,SAME,PGM])
		 */
		
		printf (gettext("    Enter Security Select:\n"));
		printf (gettext("	0) SECURITY_NONE, 1) SECURITY_SAME, 2) SECURITY_PGM"));
		printf (gettext(" [0,1,2]:  "));
		iscan = scanf ("%d", &ix);
		check_scan();
		s_param.security_select = (SECURITY_SELECT)ix;

		switch (s_param.security_select) {
			case SECURITY_NONE:
				s_param.sec_user_id[0] = 0x00;
				s_param.sec_password[0] = 0x00;
				s_param.sec_profile[0] = 0x00;
				break;

			case SECURITY_PGM:
			case SECURITY_SAME:

				/*
				 *  get user id
				 */

				s_param.sec_user_id_is_iso =
					get_iso_ebcdic_string ((u_char *)"sec_user_id",
											s_param.sec_user_id,
											MAX_USER_ID);

				/*
				 *  get password
				 */

				printf (gettext("   Is there a password for the user_id (y/n)?  "));
				iscan = scanf ("%c", &answer);
				check_scan();
				if (answer == 'y') {
					s_param.sec_password_is_iso = 
						get_iso_ebcdic_string ((u_char *)"sec_password",
												s_param.sec_password,
												MAX_PASSWORD);
				} else {
					s_param.sec_password[0] = 0x00;
					iscan = scanf ("%c", &answer);	/* eat <cr> */
				}

				/*
				 *  get profile
				 */

				printf (gettext("   Is there a profile for the user_id (y/n)?  "));
				iscan = scanf ("%c", &answer);
				check_scan();
				if (answer == 'y') {
					s_param.sec_profile_is_iso = 
						get_iso_ebcdic_string ((u_char *)"sec_profile",
												s_param.sec_profile,
												MAX_PROFILE);
				} else {
					s_param.sec_profile[0] = 0x00;
					iscan = scanf ("%c", &answer);	/* eat <cr> */
				}
		}

		uli = allocate (&s_param);
		if (uli) {
			appc_error((u_char *)"allocate");
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		} else {
			conv_id = s_param.conv_id;
			printf(gettext(" New conv_id = %x\n"), conv_id);
		}
		break;
	}

/************************************************************************/
/*		Mapped conversation verbs				*/
/************************************************************************/

/*	case VERB_MC_ALLOCATE: {
		u_char	unique_session_name[MAX_TYP_NAME + 1];
		int ix;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter tp_name_is_iso (1=ISO, 0=EBCDIC):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		if ( i ) {
			while (iscan != 1) {
				printf(gettext("   Enter tp_name (1-64 ISO chars):  "));
				iscan = scanf("%s", tp_name);
				check_scan ();
			}
		} else {
			printf(gettext("   Enter tp_name\n	"));
			printf ("(hex chars, separated by spaces, terminate with 40):  ");
			for ( len=0;;len++) {
				scanf(" %x", &j);
				tp_name[len] = j;
				if (j == 0x40) break;
			}
			tp_name[len+1] = 0x00;
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter unique_session_name (1-16 ISO chars):  "));
			iscan = scanf("%s", unique_session_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter sub_type (30=when allocated, 31=delayed,"));
			printf (gettext(" 32=immediate):  "));
			iscan = scanf("%d", &sub_type);
			check_scan ();
		}

		for (ix = 0; ix < MAX_PIP; ix++) {
			pip_data[ix] = 0x00;
		}

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   PIP data is automatically generated (0-x), where\n"));
			printf(gettext("   x = length specified, max 300.\n"));
			printf(gettext("   Enter pip data length (0 to stop):  "));
			iscan = scanf("%d", &len);
			check_scan ();
			if (len > MAX_PIP) iscan = 0;
		}
		if ( len ) {
			u_char pipnumbers = 0x00;

			startpip( pip_data, MAX_PIP );
			do {
				u_char	subfield[MAX_PIP];
	
				if (len) {
					int i;
	
					for (i=0;i<len;i++)
						subfield[i] = pipnumbers++;

					if (addpip( pip_data, subfield, len )) {
						printf(gettext("addpip fails\n"));
						break;
					}
				}

				iscan = 0;
				while (iscan != 1) {
					printf(gettext("   Enter next pip data length (0 to stop):  "));
					iscan = scanf("%d", &len);
					check_scan ();
					if (len > MAX_PIP) iscan = 0;
				}
			} while (len);
		}
		has_tp++;
		conv_id1 = conv_id;
		mc_allocate_proc( unique_session_name, i, tp_name, sub_type,
			SYNC_CONFIRM, 100, &conv_id, pip_data, endpip(pip_data) );
		printf(gettext(" New conv_id = %x\n"), conv_id );
		break;
	}*/

	case VERB_MC_ALLOCATE: {/* ME GOOD*/
		MC_ALLOCATE ms_param;
		u_char	unique_session_name[MAX_TYP_NAME + 1];
		int ix;
		char answer;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter tp_name_is_iso (1=ISO , 0=EBCDIC):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		if ( i ) {
			while (iscan != 1) {
				printf(gettext("   Enter tp_name (1-64 ISO chars):  "));
				iscan = scanf("%s", ms_param.tp_name);
				check_scan ();
			}
		} else {
			printf(gettext("   Enter tp_name\n	"));
			printf (gettext("(hex chars, separated by spaces, terminate with 40):  "));
			for ( len=0;;len++) {
				scanf(" %x", &j);
				ms_param.tp_name[len] = j;
				if (j == 0x40) break;
			}
			ms_param.tp_name[len+1] = 0x00;
		}
		ms_param.tp_name_is_iso = (u_char)i;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter unique_session_name (1-16 ISO chars):  "));
			iscan = scanf("%s", ms_param.unique_session_name);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter sub_type (30=when allocated, 31=delayed,"));
			printf (gettext(" 32=immediate):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		ms_param.type = (u_char)i;

		for (ix = 0; ix < MAX_PIP; ix++) {
			pip_data[ix] = 0x00;
		}

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   PIP data is automatically generated (0-x), where\n"));
			printf(gettext("   x = length specified, max 300.\n"));
			printf(gettext("   Enter pip data length (0 to stop):  "));
			iscan = scanf("%d", &len);
			check_scan ();
			if (len > MAX_PIP) iscan = 0;
		}
		if ( len ) {
			u_char pipnumbers = 0x00;

			startpip( pip_data, MAX_PIP );
			do {
				u_char	subfield[MAX_PIP];
	
				if (len) {
					int i;
	
					for (i=0;i<len;i++)
						subfield[i] = pipnumbers++;

					if (addpip( pip_data, subfield, len )) {
						printf(gettext("addpip fails\n"));
						break;
					}
				}

				iscan = 0;
				while (iscan != 1) {
					printf(gettext("   Enter next pip data length (0 to stop):  "));
					iscan = scanf("%d", &len);
					check_scan ();
					if (len > MAX_PIP) iscan = 0;
				}
			} while (len);
		}
		has_tp++;
		conv_id1 = conv_id;

		ms_param.sync_level = SYNC_CONFIRM;
		ms_param.timeout = 100;
		ms_param.pip_length = endpip (pip_data);
		ms_param.pip_data = pip_data;

		printf (gettext("    Enter Security Select:\n"));
		printf (gettext("	0) SECURITY_NONE, 1) SECURITY_SAME, 2) SECURITY_PGM"));
		printf (gettext(" [0,1,2]:  "));
		iscan = scanf ("%d", &ix);
		check_scan();
		ms_param.security_select = (SECURITY_SELECT)ix;

		switch (ms_param.security_select) {
			case SECURITY_NONE:
				ms_param.sec_user_id[0] = 0x00;
				ms_param.sec_password[0] = 0x00;
				ms_param.sec_profile[0] = 0x00;
				break;

			case SECURITY_PGM:
			case SECURITY_SAME:

				/*
				 *  get user id
				 */

				ms_param.sec_user_id_is_iso =
					get_iso_ebcdic_string ((u_char *)"sec_user_id",
											ms_param.sec_user_id,
											MAX_USER_ID);

				/*
				 *  get password
				 */

				printf (gettext("   Is there a password for the user_id (y/n)?  "));
				iscan = scanf ("%c", &answer);
				check_scan();
				if (answer == 'y') {
					ms_param.sec_password_is_iso = 
						get_iso_ebcdic_string ((u_char *)"sec_password",
												ms_param.sec_password,
												MAX_PASSWORD);
				} else {
					ms_param.sec_password[0] = 0x00;
					iscan = scanf ("%c", &answer);	/* eat <cr> */
				}

				/*
				 *  get profile
				 */

				printf (gettext("   Is there a profile for the user_id (y/n)?  "));
				iscan = scanf ("%c", &answer);
				check_scan();
				if (answer == 'y') {
					ms_param.sec_profile_is_iso = 
						get_iso_ebcdic_string ((u_char *)"sec_profile",
												ms_param.sec_profile,
												MAX_PROFILE);
				} else {
					ms_param.sec_profile[0] = 0x00;
					iscan = scanf ("%c", &answer);	/* eat <cr> */
				}
		}

		uli = mc_allocate (&ms_param);
		if (uli) {
			appc_error((u_char *)"allocate");
			printf (" Return_code = 0x%08x\n", uli);
		} else {
			conv_id = ms_param.conv_id;
			printf(" New conv_id = %x\n", conv_id);
		}
		
		break;
	}

	case VERB_MC_SEND_DATA: {
		int	nbio;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Sub_type (0=NONE, 2=FLUSH, 3=CONFIRM,\n"));
			printf(gettext("                   10=PREP-TO-RCV-FLSH,\n"));
			printf(gettext("                   11=PREP-TO-RCV-CONFIRM-SHORT,\n"));
			printf(gettext("                   12=PREP-TO-RCV-CONFIRM-LONG):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter real_data_len (0-32765):  "));
			iscan = scanf("%d", &len);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter nbio (1=nonblocking, 0=blocking):  "));
			iscan = scanf("%d", &nbio );
			check_scan ();
		}
		set_data( data_buf, len );
		(void) mc_send_data_proc( conv_id, i, len, data_buf,
						 &request_to_send_received, nbio );
		if ( request_to_send_received )
			printf(gettext(" RTS received\n") );
		break;
	}

	case VERB_MC_RECEIVE_IMMEDIATE:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Type (0=NONE, 20=CONFIRMED_ON_CONFIRM):  "));
			iscan = scanf("%d", &j);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Len (1-32767):  "));
			iscan = scanf("%d", &len );
			check_scan ();
			if (len > 32767) iscan = 0;
		}
		uli = mc_receive_immediate_proc( conv_id, j, data_buf, &len,
				&rts_rcvd, &wr_flag_type, &wr_data_type );
		if (uli == OK) {
			print_flags (len, rts_rcvd, wr_flag_type, wr_data_type);
			if (use_long)
				print_in_format( data_buf, len, err_file );
		}
		else
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		break;

	case VERB_MC_POST_ON_RECEIPT:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter len:  "));
			iscan = scanf("%d", &len );
			check_scan ();
		}
		mc_post_on_receipt_proc( conv_id, len );
		break;

	case VERB_MC_TEST: {
		int 

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("   Enter Sub_type (56=POSTED, 57=SUB_REQUEST_TO_SEND_RECEIVED): "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		uli = mc_appc_test_proc( conv_id, i, &wr_data_type );
		if (uli) {
			printf (gettext(" Return_code = %08x\n"), uli);
		}
		if ( appc_errno == DEALLOCATE_NORMAL ) {
			printf(gettext(" DEALLOCATE_NORMAL received\n") );
		} 
		else if (!uli) {
			if (i == SUB_POSTED) {
				printf (gettext("wr_data = "));
				switch (wr_data_type) {
				case WR_NOT_DATA:
					printf ("WR_NOT_DATA ");
					break;
				case WR_DATA:
					printf ("WR_DATA\n");
					break;
				default:
					printf (gettext("*** Invalid Value ***\n"));
				}
			}
			else
				printf(gettext("REQUEST_TO_SEND_RECEIVED\n"));
		}
		break;
	}

	case VERB_MC_RECEIVE_AND_WAIT:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Type (0=NONE, 20=CONFIRMED_ON_CONFIRM):  "));
			iscan = scanf("%d", &j);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Len (1-32767):  "));
			iscan = scanf("%d", &len );
			check_scan ();
			if (len > 32767) iscan = 0;
		}
		uli = mc_receive_and_wait_proc( conv_id, j, data_buf, &len,
				&rts_rcvd, &wr_flag_type, &wr_data_type );
		if (uli) {
			printf (gettext(" Return_code = 0x%08x\n"), uli);
		}
		print_flags (len, rts_rcvd, wr_flag_type, wr_data_type);
		if ( appc_errno == DEALLOCATE_NORMAL ) { 
			printf(gettext(" DEALLOCATE_NORMAL received\n") );
		}
		if (use_long)
			print_in_format( data_buf, len, err_file );
		break;

	case VERB_MC_CONFIRM:
		(void) mc_confirm_proc( conv_id, &request_to_send_received );
		if ( request_to_send_received )
			printf(gettext(" RTS received\n") );
		break;

	case VERB_MC_CONFIRMED:
		(void) mc_confirmed_proc( conv_id );
		break;

	case VERB_MC_GET_ATTRIBUTES: {
		register MC_GET_ATTRIBUTES	*param;

		param = (MC_GET_ATTRIBUTES *)buf;
		param->conv_id = conv_id;
		uli = mc_get_attributes( param );
		if (uli) appc_error ((u_char *)"mc_get_attributes");
		else {
			printf("pu_name=%s\n", param->pu_name );
			printf("lu_local_address=%d\n", param->lu_local_address );
			printf("fql_partner_lu_name=%s\n", param->fql_partner_lu_name );
			printf("unique_session_name=%s\n", param->unique_session_name );
			printf("mode_name=%s\n", param->mode_name );
			printf("sync_level=%d\n", (long)param->sync_level );
			printf("tp_name_is_iso=%d\n", param->tp_name_is_iso );
			if ( param->tp_name_is_iso )
				printf("tp_name=%s\n", param->tp_name );
			else {
				printf("tp_name:");
				for ( i=0;param->tp_name[i]!=0x40;i++)
					printf(" 0x%02x", param->tp_name[i] );
				printf("\n");
			}
			printf("state=%d\n", param->state );
		}
		break;
	}

	case VERB_MC_SEND_ERROR:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter dont_flush_fmh7 (1=don't flush, 0=do flush):  "));
			iscan = scanf("%d", &j );
			check_scan ();
		}
		(void) mc_send_error_proc( conv_id, SUB_PROG, j,
						&request_to_send_received );
		if ( request_to_send_received )
			printf(gettext(" RTS received\n") );
		break;

	case VERB_MC_REQUEST_TO_SEND:
		(void) mc_request_to_send_proc( conv_id );
		break;

	case VERB_MC_PREPARE_TO_RECEIVE:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Sub_type (1=SYNC_LEVEL, 2=FLUSH, 3=CONFIRM):  "));
			iscan = scanf("%d", &i);
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Locks (SHORT = 0, LONG = 1):  "));
			iscan = scanf("%d", &len );
			check_scan ();
		}
		(void) mc_prepare_to_receive_proc( conv_id, i , len );
		break;

	case VERB_MC_FLUSH:
		(void) mc_flush_proc( conv_id );
		break;

	case VERB_MC_DEALLOCATE:
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Sub_type (SYNC_LEVEL=1, FLUSH=2, CONFIRM=3, "));
			printf(gettext("LOCAL=42):  "));
			iscan = scanf("%d", &i );
			check_scan ();
		}
		(void) mc_deallocate_proc( conv_id, i );
		break;

	case VERB_DISPLAY_STATISTICS: {
		u_long	id, flags;
		DISPLAY_STATISTICS	param;

		iscan = 0;
		while (iscan != 1) {
			printf(gettext("conv_id is returned by tp_wait_remote_start"));
			printf (gettext(" or allocate.\n"));
			printf(gettext("Enter conv_id (0 if entire system):  0x"));
			iscan = scanf("%x", &id );
			check_scan ();
		}
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter flags (1 if reset statistics after display):  0x"));
			iscan = scanf("%x",&flags );
			check_scan ();
		}
		param.conv_id = id;
		param.flags = flags;
		uli = display_statistics( &param );
		if (uli == OK) {
			printf("ibyte=%d idataru=%d obyte=%d odataru=%d\n",
				param.ibytes, param.idatarus, param.obytes, param.odatarus );
		}
		break;
	}

	case 90:
		exit (0);
		break;
	
	case 91:
		printf (gettext("Now using "));
		if (use_long == 0) {
			printf (gettext("long"));
			use_long = 1;
		} else {
			printf (gettext("short"));
			use_long = 0;
		}
		printf (gettext(" output format.\n"));
		break;

	case 200:
		if ( has_tp > 1 ) {
			tmp_conv_id = conv_id;
			conv_id = conv_id1;
			conv_id1 = tmp_conv_id;
		} else
			printf(gettext("Switch fails, only one tp exists\n"));
		break;

	case 300: /* enter conv_id */
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Current conv_id=0x%x  Enter conv_id : 0x"), conv_id);
			iscan = scanf("%x", &conv_id );
			check_scan ();
		}
		break;

	default:
		printf(gettext("verb not support in sunlink/p2p or this test program\n"));
	}
}

void
print_menu ()
{
	printf (gettext(" 0 Allocate   1 Confirm       2 Confirmed      3 Deallocate   4 Flush\n"));
	printf (gettext(" 5 Get_Attr   7 Prep-to-Rcv   8 Rcv-and-Wait   9 Rcv-Immed   10 Rqt-to-Send\n"));
	printf (gettext("11 Send-Data 12 Send-Error   13 Post-on-Rcpt  14 Test\n"));
	printf (gettext("72 Tp_Listen 74 Tp_Wait_Rmt_Start             71 Tp_End      81 Cnos\n"));
	printf (gettext("90 Exit      91 Short/Long output\n"));
}

u_long
main(int argc, u_char *argv[])
{
	long	len;
	int	verb;
	TP_START param;
	u_long	gateway_fd;
	int	mapped_conv = 0;


	setlocale(LC_ALL, "");
	bindtextdomain("snap2p", "/opt/SUNWconn/snap2p");
	textdomain("snap2p");

	has_tp = 0;
	if ( argc == 1 ) {
		printf(gettext("Usage: test_p2p [-m] gateway_name\n"));
		printf(gettext("-m: mapped conversation\n"));
		printf(gettext("<gateway_name>: the name of APPC server\n"));
		exit( 1 );
	}

	if (!strcmp(argv[1], "-m")) {
		if (argc > 2) {
			mapped_conv = 1;
			strcpy( gateway, argv[2] );
		}
		else {
			printf(gettext("Usage: test_p2p gateway_name\n"));
			printf(gettext("       where gateway_name is the name of APPC server\n"));
			exit( 1 );
		}
	}
	else 	
		strcpy( gateway, argv[1] );

	if ( tp_start_proc( gateway, (u_char *)"TEST_P2P", &gateway_fd ) ) {
		appc_error( (u_char *)"tp_start" );
		exit(1);
	}
	printf(gettext("gateway_fd is 0x%x\n"), gateway_fd);
	/* to get pu name */

	if ((pip_data = (u_char *)memalign(4,MAX_PIP)) == 0) {
		printf(gettext("Not enough memory\n"));
		exit(0);
	}
	process_verb( VERB_DISPLAY_SYSTEM );
	do {
		print_menu();
		iscan = 0;
		while (iscan != 1) {
			printf(gettext("Enter Verb: "));
			iscan = scanf("%d", &verb );
			check_scan ();
			if (mapped_conv && (verb <= MAX_BASIC_VERB))
				verb += VERB_MC_ALLOCATE;
		}
		if ( verb == -1 )
			break;
		process_verb( verb );
	} while ( 1 );
	tp_end_proc();
	return(0);
}

