#ifndef lint
static char sccsid[] = "@(#)p2pconv.c	1.7 15 Sep 1994 Copyr 1992-1993 Sun Micro";
#endif


/*
        Copyright (c) 1992-1993, Sun Microsystems, Inc.  All Rights Reserved.
        Sun considers its source code as an unpublished, proprietary
        trade secret, and it is available only under strict license
        provisions.  This copyright notice is placed here only to protect
        Sun in the event the source is deemed a published work.
 
        RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
        Government is subject to restrictions as set forth in subparagraph
        (c)(1)(ii) of the Rights in Technical Data and Computer Software
        clause at DFARS 52.227-7013 and in similar clauses in the FAR and
        NASA FAR Supplement.
*/

#include <stdio.h>

#define LINESIZE 	500
#define WORDSIZE 	100
#define TRUE 		1
#define FALSE		0

void
get_first_word(aline, first_word)
	char *aline;
	char *first_word;
{
	first_word[0] = 0;
	sscanf(aline, "%s", first_word);
	return;
}

void
get_second_word(aline, second_word)
	char *aline;
	char *second_word;
{
	char dummy[WORDSIZE];

	second_word[0] = 0;
	sscanf(aline, "%s %s", dummy, second_word);
	return;
}

void
get_third_word(aline, third_word)
	char *aline;
	char *third_word;
{
	char dummy[WORDSIZE];

	third_word[0] = 0;
	sscanf(aline, "%s %s %s", dummy, dummy, third_word);
	return;
}

void
get_rem_line(aline, remline)
	char *aline, *remline;
{
	char dummy[WORDSIZE];

	remline[0] = 0;
	sscanf(aline, "%s %s %[ -~]", dummy, dummy, remline);
	return;
}

void
format_output(aline, offset)
	char *aline;
	int offset;
{
	char first_word[WORDSIZE];
	char second_word[WORDSIZE];
	char rem_line[LINESIZE];

	if (aline[0] == ':') {
		fprintf(stdout, "%s", aline);	/* line starts with colon; no format */
	} else if (aline[0] == '#') {
		fprintf(stdout, "%s", aline);	/* line starts with pound; no format */
 	} else {		
		get_first_word(aline, first_word);
		if (first_word[0] == '\000') {	/* blank line */
			fprintf(stdout, "\n");
			return;
		}
		get_second_word(aline, second_word);
		get_rem_line(aline, rem_line);
		if (offset == 0) { 
			fprintf(stdout, "%-30s%-2s%-17s\n",
				first_word, second_word, rem_line); 
		} else {
			fprintf(stdout, "%-29s%-2s%-17s\n",
				first_word, second_word, rem_line); 
		} 
	}
	return;
}

void
format_comment(text)
	char *text;
{
	fprintf(stdout, "%-30s%-2s%-17s\n","#", " ", text);
	return;
}

void
get_a_line(aline, asize, is_eof)
	char *aline;
	int asize;
	int *is_eof;
{
	if (!feof(stdin)) {
		fgets(aline, asize, stdin);	/* get a line */
		if (feof(stdin)) {
			*is_eof = TRUE;
		} else {
			*is_eof = FALSE;
		}
	}
}

int
socket_remote()
{
	char aline[LINESIZE];
	char first_word[WORDSIZE];
	char third_word[WORDSIZE];
	int is_eof;

	rewind(stdin);
	clearerr(stdin);
	while (!feof(stdin)) {
		is_eof = 0;
		get_a_line(aline, sizeof(aline), &is_eof);
		if (is_eof) return(0);		/* did not find socket_remote */
		get_first_word(aline, first_word);
		if (strcmp(first_word, "socket_remote_p2p") == 0) return (1);
	} 
}

char
*search_dlc(prog)
	char *prog;
{
	char aline[LINESIZE];
	char first_word[WORDSIZE];
	char third_word[WORDSIZE];
	char result[WORDSIZE];
	int is_eof;

	rewind(stdin);
	clearerr(stdin);
	while (!feof(stdin)) {
		get_a_line(aline, sizeof(aline), &is_eof);
		if (is_eof) {
			fprintf(stderr, "%s: Could not find dlc_type in input file.",prog);
			fprintf(stderr, "  Conversion aborted.\n");
			exit(1);
		}
		get_first_word(aline, first_word);
		if (strcmp(first_word, "dlc_type") == 0) {
			get_third_word(aline, third_word);
			if (strcmp(third_word, "0") == 0) {
				strcpy(result, "sdlc");
				return(result);
			} else if (strcmp(third_word, "1") == 0) {
				strcpy(result, "llc");
				return(result);
			} else {
				fprintf(stderr,
				"%s: Invalid dlc_type \'%s\' encountered.", prog, third_word);
				fprintf(stderr, "  Conversion aborted.\n");
				exit(1);
			}
		}
	}
}

void
get_dlc_type(dlc_type, prog)
	char *dlc_type;
	char *prog;
{
	char aline[LINESIZE];
	char first_word[WORDSIZE];
	char third_word[WORDSIZE];
	int is_eof;

	if (socket_remote()) strcpy(dlc_type, "loopback");
	else (strcpy(dlc_type, search_dlc(prog)));
	return;
}

void
retire(aline)
	char *aline;
{
	fprintf(stdout, "#");
	format_output(aline, 1);
	format_comment("ABOVE RETIRED IN 8.0");
	return;
}

void
yesno(aline, prog)
	char *aline;
	char *prog;
{
	char first_word[WORDSIZE];
	char third_word[WORDSIZE];
	char yn[5];
	char temp[LINESIZE];

	get_first_word(aline, first_word);
	get_third_word(aline, third_word);
	strcpy(yn, "no");
	if (strcmp(third_word, "1") == 0) strcpy(yn, "yes");
	fprintf(stdout, "#");
	format_output(aline, 1);
	format_comment("ABOVE PARAMETER CHANGED TO YES/NO IN 8.0");
	sprintf(temp, "%s = %s # ADDED BY %s\n", first_word, yn, prog);
	format_output(temp, 0);
	return;
}

/* wk 09/15/94 */
void 
remoteaddr(aline,prog)
	char *aline;
	char *prog;
{
	char third_word[WORDSIZE];
	char temp[LINESIZE];

	get_third_word(aline, third_word);
	fprintf(stdout, "#");
	format_output(aline, 1);
	format_comment("REMOTE_ADDR CHANGED TO REMOTE_MAC_ADDR IN 8.0");
	sprintf(temp, "remote_mac_addr = %s # ADDED BY %s\n", third_word, prog);
	format_output(temp, 0);
	return;
}

void
ludep(aline, prog)
	char *aline;
	char *prog;
{
	char third_word[WORDSIZE];
	char yn[5];
	char temp[LINESIZE];

	get_third_word(aline, third_word);
	strcpy(yn, "no");
	if (strcmp(third_word, "1") == 0) strcpy(yn, "yes");
	fprintf(stdout, "#");
	format_output(aline, 1);
	format_comment("REMOTE_IS_SSCP CHANGED TO LU_IS_DEPENDENT IN 8.0");
	format_comment("REMOTE_IS_SSCP ALSO CHANGED TO YES-NO IN 8.0");
	sprintf(temp, "lu_is_dependent = %s # ADDED BY %s\n", yn, prog);
	format_output(temp, 0);
	return;
}

void
syncit(aline, prog)
	char *aline, *prog;
{
	char third_word[WORDSIZE];
	char sync[WORDSIZE];
	char temp[LINESIZE];

	get_third_word(aline, third_word);
	strcpy(sync, "none");
	if (strcmp(third_word, "1") == 0) strcpy(sync, "sync_confirm");
	fprintf(stdout, "#");
	format_output(aline, 1);
	format_comment("SYNC_LEVEL CHANGED TO SYNC_NONE/CONFIRM IN 8.0");
	sprintf(temp, "sync_level = %s # ADDED BY %s\n", sync, prog);
	format_output(temp, 0);
	return;
}

void
add_new_dlc_stuff(dlc_type, prog)
	char *dlc_type;
	char *prog;
{
	char dev[WORDSIZE];
	char temp[LINESIZE];

	if (strcmp(dlc_type, "sdlc") == 0) strcpy(dev, "/dev/sdlc");
	else if (strcmp(dlc_type, "llc") == 0) strcpy(dev, "/dev/llc2");
	else if (strcmp(dlc_type, "loopback") == 0) strcpy(dev, "/dev/loopback");
	else {
		fprintf(stderr,
		"%s: Invalid dlc_type '''%s'`' in add_new_dlc_stuff().", dlc_type, prog);
/*	"%s: Invalid dlc_type \'%s`\ in add_new_dlc_stuff().", dlc_type, prog);*/
		fprintf(stderr, "  Conversion aborted.\n");
		exit(1);
	}
 
	sprintf(temp, "dlc_driver_name = %s # ADDED BY %s\n", dev, prog);
	format_output(temp, 0);
	sprintf(temp,
		"port_driver_name = XXX # ADDED BY %s [must be changed!]\n", prog);
	format_output(temp, 0);
	return;
}

void
maxdata(aline, prog)
	char *aline;
	char *prog;
{
	char third_word[WORDSIZE];
	int maxd;
	char temp[LINESIZE];

	get_third_word(aline, third_word);
	maxd = atoi(third_word);

	fprintf(stdout, "#");
	format_output(aline, 1);
	format_comment("FRM_SIZE CHANGED TO MAXDATA IN 8.0");
	sprintf(temp, "maxdata = %d # ADDED BY %s [frm_size - 8]\n", maxd-8, prog);
	format_output(temp, 0);
	return;
}

void
getaddr(aline, addr)
	char *aline, *addr;
{
	char third_word[WORDSIZE];

	get_third_word(aline, third_word);
	strcpy(addr, third_word);
	return;
}

void
putaddr(aline, addr, prog)
	char *aline, *addr, *prog;
{
	char temp[LINESIZE];

	sprintf(temp,
		"sdlc_addr = %s # ADDED BY P2PCONV [taken from txaddr]\n", addr, prog);
	format_output(temp, 0);
	return;
}


void
dlctype(aline, dlc_type, prog)
	char *aline, *dlc_type, *prog;
{
	char temp[LINESIZE];

	fprintf(stdout, "#");
	format_output(aline, 1);		/* offset 1 cuz of pound sign */
	format_comment("DLC_TYPE FORMAT CHANGED IN 8.0");
	sprintf(temp, "dlc_type = %s # ADDED BY %s\n", dlc_type, prog);
	format_output(temp, 1);
	return;
}

void
format_flags(val, prog)
	int val;
	char *prog;
{
	int val1, val2, val3;
	char mode[WORDSIZE], charset[WORDSIZE], recsize[WORDSIZE];
	char temp[LINESIZE];

	val1 = val & 1;
	val2 = val & 2;
	val3 = val & 8;

	if (val1) strcpy(mode, "append");
	else strcpy(mode, "create");
	if (val2) strcpy(charset, "ebcdic");
	else strcpy(charset, "iso");
	if (val3) strcpy(recsize, "short");
	else strcpy(recsize, "long");
 
	sprintf(temp, "db_character_set = %s", charset);
	format_output(temp, 0);
	sprintf(temp, "db_record_size = %s", recsize);
	format_output(temp, 0);
	sprintf(temp, "file_mode = %s", mode);
	format_output(temp, 0);
	return;
} 

void
flags(aline, prog)
	char *aline, *prog;
{
	char temp[LINESIZE];
	char third_word[WORDSIZE];

	fprintf(stdout, "#");
	format_output(aline, 1);
	format_comment("FLAGS SPLIT INTO 3 FIELDS IN 8.0");
	get_third_word(aline, third_word);
	format_flags(atoi(third_word), prog);
	return;
}


main(argc, argv)
	int argc;
	char *argv[];
{

	char aline[LINESIZE];			/* line read in from input file */	
	char first_word[WORDSIZE];		/* first word of line */
	char dlc_type[WORDSIZE];		/* sdlc, llc, or loopback */
	char addr[WORDSIZE];			/* station address */
	int is_eof;						/* encounter end of file? */
 
	get_dlc_type(dlc_type, argv[0]);	
	rewind(stdin);
	clearerr(stdin);

	while (!feof(stdin)) {
		get_a_line(aline, sizeof(aline), &is_eof);
		if (is_eof) break;
		get_first_word(aline, first_word);

		if (strcmp(first_word, "local_plu_name") == 0) retire(aline);
		else if (strncmp(first_word, "parallel_session", 16) == 0)
			yesno(aline, argv[0]);
		else if (strcmp(first_word, "cnos_supported") == 0) retire(aline);
		else if (strcmp(first_word, "remote_is_sscp") == 0)
			ludep(aline, argv[0]);
		else if (strcmp(first_word, "sync_level") == 0) syncit(aline, argv[0]);
		else if (strcmp(first_word, "device_driver_name") == 0) {
			retire(aline);
			add_new_dlc_stuff(dlc_type, argv[0]);
		} else if (strcmp(first_word, "dlc_type") == 0)
			dlctype(aline, dlc_type, argv[0]);
		else if (strcmp(first_word, "frm_size") == 0) maxdata(aline, argv[0]);
		else if (strcmp(first_word, "txaddr") == 0) {
			getaddr(aline, addr);
			retire(aline);
			putaddr(aline, addr, argv[0]);
		} else if (strcmp(first_word, "rxaddr") == 0) retire(aline);
		else if (strcmp(first_word, "addr_search") == 0) retire(aline);
		else if (strcmp(first_word, "send_reject") == 0) retire(aline);
		else if (strcmp(first_word, "rcv_reject") == 0) retire(aline);
		else if (strncmp(first_word, "socket_remote_p2p", 17) == 0)
			retire(aline);
		else if (strcmp(first_word, "abm_support") == 0) retire(aline);
		else if (strcmp(first_word, "max_btu_rcv") == 0) retire(aline);
		else if (strcmp(first_word, "sim_rim") == 0) retire(aline);
		else if (strcmp(first_word, "remote_addr") == 0) remoteaddr(aline, argv[0]);
		else if (strcmp(first_word, "db_pc") == 0) yesno(aline, argv[0]);
		else if (strcmp(first_word, "db_mail") == 0) yesno(aline, argv[0]);
		else if (strcmp(first_word, "db_buf") == 0) yesno(aline, argv[0]);
		else if (strcmp(first_word, "db_dev") == 0) yesno(aline, argv[0]);
		else if (strcmp(first_word, "db_api_verb") == 0) yesno(aline, argv[0]);
		else if (strcmp(first_word, "flags") == 0) flags(aline, argv[0]);
		else if (strcmp(first_word, "db_tp_info") == 0) yesno(aline, argv[0]);
		else format_output(aline, 0);		/* nothing done; just output */
	}
	fflush(stdout);
	exit(0);
}
  


