#ifndef lint
static char sccsid[] = "@(#)cnos.c	8.10 17 Aug 1993 Copyr 1987-1993 Sun Micro";
#endif

/*
        Copyright (c) 1987-1993, Sun Microsystems, Inc.  All Rights Reserved.
        Sun considers its source code as an unpublished, proprietary
        trade secret, and it is available only under strict license
        provisions.  This copyright notice is placed here only to protect
        Sun in the event the source is deemed a published work.
 
        RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
        Government is subject to restrictions as set forth in subparagraph
        (c)(1)(ii) of the Rights in Technical Data and Computer Software
        clause at DFARS 52.227-7013 and in similar clauses in the FAR and
        NASA FAR Supplement.
*/
 
 
#include <sys/types.h>
#include <locale.h>
#include "api_const.h"
#include "api.h"
#include "api_proto.h"
#include "cnos.h"

extern u_long appc_errno;
u_char	data_buf[640];
u_char	buf[256];

main( int argc, u_char *argv[] )
{
	int session_limit, conwinner, conloser, quit;
	CNOS	cnos_param;
	DISPLAY_MODE	dsp_mode;
	register CNOS	*cnos_ptr;
	u_long gateway_fd;

	setlocale(LC_ALL, "");
	bindtextdomain("snap2p", "/opt/SUNWconn/snap2p");
	textdomain("snap2p");

	cnos_ptr = &cnos_param;
	if ( argc == 1 ) {
		printf(gettext("Usage: cnos gateway_name pu_name local_lu_number fql_remote_lu_name\n"));
		exit( 0 );
	}

	tp_start_proc( argv[1], (u_char *)"CNOS", &gateway_fd );

	strcpy( cnos_ptr->pu_name, argv[2] );
	cnos_ptr->lu_local_address = atoi( argv[3] );
	strcpy( cnos_ptr->fql_partner_lu_name, argv[4] );
	cnos_ptr->all_mode_names = 0;
	cnos_ptr->auto_activate = 0;
	cnos_ptr->set_negotiable = 0;
	cnos_ptr->target_deact_session = 1;
	cnos_ptr->drain_source = 1;
	cnos_ptr->drain_target = 0;
	cnos_ptr->force = 0;

	do {
		printf(gettext("Enter mode_name session_limit conwinner conloser:"));
		scanf("%s %d %d %d", cnos_ptr->mode_name, &session_limit, &conwinner, &conloser );
		cnos_ptr->lu_mode_session_limit = session_limit;
		cnos_ptr->min_conwinner_source = conwinner;
		cnos_ptr->min_conwinner_target = conloser;
		cnos( cnos_ptr );
		appc_error((u_char *)"cnos");

		/* print the result of cnos negotiation over this mode */
		strcpy( dsp_mode.pu_name, argv[2] );
		dsp_mode.lu_local_address = atoi( argv[3] );
		strcpy( dsp_mode.fql_partner_lu_name, argv[4] );
		strcpy( dsp_mode.mode_name, cnos_ptr->mode_name );
		display_mode( &dsp_mode );
		printf(gettext("sesslim=%d conwinnerlim=%d conloserlim=%d\n"),
			dsp_mode.session_limit, dsp_mode.min_conwinner_limit,
			dsp_mode.min_conloser_limit );

		printf(gettext("Quit? (1/0): "));
		scanf("%d", &quit );
	} while ( ! quit );

	tp_end_proc();
	return(0);
}
