/* @(#)proginterface.h 8.8 94/05/04 Copyr 1993 Sun Micro */

/*
** Copyright (c) 1985-1993 Sun Microsystems, Inc.  All Rights Reserved.
** This copyright notice is placed here only to protect Sun in the event
** the source is deemed a published work.
**
** RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
** Government is subject to restrictions as set forth in subparagraph
** (c)(1)(ii) of the Rights in Technical Data and Computer Software
** clause at DFARS 52.227-7013 and in similar clauses in the FAR and
** NASA FAR Supplement.
*/

				/* global variable */
extern int	cgerrno;		/* error codes from emulator */

                                /* program loop control */
int runonce();                                /* run through the loop once */
int stoprunloop();                            /* stop runloop */
void abortrun(char *s, int exitstatus);       /* abort with msg for emulator */
int runloop();                                /* run through the loop forever */

                               /* register call back procedures */
int set_screenproc(void (*proc) ());           /* register new screen routine */
int set_fieldproc(void (*proc) (), u_int *mask);/* register new field routine */
int set_focusproc(void (*proc) (), u_int *mask);
int set_keyproc(void (*proc) ());              /* register LPF key routine */
int set_ioproc(int fd, void (*proc) ());    /* register pending input routine */
int set_errorproc(void (*proc) (), int level); /* register error handler */
int set_attention( void (*proc) ());           /* register attention handler */

                                /* set misc. stuff */
int set_fieldmask( u_int *mask);        /* set a new fieldmask for fieldproc */
int set_userdata(int udata);            /* set user data */
int set_debuglevel(int level);          /* set debug level to 0 or 1 */

                                /* update the emulator */
int put_cursorbyfieldnum(int fieldnum); /* move cursor location (by fieldnum) */
int put_cursorbyoffset(int offset);     /* move cursor location (by offset) */
int put_string(char *string);           /* put string at current localtion */
int put_cmd( u_char cmd);               /* put ENTER, PF1-PF24, CLEAR, etc... */
int put_ereof();                        /* erase to end of field */

                                /* interrogate the screen buffer */
int get_numfields();                  /* get number of fields on screen */
int get_fieldnum(int offset);         /* get fieldnum for given offset */
int get_offset(int fieldnum);         /* get offset of given fieldnum */
int get_fieldlen(int fieldnum);       /* get length of given fieldnum */
     /* get attribute at given fieldnum */
int get_attrbyfieldnum( int fieldnum, int  type, u_char *attr);
     /* get attribute at given offset */
int get_attrbyoffset(int offset, int type, u_char *attr);
     /* get the string at given offset */
int get_stringbyoffset(int offset, char *buffer, int count);
     /* get the string at given fieldnum */
int get_stringbyfieldnum(int fieldnum, char *buffer, int count);

                                /* design and debugging */
int get_screendump(FILE *file);       /* dump info for the entire screen */

				/* search */
int get_searchstring(char *string, int offset); /* search for a given string */
int get_searchattr(int type, int offset);       /* attribute "search" */
int get_searchfield(int type, int offset);      /* field "search" */

                                /* get misc. stuff */
int get_status();           /* return error code for last failure */
int get_userdata();         /* return value set by set_userdata */
int get_pollfd();           /* return emulator input file descr. */
				/* commands passed to new screen routines */
#define SCREEN_WR		0xF1	/* write */
#define SCREEN_EW		0xF5	/* erase write */
#define SCREEN_EWA		0x7E	/* erase write alternate*/
#define SCREEN_EAU		0x6F	/* erase all unprotected */
#define SCREEN_CLEAR		0x6D	/* clear */
#define SCREEN_SSCP		0x01	/* sscp */

				/* macros for use with the fieldmask */
#define MASK_LEN             8
#define FIELD_ISSET(m, f)    (m[f/32] &   ((unsigned)0x80000000 >> (f%32)))
#define FIELD_SET(m, f)      (m[f/32] |=  ((unsigned)0x80000000 >> (f%32)))
#define FIELD_CLEAR(m, f)    (m[f/32] &= ~((unsigned)0x80000000 >> (f%32)))


				/* error levels used with set_errorproc(); */
				/* levels may be OR-ed	*/
#define ERR_LEVELA		0x00	/* normal error reporting */
#define	ERR_LEVELB		0x01	/* no BUFFCHANGED on simple write */
#define ERR_LEVELC		0x02	/* put/get never set BUFFCHANGED */


				/* values passed to LPF key routines */
#define LPF1			0xF1
#define LPF2			0xF2
#define LPF3			0xF3
#define LPF4			0xF4
#define LPF5			0xF5
#define LPF6			0xF6
#define LPF7			0xF7
#define LPF8			0xF8
#define LPF9			0xF9
#define LPF10			0x7A
#define LPF11			0x7B
#define LPF12			0x7C
#define LPF13			0xC1
#define LPF14			0xC2
#define LPF15			0xC3
#define LPF16			0xC4
#define LPF17			0xC5
#define LPF18			0xC6
#define LPF19			0xC7
#define LPF20			0xC8
#define LPF21			0xC9
#define LPF22			0x4A
#define LPF23			0x4B
#define LPF24			0x4C

				/* general return values */
#define NO_ERROR		0	/* no error */
#define ERROR_SET		-1	/* call get_error() to find err */

				/* error codes returned by get_status() */
#define ERROR_ALREADYRUNNING	1	/* already in runloop */
#define	ERROR_NOTINCALLBACK	2	/* not called from a call back */
#define ERROR_NOTHINGSET	3	/* nothing is set to call back to */
#define ERROR_INIT		4	/* error during initialization */
#define ERROR_CGPIPE		5	/* problem with pipe to emulator */
#define ERROR_IO		6	/* other IO errors */
#define ERROR_INTERNAL		7	/* internal error */
#define ERROR_ALLOCFAILED	8	/* memory allocation failed */
#define ERROR_ARG		9	/* bad argument to library routine */
#define	ERROR_SCRNCHANGED	10	/* screen buffer has changed */
#define ERROR_NOTFOUND		11	/* search failed */
#define ERROR_ALREADYPUTCMD	12	/* put_cmd() already called */

				/* error codes passed to registered */
				/* error procedures */
#define ERRCODE_KEYBUSY		1	/* keyboard locked unexpectedly */
#define ERRCODE_KEYMODE		2	/* keyboard is in unexpected mode */
#define ERRCODE_SCRNCHANGED	3	/* screen buffer has changed */
#define ERRCODE_JAMMED		4	/* not in appl or in protected field */
#define ERRCODE_TOOMUCH		5	/* insert beyond end of field */
#define ERRCODE_SCRNUPDATED     6       /* screen changed before client */

				/* types of get_searchfield() searches */
#define FIND_HERE		1	/* start of current field */
#define FIND_LAST		2	/* start of last field */
#define FIND_NEXT		3	/* start of next field */
#define FIND_LAST_UNPROT	4	/* start of last unprotected field */
#define FIND_NEXT_UNPROT	5	/* start of next unprotected field */
#define FIND_LAST_PROT		6	/* start of last protected field */
#define FIND_NEXT_PROT		7	/* start of next protected field */

				/* messaging levels for set_debuglevel() */
#define ML_internal		1	/* more info on ERROR_INTERNAL */
#define ML_trace		2	/* trace chatter with emulator */
#define ML_debug		3	/* print debug messages */


#ifndef ATC_ALL
/*  Attribute Type Codes GA23-0059-2 4-17 */

#define ATC_ALL	0x00		/* Default All */

#define ATC_FA	0xC0		/* Field Attribute*/
#define	ATV_FA_EB	0xC0		/* Make EBCDIC Bits */
#define	ATV_FA_PRO	0x20		/* Protected */
#define	ATV_FA_NUM	0x10		/* Numeric */
#define ATV_FA_SKIP	(ATV_FA_PRO | ATV_FA_NUM)
#define	ATV_FA_D	0x0C		/* Display Mode mask */
#define	ATV_FA_D_NORM	0x00		/* Normal */
#define	ATV_FA_D_SELECT	0x04		/* Normal Selectable */
#define	ATV_FA_D_INTENS	0x08		/* Intense Selectable */
#define	ATV_FA_D_INVIS	0x0C		/* Invisible */
#define	ATV_FA_MDT	0x01		/* Modified Data Tag */


#define ATC_FV	0xC1		/* Field Validation */
#define ATV_FV_MF	0x04		/* Mandatory Fill */
#define ATV_FV_ME	0x02		/* Mandatory Entry */
#define ATV_FV_TRIG	0x01		/* Mandatory Trigger */

#define ATC_FO	0xC2		/* Field Outlining */
#define ATV_FO_BOT	0x01		/* Bottom */
#define ATV_FO_RIGHT	0x02		/* Right */
#define ATV_FO_LEFT	0x08		/* Left */
#define ATV_FO_TOP	0x04		/* Top */

#define ATC_EH	0x41		/* Extended Highlighting */
#define ATV_EH_DEF	0x00		/* Default */
#define ATV_EH_BNK	0xF1		/* Blink */
#define ATV_EH_REV	0xF2		/* Reverse Video */
#define ATV_EH_UNL	0xF4		/* Under Line */

#define ATC_CLR	0x42		/* Color */
#define ATV_CLR_DEF	0x00		/* Default (Green) */
#define ATV_CLR_BLU	0xF1		/* Blue */
#define ATV_CLR_RED	0xF2		/* Red */
#define ATV_CLR_PNK	0xF3		/* Pink */
#define ATV_CLR_GRN	0xF4		/* Green */
#define ATV_CLR_TRQ	0xF5		/* Turquoise */
#define ATV_CLR_YEL	0xF6		/* Yellow */
#define ATV_CLR_WHT	0xF7		/* White */

#define ATC_CS	0x43		/* Character Set */
#define ATV_CS_GE	0xF1		/* Character set used by GE */

#define ATC_BT	0x46		/* Background Transparency */
#define ATV_BT_TRN	0x00		/* Transparent (Default) */
#define ATV_BT_OPQ	0xFF		/* Opaque */

#endif ATC_ALL
