#!/bin/sh
# script to clean miq/07ems/00erq; called by /usr/etc/cron
# version 1.12 (91/01/07)

# product configuration
PRODDIR=/usr/sunlink/mhs
    XSUBDIR=bin
    ADMINSUBDIR=usr.etc
    DEVSUBDIR=dev
ETCDIR=/etc/sunlink/mhs
ETC2SLASH=../../..
DEVDIR=/usr/sunlink/mhs/
INSTALL_CFG_FILE=/etc/sunlink/mhs/install_cfg
export PRODDIR XSUBDIR ADMINSUBDIR ETCDIR ETC2SLASH INSTALL_CFG_FILE

PATH=$PRODDIR/$ADMINSUBDIR:/usr/ucb:/usr/bin:/usr/etc
export PATH


# set directories
classdir=$ETCDIR/miq/07ems
queuedir=$classdir/00erq
outdir=$classdir/EA_Data

# cd to output directory
cd $outdir

# save last ev_log
if [ -f ev_log ]
then
	mv ev_log ev_log.old
fi

# change to queue directory
cd $queuedir

# list files by time
infiles=`/bin/ls -tr *000 2> /dev/null`

# generate summary in ../EA_Data/ev_log
for f in $infiles
do
	cat $f
	echo ""
done | sed -e 's;^.........\(..\)\(..\)\(..\)\(..\)\(..\)..........\(...\)\(...\)\(....\).....................................\(.*\)$;\1-\2-\3 \4:\5 (\6/\7/\8) \9;' \
	> $outdir/ev_log

# remove files
rm $infiles
rm 0*

# tell scheduler about dequeued files
for f in $infiles
do
	mhsc -dequeue 07ems 00erq $f > /dev/null
done
