#ifndef lint
static  char sccsid[] = "@(#)hliterm.c 7.10 92/01/17 Copyr 1985-1991 Sun Micro";
#endif

/*
** Copyright (c) 1985-1991 Sun Microsystems, Inc.  All Rights Reserved.
** Sun considers its source code as an unpublished, proprietary trade 
** secret, and it is available only under strict license provisions.  
** This copyright notice is placed here only to protect Sun in the event
** the source is deemed a published work.  Dissassembly, decompilation, 
** or other means of reducing the object code to human readable form is 
** prohibited by the license agreement under which this code is provided
** to the user or company in possession of this copy.
** 
** RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the 
** Government is subject to restrictions as set forth in subparagraph 
** (c)(1)(ii) of the Rights in Technical Data and Computer Software 
** clause at DFARS 52.227-7013 and in similar clauses in the FAR and 
** NASA FAR Supplement.
*/


/*
**	hliterm.c - a generic session tester/half terminal
**
**      to compile:
**        cc -g -I/usr/sunlink/dai/hli session.c /usr/sunlink/dai/DAILIB.a
**              /usr/sunlink/dai/hli/HLILIB.a
**
**	uses keystrokes input in hllapi format
*/

#include <stdio.h>
#include <sys/types.h>
#include "hli.h"


main(argc,argv)
int argc;
char *argv[];
{
	char str[256];
	char host[32];
	int show = 0;
	int i;
	int status;

	if (argc < 2)
	{
		printf("usage: %s [-s] gateway\n",argv[0]);
		exit(1);
	}

	i = 1;
	while (i < argc)
	{
		if (argv[i][0] == '-')
		{
			switch (argv[i][1])
			{
			case 's':
				show++;
				break;
			default:
				break;
			}
		}
		else (strcpy(host,argv[i]));
		i++;
	}

	set_sna_host(host);

 	status = start_session("hliterm", SHOWSCREEN);

	clock_wait();

	printf ("Enter hllapi string(s) to send or \"quit\" to exit\n");

	while(1)
	{
		gets(str);
		if (!strcmp(str,"quit"))
			break;
		
		send_keystrokes(str);

		/*
		**	refresh the screen to show what you've
		**	just typed in.
		*/
		if (show)
			show_screen();

	}

	/*
	**	be sure and call hli_disconnect() to kill the daemon
	**	when you're done.
	*/
	hli_disconnect();

	exit(0);
}

