#ifndef lint
static  char sccsid[] = "@(#)session.c 7.9 92/01/17 Copyr 1985-1991 Sun Micro";
#endif

/*
** Copyright (c) 1985-1991 Sun Microsystems, Inc.  All Rights Reserved.
** Sun considers its source code as an unpublished, proprietary trade 
** secret, and it is available only under strict license provisions.  
** This copyright notice is placed here only to protect Sun in the event
** the source is deemed a published work.  Dissassembly, decompilation, 
** or other means of reducing the object code to human readable form is 
** prohibited by the license agreement under which this code is provided
** to the user or company in possession of this copy.
** 
** RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the 
** Government is subject to restrictions as set forth in subparagraph 
** (c)(1)(ii) of the Rights in Technical Data and Computer Software 
** clause at DFARS 52.227-7013 and in similar clauses in the FAR and 
** NASA FAR Supplement.
*/


/*
**	session.c - a generic session starter
**	
**	to compile:
**	  cc -g -I/usr/sunlink/dai/hli session.c /usr/sunlink/dai/DAILIB.a 
**		/usr/sunlink/dai/hli/HLILIB.a
**
*/

#include <stdio.h>
#include <sys/types.h>
#include "hli.h"


main(argc,argv)
int argc;
char *argv[];
{
	char str[256];
	char host[32];
	int show = 0;
	int i;
	int status;

	if (argc < 2)
	{
		printf("usage: %s [-s] gateway\n",argv[0]);
		exit(1);
	}

	i = 1;
	while (i < argc)
	{
		if (argv[i][0] == '-')
		{
			switch (argv[i][1])
			{
			case 's':
				show++;
				break;
			default:
				break;
			}
		}
		else (strcpy(host,argv[i]));
		i++;
	}


	/* the gateway name (SNA, BSC or LCL) to connect to */
	set_sna_host(host);

	sprintf(str,"%s.%d",host,getpid());

	/* start a new session with the gateway specified above */
 	status = start_session(str, show);

	if (status != HLI_OK)
	{
		printf("error starting session on gateway %s\n",host);
		exit(1);
	}

	/* wait for session connection completed */
	clock_wait();

	printf ("session started on gateway %s\n",host);

	exit(0);
}

