/* sccsid[] = "@(#)hli.h 7.12 92/03/18 Copyr 1985-1991 Sun Micro"; */
 
/*
** Copyright (c) 1985-1991 Sun Microsystems, Inc.  All Rights Reserved.
** Sun considers its source code as an unpublished, proprietary trade 
** secret, and it is available only under strict license provisions.  
** This copyright notice is placed here only to protect Sun in the event
** the source is deemed a published work.  Dissassembly, decompilation, 
** or other means of reducing the object code to human readable form is 
** prohibited by the license agreement under which this code is provided
** to the user or company in possession of this copy.
** 
** RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the 
** Government is subject to restrictions as set forth in subparagraph 
** (c)(1)(ii) of the Rights in Technical Data and Computer Software 
** clause at DFARS 52.227-7013 and in similar clauses in the FAR and 
** NASA FAR Supplement.
*/


/* 
**	hli.h
**
**	A high level applications program interface for the 
**	SunLink Datastream Access Interface library.
**
*/

#define SHOWSCREEN 1
#define NOSHOWSCREEN 0

/*
**	HLI error codes
*/
#define HLI_OK			0		/* No errors were detected    */
#define HLI_ERROR		-1		/* An error was detected      */
#define	HLI_ZERO		0		/* Position for "not found"   */

/*
**	The following may be returned in _return_code (or in *pos)
*/

#define HLI_CONNECT_ERROR	1		/* Application not connected  */
#define HLI_PARM_ERROR		2		/* Parameter error occurred   */
#define HLI_FILE_TRANSFER_COMPLETE	3	/* Not an error - FTP normal  */
#define HLI_FILE_TRANSFER_COMPLETE_SEG	4	/* Not an error - FTP segmtd  */
#define HLI_BUSY		4		/* P/S is busy		      */
#define HLI_KLOCKED		5		/* P/S is locked	      */
#define HLI_DATA_ERROR		6		/* P/S data truncated	      */
#define HLI_POSITION_ERROR	7		/* P/S position is invalid    */
#define HLI_SEQUENCE_ERROR	8		/* No prerequisite function   */
#define HLI_SYSTEM_ERROR	9		/* System error occurred      */
#define HLI_SYS_ERROR		9
#define HLI_UNSUPPORTED	 	10		/* Function not supported     */
#define HLI_UNDEFINED	 	10		/* Function not defined	      */
#define HLI_UNAVAIL		11		/* Resource is unavailable    */
#define HLI_OIA_UPDATED		21		/* Not an error - OIA updatd  */
#define HLI_PS_UPDATED		22		/* Not an error - P/S updatd  */
#define HLI_BOTH_UPDATED	23		/* Not an error - both updatd */
#define HLI_NOTFOUND		24		/* String not found	      */
#define HLI_UNFORMATTED		24		/* P/S not formatted	      */
#define HLI_HOST_EVENT		26		/* Not an error - host event  */
#define HLI_FILE_TRANSFER_TIMEOUT	27	/* File transfer timed out    */
#define HLI_FIELD_ERROR		28		/* Zero field length          */
#define HLI_DAEMON		100
#define HLI_TIMEOUT		101
#define HLI_TD_DEATH		102
#define HLI_FILE_NOT_FOUND	302
#define HLI_ACCESS_DENIED	305
#define HLI_C_CONNECT_ERROR	9998		/* Application not connected  */
#define HLI_C_POSITION_ERROR	9999		/* P/S position is invalid    */

extern int _return_code;

/*
**	PUBLIC HLI function calls
*/

extern	attach();
extern	clock_status();
extern	clock_wait();
extern	close_session();
extern	connect_host();
extern	convert_pos();
extern	convert_row_col();
extern	copy_oia();
extern	copy_ps();
extern	dump_screen();
extern	field_to_string();
extern	find_field_length();
extern	find_field_position();
extern	hli_pause();
extern	hllc();
extern	kill_screen();
extern	ps_to_string();
extern	query_cursor();
extern	query_field_attribute();
extern	query_sessions();
extern	query_update();
extern	recv_file();
extern	search_field();
extern	search_ps();
extern	search_string();
extern	search_string_from();
extern	send_file();
extern	send_keystrokes();
extern	set_cursor();
extern	set_device();
extern	set_model();
extern	set_notrace_new();
extern	set_screen();
extern	set_session_parms();
extern	set_sna_host();
extern	set_trace_new();
extern	show_screen();
extern	start_hn();
extern	start_screen();
extern	start_session();
extern	start_trace();
extern	stop_hn();
extern	stop_trace();
extern	string_to_field();
extern	string_to_ps();
extern	wait_complete();
extern	wait_for_text();

/*
**	EHLLAPI function codes (for hllc())
*/

#define CONNECT_PS		1
#define DISCONNECT_PS		2
#define SEND_KEY		3
#define WAIT			4
#define COPY_PS			5
#define SEARCH_PS		6
#define QUERY_CURSOR		7
#define COPY_PS_TO_STRING	8
#define SET_SESSION_PARMS	9
#define QUERY_SESSIONS		10
#define COPY_OIA		13
#define QUERY_FIELD_ATTR	14
#define COPY_STRING_TO_PS	15
#define PAUSE			18
#define START_HOST_NOTIFICATION	23
#define QUERY_HOST_UPDATE	24
#define STOP_HOST_NOTIFICATION	25
#define SEARCH_FIELD		30
#define FIND_FIELD_POSITIONS	31
#define FIND_FIELD_LENGTH	32
#define COPY_STRING_TO_FIELD	33
#define COPY_FIELD_TO_STRING	34
#define SET_CURSOR		40
#define SEND_FILE		90
#define RECV_FILE		91
#define CONVERT_ROWCOL		99
