/* @(#)if_llc.h 1.10 91/01/11 */

/*
 * IEEE802 definitions
 */

#define LLC_GLOBAL	0xff	/* global sap */
#define LLC_GROUP	0x01	/* group bit */
#define LLC_RESP	0x01	/* Response bit - add to the SSAP */
#define LLC_XID_FORMAT	0x81	/* IEEE format */

#define LLC_REGISTER_CLIENT	_IOW(L, 1, struct llc_client)
#define LLC_DEREGISTER_CLIENT	_IOW(L, 2, struct llc_client)
#define LLC_SEND_TEST		_IOW(L, 3, struct llc_ctl_parms)
#define LLC_CLOSE		_IO(L, 4)
#define LLC_SEND_XID		_IOW(L, 5, struct llc_ctl_parms)

/* 
 * the LLC station component structures are statically allocated, one per
 * llc device (e.g. one for ie0, one for ie1, ...)
 */
#define         LLC_DOWN        0
#define         LLC_UP          1
#define         LLC_CHECK       2

/*
 * LLC connection hashing constants.
 */
#define	LLCHASHMOD	32	/* Must be power of 2 */
#define	LLCHASHMASK	31
#define	LLCHASHVAL(s)	((s)->s802_lsel + (s)->s802_macaddr.l_fmt[4] + \
				(s)->s802_macaddr.l_fmt[5])

struct llc_softc {			/* llc per instance data */
        struct ifnet llc_if;		/* MUST BE FIRST */
        int llc_st_state;		/* current station state of llc FSM */
        int xid_r_count;		/* number of xid responses received */
        int retry_count;		/* retries in duplicate address test */
	struct llc_client *llc_clp;	/* head of client list for this unit */
	struct ifnet *hash[LLCHASHMOD];	/* connection hash list */
	struct hdlc_param llc_parms;	/* default parameters, set by ioctl */
};

#define IFTOLLC(ifp)	((struct llc_softc *)(ifp))

/*
 * llc SAP components are statically allocated by the calling client,
 * who passes the address to llc registration
 */

#define LLC_CLASS1	0x01
#define LLC_CLASS2	0x03

struct llc_client {
	char		llc_name[IFNAMSIZ];	/* for convenience */
	u_char		llc_lsel;		/* L-selector for client */
	u_char		llc_type;		/* specifies llc1 or llc2 */
	int		(*llc_infunc)();	/* input function */
	int		(*llc_ctlin)();		/* control input function */
	int		(*llc_netisr)();	/* soft interrupt function */
	struct ifqueue	*llc_ifqueue;		/* input queue */
	struct ifnet	*llc_upper;		/* pointer to upper layer */
	caddr_t		llc_user;		/* client's private data */
	/*
	 * the rest of the fields are used by llc - client should not
	 * change these
	 */
	struct ifnet	      *llc_conn;	/* connection list (llc2) */
	struct llc_client     *llc_next;	/* link to next on list	*/
	caddr_t		      llc_dev;		/* pointer back to dev cb */
	int		      llc_flags;	/* misc state variables */
};

struct llc_connect_params {
	char			llc_name[IFNAMSIZ];	/* for convenience */
	struct llc_client	*clientp;/* client's registration entry */
	struct sockaddr_802	dst;     /* destination MAC and lsel */
	struct ifnet 		*ifp;    /* client's connection context */ 
}; 

struct llc_connect_in_parms {
	struct llc_client	*clientp;
	struct raw_header	*raw_header;
};

struct llc_ctl_parms {
	char			llc_name[IFNAMSIZ];	/* for convenience */
	struct sockaddr_802	dst;	    /* destination MAC and lsel */
	u_char			cmd;	    /* 0 = response, 1 = command */
	u_char			pf;	    /* poll/final bit */
	struct llc_client	*clientp;   /* client's registration entry */
	struct mbuf		*m;	    /* test/xid data */
};

struct llc_ctl_in {
	struct raw_header	*rh;	    /* raw header */
	u_char			cmd;	    /* 1 = command, 0 = resp */
	u_char			pf;	    /* poll/final bit */
	struct mbuf		*m;	    /* test/xid data */
};

/* 
 * Structure of a IEEE 802.2 LLC headers
 */
struct llc_hdr1 {
	u_char	d_lsap;		/* destination link service access point */
	u_char	s_lsap;		/* source link service access point */
	u_char	control;	/* short control field */
};

#define LLC_HDR1_LEN	3	/* DON'T use sizeof(struct llc_hdr1) */

struct llc_hdr2 {
	u_char	d_lsap;		/* destination link service access point */
	u_char	s_lsap;		/* source link service access point */
	u_short	control;	/* long control field */
};

#define LLC_HDR2_LEN	4	/* DON'T use sizeof(struct llc_hdr2) */

/* Excluding the LLC type 1 header */
struct llc_snap_hdr {
	u_char	org[3];		/* Ethernet style organization field */
	u_char	type[2];	/* Ethernet style type field */
};

#define LLC_SNAP_HDR_LEN 5	/* DON'T use sizeof(struct llc_snap_hdr) */

struct llc_xid {
	u_char	d_lsap;		/* destination link service access point */
	u_char	s_lsap;		/* source link service access point */
	u_char	control;	/* short control field */
	u_char	xid_formatid;	/* usually 0x81 for IEEE */
	u_char	supported_class;/* 1 for llc.1, 3 for llc.2 */
	u_char	llc2_window;	/* window size, *2 */
};

#define LLC_XID_LEN	6 	/* DON'T use sizeof(struct llc_xid) */


/* ------------------------------------------------------------------------- */

#ifdef KERNEL
extern struct ifqueue llc_usrintrq;
int llc_usrinput();
#ifdef DLCDEBUG
extern	int		llc_trace();
#endif

#define llc_t_pdu(ifp, eh, m, direction) \
	{ if ((ifp)->if_flags & IFF_PROMISC) \
		r_llc_t_pdu(ifp, eh, m, direction); }



#endif
