/* @(#)hdlc_ioctl.h 1.5 92/09/06 */

/*
 * Parameters for HDLC
 * Note that the tN values will be rounded up to the next tick,
 * if they are not divisible by hp_tick evenly.
 */
struct hdlc_param {
	u_short	hp_t1;		/* T1 - P-bit timer (msec) */
	u_short	hp_t2;		/* T2 - max delay before ACK (msec) */
	u_short	hp_t3;		/* T3 - max idle link time (msec) */
	u_short hp_t4;		/* T4 - LLC2 busy timer (msec) */
	u_short hp_t5;		/* T5 - LLC2 reject timer (msec) */
	u_short hp_t6;		/* T6 - Ack timer (msec) */
	u_short	hp_tick;	/* resolution of timer (msec/tick) */
	u_short	hp_n1;		/* N1 - max frame size - bytes */
	u_char	hp_n2;		/* N2 - max retries (used with T1, T4) */
	u_char	hp_xcntl;	/* extended control - mod 128 */
	u_char	hp_k;		/* K - window size */
	u_char	hp_addr;	/* address */
};

struct hdlc_param_req {
	char ifr_name[IFNAMSIZ];
	struct hdlc_param hp;
};

/* 
 * HDLC addresses 
 */
#define LAPB_ADDR_A     0x03    /* commands to DTE secondary */
                                /* responses from DTE secondary */
#define LAPB_ADDR_B     0x01    /* commands to DCE secondary */
                                /* responses from DCE secondary */

struct hdlc_stats {
	u_short			hs_state;	/* hdlc state  */
        u_short                 hs_sentsabms;   /* sabms sent  */
        struct ss_dstats        hs_data;        /* data stats  */
        struct ss_estats        hs_errors;      /* error stats */
};

struct hdlc_stats_req {
	char ifr_name[IFNAMSIZ];
	struct hdlc_stats hs;
};

/*
 * Link states
 */
#define HDLCLINK_DOWN   0               /* initial state */
#define HDLCLINK_SABM   1               /* SABM outstanding */
#define HDLCLINK_FRMR   2               /* FRMR outstanding */
#define HDLCLINK_DISC   3               /* DISC outstanding */
#define HDLCLINK_UP     4               /* information transfer state */

/*
 * WARNING: 
 * 	Do not pass a first parameter with a space in it, as follows:
 *		_IO( i, 42, struct hdlc_param )
 *	this is correct
 *		_IO(i, 42, struct hdlc_param)
 * 	Hurray for macros!
 */
#define HDLC_SET_PARAM _IOW(x, 140, struct hdlc_param_req)/* set HDLC parms */
#define HDLC_GET_PARAM _IOR(x, 141, struct hdlc_param_req)/* get HDLC parms */
#define HDLC_STATS     _IOR(x, 142, struct hdlc_stats_req)/* get stats */
#define HDLC_INIT      _IO(x, 143 ) 			  /* startup link */
#define HDLC_RESET     _IO(x, 144 ) 		 	  /* shut down link */
/* ICNCFIX by -TH- for ISO8882 conformance.  We need an ioctl to set LAPB 
   into passive mode. */
#define HDLC_PASSIVE   _IOW(x, 145, int)	/* Set link into passive mode */
/* End of fix */
